/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.delegate.event.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class ActivitiEventSupport {
    protected static Log log = LogFactory.getLog(ActivitiEventSupport.class);
    protected Set<ActivitiEventListener> eventListeners = new CopyOnWriteArraySet<ActivitiEventListener>();
    protected Map<ActivitiEventType, List<ActivitiEventListener>> typedListeners = new HashMap<ActivitiEventType, List<ActivitiEventListener>>();
    protected Map<ActivitiEventType, List<ActivitiEventListener>> testingListeners = new HashMap<ActivitiEventType, List<ActivitiEventListener>>();
    protected Map<ActivitiEventType, List<ActivitiEventListener>> testingPlanListeners = new HashMap<ActivitiEventType, List<ActivitiEventListener>>();

    public synchronized void addEventListener(ActivitiEventListener listenerToAdd) {
        if (listenerToAdd == null) {
            throw new WFIllegalArgumentException("Listener cannot be null.");
        }
        this.eventListeners.add(listenerToAdd);
    }

    public Map<ActivitiEventType, List<ActivitiEventListener>> getTypedListeners() {
        return this.typedListeners;
    }

    public synchronized void addEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        if (listenerToAdd == null) {
            throw new WFIllegalArgumentException("Listener cannot be null.");
        }
        if (types == null || types.length == 0) {
            this.addEventListener(listenerToAdd);
        } else {
            for (ActivitiEventType type : types) {
                this.addTypedEventListener(listenerToAdd, type);
            }
        }
    }

    public void addTestingListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        if (listenerToAdd == null || types == null) {
            throw new WFIllegalArgumentException("Listener or EventType cannot be null.");
        }
        for (ActivitiEventType type : types) {
            this.addTestingEventListener(listenerToAdd, type);
        }
    }

    public void addTestingPlanListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        if (listenerToAdd == null || types == null) {
            throw new WFIllegalArgumentException("Listener or EventType cannot be null.");
        }
        for (ActivitiEventType type : types) {
            this.addTestingPlanEventListener(listenerToAdd, type);
        }
    }

    public void removeEventListener(ActivitiEventListener listenerToRemove) {
        this.eventListeners.remove(listenerToRemove);
        for (List<ActivitiEventListener> listeners : this.typedListeners.values()) {
            listeners.remove(listenerToRemove);
        }
    }

    public void removeTestingListener(ActivitiEventListener listenerToRemove) {
        for (List<ActivitiEventListener> listeners : this.testingListeners.values()) {
            listeners.remove(listenerToRemove);
        }
    }

    public void removeTestingPlanListener(ActivitiEventListener listenerToRemove) {
        for (List<ActivitiEventListener> listeners : this.testingPlanListeners.values()) {
            listeners.remove(listenerToRemove);
        }
    }

    public void dispatchEvent(ActivitiEvent event) {
        List<ActivitiEventListener> list;
        List<ActivitiEventListener> list2;
        List<ActivitiEventListener> typed;
        if (event == null) {
            throw new WFIllegalArgumentException("Event cannot be null.");
        }
        if (event.getType() == null) {
            throw new WFIllegalArgumentException("Event type cannot be null.");
        }
        if (!this.eventListeners.isEmpty()) {
            for (ActivitiEventListener activitiEventListener : this.eventListeners) {
                this.dispatchEvent(event, activitiEventListener);
            }
        }
        if ((typed = this.typedListeners.get((Object)event.getType())) != null && !typed.isEmpty()) {
            for (ActivitiEventListener listener : typed) {
                this.dispatchEvent(event, listener);
            }
        }
        if (WfUtils.isTesting() && (list2 = this.testingListeners.get((Object)event.getType())) != null && !list2.isEmpty()) {
            for (ActivitiEventListener listener : list2) {
                this.dispatchEvent(event, listener);
            }
        }
        if ((list = this.testingPlanListeners.get((Object)event.getType())) != null && !list.isEmpty()) {
            for (ActivitiEventListener listener : list) {
                this.dispatchEvent(event, listener);
            }
        }
    }

    protected void dispatchEvent(ActivitiEvent event, ActivitiEventListener listener) {
        try {
            listener.onEvent(event);
        }
        catch (Exception t) {
            if (listener.isFailOnException()) {
                throw new WFEngineException("Exception while executing event-listener", t);
            }
            log.warn("Exception while executing event-listener, which was ignored", (Throwable)t);
        }
    }

    protected synchronized void addTypedEventListener(ActivitiEventListener listener, ActivitiEventType type) {
        this.typedListeners.computeIfAbsent(type, k -> new CopyOnWriteArrayList());
        List<ActivitiEventListener> listeners = this.typedListeners.get((Object)type);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    protected void addTestingEventListener(ActivitiEventListener listener, ActivitiEventType type) {
        this.testingListeners.computeIfAbsent(type, k -> new CopyOnWriteArrayList());
        List<ActivitiEventListener> listeners = this.testingListeners.get((Object)type);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    protected void addTestingPlanEventListener(ActivitiEventListener listener, ActivitiEventType type) {
        this.testingPlanListeners.computeIfAbsent(type, k -> new CopyOnWriteArrayList());
        List<ActivitiEventListener> listeners = this.testingPlanListeners.get((Object)type);
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }
}

