/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.enumeration;

import java.util.HashSet;
import java.util.Set;
import kd.bos.workflow.engine.rule.condition.constants.ConditionalRuleConstants;

public enum ConditionalRuleType {
    sequenceFlow,
    autoApproval,
    participant,
    processStartUp,
    bpmProcStartUp,
    eventStartUp,
    skip,
    closeProcess,
    taskCenter,
    configScheme,
    msgSendRule,
    auditPointsRule,
    auditPointsBizRule,
    taskSubjectRule,
    billSubjectRule,
    timingWait,
    taskCloseRule,
    dataConvergenceRule,
    exeConditionRule,
    batchOpRule,
    JUDGECONDITION,
    DELEGATESETTINGRULE;


    public static String getTypeName(String type) {
        String name = "";
        switch (type) {
            case "sequenceFlow": {
                name = ConditionalRuleConstants.getSequenceFlowText();
                break;
            }
            case "autoApproval": {
                name = ConditionalRuleConstants.getAutoApprovalText();
                break;
            }
            case "participant": {
                name = ConditionalRuleConstants.getParticipantText();
                break;
            }
            case "processStartUp": 
            case "bpmProcStartUp": {
                name = ConditionalRuleConstants.getProcessStartUpText();
                break;
            }
            case "eventStartUp": {
                name = ConditionalRuleConstants.getEventStartUpText();
                break;
            }
            case "skip": {
                name = ConditionalRuleConstants.getSkipText();
                break;
            }
            case "closeProcess": {
                name = ConditionalRuleConstants.getCloseProcessText();
                break;
            }
            case "taskCenter": {
                name = ConditionalRuleConstants.getTaskCenterText();
                break;
            }
            case "configScheme": {
                name = ConditionalRuleConstants.getConfigSchemeText();
                break;
            }
            case "msgSendRule": {
                name = ConditionalRuleConstants.getMsgSendRuleText();
                break;
            }
            case "auditPointsRule": {
                name = ConditionalRuleConstants.getAuditPointsRuleText();
                break;
            }
            case "auditPointsBizRule": {
                name = ConditionalRuleConstants.getAuditPointsBizRuleText();
                break;
            }
            case "taskSubjectRule": {
                name = ConditionalRuleConstants.getTaskSubjectRuleText();
                break;
            }
            case "billSubjectRule": {
                name = ConditionalRuleConstants.getBillSubjectRuleText();
                break;
            }
            case "taskCloseRule": {
                name = ConditionalRuleConstants.getTaskCloseRuleText();
                break;
            }
            case "dataConvergenceRule": {
                name = ConditionalRuleConstants.getDataConvergenceRuleText();
                break;
            }
            case "exeConditionRule": {
                name = ConditionalRuleConstants.getExeConditionRuleText();
                break;
            }
            case "timingWait": {
                name = ConditionalRuleConstants.getTimingWaitText();
                break;
            }
            case "batchOpRule": {
                name = ConditionalRuleConstants.getBatchOpRuleText();
                break;
            }
            case "DELEGATESETTINGRULE": {
                name = ConditionalRuleConstants.getDelegateSettingRuleText();
                break;
            }
        }
        return name;
    }

    public static Set<String> getTypes() {
        ConditionalRuleType[] values = ConditionalRuleType.values();
        HashSet<String> types = new HashSet<String>(values.length);
        for (ConditionalRuleType type : values) {
            types.add(type.name());
        }
        return types;
    }
}

