/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.event.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.EventParam;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;

public class WaitEventUtil {
    public static final String KEY_EVENT_PARAMS = "params";
    public static final String START_PROCESS_EVENT_ID = "event_id_to_start_process";
    private static Log logger = LogFactory.getLog(WaitEventUtil.class);

    private WaitEventUtil() {
    }

    public static String getEventParamsVariableKey(WaitTask waitTask) {
        return String.format("%s.%s", waitTask.getId(), waitTask.getTimingModel().getEvent());
    }

    public static String getEventParamsVariableKey(String activityId, String event) {
        return String.format("%s.%s", activityId, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTrueEventCondition(WaitTask waitTask, ExecutionEntity execution, Map<String, Object> data) {
        boolean ret = false;
        try {
            Object evtParams;
            ConditionalRuleEntity condition = waitTask.getTimingModel().getCondition();
            String key = ConditionUtil.getConInstKey(execution.getCurrentActivityId(), "EVENT-WAIT-CONDITION");
            Object object = evtParams = data != null ? data.get("eventParams") : null;
            if (evtParams != null) {
                JsonNode eventParams = null;
                try {
                    eventParams = new ObjectMapper().readTree(SerializationUtils.toJsonString((Object)evtParams));
                    execution.setTransientVariable("eventParams", eventParams);
                }
                catch (Exception e) {
                    logger.error(WfUtils.getExceptionStacktrace(e));
                }
            }
            ConditionType.logOpDesc(condition);
            ret = ConditionUtil.hasTrueCondition(condition, (VariableScope)execution, key);
        }
        finally {
            execution.removeTransientVariable("eventParams");
        }
        return ret;
    }

    public static ObjectNode getEventParamsJson(DelegateExecution execution, List<EventParam> eventParams) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        if (eventParams != null && !eventParams.isEmpty()) {
            DynamicObject dynamicObject = WfUtils.findBusinessObject(execution.getBusinessKey(), execution.getEntityNumber());
            for (EventParam param : eventParams) {
                String value = param.getValue();
                if (value != null && ExpressionPropUtils.isExpressionValue(value)) {
                    node.put(param.getNumber(), WaitEventUtil.getValue(mapper, execution, dynamicObject, param.getValue()));
                    continue;
                }
                node.put(param.getNumber(), value);
            }
        }
        return node;
    }

    private static JsonNode getValue(ObjectMapper mapper, DelegateExecution execution, DynamicObject dynamicObject, String expression) {
        try {
            Object value = ExpressionCalculatorUtil.parseValue(dynamicObject, execution, expression, null);
            if (value == null) {
                return null;
            }
            return mapper.readTree(SerializationUtils.toJsonString((Object)value));
        }
        catch (Exception e) {
            logger.error(String.format("parse eventParams error! executionId: %s, expression: %s, reason: %s", execution.getId(), expression, WfUtils.getExceptionStacktrace(e)));
            return null;
        }
    }
}

