/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.extitf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.extitf.IExternalInterfaceExecutor;
import kd.bos.workflow.engine.idempotent.IdempotentHelper;
import kd.bos.workflow.engine.idempotent.IdempotentInfo;
import kd.bos.workflow.engine.impl.AgentExecutionImpl;
import kd.bos.workflow.engine.impl.AgentTaskImpl;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.relservice.BusinessLogicServiceHelper;

public abstract class AbstractExtItfExecutor
implements IExternalInterfaceExecutor {
    protected String KEY_RESULT = "result";
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(ExtItfCallerType type, Object value, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (IdempotentHelper.isEnableIdempotent() && this.supportIdempotent(type, this.getEventName(args))) {
            return this.idempotentExecute(type, value, args);
        }
        return this.executeExtItf(type, value, args);
    }

    private String getEventName(Object ... args) {
        String eventName = "";
        AgentExecution execution = this.getAgentExecution(args);
        if (execution != null) {
            eventName = execution.getEventName();
        } else {
            AgentTask task = this.getAgentTask(args);
            if (task != null) {
                eventName = task.getEventName();
            }
        }
        return eventName;
    }

    protected AgentExecution getAgentExecution(Object ... args) {
        if (args == null || args.length < 1) {
            return null;
        }
        for (Object obj : args) {
            if (!(obj instanceof AgentExecution)) continue;
            return (AgentExecution)obj;
        }
        return null;
    }

    private AgentTask getAgentTask(Object ... args) {
        if (args == null || args.length < 1) {
            return null;
        }
        for (Object obj : args) {
            if (!(obj instanceof AgentTask)) continue;
            return (AgentTask)obj;
        }
        return null;
    }

    private Object idempotentExecute(ExtItfCallerType type, Object value, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String typeStr = type.name();
        String valStr = value.toString();
        StringBuilder sb = new StringBuilder(valStr).append(typeStr);
        String xid = sb.toString();
        AgentExecution execution = this.getAgentExecution(args);
        String scene = "";
        String businessKey = null;
        Long instanceId = null;
        HistoricActivityInstanceEntity actInst = null;
        if (execution != null) {
            scene = IdempotentHelper.getExecuteScene(typeStr, execution);
            actInst = IdempotentHelper.getLatestHistoricActivityInstance(execution);
            xid = IdempotentHelper.generateXid(sb, execution, actInst);
            businessKey = execution.getBusinessKey();
            instanceId = execution.getProcessInstanceId();
        } else {
            AgentTask task = this.getAgentTask(args);
            if (task != null) {
                execution = task.getExecution();
                scene = String.format("%s:%s", typeStr, execution.getEventName());
                actInst = IdempotentHelper.getLatestHistoricActivityInstance(execution);
                xid = IdempotentHelper.generateXid(sb, task, actInst);
                businessKey = task.getBusinessKey();
                instanceId = task.getProcessInstanceId();
            }
        }
        boolean success = true;
        String jsonResult = "";
        String tip = "";
        try {
            IdempotentInfo xidInfo = IdempotentHelper.findIdempotentInfoByXid(xid);
            if (xidInfo != null && "successed".equals(xidInfo.getState())) {
                this.log.debug(String.format("%s has been executed! type: %s", new Object[]{value, type}));
                tip = "has been executed!";
                jsonResult = xidInfo.getResult();
                Object object = this.getResultFromJSON(jsonResult);
                return object;
            }
            Object result = this.executeExtItf(type, value, args);
            jsonResult = this.resultToJSON(result);
            IdempotentHelper.success(xid, valStr, businessKey, instanceId, jsonResult, actInst, scene);
            Object object = result;
            return object;
        }
        catch (Exception e) {
            success = false;
            IdempotentHelper.fail(xid, valStr, businessKey, instanceId, WfUtils.getExceptionStacktrace(e), actInst, scene);
            throw e;
        }
        finally {
            this.dispatchEvent(execution, valStr, xid, tip, success, jsonResult);
        }
    }

    protected boolean supportIdempotent(ExtItfCallerType type, String eventName) {
        if (eventName != null && eventName.startsWith("approverModify")) {
            return false;
        }
        String method = ExternalInterfaceUtil.getMethodName(type);
        return "notify".equals(method) || "notifyByWithdraw".equals(method);
    }

    protected void dispatchEvent(AgentExecution execution, String value, String xid, String tip, boolean success, String result) {
        if (execution != null) {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("xid", xid);
            params.put("tip", tip);
            BusinessLogicServiceHelper.dispatchExecuteBusinessExtItfEvent(execution, value, params, success, result);
        } else {
            this.log.warn("dispatch event failed, because execution is null!");
        }
    }

    protected String resultToJSON(Object result) {
        if (result == null) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(1);
        ret.put(this.KEY_RESULT, result);
        return JSON.toJSONString(ret);
    }

    protected Object getResultFromJSON(String json) {
        if (WfUtils.isNotEmpty(json)) {
            JSONObject ret = JSON.parseObject((String)json);
            return ret.get((Object)this.KEY_RESULT);
        }
        return null;
    }

    protected Object[] getMicroServiceInvokeParams(Object[] args) {
        if (args == null || args.length < 1) {
            return args;
        }
        Object[] params = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            params[i] = arg instanceof DelegateExecution ? new AgentExecutionImpl((DelegateExecution)arg) : (arg instanceof AgentTask ? new AgentTaskImpl((AgentTask)arg) : arg);
        }
        return params;
    }

    protected void mergeMicroVariable(DelegateExecution execution) {
        Map<String, Object> variableMap;
        if (execution == null) {
            return;
        }
        Long variablesKey = (Long)execution.getVariable("microservice_variablesid");
        if (variablesKey != null && (variableMap = WfCacheHelper.getMicroOperateVariable(variablesKey)) != null) {
            execution.setVariables(variableMap);
        }
    }

    protected void clearOperationOfMicroVariable(DelegateExecution execution) {
        if (execution == null) {
            return;
        }
        Long variablesKey = (Long)execution.getVariable("microservice_variablesid");
        WfCacheHelper.removeMicroOperateVariable(variablesKey);
        execution.removeVariable("microservice_variablesid");
    }

    protected abstract Object executeExtItf(ExtItfCallerType var1, Object var2, Object ... var3) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException;
}

