/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.extitf;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.extitf.DefaultExtItfExecutor;
import kd.bos.workflow.engine.extitf.ExtItfOperationExecutor;
import kd.bos.workflow.engine.extitf.ExtItfPluginExecutor;
import kd.bos.workflow.engine.extitf.ExtItfScriptExecutor;
import kd.bos.workflow.engine.extitf.IExternalInterfaceExecutor;

public class ExtItfExecutorFactory {
    private static Map<String, IExternalInterfaceExecutor> executorMap = new HashMap<String, IExternalInterfaceExecutor>();

    public static IExternalInterfaceExecutor getExecutor(String type) {
        IExternalInterfaceExecutor executor = executorMap.get(type);
        if (executor != null) {
            return executor;
        }
        switch (type) {
            case "class": {
                executor = new ExtItfPluginExecutor();
                break;
            }
            case "script": {
                executor = new ExtItfScriptExecutor();
                break;
            }
            case "operation": {
                executor = new ExtItfOperationExecutor();
                break;
            }
            default: {
                executor = new DefaultExtItfExecutor();
            }
        }
        executorMap.put(type, executor);
        return executor;
    }
}

