/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.extitf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.extitf.IExternalInterfaceExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.relservice.BusinessLogicServiceHelper;

public class ExtItfOperationExecutor
implements IExternalInterfaceExecutor {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(ExtItfCallerType type, Object value, Object ... args) {
        Map data = (Map)value;
        String operType = ExternalInterfaceUtil.getMethodName(type);
        String operation = (String)data.get(operType);
        if (WfUtils.isEmpty(operation)) {
            return null;
        }
        int len = args.length;
        if (len < 3) {
            return null;
        }
        Object param = args[0];
        if (param instanceof String) {
            String entityNumber = (String)args[0];
            DelegateExecution execution = (DelegateExecution)args[len - 1];
            Object context = args[len - 2];
            Object[] params = Arrays.copyOfRange(args, 1, len - 2);
            this.log.debug(String.format("--\u6267\u884c %s %s", entityNumber, operation));
            return BusinessLogicServiceHelper.invokeOperationService(operation, entityNumber, params, context, execution);
        }
        if (param instanceof TaskEntityImpl) {
            AgentTask task = (AgentTask)param;
            String entityNumber = task.getEntityNumber();
            Map variables = (Map)args[len - 1];
            HashMap<String, String> tp = new HashMap<String, String>();
            if (variables != null && !variables.isEmpty()) {
                Set set = variables.entrySet();
                for (Map.Entry entry : set) {
                    try {
                        if (entry.getValue() instanceof String) {
                            tp.put((String)entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        if (entry.getValue() instanceof Long) {
                            tp.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                            continue;
                        }
                        tp.put((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
                    }
                    catch (Exception e) {
                        this.log.error(String.format("wrong data type:%s", e.getMessage()));
                    }
                }
            }
            this.log.debug(String.format("--\u6267\u884c %s %s", entityNumber, operation));
            return BusinessLogicServiceHelper.invokeOperationService(operation, entityNumber, new Object[]{task.getBusinessKey()}, tp, task, task.getExecution());
        }
        this.log.error(String.format("--error params[%s]", value));
        return null;
    }
}

