/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.extitf;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.orm.ORM;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.extitf.AbstractExtItfExecutor;
import kd.bos.workflow.engine.extitf.EntityNumberParam;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExtItfParameter;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.util.WfCommonUtil;
import org.apache.commons.beanutils.MethodUtils;

public class ExtItfPluginExecutor
extends AbstractExtItfExecutor {
    @Override
    public Object executeExtItf(ExtItfCallerType type, Object value, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String method = ExternalInterfaceUtil.getMethodName(type);
        Object obj = TypesContainer.createInstance((String)value.toString());
        Object result = null;
        try {
            result = MethodUtils.invokeMethod((Object)obj, (String)method, (Object[])args);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
        return result;
    }

    private boolean isSupportMicroService(ExtItfCallerType type, String event) {
        if (ExtItfCallerType.CUSTOMBUSINESS == type || ExtItfCallerType.VALIDATION == type || ExtItfCallerType.LISTENER_WITHDRAW == type || ExtItfCallerType.PARTICIPANT == type || ExtItfCallerType.CALCULATEPARTICIPANT == type || ExtItfCallerType.GETPERMISSIONS == type || ExtItfCallerType.GETPUSHSTATUS == type) {
            return true;
        }
        return ExtItfCallerType.LISTENER == type && event != null && event.startsWith("approverModify") && !JobUtil.isInJobThread();
    }

    @Override
    public Object executeByMicroService(ExtItfCallerType type, Object value, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String method = ExternalInterfaceUtil.getMethodName(type);
        ExtItfParameter parameter = this.getExtItfParameter(method, args);
        if (!this.isSupportMicroService(type, parameter.getEvent())) {
            this.log.debug(String.format("%s not support execute by microService.", new Object[]{type}));
            return this.execute(type, value, args);
        }
        String entityNumber = parameter.getEntityNumber();
        String appId = "wf";
        if (WfUtils.isNotEmpty(entityNumber)) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
            appId = dt.getAppId();
        } else {
            this.log.debug("entityNumber is null.");
        }
        DelegateExecution execution = (DelegateExecution)this.getAgentExecution(args);
        if (execution != null) {
            execution.setVariable("microservice_variablesid", ORM.create().genLongId("wf_confcenter"));
        }
        Object[] params = this.getMicroServiceInvokeParams(args);
        Object result = null;
        try {
            result = WfCommonUtil.invokeBOSServiceByAppId((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBizPlugin", (Object[])new Object[]{value, method, params});
            this.mergeMicroVariable(execution);
        }
        catch (Exception e) {
            this.log.debug(String.format("Invoke %s's %s Error! %s", value, method, WfUtils.getExceptionStacktrace(e)));
            throw e;
        }
        finally {
            this.clearOperationOfMicroVariable(execution);
        }
        return result;
    }

    private ExtItfParameter getExtItfParameter(String methodName, Object ... args) {
        ExtItfParameter parameter = new ExtItfParameter();
        if (args == null || args.length < 1) {
            return parameter;
        }
        for (Object obj : args) {
            if (obj instanceof DynamicObject) {
                DynamicObject dynObj = (DynamicObject)obj;
                parameter.setEntityNumber(dynObj.getDataEntityType().getName());
                break;
            }
            if (obj instanceof AgentTask) {
                AgentTask task = (AgentTask)obj;
                parameter.setEvent(task.getEventName());
                parameter.setEntityNumber(task.getEntityNumber());
                break;
            }
            if (obj instanceof AgentExecution) {
                AgentExecution execution = (AgentExecution)obj;
                parameter.setEvent(execution.getEventName());
                parameter.setEntityNumber(execution.getEntityNumber());
                break;
            }
            this.log.debug("no DynamicObject\u3001 agentTask or agentExecution in args.");
        }
        if (parameter.getEntityNumber() != null) {
            return parameter;
        }
        try {
            Method extItfMethod = this.getMethod(methodName, args);
            if (extItfMethod == null) {
                return parameter;
            }
            Annotation[][] paramAnnotations = extItfMethod.getParameterAnnotations();
            if (paramAnnotations == null) {
                return parameter;
            }
            boolean find = false;
            Annotation[] annotations = null;
            for (int i = 0; i < paramAnnotations.length; ++i) {
                for (Annotation annotation : annotations = paramAnnotations[i]) {
                    if (!(annotation instanceof EntityNumberParam)) continue;
                    find = true;
                    parameter.setEntityNumber((String)args[i]);
                    break;
                }
                if (!find) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        return parameter;
    }

    private Method getMethod(String methodName, Object ... args) {
        Method[] methods;
        for (Method method : methods = IWorkflowPlugin.class.getMethods()) {
            Class<?>[] types;
            if (!methodName.equals(method.getName()) || (types = method.getParameterTypes()).length != args.length) continue;
            boolean match = true;
            for (int i = 0; i < args.length; ++i) {
                if (ExternalInterfaceUtil.isSameClass(types[i], args[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return null;
    }
}

