/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.extitf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptExecutor;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.extitf.AbstractExtItfExecutor;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import org.mozilla.javascript.JavaScriptException;

public class ExtItfScriptExecutor
extends AbstractExtItfExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeExtItf(ExtItfCallerType type, Object value, Object ... args) {
        Map data = (Map)value;
        String id = (String)data.get("id");
        String content = this.getScriptContent(id);
        ScriptExecutor executor = ScriptExecutor.getOrCreate();
        executor.init(ctx -> ctx.require(new String[]{"/WorkflowScriptModule.conf"}));
        Object result = null;
        DelegateExecution execution = (DelegateExecution)this.getAgentExecution(args);
        if (execution != null) {
            execution.setVariable("microservice_variablesid", ORM.create().genLongId("wf_confcenter"));
        }
        try {
            executor.begin();
            executor.exec(new String[]{content});
            try {
                result = executor.call("plugin." + ExternalInterfaceUtil.getMethodName(type), this.getMicroServiceInvokeParams(args));
            }
            finally {
                TimeoutHandleFactory.get().doTimeoutMarker(true);
            }
            this.mergeMicroVariable(execution);
        }
        catch (Exception e) {
            UndeclaredThrowableException ute;
            this.log.warn(String.format("\u5916\u90e8\u63a5\u53e3(\u811a\u672c)\u6267\u884c\u51fa\u9519\uff01 %s ", WfUtils.getExceptionStacktrace(e)));
            Throwable t = e;
            if (t instanceof UndeclaredThrowableException && (ute = (UndeclaredThrowableException)t).getUndeclaredThrowable() instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)ute.getUndeclaredThrowable();
                t = ite.getTargetException();
            }
            if (t instanceof JavaScriptException) {
                String message = t.getMessage();
                if (message != null) {
                    message = message.replaceFirst("Error:\\s*(.+)\\(script.+?\\)", "$1");
                }
                throw new KDBizException(message);
            }
            throw e;
        }
        finally {
            executor.end();
            this.clearOperationOfMicroVariable(execution);
        }
        return result;
    }

    private String getScriptContent(String scriptId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)scriptId)};
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"ide_pluginscript", (String)"id,txt_scriptcontext_tag", (QFilter[])filters);
        return dynObj.getString("txt_scriptcontext_tag");
    }
}

