/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.extitf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.ws.handler.MessageContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.DelegateTask;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExtItfExecutorFactory;
import kd.bos.workflow.engine.extitf.ExternalInterfaceType;
import kd.bos.workflow.engine.extitf.IExternalInterfaceExecutor;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WfTraceType;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;

public class ExternalInterfaceUtil {
    private static Log log = LogFactory.getLog(ExternalInterfaceUtil.class);
    public static final String EXTITFVALREGEX = "^\\{\"type\":\"[a-zA-Z]+\"(,\\s*\"microservice\":(true|false))?,\\s*\"value\":(.+?)(,\\s*\"params\":(.+))?\\}$";
    private static final int MAX_LENGTH = 1000;

    private static boolean isMicroserviceExecute(Object microService) {
        if (microService != null) {
            return Boolean.TRUE.equals(microService);
        }
        return WfConfigurationUtil.isEnableMicroservice();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object executeExtItf(ExtItfCallerType type, String str, Object ... args) {
        Object method;
        if (WfUtils.isEmpty(str)) {
            return null;
        }
        Long beginTime = System.currentTimeMillis();
        boolean isSuccess = true;
        HashMap<String, Object> map = ExternalInterfaceUtil.castJSONToMap(str);
        boolean kingscriptMark = ExternalInterfaceUtil.isKingScript(map);
        IExternalInterfaceExecutor executor = null;
        IWorkflowPlugin workflowPlugin = null;
        if (kingscriptMark) {
            workflowPlugin = (IWorkflowPlugin)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(ExternalInterfaceUtil.getValueByExtParams(map, "number"), scriptPath -> ProjectInitializerManager.getEngineAutoDebug((String)scriptPath)));
        } else {
            executor = ExtItfExecutorFactory.getExecutor((String)map.get("type"));
        }
        Object value = map.get("value");
        if (value == null) return null;
        if (value instanceof String && WfUtils.isEmpty(value.toString())) {
            return null;
        }
        boolean isNeedRemovePluginParams = ExternalInterfaceUtil.setExtItfPluginParams((String)map.get("type"), map.get("params"), args);
        Object ret = null;
        try {
            log.debug("--execute external interface: " + value);
            Object microService = map.get("microservice");
            if (kingscriptMark) {
                method = ExternalInterfaceUtil.getMethodName(type);
                ret = MethodUtils.invokeMethod((Object)workflowPlugin, (String)method, (Object[])args);
            } else {
                ret = ExternalInterfaceUtil.isMicroserviceExecute(microService) ? executor.executeByMicroService(type, value, args) : executor.execute(type, value, args);
            }
            method = ret;
        }
        catch (KDBizException e) {
            try {
                log.error("ExternalInterfaceUtil#executeExtItf#KDBizException", (Throwable)e);
                isSuccess = false;
                Object ctx = ExternalInterfaceUtil.findExecutionContext(args);
                ErrorCode code = e.getErrorCode();
                if (code != null) throw ExceptionUtil.createBusinessException(ctx, e, str, code);
                code = WFErrorCode.businessBizOperationError();
                throw ExceptionUtil.createBusinessException(ctx, e, str, code);
                catch (Exception e2) {
                    log.error("ExternalInterfaceUtil#executeExtItf#Exception", (Throwable)e2);
                    isSuccess = false;
                    ctx = ExternalInterfaceUtil.findExecutionContext(args);
                    Throwable t = e2;
                    if (e2 instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e2;
                        t = ite.getTargetException();
                    }
                    if (t instanceof KDBizException) {
                        ErrorCode code2 = ((KDBizException)t).getErrorCode();
                        if (code2 != null) throw ExceptionUtil.createBusinessException(ctx, t, str, code2);
                        code2 = WFErrorCode.businessBizOperationError();
                        throw ExceptionUtil.createBusinessException(ctx, t, str, code2);
                    }
                    if (!(t instanceof WFBizException)) throw ExceptionUtil.createBusinessException(ctx, t, str);
                    throw (WFBizException)((Object)t);
                }
            }
            catch (Throwable throwable) {
                ExternalInterfaceUtil.removeExtItfPluginParams(isNeedRemovePluginParams, args);
                if (!isSuccess) throw throwable;
                Long endTime = System.currentTimeMillis();
                log.debug(String.format("ext plugin:[%s] executed success!", value));
                if (WfTraceType.get() == null) throw throwable;
                if (WfTraceType.get().getJobInfo() == null) throw throwable;
                if (WfTraceType.get().getJobInfo().getCurrentJobId() == null) throw throwable;
                if (ret == null && ExternalInterfaceUtil.checkPluginJsonStr(value)) {
                    log.debug("no need collection");
                    throw throwable;
                }
                IndicatorInfo indicatorInfo = ExternalInterfaceUtil.buildPluginExecutionIndicator(beginTime, endTime, type, str, args);
                if (indicatorInfo != null && WfUtils.isNotEmpty(indicatorInfo.getNumber())) {
                    WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
                }
                indicatorInfo = null;
                throw throwable;
            }
        }
        ExternalInterfaceUtil.removeExtItfPluginParams(isNeedRemovePluginParams, args);
        if (!isSuccess) return method;
        Long endTime = System.currentTimeMillis();
        log.debug(String.format("ext plugin:[%s] executed success!", value));
        if (WfTraceType.get() == null) return method;
        if (WfTraceType.get().getJobInfo() == null) return method;
        if (WfTraceType.get().getJobInfo().getCurrentJobId() == null) return method;
        if (ret == null && ExternalInterfaceUtil.checkPluginJsonStr(value)) {
            log.debug("no need collection");
            return method;
        }
        IndicatorInfo indicatorInfo = ExternalInterfaceUtil.buildPluginExecutionIndicator(beginTime, endTime, type, str, args);
        if (indicatorInfo != null && WfUtils.isNotEmpty(indicatorInfo.getNumber())) {
            WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
        }
        indicatorInfo = null;
        return method;
    }

    private static boolean isKingScript(HashMap<String, Object> map) {
        String typeValue;
        String string = typeValue = map.get("type") == null ? "" : map.get("type").toString();
        if (!"script".equals(typeValue)) {
            return false;
        }
        String kingscriptType = ExternalInterfaceUtil.getValueByExtParams(map, "script_type");
        return "KingScript".equals(kingscriptType);
    }

    private static String getValueByExtParams(HashMap<String, Object> map, String key) {
        String valueValue;
        String string = valueValue = map.get("value") == null ? null : JSONObject.toJSONString((Object)map.get("value"));
        if (StringUtils.isBlank((String)valueValue)) {
            return null;
        }
        JSONObject valueJson = JSONObject.parseObject((String)valueValue);
        return valueJson.get((Object)key) == null ? null : valueJson.get((Object)key).toString();
    }

    private static void removeExtItfPluginParams(boolean isNeedRemovePluginParams, Object[] args) {
        if (isNeedRemovePluginParams) {
            for (Object arg : args) {
                if (arg instanceof DelegateExecution) {
                    DelegateExecution execution = (DelegateExecution)arg;
                    execution.setCurrentWFPluginParams(null);
                    log.debug("DelegateExecution\u6e05\u9664\u5916\u90e8\u63a5\u53e3\u63d2\u4ef6\u53c2\u6570\u6210\u529f\uff01");
                    continue;
                }
                if (arg instanceof BusinessModelVariableScope) {
                    BusinessModelVariableScope variableScope = (BusinessModelVariableScope)arg;
                    variableScope.setCurrentWFPluginParams(null);
                    log.debug("BusinessModelVariableScope\u6e05\u9664\u5916\u90e8\u63a5\u53e3\u63d2\u4ef6\u53c2\u6570\u6210\u529f\uff01");
                    continue;
                }
                if (!(arg instanceof DelegateTask)) continue;
                DelegateTask delegateTask = (DelegateTask)arg;
                delegateTask.setCurrentWFPluginParams(null);
                log.debug("DelegateTask\u6e05\u9664\u5916\u90e8\u63a5\u53e3\u63d2\u4ef6\u53c2\u6570\u6210\u529f\uff01");
            }
        }
    }

    private static boolean setExtItfPluginParams(String type, Object pluginParams, Object[] args) {
        List paramsList;
        boolean isNeedRemovePluginParams = false;
        if ("class".equals(type) && ExternalInterfaceUtil.isValidParameterValues(pluginParams) && WfUtils.isNotEmptyForCollection(paramsList = (List)pluginParams)) {
            LinkedHashMap<String, Object> wfPluginParams = new LinkedHashMap<String, Object>(paramsList.size());
            for (Map map : paramsList) {
                String parameterNumber = (String)map.get("number");
                String parameterType = (String)map.get("type");
                Object parameterValue = ExternalInterfaceUtil.getParameterValue(parameterType, map.get("value"));
                wfPluginParams.put(parameterNumber, parameterValue);
            }
            for (Object arg : args) {
                if (arg instanceof DelegateExecution) {
                    DelegateExecution execution = (DelegateExecution)arg;
                    execution.setCurrentWFPluginParams(wfPluginParams);
                    isNeedRemovePluginParams = true;
                    continue;
                }
                if (arg instanceof BusinessModelVariableScope) {
                    BusinessModelVariableScope variableScope = (BusinessModelVariableScope)arg;
                    variableScope.setCurrentWFPluginParams(wfPluginParams);
                    isNeedRemovePluginParams = true;
                    continue;
                }
                if (!(arg instanceof DelegateTask)) continue;
                DelegateTask delegateTask = (DelegateTask)arg;
                delegateTask.setCurrentWFPluginParams(wfPluginParams);
                isNeedRemovePluginParams = true;
            }
        }
        log.debug(String.format("\u6267\u884cJava\u63d2\u4ef6\uff0c\u5916\u90e8\u63a5\u53e3\u53c2\u6570\u8bbe\u7f6e\u7ed3\u679c\u6700\u7ec8\u4e3a\uff1a%s", isNeedRemovePluginParams));
        return isNeedRemovePluginParams;
    }

    private static boolean isValidParameterValues(Object params) {
        if (params instanceof List) {
            return true;
        }
        log.debug(String.format("\u5f53\u524d\u5916\u90e8\u63a5\u53e3\u63d2\u4ef6\u53c2\u6570[%s]\uff0c\u4e3a\u7a7a\u6216\u65e0\u6548\uff01", params));
        return false;
    }

    private static Object getParameterValue(String type, Object value) {
        Object returnValue = null;
        if (StringUtils.isNotBlank((String)type) && value != null) {
            String valueStr = String.valueOf(value);
            switch (type) {
                case "String": {
                    returnValue = valueStr;
                    break;
                }
                case "Long": {
                    returnValue = Long.parseLong(valueStr);
                    break;
                }
                case "BigDecimal": {
                    returnValue = new BigDecimal(valueStr);
                    break;
                }
                case "Boolean": {
                    returnValue = Boolean.parseBoolean(valueStr);
                    break;
                }
            }
        }
        return returnValue;
    }

    private static Object findExecutionContext(Object[] args) {
        if (args != null && args.length > 0) {
            for (Object obj : args) {
                if (!(obj instanceof VariableScope) && !(obj instanceof AbstractJobEntity) && !(obj instanceof MessageContext)) continue;
                return obj;
            }
        }
        return null;
    }

    public static String getMethodName(ExtItfCallerType type) {
        switch (type) {
            case PARTICIPANT: {
                return "calcUserIds";
            }
            case CONDITIONALRULE: {
                return "hasTrueCondition";
            }
            case LISTENER: {
                return "notify";
            }
            case LISTENER_WITHDRAW: {
                return "notifyByWithdraw";
            }
            case OPERATION: {
                return "forward";
            }
            case OPERATION_WITHDRAW: {
                return "withdraw";
            }
            case FORMATFLOWRECORD: {
                return "formatFlowRecord";
            }
            case FORMATFLOWRECORDS: {
                return "formatFlowRecords";
            }
            case BILLSUBJECT: {
                return "parseBillSubject";
            }
            case TIMECONTROL: {
                return "getExpireTime";
            }
            case LISTENER_CANWITHDRAW: {
                return "canWithdraw";
            }
            case BEFOREHANDLETASK: {
                return "beforeHandleTask";
            }
            case HANDLETASK: {
                return "handleTask";
            }
            case AFTERHANDLETASK: {
                return "afterHandleTask";
            }
            case TASKOPERATIONPLUGIN: {
                return "executeTaskOperation";
            }
            case TRDPRINTFORMATRECORDS: {
                return "formatTrdPrintRecords";
            }
            case VALIDATION: {
                return "validate";
            }
            case GETPUSHSTATUS: {
                return "getPushStatusInfo";
            }
            case GETPERMISSIONS: {
                return "getBillPermissions";
            }
            case CUSTOMAPPROVALRECORD: {
                return "getCustomApprovalRecordGroup";
            }
            case CALCULATEPARTICIPANT: {
                return "filterParticipant";
            }
            case CUSTOMBUSINESS: {
                return "getJointAuditResult";
            }
            case AFTERSUSPENDPROCESS: {
                return "afterSuspendProcess";
            }
            case AFTERACTIVEPROCESS: {
                return "afterActiveProcess";
            }
            case CALALLOWVIEWCHATPROCESS: {
                return "hasViewFlowChartPermProcessInstance";
            }
            case FILTERAPPROVALRECORDBYAUTH: {
                return "filterApprovalRecordByAuth";
            }
            case EXPIREPLUGIN: {
                return "expirePluin";
            }
            case GROUPNAMEFORAPPROVALRECORD: {
                return "resetYZJGroupProperty";
            }
        }
        return null;
    }

    public static HashMap<String, Object> castJSONToMap(Object jsonStr) {
        HashMap valMap = new HashMap();
        try {
            if (WfUtils.isNotEmptyString(jsonStr)) {
                valMap = (HashMap)JSONUtils.cast((String)((String)jsonStr), HashMap.class);
            }
        }
        catch (IOException e) {
            log.warn(String.format("%s %s %s", "JSON\u5b57\u7b26\u4e32\u8f6cMap\u51fa\u9519\uff01", WfUtils.getExceptionStacktrace(e), e.getStackTrace()));
        }
        return valMap;
    }

    public static String castObjectToJSON(Object value) {
        String json = "{}";
        try {
            json = JSONUtils.toString((Object)value);
        }
        catch (IOException e) {
            log.warn(String.format("%s %s %s", "Object\u8f6cJSON\u5b57\u7b26\u4e32\u51fa\u9519\uff01", WfUtils.getExceptionStacktrace(e), e.getStackTrace()));
        }
        return json;
    }

    public static String getTypes(String ... types) {
        int len = types.length;
        if (len == 1) {
            return types[0];
        }
        StringBuilder sb = new StringBuilder();
        while (len-- > 1) {
            sb.append("%s,");
        }
        sb.append("%s");
        Object[] params = new Object[types.length];
        System.arraycopy(types, 0, params, 0, types.length);
        return String.format(sb.toString(), params);
    }

    public static String getExtItfTypeName(String value) {
        String type = ExternalInterfaceUtil.getExtItfType(value);
        return ExternalInterfaceType.getTypeName(type);
    }

    public static String getExtItfType(String value) {
        Pattern pattern;
        Matcher matcher;
        if (ExternalInterfaceUtil.isValidValue(value) && (matcher = (pattern = Pattern.compile("\\{\"type\":\"(\\w+)\",")).matcher(value)).find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static boolean isValidValue(String value) {
        if (value == null) {
            return false;
        }
        return value.matches(EXTITFVALREGEX);
    }

    public static String getExtItfValue(String value) {
        if (!ExternalInterfaceUtil.isValidValue(value)) {
            return value;
        }
        Pattern pattern = Pattern.compile(EXTITFVALREGEX);
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            String val = matcher.group(3);
            if (val.startsWith("{")) {
                return val;
            }
            return val.replaceAll("\"", "");
        }
        return value;
    }

    public static String getExtItfParams(String value) {
        String params;
        if (!ExternalInterfaceUtil.isValidValue(value)) {
            return null;
        }
        Pattern pattern = Pattern.compile(EXTITFVALREGEX);
        Matcher matcher = pattern.matcher(value);
        if (matcher.find() && WfUtils.isNotEmpty(params = matcher.group(5))) {
            return params;
        }
        return null;
    }

    public static String getFormattedValue(String type, String value) {
        String string = value = value == null ? "" : value.trim();
        if (!value.startsWith("{")) {
            value = String.format("\"%s\"", value);
        }
        return String.format("{\"type\":\"%s\", \"value\":%s}", type, value);
    }

    public static String getFormattedPluginValue(String type, Boolean microService, String value) {
        if (Boolean.TRUE.equals(microService)) {
            value = String.format("\"%s\"", value == null ? "" : value.trim());
            return String.format("{\"type\":\"%s\", \"microservice\":%s, \"value\":%s}", type, microService, value);
        }
        return ExternalInterfaceUtil.getFormattedValue(type, value);
    }

    public static String getFormattedPluginValueWithParams(String type, Boolean microService, String pluginValue, String paramsValue) {
        if (Boolean.TRUE.equals(microService)) {
            pluginValue = String.format("\"%s\"", pluginValue == null ? "" : pluginValue.trim());
            return String.format("{\"type\":\"%s\", \"microservice\":%s, \"value\":%s, \"params\":%s}", type, microService, pluginValue, paramsValue);
        }
        String string = pluginValue = pluginValue == null ? "" : pluginValue.trim();
        if (!pluginValue.startsWith("{")) {
            pluginValue = String.format("\"%s\"", pluginValue);
        }
        return String.format("{\"type\":\"%s\", \"value\":%s, \"params\":%s}", type, pluginValue, paramsValue);
    }

    public static String getFormattedShowValue(String value) {
        String type = ExternalInterfaceUtil.getExtItfType(value);
        String fmtVal = ExternalInterfaceUtil.getExtItfValue(value);
        if (fmtVal == null || fmtVal.trim().length() < 1) {
            return "";
        }
        HashMap<String, Object> data = null;
        switch (type) {
            case "class": {
                fmtVal = fmtVal.substring(fmtVal.lastIndexOf(46) + 1);
                break;
            }
            case "script": {
                data = ExternalInterfaceUtil.castJSONToMap(fmtVal);
                fmtVal = (String)data.get("number");
                break;
            }
            case "operation": {
                data = ExternalInterfaceUtil.castJSONToMap(fmtVal);
                fmtVal = ExternalInterfaceUtil.getOperationFormattedShowValue(data);
                break;
            }
        }
        return fmtVal;
    }

    private static String getOperationFormattedShowValue(Map<String, Object> data) {
        Object number = data.get("forward");
        Object name = data.get("forward_name");
        Object withdrawNumber = data.get("withdraw");
        Object withdrawName = data.get("withdraw_name");
        name = name != null ? name : number;
        Object object = withdrawName = withdrawName != null ? withdrawName : withdrawNumber;
        if (WfUtils.isNotEmptyString(number) && WfUtils.isNotEmptyString(withdrawNumber)) {
            return String.format(ResManager.loadKDString((String)"\u6b63\u5411\u6d41\u8f6c\u65f6: %1$s(%2$s), \u53cd\u5411\u64a4\u56de\u65f6: %3$s(%4$s)", (String)"ExternalInterfaceUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), name, number, withdrawName, withdrawNumber);
        }
        if (WfUtils.isEmptyString(withdrawNumber)) {
            return String.format(ResManager.loadKDString((String)"\u6b63\u5411\u6d41\u8f6c\u65f6: %1$s(%2$s)", (String)"ExternalInterfaceUtil_2", (String)"bos-wf-engine", (Object[])new Object[0]), name, number);
        }
        return String.format(ResManager.loadKDString((String)"\u53cd\u5411\u64a4\u56de\u65f6: %1$s(%2$s)", (String)"ExternalInterfaceUtil_3", (String)"bos-wf-engine", (Object[])new Object[0]), withdrawName, withdrawNumber);
    }

    public static String buildExtItfOperation(String forward, String forwardName, String withdraw, String withdrawName) {
        if (forward == null && withdraw == null) {
            return null;
        }
        if (forward == null) {
            forwardName = "";
            forward = "";
        } else if (forwardName == null) {
            forwardName = forward;
        }
        if (withdraw == null) {
            withdrawName = "";
            withdraw = "";
        } else if (withdrawName == null) {
            withdrawName = withdraw;
        }
        return String.format("{\"forward\":\"%s\", \"forward_name\":\"%s\", \"withdraw\":\"%s\", \"withdraw_name\":\"%s\"}", forward, forwardName, withdraw, withdrawName);
    }

    public static String buildExtItfOperationValue(String forward, String forwardName, String withdraw, String withdrawName) {
        String operation = ExternalInterfaceUtil.buildExtItfOperation(forward, forwardName, withdraw, withdrawName);
        if (operation == null) {
            return null;
        }
        return ExternalInterfaceUtil.getFormattedValue("operation", operation);
    }

    public static boolean invokeValidateExtItf(DynamicObject billInfo, String extItfValue) {
        HashMap params = new HashMap();
        Object ret = ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.VALIDATION, extItfValue, billInfo, params);
        return ret != null && Boolean.parseBoolean(String.valueOf(ret));
    }

    public static boolean isSameClass(Class<?> targetClass, Class<?> originClass) {
        if (targetClass.isAssignableFrom(originClass)) {
            return true;
        }
        if (Integer.TYPE.equals(targetClass) && Integer.class.equals(originClass) || Integer.TYPE.equals(originClass) && Integer.class.equals(targetClass)) {
            return true;
        }
        if (Long.TYPE.equals(targetClass) && Long.class.equals(originClass) || Long.TYPE.equals(originClass) && Long.class.equals(targetClass)) {
            return true;
        }
        if (Double.TYPE.equals(targetClass) && Double.class.equals(originClass) || Double.TYPE.equals(originClass) && Double.class.equals(targetClass)) {
            return true;
        }
        return Boolean.TYPE.equals(targetClass) && Boolean.class.equals(originClass) || Boolean.TYPE.equals(originClass) && Boolean.class.equals(targetClass);
    }

    public static List<IApprovalRecordGroup> invokeCustomApprovalRecordExtItf(String extItfValue, String businesskey) {
        HashMap params = new HashMap();
        QFilter qFilter = new QFilter("businesskey", "=", (Object)businesskey);
        String field = "entitynumber";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)field, (QFilter[])new QFilter[]{qFilter}, (String)"creatorid desc");
        String entityNumber = null;
        if (dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!WfUtils.isNotEmpty(dynamicObject.getString(field))) continue;
                entityNumber = dynamicObject.getString(field);
                break;
            }
        }
        if (WfUtils.isEmpty(businesskey) || WfUtils.isEmpty(entityNumber)) {
            return new ArrayList<IApprovalRecordGroup>();
        }
        List ret = (List)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CUSTOMAPPROVALRECORD, extItfValue, businesskey, entityNumber, params);
        return ret != null ? ret : new ArrayList();
    }

    public static List<IApprovalRecordGroup> invokeCustomApprovalRecordExtItf(String extItfValue, String businesskey, Long processInstanceId, Map<String, Object> params) {
        if (WfUtils.isEmpty(businesskey) && WfUtils.isEmpty(processInstanceId)) {
            return new ArrayList<IApprovalRecordGroup>();
        }
        String entityNumber = null;
        if (WfUtils.isNotEmpty(businesskey)) {
            String field = "entitynumber";
            QFilter qFilter = new QFilter("businesskey", "=", (Object)businesskey);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)field, (QFilter[])new QFilter[]{qFilter}, (String)"creatorid desc");
            if (dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (!WfUtils.isNotEmpty(dynamicObject.getString(field))) continue;
                    entityNumber = dynamicObject.getString(field);
                    break;
                }
            }
        } else {
            DynamicObject hiprocinst = QueryServiceHelper.queryOne((String)"wf_hiprocinst", (String)"businesskey,entitynumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processInstanceId)});
            businesskey = hiprocinst.getString("businesskey");
            entityNumber = hiprocinst.getString("entitynumber");
        }
        if (WfUtils.isEmpty(businesskey) || WfUtils.isEmpty(entityNumber)) {
            return new ArrayList<IApprovalRecordGroup>();
        }
        params.put("processInstanceId", processInstanceId);
        List ret = (List)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.CUSTOMAPPROVALRECORD, extItfValue, businesskey, entityNumber, params);
        return ret != null ? ret : new ArrayList();
    }

    private static IndicatorInfo buildPluginExecutionIndicator(Long beginTime, Long endTime, ExtItfCallerType type, String jsonStr, Object ... args) {
        log.debug("buildPluginExecutionIndicator.begin-{}", (Object)jsonStr);
        if (ExtItfCallerType.FUNCTION.name().equalsIgnoreCase(type.name()) || ExtItfCallerType.FORMATFLOWRECORD.name().equalsIgnoreCase(type.name())) {
            return null;
        }
        try {
            Object[] tempParams = args;
            if (tempParams.length > 0) {
                for (int i = 0; i < tempParams.length; ++i) {
                    IndicatorInfo indicator;
                    HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
                    paramsMap.put("begintime", beginTime);
                    paramsMap.put("endtime", endTime);
                    if (tempParams[i] instanceof ExecutionEntityImpl) {
                        ExecutionEntityImpl executionEntities = (ExecutionEntityImpl)tempParams[i];
                        indicator = ExternalInterfaceUtil.buildIndicatorForExecutionEntityImpl(paramsMap, executionEntities, type, jsonStr);
                        if (indicator == null) continue;
                        return indicator;
                    }
                    if (tempParams[i] instanceof TaskEntityImpl) {
                        TaskEntityImpl taskEntityImpl = (TaskEntityImpl)tempParams[i];
                        indicator = ExternalInterfaceUtil.buildIndicatorForTaskEntityImpl(paramsMap, taskEntityImpl, type, jsonStr);
                        if (indicator == null) continue;
                        return indicator;
                    }
                    log.debug("buildPluginExecutionIndicator others");
                }
            }
        }
        catch (Exception e) {
            log.debug("buildPluginExecutionIndicator.exception-{}", (Object)WfUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    private static IndicatorInfo buildIndicatorForExecutionEntityImpl(Map<String, Object> paramsMap, ExecutionEntityImpl executionEntities, ExtItfCallerType type, String jsonStr) {
        String wfPlugin;
        IndicatorInfo indicator = null;
        if (ModelType.NoCodeFlow.name().equalsIgnoreCase(executionEntities.getProcessType())) {
            log.debug("wfPlugin type  is NoCodeFlow");
            return null;
        }
        String string = wfPlugin = WfUtils.isEmpty(jsonStr) ? executionEntities.getCurrentWFPlugin() : jsonStr;
        if (WfUtils.isEmpty(wfPlugin)) {
            log.debug("wfPlugin is empty");
            return null;
        }
        if (!ExternalInterfaceUtil.isJSON(wfPlugin)) {
            log.debug("workflow-self plugin");
            return null;
        }
        if (WfUtils.isEmpty(executionEntities.getProcessDefinitionId())) {
            log.debug("procDefId is empty");
            return null;
        }
        paramsMap.put("businesskey", executionEntities.getBusinessKey());
        paramsMap.put("billno", executionEntities.getBillNo());
        paramsMap.put("elementid", executionEntities.getActivityId());
        paramsMap.put("procinstid", executionEntities.getProcessInstanceId());
        if (type.name().startsWith(ExtItfCallerType.LISTENER.name())) {
            paramsMap.put("extitfcallertype", executionEntities.getEventName());
        } else {
            paramsMap.put("extitfcallertype", type.name());
        }
        paramsMap.put("entitynumber", executionEntities.getEntityNumber());
        paramsMap.put("procdefid", executionEntities.getProcessDefinitionId());
        ExternalInterfaceUtil.buildCommonParam(paramsMap, wfPlugin);
        ExternalInterfaceUtil.doubleCheckParamLength(paramsMap, executionEntities.getActivityName());
        indicator = ExternalInterfaceUtil.buildIndicatorInfo(executionEntities.getProcessDefinitionId(), paramsMap);
        log.debug("buildIndicatorForExecutionEntityImpl.end-{}", (Object)indicator);
        return indicator;
    }

    private static IndicatorInfo buildIndicatorForTaskEntityImpl(Map<String, Object> paramsMap, TaskEntityImpl taskEntityImpl, ExtItfCallerType type, String jsonStr) {
        String wfPlugin;
        IndicatorInfo indicator = null;
        if (ModelType.NoCodeFlow.name().equalsIgnoreCase(taskEntityImpl.getProcessType())) {
            log.debug("process type  is NoCodeFlow");
            return null;
        }
        if (WfUtils.isEmpty(taskEntityImpl.getProcessDefinitionId())) {
            log.debug("procDefId is empty");
            return null;
        }
        paramsMap.put("procdefid", taskEntityImpl.getProcessDefinitionId());
        String string = wfPlugin = WfUtils.isEmpty(jsonStr) ? taskEntityImpl.getCurrentWFPlugin() : jsonStr;
        if (WfUtils.isEmpty(wfPlugin)) {
            log.debug("wfPlugin is empty");
            return null;
        }
        if (!ExternalInterfaceUtil.isJSON(wfPlugin)) {
            log.debug("workflow-self plugin");
            return null;
        }
        paramsMap.put("businesskey", taskEntityImpl.getBusinessKey());
        paramsMap.put("billno", taskEntityImpl.getBillNo());
        paramsMap.put("elementid", taskEntityImpl.getExecution().getActivityId());
        paramsMap.put("procinstid", taskEntityImpl.getProcessInstanceId());
        paramsMap.put("extitfcallertype", taskEntityImpl.getEventName());
        paramsMap.put("entitynumber", taskEntityImpl.getEntityNumber());
        ExternalInterfaceUtil.buildCommonParam(paramsMap, wfPlugin);
        ExternalInterfaceUtil.doubleCheckParamLength(paramsMap, taskEntityImpl.getExecution().getActivityName());
        indicator = ExternalInterfaceUtil.buildIndicatorInfo(taskEntityImpl.getProcessDefinitionId(), paramsMap);
        log.debug("buildIndicatorForTaskEntityImpl.end-{}", (Object)indicator);
        return indicator;
    }

    private static void buildCommonParam(Map<String, Object> paramsMap, String wfPlugin) {
        if (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
            paramsMap.put("jobid", WfTraceType.get().getJobInfo().getCurrentJobId());
        } else {
            paramsMap.put("jobid", 0L);
        }
        paramsMap.put("traceid", RequestContext.get().getTraceId());
        paramsMap.put("currentwfplugin", wfPlugin);
    }

    private static IndicatorInfo buildIndicatorInfo(Long procDefId, Map<String, Object> paramsMap) {
        IndicatorInfo indicator = new IndicatorInfo();
        indicator.setAddCount(1);
        indicator.setNumber("pluginExecutionInfo");
        indicator.setDimValue((Object)procDefId);
        indicator.setSpecialProperty(paramsMap);
        return indicator;
    }

    private static boolean isJSON(String str) {
        try {
            JSON.parse((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void doubleCheckParamLength(Map<String, Object> paramsMap, ILocaleString elementName) {
        OrmLocaleValue tempElementMap;
        int elementNameLength;
        int noElementNameLength = paramsMap.toString().length();
        if (noElementNameLength >= 1000) {
            paramsMap = Collections.EMPTY_MAP;
        }
        if (elementName != null && noElementNameLength + (elementNameLength = ExternalInterfaceUtil.getLocaleStringLength((Map<String, String>)(tempElementMap = (OrmLocaleValue)elementName))) < 1000) {
            paramsMap.put("elementname", elementName);
        }
        if (paramsMap.toString().length() > 1000) {
            paramsMap = Collections.EMPTY_MAP;
        }
    }

    private static int getLocaleStringLength(Map<String, String> tempElementMap) {
        StringBuilder joinStr = new StringBuilder();
        if (!WfUtils.isEmptyForMap(tempElementMap)) {
            for (Map.Entry<String, String> map : tempElementMap.entrySet()) {
                joinStr.append(map.getKey()).append(map.getValue());
            }
        }
        return joinStr.length();
    }

    private static boolean checkPluginJsonStr(Object value) {
        Boolean flag = false;
        try {
            if (value instanceof Map) {
                String forward = (String)((Map)value).get("forward");
                String forward_name = (String)((Map)value).get("forward_name");
                if (WfUtils.isEmpty(forward) && WfUtils.isEmpty(forward_name)) {
                    flag = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            flag = Boolean.FALSE;
        }
        return flag;
    }
}

