/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.idempotent;

import java.security.MessageDigest;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.idempotent.IdempotentInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import org.apache.commons.codec.binary.Hex;

public class IdempotentHelper {
    private static final String FIELD_ID = "id";
    private static final String FIELD_XID = "xid";
    private static final String FIELD_STATE = "state";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_RESULT = "result";
    private static final String FIELD_TYPE = "type";
    public static final String FIELD_INSTANCEID = "instanceid";
    private static final String FIELD_BUSINESSKEY = "businesskey";
    private static final String FIELD_LOG = "log";
    private static final String FIELD_ACTINSTID = "actinstid";
    private static final String FIELD_ACTIVITYID = "activityid";
    private static final String FIELD_SCENE = "scene";
    private static final String FIELD_CREATEDATE = "createdate";
    private static final String FIELD_MODIFYDATE = "modifydate";
    private static final String STATE_FAILED = "failed";
    public static final String STATE_SUCCESSED = "successed";
    private static final String TYPE_PROCESS = "process";
    public static final String FORMID_IDEMPOTENT = "wf_idempotent";
    private static final String SELECTFIELDS = String.format("%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s", "id", "xid", "state", "value", "result", "createdate", "modifydate", "type", "instanceid", "businesskey", "log");
    private static Log logger = LogFactory.getLog(IdempotentHelper.class);
    private static boolean localIdempotent = "true".equals(System.getProperty("workflow.runtime.idempotent"));

    private IdempotentHelper() {
    }

    public static boolean isEnableIdempotent() {
        boolean idempotent = false;
        String FIELD_VALUE = FIELD_VALUE;
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)"workflow.runtime.idempotent")};
        Map config = BusinessDataServiceHelper.loadFromCache((String)"wf_confcenter", (String)FIELD_VALUE, (QFilter[])filters);
        if (config != null && !config.isEmpty()) {
            idempotent = "true".equals(((DynamicObject)config.entrySet().iterator().next().getValue()).getString(FIELD_VALUE));
        }
        return idempotent || localIdempotent;
    }

    public static String generateXid(StringBuilder sb) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int len = Math.min(stack.length, 25);
        for (int i = 0; i < len; ++i) {
            sb.append(stack[i].getFileName());
            sb.append("#");
            sb.append(stack[i].getMethodName());
        }
        String xid = sb.toString().replaceAll("\\.java", "");
        try {
            logger.debug("xid source: " + xid);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(sb.toString().getBytes("UTF-8"));
            xid = Hex.encodeHexString((byte[])hash);
            logger.debug("generated xid: " + xid);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
        return xid;
    }

    public static String generateXid(StringBuilder base, Object param, HistoricActivityInstanceEntity actInst) {
        String businessKey = "";
        String procInstId = "";
        String activityId = "";
        String event = "";
        if (param instanceof ExecutionEntity) {
            ExecutionEntity entity = (ExecutionEntity)param;
            activityId = entity.getActivityId();
            businessKey = entity.getBusinessKey();
            procInstId = String.valueOf(entity.getProcessInstanceId());
            event = entity.getEventName();
        } else if (param instanceof AgentTask) {
            TaskEntity entity = (TaskEntity)param;
            businessKey = entity.getBusinessKey();
            activityId = entity.getTaskDefinitionKey();
            procInstId = String.valueOf(entity.getProcessInstanceId());
            event = entity.getEventName();
        }
        base.append(businessKey).append(procInstId);
        if (actInst != null) {
            if ("AutoTask".equals(actInst.getActivityType()) && !actInst.isInserted()) {
                base.append(activityId);
                logger.debug(String.format("Error: actInst is null! BusinessKey: %s, ProcInstId: %s", businessKey, procInstId));
            } else {
                base.append(actInst.getActivityId());
                if (event != null && event.startsWith("start") && WfUtils.isNotEmpty(actInst.getSourceElementId())) {
                    base.append(actInst.getSourceElementId());
                } else {
                    base.append(actInst.getId());
                }
            }
        } else {
            base.append(activityId);
            logger.debug(String.format("Error: actInst is null! BusinessKey: %s, ProcInstId: %s", businessKey, procInstId));
        }
        return IdempotentHelper.generateXid(base);
    }

    public static IdempotentInfo findIdempotentInfoByXid(String xid) {
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_XID, "=", (Object)xid)};
        DynamicObject result = QueryServiceHelper.queryOne((String)FORMID_IDEMPOTENT, (String)SELECTFIELDS, (QFilter[])filters);
        if (result != null) {
            return IdempotentHelper.getIdempotentInfo(result);
        }
        return null;
    }

    private static DynamicObject getIdempotentInfo(String xid, String extItfValue, String businessKey, Long instanceId, HistoricActivityInstanceEntity actInst, String scene) {
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_XID, "=", (Object)xid)};
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((String)FORMID_IDEMPOTENT, (String)SELECTFIELDS, (QFilter[])filters);
        if (dynObj != null) {
            return dynObj;
        }
        dynObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FORMID_IDEMPOTENT));
        Date date = WfUtils.now();
        dynObj.set(FIELD_XID, (Object)xid);
        dynObj.set(FIELD_VALUE, (Object)extItfValue);
        dynObj.set(FIELD_CREATEDATE, (Object)date);
        dynObj.set(FIELD_MODIFYDATE, (Object)date);
        dynObj.set(FIELD_INSTANCEID, (Object)instanceId);
        dynObj.set(FIELD_BUSINESSKEY, (Object)businessKey);
        if (actInst != null) {
            dynObj.set(FIELD_ACTINSTID, (Object)actInst.getId());
            dynObj.set(FIELD_ACTIVITYID, (Object)actInst.getActivityId());
        }
        dynObj.set(FIELD_SCENE, (Object)scene);
        return dynObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void complete(DynamicObject info, String state) {
        info.set(FIELD_STATE, (Object)state);
        if (WfUtils.isNotEmpty(info.getLong(FIELD_ID))) {
            info.set(FIELD_MODIFYDATE, (Object)WfUtils.now());
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        }
    }

    public static void success(String xid, String extItfValue, String businessKey, Long instanceId, String result, HistoricActivityInstanceEntity actInst, String scene) {
        DynamicObject info = IdempotentHelper.getIdempotentInfo(xid, extItfValue, businessKey, instanceId, actInst, scene);
        info.set(FIELD_TYPE, (Object)TYPE_PROCESS);
        info.set(FIELD_RESULT, (Object)result);
        IdempotentHelper.complete(info, STATE_SUCCESSED);
    }

    public static void fail(String xid, String extItfValue, String businessKey, Long instanceId, String errorInfo, HistoricActivityInstanceEntity actInst, String scene) {
        DynamicObject info = IdempotentHelper.getIdempotentInfo(xid, extItfValue, businessKey, instanceId, actInst, scene);
        info.set(FIELD_TYPE, (Object)TYPE_PROCESS);
        info.set(FIELD_LOG, (Object)errorInfo);
        IdempotentHelper.complete(info, STATE_FAILED);
    }

    public static void delete(String xid) {
        try (TXHandle tx = TX.requiresNew();){
            QFilter[] filters = new QFilter[]{new QFilter(FIELD_XID, "=", (Object)xid)};
            DeleteServiceHelper.delete((String)FORMID_IDEMPOTENT, (QFilter[])filters);
        }
    }

    private static IdempotentInfo getIdempotentInfo(DynamicObject result) {
        IdempotentInfo info = new IdempotentInfo();
        info.setId(result.getLong(FIELD_ID));
        info.setXid(result.getString(FIELD_XID));
        info.setValue(result.getString(FIELD_VALUE));
        info.setState(result.getString(FIELD_STATE));
        info.setResult(result.getString(FIELD_RESULT));
        info.setCreatedate(result.getDate(FIELD_CREATEDATE));
        info.setModifydate(result.getDate(FIELD_MODIFYDATE));
        info.setType(result.getString(FIELD_TYPE));
        info.setLog(result.getString(FIELD_LOG));
        info.setInstanceid(result.getLong(FIELD_INSTANCEID));
        info.setBusinesskey(result.getString(FIELD_BUSINESSKEY));
        return info;
    }

    public static HistoricActivityInstanceEntity getLatestHistoricActivityInstance(AgentExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getHistoricActivityInstanceEntityManager().findLatestActivityByExecution(execution);
    }

    public static void deleteListenerExecuteLog(CommandContext commandContext, String businessKey, Long actInstId, String eventType) {
        HistoricActivityInstanceEntity actInst = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(actInstId);
        if (actInst != null && "YunzhijiaTask".equals(actInst.getActivityType())) {
            actInstId = actInst.getParentTaskId();
        }
        String condition = String.format("%%:%s%%", eventType);
        String sql = "DELETE FROM T_WF_IDEMPOTENT WHERE FBUSINESSKEY = ? AND FACTINSTID = ? AND FSCENE like ?";
        BatchSQLInfo info = new BatchSQLInfo(sql, 10);
        info.addParam(new Object[]{businessKey, actInstId, condition});
        commandContext.getDbSqlSession().addBatchSQLInfo(info);
    }

    public static String getExecuteScene(String prefix, AgentExecution execution) {
        AgentTask currentTask = execution.getCurrentTask();
        String taskEvent = null;
        if (currentTask != null) {
            taskEvent = currentTask.getEventName();
        }
        return String.format("%s:%s", prefix, WfUtils.isNotEmpty(taskEvent) ? taskEvent : execution.getEventName());
    }
}

