/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.api.constants.WFTaskResultEnum;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.AgentTaskImpl;
import kd.bos.workflow.engine.impl.WorkflowElementImpl;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariablesUtil;

public class AgentExecutionImpl
implements AgentExecution,
Serializable {
    private static final long serialVersionUID = 3684116039131540869L;
    private Long id;
    private String businessKey;
    private String entityNumber;
    private Long currentTaskId;
    private AgentTaskImpl currentTask;
    private Long processDefinitionId;
    private Long processInstanceId;
    private WorkflowElementImpl currentFlowElement;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Long startUserId;
    private String eventName;
    private String currentWfPlugin;
    private Long currentActInstId;
    private String activityId;
    private DynamicObject transientBill;
    private Map<String, Object> wfPluginParams;

    public AgentExecutionImpl(DelegateExecution execution) {
        if (execution == null) {
            return;
        }
        this.id = execution.getId();
        this.businessKey = execution.getBusinessKey();
        this.entityNumber = execution.getEntityNumber();
        this.currentTaskId = execution.getCurrentTaskId();
        this.processDefinitionId = execution.getProcessDefinitionId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.currentFlowElement = new WorkflowElementImpl(execution);
        this.variables = VariablesUtil.initVaribles(execution.getVariables());
        this.startUserId = execution.getStartUserId();
        this.eventName = execution.getEventName();
        this.currentWfPlugin = execution.getCurrentWFPlugin();
        this.currentActInstId = execution.getCurrentActInstId();
        this.activityId = execution.getCurrentActivityId();
        this.currentTask = new AgentTaskImpl();
        this.currentTask.initTask(execution.getCurrentTask());
        this.setTransientBill(execution);
        this.wfPluginParams = WfUtils.shallowCopyMap(execution.getCurrentWFPluginParams());
    }

    private void setTransientBill(DelegateExecution execution) {
        this.transientBill = execution.getTransientBill();
        if (this.transientBill == null && execution instanceof AbstractEntity) {
            this.transientBill = ((AbstractEntity)((Object)execution)).getDynamicObject();
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public Long getCurrentTaskId() {
        return this.currentTaskId;
    }

    public AgentTask getCurrentTask() {
        return this.currentTask;
    }

    public Long getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public WorkflowElement getCurrentFlowElement() {
        return this.currentFlowElement;
    }

    public Object getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public Object getCurrentTaskResult(WFTaskResultEnum result) {
        return this.variables.get(result.name());
    }

    public List<Long> getCurrentApprover() {
        ArrayList<Long> approverIds = new ArrayList<Long>();
        if (this.currentTask != null && this.currentTask.getParticipants() != null) {
            approverIds = new ArrayList<Long>(this.currentTask.getParticipants());
        }
        return approverIds;
    }

    public Long getStartUserId() {
        return this.startUserId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getCurrentWFPlugin() {
        return this.currentWfPlugin;
    }

    public Long getCurrentActInstId() {
        return this.currentActInstId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
        Long variablesKey = (Long)this.getVariable("microservice_variablesid");
        this.setMicroVariable(variablesKey, variableName, value);
    }

    public DynamicObject getTransientBill() {
        return this.transientBill;
    }

    public Map<String, Object> getCurrentWFPluginParams() {
        return this.wfPluginParams;
    }

    private void setMicroVariable(Long variablesKey, String variableName, Object value) {
        if (variablesKey == null) {
            return;
        }
        Map<String, Object> variableMap = WfCacheHelper.getMicroOperateVariable(variablesKey);
        if (variableMap == null) {
            variableMap = new HashMap<String, Object>(16);
        }
        variableMap.put(variableName, value);
        WfCacheHelper.putMicroOperateVariable(variablesKey, SerializationUtils.toJsonString(variableMap));
    }
}

