/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.AgentExecutionImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariablesUtil;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class AgentTaskImpl
implements AgentTask,
Serializable {
    private static final long serialVersionUID = 5404580343128489106L;
    private Long id;
    private Map<String, String> name;
    private Map<String, String> description;
    private Long processInstanceId;
    private Long processDefinitionId;
    private String taskDefinitionKey;
    private AgentExecutionImpl execution;
    private Long ownerId;
    private Long assigneeId;
    private String eventName;
    private String currentWFPlugin;
    private Map<String, Object> wfPluginParams;
    private Map<String, String> entityName;
    private Map<String, String> subject;
    private Map<String, String> startName;
    private String entityNumber;
    private String businessKey;
    private Map<String, String> senderName;
    private String handleState;
    private String billNo;
    private Long starterId;
    private Set<Long> participants;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public AgentTaskImpl() {
    }

    public AgentTaskImpl(AgentTask agentTask) {
        if (agentTask == null) {
            return;
        }
        this.initTask(agentTask);
        if (agentTask.getExecution() instanceof DelegateExecution) {
            this.execution = new AgentExecutionImpl((DelegateExecution)agentTask.getExecution());
        }
    }

    protected final void initTask(AgentTask agentTask) {
        if (agentTask == null) {
            return;
        }
        this.id = agentTask.getId();
        this.name = this.localeStringToMap(agentTask.getName());
        this.description = this.localeStringToMap(agentTask.getDescription());
        this.processInstanceId = agentTask.getProcessInstanceId();
        this.processDefinitionId = agentTask.getProcessDefinitionId();
        this.taskDefinitionKey = agentTask.getTaskDefinitionKey();
        this.ownerId = agentTask.getOwnerId();
        this.assigneeId = agentTask.getAssigneeId();
        this.eventName = agentTask.getEventName();
        this.currentWFPlugin = agentTask.getCurrentWFPlugin();
        this.wfPluginParams = WfUtils.shallowCopyMap(agentTask.getCurrentWFPluginParams());
        this.entityName = this.localeStringToMap(agentTask.getEntityName());
        this.subject = this.localeStringToMap(agentTask.getSubject());
        this.startName = this.localeStringToMap(agentTask.getStartName());
        this.entityNumber = agentTask.getEntityNumber();
        this.businessKey = agentTask.getBusinessKey();
        this.senderName = this.localeStringToMap(agentTask.getSenderName());
        this.handleState = agentTask.getHandleState();
        this.billNo = agentTask.getBillNo();
        this.starterId = agentTask.getStarterId();
        if (agentTask instanceof TaskEntity) {
            this.variables = VariablesUtil.initVaribles(((TaskEntity)agentTask).getVariables());
        }
    }

    private Map<String, String> localeStringToMap(ILocaleString localeString) {
        if (localeString == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll((Map<String, String>)localeString);
        return map;
    }

    private ILocaleString mapToLocaleString(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        return LocaleString.fromMap(map);
    }

    public Long getId() {
        return this.id;
    }

    public ILocaleString getName() {
        return this.mapToLocaleString(this.name);
    }

    public ILocaleString getDescription() {
        return this.mapToLocaleString(this.description);
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Long getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public AgentExecution getExecution() {
        return this.execution;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public Long getAssigneeId() {
        return this.assigneeId;
    }

    public Set<Long> getParticipants() {
        if (this.participants != null) {
            return this.participants;
        }
        HashSet<Long> userIds = null;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List<HistoricIdentityLinkEntity> identityLinks = wfService.getTaskService().getHiParticipantByTaskId(this.id);
        if (identityLinks != null && !identityLinks.isEmpty()) {
            userIds = new HashSet<Long>(identityLinks.size());
            for (HistoricIdentityLinkEntity identityLink : identityLinks) {
                userIds.add(identityLink.getUserId());
            }
            this.participants = userIds;
        }
        return this.participants;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getCurrentWFPlugin() {
        return this.currentWFPlugin;
    }

    public Map<String, Object> getCurrentWFPluginParams() {
        return this.wfPluginParams;
    }

    public ILocaleString getEntityName() {
        return this.mapToLocaleString(this.entityName);
    }

    public ILocaleString getSubject() {
        return this.mapToLocaleString(this.subject);
    }

    public ILocaleString getStartName() {
        return this.mapToLocaleString(this.startName);
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public ILocaleString getSenderName() {
        return this.mapToLocaleString(this.senderName);
    }

    public String getHandleState() {
        return this.handleState;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public Long getStarterId() {
        return this.starterId;
    }

    public Object getVariable(String variableName) {
        return this.variables.get(variableName);
    }
}

