/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.cmd.job.DeleteFinishedEvtJobCmd;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cfg.TransactionPropagation;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigParam;
import kd.bos.workflow.engine.impl.cmd.GetHistoricVariablesForTaskCmd;
import kd.bos.workflow.engine.impl.cmd.GetTaskHistoricIdentityLink;
import kd.bos.workflow.engine.impl.cmd.history.CompactFinishProcDatasCmd;
import kd.bos.workflow.engine.impl.cmd.history.DeleteFinishedProcessDatasCmd;
import kd.bos.workflow.engine.impl.cmd.history.FindActivityByExecutionIdAndActId;
import kd.bos.workflow.engine.impl.cmd.history.FindConditionParseLogByBill;
import kd.bos.workflow.engine.impl.cmd.history.GetActInstInfoCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoriableVariableByExecutionCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoricActivityInstanceByBusinessKeyAndEntityNumberCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoricActivityInstanceByTaskCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoricActivityInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoricProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.history.GetLatestTaskHandleStateCmd;
import kd.bos.workflow.engine.impl.cmd.history.RecoverProcDataFromCompactCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.GetHistoricalProcessesDataCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.GetHistoricalProcessesDataCountCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.GetViewBillsCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.GetViewBillsCountCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.log.entity.ConditionParseLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.util.QueryWrapper;

public class HistoryServiceImpl
extends ServiceImpl
implements HistoryService {
    public HistoryServiceImpl() {
    }

    public HistoryServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public EntityQueryBuilder<HistoricProcessInstanceEntity> createHistoricProcessInstanceQuery() {
        return this.processEngineConfiguration.getHistoricProcessInstanceEntityManager().createQueryBuilder(this.processEngineConfiguration);
    }

    @Override
    public EntityQueryBuilder<HistoricActivityInstanceEntity> createHistoricActivityInstanceQuery() {
        return this.processEngineConfiguration.getHistoricActivityInstanceEntityManager().createQueryBuilder(this.processEngineConfiguration);
    }

    @Override
    public EntityQueryBuilder<HistoricTaskInstanceEntity> createHistoricTaskInstanceQuery() {
        return this.processEngineConfiguration.getHistoricTaskInstanceEntityManager().createQueryBuilder(this.processEngineConfiguration);
    }

    @Override
    public EntityQueryBuilder<HistoricVariableInstanceEntity> createHistoricVariableInstanceQuery() {
        return this.processEngineConfiguration.getHistoricVariableInstanceEntityManager().createQueryBuilder(this.processEngineConfiguration);
    }

    @Override
    public HistoricIdentityLinkEntity getHistoricIdentityLink(Long taskId, Long userId, String type) {
        return this.commandExecutor.execute(new GetTaskHistoricIdentityLink(taskId, userId, type));
    }

    @Override
    public List<HistoricVariableInstanceEntity> getHistoricVariableInstanceEntityByTaskId(Long taskId) {
        return this.commandExecutor.execute(new GetHistoricVariablesForTaskCmd(taskId));
    }

    @Override
    public HistoricProcessInstanceEntity getHistoricProcessInstance(Long id) {
        return this.commandExecutor.execute(new GetHistoricProcessInstanceCmd(id));
    }

    @Override
    public List<HistoricProcessInstanceEntity> getSameRootHistoricProcessInstance(Long rootInstanceId) {
        return this.commandExecutor.execute(commandContext -> {
            if (rootInstanceId == null || rootInstanceId == 0L) {
                return new ArrayList(0);
            }
            QFilter qFilter = new QFilter("rootProcessInstanceId", "=", (Object)rootInstanceId);
            return commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(qFilter.toArray());
        });
    }

    @Override
    public List<HistoricActivityInstanceEntity> getHistoricActivityByProcessInstanceId(Long processInstanceId) {
        return this.commandExecutor.execute(new GetHistoricActivityInstanceCmd(processInstanceId));
    }

    @Override
    public List<HistoricActivityInstanceEntity> getHistoricActivityByProcessInstanceIdAndActivityId(Long processInstanceId, String activityId) {
        return this.commandExecutor.execute(new GetHistoricActivityInstanceCmd(processInstanceId, activityId));
    }

    @Override
    public HistoricActivityInstanceEntity getHistoricActivityByTaskId(Long taskId) {
        return this.commandExecutor.execute(new GetHistoricActivityInstanceByTaskCmd(taskId));
    }

    @Override
    public String getLatestTaskHandleState(Long procInstId, String activityId) {
        return this.commandExecutor.execute(new GetLatestTaskHandleStateCmd(procInstId, activityId));
    }

    @Override
    public void deleteFinishedProcessDatas() {
        this.commandExecutor.execute(new DeleteFinishedProcessDatasCmd());
    }

    @Override
    public DynamicObjectCollection getHistoricalProcessesData(int start, int limit, String entityNumber, String filterSql, List<Object> params, String orderBy, boolean isAuditFlow) {
        return this.commandExecutor.execute(new GetHistoricalProcessesDataCmd(start, limit, entityNumber, filterSql, params, orderBy, isAuditFlow));
    }

    @Override
    public DynamicObjectCollection getViewBillsData(int start, int limit, String processInstanceId, String filterSql, List<Object> params, String orderBy) {
        return this.commandExecutor.execute(new GetViewBillsCmd(start, limit, processInstanceId, filterSql, params, orderBy));
    }

    @Override
    public long getViewBillsCount(String processInstanceId, String filterSql, List<Object> params) {
        return this.commandExecutor.execute(new GetViewBillsCountCmd(processInstanceId, filterSql, params));
    }

    @Override
    public long getHistoricalProcessesDataCount(String entityNumber, String filterSql, List<Object> params) {
        return this.getHistoricalProcessesDataCount(entityNumber, filterSql, params, false);
    }

    @Override
    public long getHistoricalProcessesDataCount(String entityNumber, String filterSql, List<Object> params, boolean isAuditFlow) {
        return this.commandExecutor.execute(new GetHistoricalProcessesDataCountCmd(entityNumber, filterSql, params, isAuditFlow));
    }

    @Override
    public Map<String, Object> getHistoricVariableByExecution(Long executionId, String[] name) {
        return this.commandExecutor.execute(new GetHistoriableVariableByExecutionCmd(executionId, name));
    }

    @Override
    public List<HistoricActivityInstanceEntity> getHistoricActivityByBusinessKeyAndEntityNubmer(String businessKey, String entityNumber) {
        return this.commandExecutor.execute(new GetHistoricActivityInstanceByBusinessKeyAndEntityNumberCmd(businessKey, entityNumber));
    }

    @Override
    public void deleteEventFinishedDatas() {
        this.commandExecutor.execute(new DeleteFinishedEvtJobCmd());
    }

    @Override
    public Map<String, List<Map<String, Object>>> getActInstInfo(String businessKey, List<String> actIds, boolean isOnlyCompleted) {
        return this.commandExecutor.execute(new GetActInstInfoCmd(businessKey, actIds, isOnlyCompleted));
    }

    @Override
    public HistoricActivityInstanceEntity findActivity(Long executionId, String actId) {
        return this.commandExecutor.execute(new FindActivityByExecutionIdAndActId(executionId, actId));
    }

    @Override
    public List<ConditionParseLogEntity> findConditionParseListBy(String entityNumber, String billNoOrBusinessKey) {
        return this.commandExecutor.execute(new FindConditionParseLogByBill(entityNumber, billNoOrBusinessKey));
    }

    @Override
    public HistoricActivityInstanceEntity findHisActInstanceBy(String actId, Long processInstanceId) {
        return this.commandExecutor.execute(commandContext -> {
            QFilter[] qFilters = new QueryWrapper().eq("processinstanceid", processInstanceId).eq("activityid", actId).getQFilters();
            List result = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(qFilters);
            if (result == null || result.isEmpty()) {
                return new HistoricActivityInstanceEntityImpl();
            }
            return (HistoricActivityInstanceEntity)result.get(0);
        });
    }

    @Override
    public HistoricActivityInstanceEntity getHistoricActivityByProcessInstanceIdAndActivityInstId(Long processInstanceId, Long activityInstId) {
        return this.commandExecutor.execute(commandContext -> commandContext.getHistoricActivityInstanceEntityManager().findByActivityInstId(processInstanceId, activityInstId));
    }

    @Override
    public HistoricActivityInstanceEntity getHistoricActivityByBusinessKeyAndActivityInstId(String businessKey, Long activityInstId) {
        return this.commandExecutor.execute(commandContext -> commandContext.getHistoricActivityInstanceEntityManager().findByBusinessKeyAndActivityInstId(businessKey, activityInstId));
    }

    @Override
    public List<HistoricActivityInstanceEntity> getHistoricActivityByBusinessKeysAndActType(Set<String> businessKeys, String actType, String fields, String orderBy) {
        return this.commandExecutor.execute(commandContext -> commandContext.getHistoricActivityInstanceEntityManager().findByBusinessKeysAndActType(businessKeys, actType, fields, orderBy));
    }

    @Override
    public List<HistoricActivityInstanceEntity> getHistoricActivityByActivityType(Set<Long> processInstanceIds, String activityType, String fields, String orderBy) {
        return this.commandExecutor.execute(commandContext -> commandContext.getHistoricActivityInstanceEntityManager().findByActivityType(processInstanceIds, activityType, fields, orderBy));
    }

    @Override
    public void recoverProcDataFromWide(List<Long> ids) {
        this.commandExecutor.execute(new RecoverProcDataFromCompactCmd(ids));
    }

    @Override
    @Deprecated
    public void compactFinishedProcessDatas(List<Long> procInstIds) {
        this.commandExecutor.execute(new CompactFinishProcDatasCmd(procInstIds));
    }

    @Override
    public void compactFinishedProcessDatas(List<Long> procInstIds, EntityCompactConfigParam configParam) {
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        this.commandExecutor.execute(commandConfig, new CompactFinishProcDatasCmd(procInstIds, configParam));
    }

    @Override
    public Long getProcInstIdFromHistoricActivityByBusinessKey(String entityNumber, String businessKey) {
        return this.commandExecutor.execute(commandContext -> commandContext.getHistoricActivityInstanceEntityManager().getProcInstIdFromHistoricActivityByBusinessKey(entityNumber, businessKey));
    }
}

