/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.cmd.job.RevokEvtAbnormalInstanceCmd;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.basedata.DelegateSettingInfo;
import kd.bos.workflow.basedata.role.WorkflowRole;
import kd.bos.workflow.basedata.role.WorkflowRoleResult;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.bpm.cmd.GetBpmStartupItemsCmd;
import kd.bos.workflow.engine.impl.bpm.cmd.UpdateBpmStartupConditionCmd;
import kd.bos.workflow.engine.impl.bpm.model.BpmStartupItem;
import kd.bos.workflow.engine.impl.cmd.CleanMultiLangDirtyDataCmd;
import kd.bos.workflow.engine.impl.cmd.DeleteDelegateSettingsCmd;
import kd.bos.workflow.engine.impl.cmd.SaveAndEnableDelegateSettingsCmd;
import kd.bos.workflow.engine.impl.cmd.SuspendOrActiveProcessCmd;
import kd.bos.workflow.engine.impl.cmd.UpdateWorkflowRoleCmd;
import kd.bos.workflow.engine.impl.cmd.job.MoveDeadLetterJobToExecutableJobCmd;
import kd.bos.workflow.engine.impl.cmd.job.MoveJobToDeadLetterJobCmd;
import kd.bos.workflow.engine.impl.cmd.job.MoveTimerToExecutableJobCmd;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.ActivateProcessInstanceAndRuleByUserIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.ActivateProcessInstanceByDeadLetterJobCmd;
import kd.bos.workflow.engine.impl.cmd.management.ActivateProcessInstanceByProcessInstanceIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.BillPageByTypeCmd;
import kd.bos.workflow.engine.impl.cmd.management.DecideUserBelongToRoleCmd;
import kd.bos.workflow.engine.impl.cmd.management.ExistBaseDataRefCmd;
import kd.bos.workflow.engine.impl.cmd.management.ExistEnableDynamicFormMappingCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetBillSubjectModelCountCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetBillSubjectModelDataCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetEnableDynamicFormMappingEntitiesCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetJumpNodesCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetProcessDefinitionEntityBySchemeIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetSchemeIdsByProcessInfoIdsCmd;
import kd.bos.workflow.engine.impl.cmd.management.InitBaseDataRefRecordCmd;
import kd.bos.workflow.engine.impl.cmd.management.InitProcessInfoEntityCmd;
import kd.bos.workflow.engine.impl.cmd.management.JumpToNodeCmd;
import kd.bos.workflow.engine.impl.cmd.management.RecordBaseDataRefCmd;
import kd.bos.workflow.engine.impl.cmd.management.RemoveProcessDefinitionCacheByIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.RevokDeadLetterEventJobCmd;
import kd.bos.workflow.engine.impl.cmd.management.SetEnableStatusForOrgTypeCmd;
import kd.bos.workflow.engine.impl.cmd.management.SuspendProcessInstanceAndRuleByUserIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.UpgradeProcessConfigByProcDefIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.GetEnableDelegateSettingEntitiesCmd;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ValidateDelegateSettingCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CompareVersionDifferenceCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CountConfigSchemeByFiltersCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.CreateDynamicConfigSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.DeleteDynamicConfigSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.FixProcInstSchemeIdByProcDefIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeByFiltersCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeByProcInstId;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetDynamicConfigSchemesByProcDefId;
import kd.bos.workflow.engine.impl.cmd.management.scheme.IsLatestProcessDefinitionCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.LogDynamicConfigSchemeRecordCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.RemoveBpmnModelCacheCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.UpdateDynamicConfigSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.UpdateStartUpConditionalRuleCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.RecoverProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.ValidateApiCmd;
import kd.bos.workflow.engine.impl.cmd.system.InsertBaseChangeLogsCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicFormMappingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.system.BaseChangeLogsEntity;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingProperty;
import kd.bos.workflow.engine.management.batchsetting.cmd.BatchSettingAdvancedPropertiesCmd;
import kd.bos.workflow.engine.management.batchsetting.cmd.BatchSettingGeneralPropertiesCmd;
import kd.bos.workflow.engine.management.batchsetting.cmd.FindToBeInitializedProcDefIdsCmd;
import kd.bos.workflow.engine.management.batchsetting.task.AbstractBatchSettingTask;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class ManagementServiceImpl
extends ServiceImpl
implements ManagementService {
    @Override
    public Job moveTimerToExecutableJob(Long jobId) {
        return this.commandExecutor.execute(new MoveTimerToExecutableJobCmd(jobId));
    }

    @Override
    public Job moveJobToDeadLetterJob(Long jobId) {
        return this.commandExecutor.execute(new MoveJobToDeadLetterJobCmd(jobId));
    }

    @Override
    public Job moveDeadLetterJobToExecutableJob(Long jobId, int retries) {
        return this.commandExecutor.execute(new MoveDeadLetterJobToExecutableJobCmd(jobId, retries));
    }

    @Override
    public <T> T executeCommand(Command<T> command) {
        if (command == null) {
            throw new WFIllegalArgumentException("The command is null");
        }
        return this.commandExecutor.execute(command);
    }

    @Override
    public <T> T executeCommand(CommandConfig config, Command<T> command) {
        if (config == null) {
            throw new WFIllegalArgumentException("The config is null");
        }
        if (command == null) {
            throw new WFIllegalArgumentException("The command is null");
        }
        return this.commandExecutor.execute(config, command);
    }

    @Override
    public String revokeSuspendProcessInstancesByIds(Long deadLetterJobId, Long processInstanceId) {
        return this.commandExecutor.execute(new RecoverProcessInstanceCmd(deadLetterJobId, processInstanceId));
    }

    @Override
    public String validateApi(Long id, String type) {
        return this.commandExecutor.execute(new ValidateApiCmd(id, type));
    }

    @Override
    public String validateApi(Long id, String type, String srcId, String destId) {
        return this.commandExecutor.execute(new ValidateApiCmd(id, type, srcId, destId));
    }

    @Override
    public String validateApi(Long id, String type, AddSignInfo addSignInfo) {
        return this.commandExecutor.execute(new ValidateApiCmd(id, type, addSignInfo));
    }

    @Override
    public void removeProcessDefinitionCacheById(Long processDefinitionId, Long processInstanceId) {
        this.commandExecutor.execute(new RemoveProcessDefinitionCacheByIdCmd(processDefinitionId, processInstanceId));
    }

    @Override
    public List<Map<String, Object>> getBillPageByType(String entityId, String modelType) {
        return this.commandExecutor.execute(new BillPageByTypeCmd(entityId, modelType));
    }

    @Override
    public boolean isLatestProcessDefinition(Long procDefId) {
        return this.commandExecutor.execute(new IsLatestProcessDefinitionCmd(procDefId));
    }

    @Override
    public List<DynamicConfigSchemeEntity> getDynamicConfigSchemeByProcDefId(Long procDefId, boolean checkCache) {
        return this.commandExecutor.execute(new GetDynamicConfigSchemesByProcDefId(procDefId, checkCache));
    }

    @Override
    public List<DynamicConfigSchemeEntity> getDynamicConfigSchemeByFilters(QFilter[] filters) {
        return this.commandExecutor.execute(new GetConfigSchemeByFiltersCmd(filters));
    }

    @Override
    public void updateDynamicConfigScheme(DynamicConfigSchemeEntity scheme) {
        this.commandExecutor.execute(new UpdateDynamicConfigSchemeCmd(scheme));
    }

    @Override
    public BpmnModel getDynamicConfigSchemeBpmnModel(Long schemeId) {
        return this.commandExecutor.execute(new GetConfigSchemeBpmnModelCmd(schemeId));
    }

    @Override
    public String getDynamicConfigSchemeModelString(Long schemeId) {
        return this.commandExecutor.execute(new GetConfigSchemeBpmnJsonStringCmd(schemeId, null));
    }

    @Override
    public void deleteDynamicConfigScheme(Long schemeId) {
        this.commandExecutor.execute(new DeleteDynamicConfigSchemeCmd(schemeId));
    }

    @Override
    public void updateDynamicConfigScheme(DynamicConfigSchemeEntity scheme, String modelJson, String origModelJson, String condition, Set<String> initedPropsSet) {
        this.commandExecutor.execute(new UpdateDynamicConfigSchemeCmd(scheme, modelJson, condition));
        this.commandExecutor.execute(new LogDynamicConfigSchemeRecordCmd(scheme, modelJson, origModelJson, initedPropsSet));
    }

    @Override
    public DynamicConfigSchemeEntity getConfigSchemeByProcInstId(Long procInstId) {
        return this.commandExecutor.execute(new GetConfigSchemeByProcInstId(procInstId));
    }

    @Override
    public DynamicConfigSchemeEntity createDefaultConfigScheme(Long procDefId, boolean compatible) {
        return this.commandExecutor.execute(new CreateDynamicConfigSchemeCmd(procDefId, true, compatible));
    }

    @Override
    public Long getConfigSchemeCountByFilters(QFilter[] filters) {
        return this.commandExecutor.execute(new CountConfigSchemeByFiltersCmd(filters));
    }

    @Override
    public DynamicConfigSchemeEntity createDynamicConfigScheme(Long procDefId, String number, String condition, ILocaleString name, ILocaleString description) {
        return this.commandExecutor.execute(new CreateDynamicConfigSchemeCmd(procDefId, number, condition, name, description));
    }

    @Override
    public void fixProcInstSchemeIdByProcDefId(Set<Long> procDefIds) {
        this.commandExecutor.execute(new FixProcInstSchemeIdByProcDefIdCmd(procDefIds));
    }

    @Override
    public DynamicObjectCollection getBillSubjectModelData(String entityId, int start, int limit, List<QFilter> qFilters, String object) {
        return this.commandExecutor.execute(new GetBillSubjectModelDataCmd(entityId, start, limit, qFilters, object));
    }

    @Override
    public long getBillSubjectModelCount(String field, List<QFilter> qFilters, boolean distinct) {
        return this.commandExecutor.execute(new GetBillSubjectModelCountCmd(field, qFilters.toArray(new QFilter[qFilters.size()]), true));
    }

    @Override
    public boolean isUserBelongToRole(Long userId, String roleNumber) {
        return this.commandExecutor.execute(new DecideUserBelongToRoleCmd(userId, roleNumber));
    }

    @Override
    public void jumpToNode(long proInstanceId, String destId, String srcId) {
        this.commandExecutor.execute(new JumpToNodeCmd(proInstanceId, srcId, destId, false));
    }

    @Override
    public void jumpToNode(long proInstanceId, String destId, boolean isSuspend, String srcId, ILocaleString reason) {
        this.commandExecutor.execute(new JumpToNodeCmd((Long)proInstanceId, srcId, destId, isSuspend, reason));
    }

    @Override
    public void jumpToNode(long proInstanceId, String destId, boolean isSuspend, String srcId) {
        this.commandExecutor.execute(new JumpToNodeCmd(proInstanceId, srcId, destId, isSuspend));
    }

    @Override
    public List<Map<String, Object>> getJumpNodes(Long executionId) {
        return this.commandExecutor.execute(new GetJumpNodesCmd(executionId));
    }

    @Override
    public void abandonProInstance(long proInstanceId) {
        this.commandExecutor.execute(new AbandonProcessCmd(proInstanceId));
    }

    @Override
    public void abandonProcessInstance(long proInstanceId, ILocaleString cause) {
        this.commandExecutor.execute(new AbandonProcessCmd(proInstanceId, cause, "forceAbort"));
    }

    @Override
    public void abandonProcessInstance(long proInstanceId, ILocaleString cause, String dynType) {
        dynType = WfUtils.isNotEmpty(dynType) ? dynType : "forceAbort";
        this.commandExecutor.execute(new AbandonProcessCmd(proInstanceId, cause, dynType));
    }

    @Override
    public void activateProcessInstanceByDeadLetterJob(Long deadLetterJobId) {
        try (DLock lock = DLock.create((String)String.format("wf/activatedeadjob/%s", deadLetterJobId), (String)("ACTIVATEDEADLETTERJOB[" + deadLetterJobId + "]")).fastMode();){
            boolean canLock = lock.tryLock(60000L);
            if (canLock) {
                this.commandExecutor.execute(new ActivateProcessInstanceByDeadLetterJobCmd(deadLetterJobId, true));
            }
        }
    }

    @Override
    public void activateProcessInstanceByProcessInstanceId(Long processInstanceId) {
        try (DLock lock = DLock.create((String)String.format("wf/activateprocinst/%s", processInstanceId), (String)("ACTIVATEPROCINSTID[" + processInstanceId + "]")).fastMode();){
            boolean canLock = lock.tryLock(60000L);
            if (canLock) {
                this.commandExecutor.execute(new ActivateProcessInstanceByProcessInstanceIdCmd(processInstanceId, true));
            }
        }
    }

    @Override
    public void suspendProcessInstanceByProcessInstanceId(Long processInstanceId) {
        this.commandExecutor.execute(new SuspendOrActiveProcessCmd(processInstanceId, true));
    }

    @Override
    public void removeBPMNModelCacheByScheme(Long schemeId) {
        this.commandExecutor.execute(new RemoveBpmnModelCacheCmd(null, schemeId));
    }

    @Override
    public void removeBPMNModelCacheByProcessInstance(Long processInstanceId) {
        this.commandExecutor.execute(new RemoveBpmnModelCacheCmd(processInstanceId, null));
    }

    @Override
    public void setEnableStatusForOrgType(Object[] primaryKeys, boolean isEnable) {
        this.commandExecutor.execute(new SetEnableStatusForOrgTypeCmd(primaryKeys, isEnable));
    }

    @Override
    public List<BpmStartupItem> findBpmStartupItemsByProcDefId(Long procDefId) {
        return this.commandExecutor.execute(new GetBpmStartupItemsCmd(procDefId));
    }

    @Override
    public void updateBpmStartupCondition(Long procDefId, List<BpmStartupItem> items) {
        this.commandExecutor.execute(new UpdateBpmStartupConditionCmd(procDefId, items));
    }

    @Override
    public void batchSettingGeneralProperties(List<Long> ids, List<BatchSettingProperty> properties, AbstractBatchSettingTask task) {
        this.commandExecutor.execute(new BatchSettingGeneralPropertiesCmd(ids, properties, task));
    }

    @Override
    public void batchSettingAdvancedProperties(String stencilType, Map<Long, List<Long>> ids, List<BatchSettingProperty> properties, AbstractBatchSettingTask task) {
        this.commandExecutor.execute(new BatchSettingAdvancedPropertiesCmd(stencilType, ids, properties, task));
    }

    @Override
    public List<Long> findToBeInitializedProcDefIds(boolean includeOngoing) {
        return this.commandExecutor.execute(new FindToBeInitializedProcDefIdsCmd(includeOngoing));
    }

    @Override
    public void initProcessInfoByProcDefId(Long procDefId, String language) {
        this.commandExecutor.execute(new InitProcessInfoEntityCmd(procDefId, language));
    }

    @Override
    public Set<Long> getSchemeIdsByProcessInfoIds(List<Long> ids) {
        return this.commandExecutor.execute(new GetSchemeIdsByProcessInfoIdsCmd(ids));
    }

    @Override
    public ProcessConfigEntity upgradeProcessConfigByProcDefId(Long procDefId) {
        return this.commandExecutor.execute(new UpgradeProcessConfigByProcDefIdCmd(procDefId));
    }

    @Override
    public void updateStartUpConditionalRule(Long procDefId, ConditionalRuleEntity condRule, boolean deleteFlag, String condRuleId) {
        this.commandExecutor.execute(new UpdateStartUpConditionalRuleCmd(procDefId, condRule, deleteFlag, condRuleId));
    }

    @Override
    public BaseChangeLogsEntity insertBaseChangeLogsEntity(Long baseFormId, String type, String op, ILocaleString title, ILocaleString detail, String modifier) {
        return this.commandExecutor.execute(new InsertBaseChangeLogsCmd(baseFormId, type, op, title, detail, modifier));
    }

    @Override
    public String revokDeadLetterEventJob(Long deadLetterJobId) {
        return this.commandExecutor.execute(new RevokDeadLetterEventJobCmd(deadLetterJobId));
    }

    @Override
    public void suspendProcessInstanceAndRuleByUserId(Long userId, ILocaleString suspendReason) {
        this.commandExecutor.execute(new SuspendProcessInstanceAndRuleByUserIdCmd(userId, suspendReason));
    }

    @Override
    public void activateProcessInstanceAndRuleByUserId(Long userId) {
        this.commandExecutor.execute(new ActivateProcessInstanceAndRuleByUserIdCmd(userId));
    }

    @Override
    public List<ModelModifyLogEntity> compareVersionDifference(String modelJson, String origModelJson, IModelModifyLog entity, Set<String> ignoredProps) {
        return this.commandExecutor.execute(new CompareVersionDifferenceCmd(modelJson, origModelJson, entity, ignoredProps));
    }

    @Override
    public ProcessDefinitionEntity getProcessDefinitionEntityBySchemeId(Long schemeId) {
        return this.commandExecutor.execute(new GetProcessDefinitionEntityBySchemeIdCmd(schemeId));
    }

    @Override
    @Deprecated
    public void recordBaseDataRef(Long procDefId, Long schemeId, String type, Long value, String acticityId, String property) {
        this.commandExecutor.execute(new RecordBaseDataRefCmd(procDefId, schemeId, type, value, acticityId, property));
    }

    @Override
    public void recordBaseDataRef(Long procDefId, Long schemeId, String type, Long value, String acticityId, ILocaleString activityName, String property) {
        this.commandExecutor.execute(new RecordBaseDataRefCmd(procDefId, schemeId, type, value, acticityId, activityName, property));
    }

    @Override
    public List<BaseDataRefRecordEntity> getBaseDataRefEntities(String type, Long baseDataId) {
        return this.commandExecutor.execute(new ExistBaseDataRefCmd(type, baseDataId));
    }

    @Override
    public void initBaseDataRef(Long proDefId, Long schemeId) {
        this.commandExecutor.execute(new InitBaseDataRefRecordCmd(proDefId, schemeId));
    }

    @Override
    public void validateDelegateSetting(Long curDelegateId, Long assignorId, Long trusteeId) {
        this.commandExecutor.execute(new ValidateDelegateSettingCmd(curDelegateId, assignorId, trusteeId));
    }

    @Override
    public List<DelegateSettingEntity> getEnableDelegateSettingEntities(Long curDelegateId) {
        return this.commandExecutor.execute(new GetEnableDelegateSettingEntitiesCmd(curDelegateId));
    }

    @Override
    public List<DelegateSettingEntity> findDelegateSettingEntitiesByIds(List<Long> ids) {
        return this.commandExecutor.execute(c -> c.getDelegateSettingEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", (Object)ids)}));
    }

    @Override
    public Boolean cleanMultiLangDirtyData(String tables) {
        return this.commandExecutor.execute(new CleanMultiLangDirtyDataCmd(tables));
    }

    @Override
    public List<DynamicFormMappingEntity> getEnableDynamicFormMappingEntitiesByEntityNumbers(Set<String> entityNumbers) {
        return this.commandExecutor.execute(new GetEnableDynamicFormMappingEntitiesCmd(entityNumbers));
    }

    @Override
    public WorkflowRoleResult updateWorkflowRoleApi(List<WorkflowRole> roles) {
        return this.commandExecutor.execute(new UpdateWorkflowRoleCmd(roles));
    }

    @Override
    public Boolean isExistEnableDynamicFormMapping(String entityNumber, String dynamicFormNumber) {
        return this.commandExecutor.execute(new ExistEnableDynamicFormMappingCmd(entityNumber, dynamicFormNumber));
    }

    @Override
    public Map<String, Object> saveAndEnableDelegateSettings(List<DelegateSettingInfo> delegateSettings) {
        return this.commandExecutor.execute(new SaveAndEnableDelegateSettingsCmd(delegateSettings));
    }

    @Override
    public void deleteDelegateSettings(List<Long> deleteIds) {
        this.commandExecutor.execute(new DeleteDelegateSettingsCmd(deleteIds));
    }

    @Override
    public String revokEvtAbnormalInstanceJob(List<Long> instances) {
        return this.commandExecutor.execute(new RevokEvtAbnormalInstanceCmd(instances));
    }

    @Override
    public String revokDeadLetterEventJob(Long deadLetterJobId, int type) {
        return this.commandExecutor.execute(new RevokDeadLetterEventJobCmd(deadLetterJobId, type));
    }
}

