/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.bpmn.model.ExtendAttributeGroup;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowElementImpl
implements WorkflowElement,
Serializable {
    private static final long serialVersionUID = -8159105836185224868L;
    private String id;
    private String number;
    private String name;
    private String type;
    private String bizIdentifyKey;
    private Set<String> whiteListProps = new HashSet<String>();
    private Map<String, Serializable> propertiesMap;
    private Map<String, Object> customPropMap;
    private Map<String, Object> extPropMap;

    public WorkflowElementImpl(AgentExecution execution) {
        if (execution == null) {
            return;
        }
        WorkflowElement element = execution.getCurrentFlowElement();
        if (element == null) {
            return;
        }
        this.id = element.getId();
        this.number = element.getNumber();
        this.name = element.getName();
        this.type = element.getType();
        this.bizIdentifyKey = element.getBizIdentifyKey();
        this.initWhiteListProps();
        this.initPropertiesMap(execution, element);
    }

    private void initWhiteListProps() {
        this.whiteListProps.add("customParams");
    }

    private void initPropertiesMap(AgentExecution execution, WorkflowElement element) {
        Object extProParamsObj;
        Serializable customParamsObj;
        String parent;
        String processType = (String)execution.getVariable("processType");
        String modelType = GraphCodecUtils.getModelTypeByProcessType(processType);
        DomainModelType domainModelType = GraphCodecUtils.getDomainType(modelType);
        if (domainModelType == null) {
            return;
        }
        ElementType elementType = domainModelType.getElementType(this.type);
        if (elementType == null && (elementType = domainModelType.getElementType(parent = ModelConfigUtil.getExtendNodeInheritStencilType(this.type))) == null) {
            return;
        }
        List properties = elementType.getProperties();
        this.propertiesMap = new HashMap<String, Serializable>(properties.size());
        for (Property prop : properties) {
            Object value;
            Object propertyName = prop.getPropertyName();
            if (!WfUtils.isEmpty(prop.getGroupId())) {
                propertyName = String.format("%s.%s", prop.getGroupId(), propertyName);
            }
            if ((value = GraphCodecUtils.safeGetPropertyValue(element, (String)propertyName)) == null || !GraphCodecUtils.isBaseDataType(value.getClass()) && !this.whiteListProps.contains(propertyName) || !(value instanceof Serializable)) continue;
            this.propertiesMap.put((String)propertyName, (Serializable)value);
        }
        Serializable serializable = customParamsObj = this.propertiesMap != null ? this.propertiesMap.get("customParams") : null;
        if (customParamsObj != null) {
            List customParamsList = (List)((Object)customParamsObj);
            this.customPropMap = new HashMap<String, Object>(customParamsList.size());
            for (CustomParam customParam : customParamsList) {
                this.customPropMap.put(customParam.getNumber(), customParam.getValue());
            }
        }
        if ((extProParamsObj = GraphCodecUtils.safeGetPropertyValue(element, "extAttrGroup")) instanceof HashMap) {
            Map extAttrGroupMap = (Map)extProParamsObj;
            this.extPropMap = new HashMap<String, Object>(extAttrGroupMap.size());
            for (Map.Entry extAttrGroup : extAttrGroupMap.entrySet()) {
                ExtendAttributeGroup extendAttributeGroup = (ExtendAttributeGroup)extAttrGroup.getValue();
                this.extPropMap.put((String)extAttrGroup.getKey(), extendAttributeGroup.getExtAttrValue());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getBizIdentifyKey() {
        return this.bizIdentifyKey;
    }

    public Object getPropertyValue(String propertyName) {
        return this.propertiesMap != null ? this.propertiesMap.get(propertyName) : null;
    }

    public Object getCustomPropValue(String propertyName) {
        return this.customPropMap != null ? this.customPropMap.get(propertyName) : null;
    }

    public Object getExtPropValue(String propertyName) {
        return this.extPropMap != null ? this.extPropMap.get(propertyName) : null;
    }
}

