/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.HashMap;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.HasExecutionListeners;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.agenda.DefaultActivitiAgenda;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.runtime.Agenda;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizException;

public abstract class AbstractOperation
implements Runnable {
    protected CommandContext commandContext;
    protected Agenda agenda;
    protected ExecutionEntity execution;
    protected boolean enterBoundaryError = false;

    public AbstractOperation() {
    }

    public AbstractOperation(CommandContext commandContext, ExecutionEntity execution) {
        this.commandContext = commandContext;
        this.execution = execution;
        this.agenda = commandContext.getAgenda();
    }

    protected FlowElement getCurrentFlowElement(ExecutionEntity execution) {
        if (execution.getCurrentFlowElement() != null) {
            return execution.getCurrentFlowElement();
        }
        if (WfUtils.isNotEmpty(execution.getCurrentActivityId())) {
            Long processDefinitionId = execution.getProcessDefinitionId();
            Process process = ProcessDefinitionUtil.getProcess(processDefinitionId, execution.getProcessInstanceId());
            String activityId = execution.getCurrentActivityId();
            FlowElement currentFlowElement = process.getFlowElement(activityId, true);
            return currentFlowElement;
        }
        return null;
    }

    protected void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, String eventType) {
        try {
            HistoricActivityInstanceEntity ac;
            String type;
            if (this.execution != null && elementWithExecutionListeners instanceof FlowNode && Context.getProcessEngineConfiguration().isEnableBecEventDispatcher() && ("YunzhijiaTask".equalsIgnoreCase(type = ((FlowNode)elementWithExecutionListeners).getType()) || "UserTask".equalsIgnoreCase(type) || "AuditTask".equalsIgnoreCase(type)) && WfUtils.isNotEmpty(this.execution.getCurrentActInstId()) && (ac = (HistoricActivityInstanceEntity)Context.getCommandContext().getHistoricActivityInstanceEntityManager().findById(this.execution.getCurrentActInstId())) != null && ("byHand".equalsIgnoreCase(ac.getExecutionType()) || WfUtils.isEmpty(ac.getExecutionType()))) {
                HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                jsonMap.put("currentNodeId", this.execution.getActivityId());
                if ("start".equals(eventType)) {
                    String enterType = null;
                    enterType = DynamicFlowUtil.isJumpInCurrentNode(this.execution, this.execution.getCurrentActivityId()) ? "jump" : (DynamicFlowUtil.isRejectInCurrentNode(this.execution, this.execution.getCurrentActivityId()) ? "reject" : "normal");
                    jsonMap.put("enterType", enterType);
                    new EventTriggerCmd("wf.AfterNodeEnterEvent", this.execution, jsonMap).execute(this.commandContext);
                }
                if ("end".equals(eventType)) {
                    new EventTriggerCmd("wf.AfterNodeOutEvent", this.execution, jsonMap).execute(this.commandContext);
                }
            }
            if (elementWithExecutionListeners != null && eventType != null) {
                this.executeExecutionListeners(elementWithExecutionListeners, this.execution, eventType);
            }
        }
        catch (Exception e) {
            if (e instanceof WFBizException && ((WFBizException)((Object)e)).getCause() != null && ((WFBizException)((Object)e)).getCause() instanceof KDBizException) {
                this.enterBoundaryError = true;
                KDBizException kdBizExeception = (KDBizException)((WFBizException)((Object)e)).getCause();
                if (!ExceptionUtil.matchBoundryException(kdBizExeception, this.execution)) {
                    throw e;
                }
            }
            if (e instanceof KDBizException) {
                this.enterBoundaryError = true;
                if (!ExceptionUtil.matchBoundryException((KDBizException)((Object)e), this.execution)) {
                    throw e;
                }
            }
            throw e;
        }
    }

    protected void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, ExecutionEntity executionEntity, String eventType) {
        this.commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(elementWithExecutionListeners, executionEntity, eventType);
    }

    protected ExecutionEntity findFirstParentScopeExecution(ExecutionEntity executionEntity) {
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        while (currentlyExaminedExecution != null && parentScopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                parentScopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        return parentScopeExecution;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(DefaultActivitiAgenda agenda) {
        this.agenda = agenda;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }
}

