/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class ContinueMultiInstanceOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(ContinueMultiInstanceOperation.class);
    protected boolean forceSynchronousOperation;

    public ContinueMultiInstanceOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    public ContinueMultiInstanceOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation) {
        super(commandContext, execution);
        this.forceSynchronousOperation = forceSynchronousOperation;
    }

    @Override
    public void run() {
        block13: {
            FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
            try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("ContinueMultiInstanceOperation", currentFlowElement.getId()));){
                if (currentFlowElement instanceof FlowNode) {
                    this.continueThroughMultiInstanceFlowNode((FlowNode)currentFlowElement);
                    break block13;
                }
                throw new RuntimeException("Programmatic error: no valid multi instance flow node, type: " + currentFlowElement + ". Halting.");
            }
        }
    }

    protected void continueThroughMultiInstanceFlowNode(FlowNode flowNode) {
        if (this.forceSynchronousOperation || !flowNode.isAsynchronous()) {
            this.executeSynchronous(flowNode);
        } else {
            this.executeAsynchronous(flowNode);
        }
    }

    protected void executeSynchronous(FlowNode flowNode) {
        this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        ActivityBehavior activityBehavior = (ActivityBehavior)flowNode.getBehavior();
        if (activityBehavior != null) {
            logger.debug(String.format("Executing activityBehavior %s on activity '%s' with execution %s", activityBehavior.getClass().getName(), flowNode.getId(), String.valueOf(this.execution.getId())));
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), this.execution.getBusinessKey(), flowNode));
            }
            try {
                activityBehavior.execute(this.execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, this.execution, (Throwable)((Object)error));
            }
            catch (RuntimeException e) {
                throw e;
            }
        } else {
            logger.debug(String.format("No activityBehavior on activity '%s' with execution %s", flowNode.getId(), this.execution.getId()));
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        JobEntity job = this.commandContext.getJobManager().createMultiInstanceAsyncContinuationJob(this.execution, flowNode.isExclusive());
        this.commandContext.getJobManager().scheduleAsyncJob(job);
    }
}

