/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.agenda.callback.IOperationCallback;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.center.ForkNodeRejectListener;
import kd.bos.workflow.exception.WFEngineException;

public class ContinueProcessOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(ContinueProcessOperation.class);
    protected boolean forceSynchronousOperation;
    protected boolean inCompensation;
    protected List<IOperationCallback> callbacks = new ArrayList<IOperationCallback>();

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation, boolean inCompensation) {
        super(commandContext, execution);
        this.forceSynchronousOperation = forceSynchronousOperation;
        this.inCompensation = inCompensation;
    }

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution) {
        this(commandContext, execution, false, false);
    }

    public List<IOperationCallback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<IOperationCallback> callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement;
        block17: {
            currentFlowElement = this.getCurrentFlowElement(this.execution);
            try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("ContinueProcessOperation", currentFlowElement.getId()));){
                logger.debug(String.format("ContinueProcessOperation[%s],execution[%s]", currentFlowElement.getId(), this.execution.getId()));
                if (currentFlowElement instanceof FlowNode) {
                    this.continueThroughFlowNode((FlowNode)currentFlowElement);
                    break block17;
                }
                if (currentFlowElement instanceof SequenceFlow) {
                    this.continueThroughSequenceFlow((SequenceFlow)currentFlowElement);
                    break block17;
                }
                throw new WFEngineException("Programmatic error: no current flow element found or invalid type: " + currentFlowElement + ". Halting.");
            }
        }
        if (this.enterBoundaryError) {
            if (currentFlowElement instanceof YunzhijiaTask) {
                this.commandContext.getHistoryManager().recordActivityStart(this.execution);
            }
            this.callbacks = new ArrayList<IOperationCallback>();
        }
        for (IOperationCallback cb : this.callbacks) {
            cb.callback(this.commandContext);
        }
    }

    protected void executeProcessStartExecutionListeners() {
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
        this.executeExecutionListeners(process, this.execution.getParent(), "start");
        if (Context.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("startUserId", this.execution.getStartUserId());
            new EventTriggerCmd("wf.AfterProcessStartEvent", this.execution, jsonMap).execute(this.commandContext);
        }
    }

    protected void continueThroughFlowNode(FlowNode flowNode) {
        logger.debug(String.format("continueThroughFlowNode[%s]", flowNode.getId()));
        if ((this.forceSynchronousOperation || !flowNode.isAsynchronous()) && WfUtils.isEmptyForCollection(flowNode.getIncomingFlows()) && flowNode.getSubProcess() == null) {
            if ("dynJump".equals(this.execution.getVariableLocal("dynType"))) {
                logger.debug(String.format("continueThroughFlowNode[%s] is [%s], not execute processStart listeners", flowNode.getId(), "dynJump"));
            } else if ("billWithdrawJump".equals(this.execution.getVariableLocal("dynType"))) {
                logger.debug(String.format("continueThroughFlo wNode[%s] is [%s], not execute processStart listeners", flowNode.getId(), "billWithdrawJump"));
            } else {
                this.executeProcessStartExecutionListeners();
            }
        }
        if (flowNode instanceof SubProcess) {
            this.createChildExecutionForSubProcess((SubProcess)flowNode);
        }
        if (this.forceSynchronousOperation && flowNode instanceof Activity && ((Activity)flowNode).hasMultiInstanceLoopCharacteristics()) {
            logger.debug(String.format("executeMultiInstanceSynchronous[%s]", flowNode.getId()));
            this.executeMultiInstanceSynchronous(flowNode);
        } else if (this.forceSynchronousOperation || !flowNode.isAsynchronous()) {
            logger.debug(String.format("executeSynchronous[%s]", flowNode.getId()));
            this.executeSynchronous(flowNode);
        } else {
            logger.debug(String.format("executeAsynchronous[%s]", flowNode.getId()));
            this.executeAsynchronous(flowNode);
        }
    }

    protected void createChildExecutionForSubProcess(SubProcess subProcess) {
        ExecutionEntity parentScopeExecution = this.findFirstParentScopeExecution(this.execution);
        ExecutionEntity subProcessExecution = this.commandContext.getExecutionEntityManager().createChildExecution(parentScopeExecution);
        subProcessExecution.setCurrentFlowElement(subProcess);
        subProcessExecution.setScope(true);
        this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(this.execution, null, false);
        this.execution = subProcessExecution;
    }

    protected void executeSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        List<BoundaryEvent> boundaryEvents;
        this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        if (!this.inCompensation && flowNode instanceof Activity && this.canExecuteBoundaryEvents(boundaryEvents = ((Activity)flowNode).getBoundaryEvents())) {
            this.executeBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) != null) {
            this.executeActivityBehavior(activityBehavior, flowNode);
            if (!"notIn".equals(this.execution.getTransientVariable("joinNoteEnterState"))) {
                this.executeExecutionListeners(flowNode, "start");
            }
            DynamicFlowUtil.removeVariableWhenIncoming(this.execution, flowNode.getId());
        } else {
            logger.debug(String.format("No activityBehavior on activity '%s' with execution %s", flowNode.getId(), this.execution.getId()));
            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(this.execution, true);
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        JobEntity job = this.commandContext.getJobManager().createAsyncContinuationJob(this.execution, flowNode.isExclusive());
        logger.debug(String.format("createJob[%s],executionid[%s]", job.getExecutionId(), this.execution.getId()));
        this.commandContext.getJobManager().scheduleAsyncJob(job);
    }

    protected void executeMultiInstanceSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        List<BoundaryEvent> boundaryEvents;
        if (!this.inCompensation && flowNode instanceof Activity && this.canExecuteBoundaryEvents(boundaryEvents = ((Activity)flowNode).getBoundaryEvents())) {
            this.executeBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) == null) {
            throw new WFEngineException("Expected an activity behavior in flow node " + flowNode.getId());
        }
        this.executeActivityBehavior(activityBehavior, flowNode);
        this.executeExecutionListeners(flowNode, "start");
        DynamicFlowUtil.removeVariableWhenIncoming(this.execution, flowNode.getId());
    }

    protected void executeActivityBehavior(ActivityBehavior activityBehavior, FlowNode flowNode) {
        logger.debug(String.format("Executing activityBehavior %s on activity '%s' with execution %s", activityBehavior.getClass().getName(), flowNode.getId(), String.valueOf(this.execution.getId())));
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), this.execution.getBusinessKey(), flowNode));
        }
        activityBehavior.execute(this.execution);
    }

    protected void continueThroughSequenceFlow(SequenceFlow sequenceFlow) {
        Set<String> bills;
        logger.debug(String.format("continueThroughSequenceFlow[%s]", sequenceFlow.getId()));
        Long sourceNodeActInstId = this.execution.getCurrentActInstId();
        this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        if (CollectionUtil.isNotEmpty(sequenceFlow.getExecutionListeners())) {
            this.executeExecutionListeners(sequenceFlow, "start");
            this.executeExecutionListeners(sequenceFlow, "take");
            this.executeExecutionListeners(sequenceFlow, "end");
        }
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
        FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
        FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createSequenceFlowTakenEvent(this.execution, ActivitiEventType.SEQUENCEFLOW_TAKEN, sequenceFlow.getId(), sourceFlowElement != null ? sourceFlowElement.getId() : null, sourceFlowElement != null ? sourceFlowElement.getName() : null, sourceFlowElement != null ? sourceFlowElement.getClass().getName() : null, sourceFlowElement != null ? ((FlowNode)sourceFlowElement).getBehavior() : null, targetFlowElement.getId(), targetFlowElement.getName(), targetFlowElement.getClass().getName(), ((FlowNode)targetFlowElement).getBehavior()));
        }
        this.execution.setCurrentFlowElement(targetFlowElement);
        if (this.execution.getParent().isBillExecution() && WfUtils.isEmpty(this.execution.getParent().getActivityId()) && (bills = BpmnModelUtil.getTargetEntityNumber(targetFlowElement)) != null && bills.contains(this.execution.getEntityNumber())) {
            this.execution.getParent().setCurrentFlowElement(targetFlowElement);
        }
        this.commandContext.getExecutionEntityManager().update(this.execution);
        this.makeBoundaryErrorThings(targetFlowElement);
        if (ProcessType.AuditFlow.name().equals(this.execution.getProcessType()) || ProcessType.NoCodeFlow.name().equals(this.execution.getProcessType())) {
            this.getCommandContext().getHistoryManager().insertOrUpdateLastCurrentNodeMapper(this.execution, sequenceFlow, targetFlowElement);
        }
        BPMNUtil.updateExecutionActivityName(this.execution);
        BPMNUtil.updateHitaskInstPresentAssignee(this.execution, null);
        logger.debug(String.format("Sequence flow '%s' encountered. Continuing process by following it using execution %s", sequenceFlow.getId(), this.execution.getId()));
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
        boolean bizFlow = process != null && "BizFlow".equalsIgnoreCase(process.getProcessType());
        boolean notNeedConvert = false;
        if (bizFlow) {
            boolean bl = notNeedConvert = this.isNotNeedConvert(sequenceFlow.getTargetFlowElement(), this.execution) && this.judgeClosingCondition(sequenceFlow);
        }
        if (bizFlow && !notNeedConvert) {
            JobEntity job = this.commandContext.getJobManager().createAsyncExecutionConversionJob(this.execution, sequenceFlow);
            this.commandContext.getJobManager().scheduleAsyncJob(job);
        } else {
            Context.getAgenda().planContinueProcessOperation(this.execution);
            if (bizFlow && BizFlowUtil.isTargetEntity(this.execution, sequenceFlow.getTargetFlowElement())) {
                this.execution.removeVariableLocal("bizTargetEntity");
            }
        }
    }

    private boolean judgeClosingCondition(SequenceFlow sequenceFlow) {
        FlowElement element = sequenceFlow.getSourceFlowElement();
        if (element instanceof BillTask) {
            BillTask billTask = (BillTask)element;
            if (BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(this.execution, billTask, false)) {
                logger.debug(String.format("%s is skipped when boot. executionId: %s", billTask.getId(), this.execution.getId()));
                return true;
            }
            return BizFlowUtil.isMeetBillCloseCondition(billTask, this.execution);
        }
        return true;
    }

    private void makeBoundaryErrorThings(FlowElement targetFlowElement) {
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
        String targetId = targetFlowElement.getId();
        ExecutionEntity proinst = this.execution.getProcessInstance();
        String enterBoundaryErrorNodeId = (String)proinst.getVariableLocal("enterBoundaryErrorNodeId");
        if (WfUtils.isNotEmpty(enterBoundaryErrorNodeId) && process.getNonBoundaryNodes().contains(targetId)) {
            BoundaryEvent be = (BoundaryEvent)process.getFlowElement(enterBoundaryErrorNodeId);
            enterBoundaryErrorNodeId = be.getAttachedToRefId();
            proinst.removeVariableLocal("enterBoundaryErrorNodeId");
            this.execution.setVariableLocal("comeFromBoundary", targetId);
            Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
            NodeForkJoinModel enterBoundaryModel = models.get(enterBoundaryErrorNodeId);
            NodeForkJoinModel mainBrachesModel = models.get(targetId);
            String outStructure = enterBoundaryModel.getForkStructure();
            String inStructure = mainBrachesModel.getForkStructure();
            TaskEntityManager taskMgr = this.commandContext.getTaskEntityManager();
            List<TaskEntity> tasks = taskMgr.findTasksByProcessInstanceId(this.execution.getProcessInstanceId());
            int more = outStructure.length() - inStructure.length();
            if (more > 0) {
                HashSet<Long> taskIds = new HashSet<Long>();
                for (TaskEntity task : tasks) {
                    String actId = task.getTaskDefinitionKey();
                    NodeForkJoinModel tmp = models.get(actId);
                    if (tmp != null && tmp.getForkStructure().contains(inStructure + "$")) {
                        Long taskId = task.getId();
                        taskIds.add(taskId);
                        continue;
                    }
                    task.setActive(true);
                    taskMgr.update(task);
                }
                ForkNodeRejectListener.markOtherBranchsEnd(this.commandContext, this.execution, this.execution.getProcessInstanceId(), enterBoundaryErrorNodeId, null, targetId, "boundary");
            } else {
                for (TaskEntity task : tasks) {
                    task.setActive(true);
                    taskMgr.update(task);
                }
            }
        }
    }

    protected boolean canExecuteBoundaryEvents(List<BoundaryEvent> boundaryEvents) {
        if (CollectionUtil.isEmpty(boundaryEvents)) {
            return false;
        }
        if (ProcessType.BizFlow.name().equals(this.execution.getProcessType())) {
            FlowElement ele;
            boolean compensateEvent = false;
            for (BoundaryEvent event : boundaryEvents) {
                if (event.getEventDefinitions().isEmpty() || !(event.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                compensateEvent = true;
                break;
            }
            if (!compensateEvent) {
                return true;
            }
            List<HistoricActivityInstanceEntity> incomingFlowActInsts = this.commandContext.getHistoricActivityInstanceEntityManager().findByTargetId(this.execution.getProcessInstanceId(), this.execution.getCurrentActInstId());
            if (incomingFlowActInsts != null && !incomingFlowActInsts.isEmpty() && (ele = ProcessDefinitionUtil.getFlowElement(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId(), incomingFlowActInsts.get(0).getActivityId())) instanceof SequenceFlow) {
                SequenceFlow inFlow = (SequenceFlow)ele;
                BillRelationshipModel relationModel = null;
                relationModel = inFlow.getBillRelationshipModel();
                if (relationModel != null && "botpTargetBills".equals(relationModel.getRelationType()) && !"auto".equals(relationModel.getConversionMode()) && !this.isNotNeedConvert(inFlow.getTargetFlowElement(), this.execution)) {
                    return false;
                }
            }
        }
        return true;
    }

    protected void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty(boundaryEvent.getEventDefinitions())) continue;
            ExecutionEntity childExecutionEntity = this.commandContext.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement(boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            logger.debug(String.format("Executing boundary event activityBehavior %s with execution %s", boundaryEventBehavior.getClass(), childExecutionEntity.getId()));
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }

    private boolean isNotNeedConvert(FlowElement target, ExecutionEntity executionEntity) {
        if (target == null) {
            return false;
        }
        String evtStart = (String)this.execution.getVariable("_eventNumber_");
        if (WfUtils.isNotEmpty(evtStart) && BpmnModelUtil.isFirstNodeByModel((FlowNode)target)) {
            String entityNumber = (String)this.execution.getVariable("entityNumber");
            String targetProcInstance = (String)this.execution.getVariable("targetProcEntityNumber");
            return entityNumber != null && entityNumber.equalsIgnoreCase(targetProcInstance);
        }
        String prevNodeIds = (String)executionEntity.getVariable("bootNodePrevNodeIds");
        boolean skippedWhenBoot = prevNodeIds != null && prevNodeIds.contains(target.getId());
        boolean targetIsBootNode = target.getId().equals(executionEntity.getVariable("bootNodeId"));
        String tagEntityNumber = (String)executionEntity.getVariableLocal("bizTargetEntity");
        boolean skipWhenNonSameBill = tagEntityNumber != null;
        boolean isForceAbort = "40".equals(executionEntity.getVariable("endType"));
        return skippedWhenBoot || targetIsBootNode || skipWhenNonSameBill || isForceAbort;
    }
}

