/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.List;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.exception.WFEngineException;

public class DestroyScopeOperation
extends AbstractOperation {
    public DestroyScopeOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        ExecutionEntity scopeExecution;
        ExecutionEntity executionEntity = scopeExecution = this.execution.isScope() ? this.execution : this.findFirstParentScopeExecution(this.execution);
        if (scopeExecution == null) {
            throw new WFEngineException("Programmatic error: no parent scope execution found for boundary event");
        }
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(scopeExecution.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            executionEntityManager.deleteExecutionAndRelatedData(childExecution, this.execution.getDeleteReason(), false);
        }
        TaskEntityManager taskEntityManager = this.commandContext.getTaskEntityManager();
        List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(scopeExecution.getId());
        for (TaskEntity taskEntity : tasksForExecution) {
            this.commandContext.getTaskHelper().deleteTaskEntity(taskEntity, this.execution.getDeleteReason(), false, false);
        }
        TimerJobEntityManager timerJobEntityManager = this.commandContext.getTimerJobEntityManager();
        List<TimerJobEntity> timerJobsForExecution = timerJobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (TimerJobEntity job : timerJobsForExecution) {
            timerJobEntityManager.delete(job);
        }
        JobEntityManager jobEntityManager = this.commandContext.getJobEntityManager();
        List<JobEntity> jobsForExecution = jobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        if (jobsForExecution != null && !jobsForExecution.isEmpty()) {
            for (JobEntity job : jobsForExecution) {
                jobEntityManager.delete(job);
            }
        }
        SuspendedJobEntityManager suspendedJobEntityManager = this.commandContext.getSuspendedJobEntityManager();
        List<SuspendedJobEntity> suspendedJobsForExecution = suspendedJobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (SuspendedJobEntity job : suspendedJobsForExecution) {
            suspendedJobEntityManager.delete(job);
        }
        DeadLetterJobEntityManager deadLetterJobEntityManager = this.commandContext.getDeadLetterJobEntityManager();
        List<DeadLetterJobEntity> deadLetterJobsForExecution = deadLetterJobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (DeadLetterJobEntity job : deadLetterJobsForExecution) {
            deadLetterJobEntityManager.delete(job);
        }
        VariableInstanceEntityManager variableInstanceEntityManager = this.commandContext.getVariableInstanceEntityManager();
        List<VariableInstanceEntity> variablesForExecution = variableInstanceEntityManager.findVariableInstancesByExecutionId(scopeExecution.getId());
        for (VariableInstanceEntity variable : variablesForExecution) {
            variableInstanceEntityManager.delete(variable);
        }
        this.commandContext.getHistoryManager().recordActivityEnd(scopeExecution, scopeExecution.getDeleteReason());
        executionEntityManager.delete(scopeExecution);
    }
}

