/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.Transaction;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.crosstenant.CrossTenantInfo;
import kd.bos.workflow.engine.crosstenant.CrossTenantInformationHelper;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ScopeUtil;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.SubProcessActivityBehavior;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFException;

public class EndExecutionOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(EndExecutionOperation.class);
    private static final String ERRORMSG = "Error while completing sub process of execution";
    private static final String ERRORFORMATSTR = "%s %s";

    public EndExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("EndExecutionOperation", String.valueOf(this.execution.getId())));){
            if (this.execution.isProcessInstanceType()) {
                this.handleProcessInstanceExecution(this.execution);
            } else {
                this.handleRegularExecution();
            }
        }
    }

    private void handleProcessInstanceExecutionForCrosstenant(ExecutionEntity execution) {
        HashMap<String, Object> variablesForParent = new HashMap<String, Object>();
        try {
            Object subRet = execution.getVariable("subProcessResult");
            if (subRet != null) {
                variablesForParent.put("subProcessResult", subRet);
            }
            ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
            String variKey = String.format("%s_%s", execution.getVariable("currentActInstId"), "subProcessResult");
            variablesForParent.put(variKey, subRet);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
            throw new WFException(e.getMessage(), e);
        }
        CrossTenantInfo crossTenantInfo = null;
        if (execution.getVariable("crossTenantInfo") == null) {
            throw new WFException("Crosstenant complete error: crossTenantInfo is null");
        }
        String crossTenantInfoStr = (String)execution.getVariable("crossTenantInfo");
        crossTenantInfo = (CrossTenantInfo)SerializationUtils.fromJsonString((String)crossTenantInfoStr, CrossTenantInfo.class);
        CrossTenantInformationHelper.getCrossTenantProcessHandler(null).completeCallActivity(crossTenantInfo, execution.getSuperExecutionId(), variablesForParent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleProcessInstanceExecution(ExecutionEntity processInstanceExecution) {
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        Long processInstanceId = processInstanceExecution.getId();
        logger.debug(String.format("No parent execution found. Verifying if process instance %s can be stopped.", processInstanceId));
        ExecutionEntity superExecution = processInstanceExecution.getSuperExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            FlowNode superExecutionElement = (FlowNode)superExecution.getCurrentFlowElement();
            subProcessActivityBehavior = superExecutionElement instanceof BillTask ? (SubProcessActivityBehavior)((BillTask)superExecutionElement).getBillTaskCallActivity().getBehavior() : (SubProcessActivityBehavior)superExecutionElement.getBehavior();
            if (subProcessActivityBehavior instanceof ParallelMultiInstanceBehavior) {
                subProcessActivityBehavior = (SubProcessActivityBehavior)((Object)((ParallelMultiInstanceBehavior)subProcessActivityBehavior).getInnerActivityBehavior());
            }
            try {
                if (subProcessActivityBehavior != null) {
                    subProcessActivityBehavior.completing(superExecution, processInstanceExecution);
                }
            }
            catch (RuntimeException e) {
                logger.error(String.format(ERRORFORMATSTR, ERRORMSG, processInstanceExecution), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                String errMsg = String.format(ERRORFORMATSTR, ERRORMSG, processInstanceExecution);
                logger.error(errMsg, (Throwable)e);
                throw new WFEngineException(errMsg, e);
            }
        }
        boolean procInstanceEnd = false;
        int activeExecutions = this.getNumberOfActiveChildExecutionsForProcessInstance(executionEntityManager, processInstanceId);
        if (activeExecutions == 0 || DynamicFlowUtil.matchCloseCondition(this.commandContext, processInstanceId)) {
            logger.debug(String.format("No active executions found. Ending process instance %s ", processInstanceId));
            executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceId, this.execution.getCurrentFlowElement() != null ? this.execution.getCurrentFlowElement().getId() : null, null, false, false, true);
            Process process = ProcessDefinitionUtil.getProcess(processInstanceExecution.getProcessDefinitionId(), processInstanceExecution.getProcessInstanceId());
            this.executeExecutionListeners(process, processInstanceExecution, "end");
            procInstanceEnd = true;
        } else {
            logger.debug(String.format("Active executions found. Process instance %s will not be ended.", processInstanceId));
        }
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                if (subProcessActivityBehavior == null) return;
                subProcessActivityBehavior.completed(superExecution);
                return;
            }
            catch (RuntimeException e) {
                logger.error(String.format(ERRORFORMATSTR, ERRORMSG, processInstanceExecution), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                String errmsg = String.format(ERRORFORMATSTR, ERRORMSG, processInstanceExecution);
                logger.error(errmsg, (Throwable)e);
                throw new WFEngineException(errmsg, e);
            }
        } else {
            if (!procInstanceEnd) return;
            Object isCrosstenant = this.execution.getVariable("isCrossTenant");
            Object isCallactity = this.execution.getVariable("isCallActity");
            if (Boolean.TRUE.equals(isCrosstenant) && Boolean.TRUE.equals(isCallactity)) {
                this.handleProcessInstanceExecutionForCrosstenant(this.execution);
            }
            this.sendProcessEndMsg(processInstanceExecution);
            if (!this.commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) return;
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            String endType = null;
            if (null != this.commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) {
                endType = ((HistoricProcessInstanceEntity)this.commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId)).getEndType();
                jsonMap.put("endType", endType);
            }
            new EventTriggerCmd("wf.AfterProcessFinishEvent", this.execution, jsonMap).execute(this.commandContext);
        }
    }

    private void sendProcessEndMsg(ExecutionEntity processInstance) {
        if (processInstance == null) {
            return;
        }
        if (WfConfigurationUtil.needEndProcMsg()) {
            ILocaleString billName = processInstance.getEntraBillName();
            ILocaleString titleValue = WfUtils.getPromptWordLocaleString("\u60a8\u63d0\u4ea4\u7684%1$s-%2$s\u5ba1\u6279\u5b8c\u6210\u3002", "EndExecutionOperation_1", "bos-wf-engine");
            ILocaleString title = WfMultiLangUtils.getMultiLangValue(new ILocaleString[]{titleValue, billName, new LocaleString(processInstance.getBillNo())});
            MessageContext ctx = MessageServiceUtil.buildMessageContext(processInstance);
            MessageInfo info = new MessageInfo();
            info.setNotifyType(MessageServiceUtil.getNotifyTypeByNode("message"));
            info.setMessageTitle(title);
            info.setMessageContent(title);
            ArrayList<Long> u = new ArrayList<Long>();
            u.add(processInstance.getStartUserId());
            info.setUserIds(u);
            String contentUrl = MessageServiceUtil.buildWebPageUrlForMyApplyed(processInstance.getId());
            info.setContentUrl(contentUrl);
            info.setMobContentUrl(contentUrl);
            info.setBizDataId(processInstance.getId());
            info.setTplScene(MessageTypeEnum.PROCEND.getNumber());
            this.commandContext.getMessageService().sendMessage(ctx, info);
            ILocaleString opinion = WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u7ed3\u675f\u65f6\u53d1\u9001\u6d88\u606f\u3002", "EndExecutionOperation_0", "bos-wf-engine");
            Date date = this.commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
            OperationLogEntity operationLog = WfOperationLogUtil.recordOperationLogForSendLinkMsg(u, opinion, date, this.execution);
            WfOperationLogUtil.recordOperationLog(this.commandContext, operationLog);
        }
    }

    protected void handleRegularExecution() {
        logger.debug(String.format("start Ending execution %s billexecution:%s", this.execution.getId(), this.execution.isBillExecution()));
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(this.execution.getParentId());
        if (this.execution.isScope() || this.execution.isBillExecution()) {
            executionEntityManager.deleteChildExecutions(this.execution, null, false);
        }
        executionEntityManager.deleteExecutionAndRelatedData(this.execution, null, false);
        logger.debug(String.format("Parent execution found. Continuing process using execution %s", parentExecution.getId()));
        if (this.isEndEventInMultiInstanceSubprocess(this.execution)) {
            this.handleMultiInstanceSubProcess(executionEntityManager, parentExecution);
            return;
        }
        SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
        if (this.getNumberOfActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId()) == 0 || this.isAllEventScopeExecutions(executionEntityManager, parentExecution)) {
            ExecutionEntity executionToContinue = null;
            logger.debug(String.format("active child of execution[%s] is empty. ", parentExecution.getId()));
            if (subProcess != null) {
                if (subProcess.isForCompensation()) {
                    Context.getAgenda().planEndExecutionOperation(parentExecution);
                } else {
                    executionToContinue = this.handleSubProcessEnd(executionEntityManager, parentExecution, subProcess);
                }
            } else {
                executionToContinue = this.handleRegularExecutionEnd(executionEntityManager, parentExecution);
            }
            if (executionToContinue != null) {
                if (executionToContinue.isProcessInstanceType()) {
                    this.handleProcessInstanceExecution(executionToContinue);
                } else {
                    if (BizFlowUtil.isBizFlowExecution(this.execution) && parentExecution.isBillExecution()) {
                        logger.debug(String.format("parentExecution[%s] is biz execution, ready to delete. ", parentExecution.getId()));
                        Context.getAgenda().planEndExecutionOperation(parentExecution);
                        return;
                    }
                    Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(executionToContinue, true);
                }
            }
        }
    }

    protected ExecutionEntity handleSubProcessEnd(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution, SubProcess subProcess) {
        ExecutionEntity executionToContinue = null;
        executionToContinue = executionEntityManager.createChildExecution(parentExecution.getParent());
        executionToContinue.setCurrentFlowElement(subProcess);
        boolean hasCompensation = false;
        if (subProcess instanceof Transaction) {
            hasCompensation = true;
        } else {
            block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                Activity subActivity;
                if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty((subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                    if (!CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                    hasCompensation = true;
                    continue block0;
                }
            }
        }
        if (hasCompensation) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution);
        }
        executionEntityManager.deleteChildExecutions(parentExecution, null, false);
        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, subProcess.getId(), subProcess.getName(), parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId(), parentExecution.getBusinessKey(), subProcess));
        return executionToContinue;
    }

    protected ExecutionEntity handleRegularExecutionEnd(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        ExecutionEntity executionToContinue = null;
        if (!parentExecution.isProcessInstanceType() && !(parentExecution.getCurrentFlowElement() instanceof SubProcess)) {
            parentExecution.setCurrentFlowElement(this.execution.getCurrentFlowElement());
        }
        if (this.execution.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess currentSubProcess = (SubProcess)this.execution.getCurrentFlowElement();
            if (currentSubProcess.getOutgoingFlows().size() > 0) {
                executionToContinue = executionEntityManager.createChildExecution(parentExecution);
                executionToContinue.setCurrentFlowElement(this.execution.getCurrentFlowElement());
            } else if (!parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                executionToContinue = executionEntityManager.createChildExecution(parentExecution.getParent());
                executionToContinue.setCurrentFlowElement(parentExecution.getCurrentFlowElement());
                executionEntityManager.deleteChildExecutions(parentExecution, null, false);
                executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
            } else {
                executionToContinue = parentExecution;
            }
        } else {
            executionToContinue = parentExecution;
        }
        return executionToContinue;
    }

    protected void handleMultiInstanceSubProcess(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        List<ExecutionEntity> activeChildExecutions = this.getActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId());
        boolean containsOtherChildExecutions = false;
        for (ExecutionEntity activeExecution : activeChildExecutions) {
            if (activeExecution.getId().equals(this.execution.getId())) continue;
            containsOtherChildExecutions = true;
        }
        if (!containsOtherChildExecutions) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution);
            Context.getAgenda().planDestroyScopeOperation(parentExecution);
            SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
            MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
            parentExecution.setCurrentFlowElement(subProcess);
            multiInstanceBehavior.leave(parentExecution);
        }
    }

    protected boolean isEndEventInMultiInstanceSubprocess(ExecutionEntity executionEntity) {
        if (executionEntity.getCurrentFlowElement() instanceof EndEvent) {
            SubProcess subProcess = ((EndEvent)this.execution.getCurrentFlowElement()).getSubProcess();
            return !executionEntity.getParent().isProcessInstanceType() && subProcess != null && subProcess.getLoopCharacteristics() != null && subProcess.getBehavior() instanceof MultiInstanceActivityBehavior;
        }
        return false;
    }

    protected int getNumberOfActiveChildExecutionsForProcessInstance(ExecutionEntityManager executionEntityManager, Long processInstanceId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        int activeExecutions = 0;
        for (ExecutionEntity execution : executions) {
            if (!execution.isActive() || processInstanceId.equals(execution.getId())) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected int getNumberOfActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, Long executionId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        int activeExecutions = 0;
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent || !activeExecution.isActive()) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected List<ExecutionEntity> getActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, Long executionId) {
        ArrayList<ExecutionEntity> activeChildExecutions = new ArrayList<ExecutionEntity>();
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            activeChildExecutions.add(activeExecution);
        }
        return activeChildExecutions;
    }

    protected boolean isAllEventScopeExecutions(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        boolean allEventScopeExecutions = true;
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        for (ExecutionEntity childExecution : executions) {
            if (childExecution.isEventScope()) {
                executionEntityManager.deleteExecutionAndRelatedData(childExecution, null, false);
                continue;
            }
            allEventScopeExecutions = false;
            break;
        }
        return allEventScopeExecutions;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }
}

