/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class ExecuteBehaviorOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(ExecuteBehaviorOperation.class);
    protected boolean forceSynchronousOperation;

    public ExecuteBehaviorOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation) {
        super(commandContext, execution);
        this.forceSynchronousOperation = forceSynchronousOperation;
    }

    @Override
    public void run() {
        block16: {
            FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
            try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("ExecuteBehaviorOperation", currentFlowElement.getId()));){
                logger.debug(String.format("ExecuteBehaviorOperation[%s],execution[%s]", currentFlowElement.getId(), this.execution.getId()));
                if (currentFlowElement instanceof FlowNode) {
                    FlowNode flowNode = (FlowNode)currentFlowElement;
                    if (this.forceSynchronousOperation) {
                        ActivityBehavior activityBehavior = (ActivityBehavior)flowNode.getBehavior();
                        activityBehavior.execute(this.execution);
                        break block16;
                    }
                    JobEntity job = this.commandContext.getJobManager().createAsyncExecuteBehaviorJob(this.execution, flowNode.isExclusive());
                    logger.debug(String.format("createJob[%s],executionid[%s]", job.getExecutionId(), this.execution.getId()));
                    this.commandContext.getJobManager().scheduleAsyncJob(job);
                    break block16;
                }
                throw new WFException(WFErrorCode.engineError(), String.format("current element is [%s], execution is [%s]", currentFlowElement.getId(), this.execution.getId()));
            }
        }
    }
}

