/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.delegate.InactiveActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class ExecuteInactiveBehaviorsOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(ExecuteInactiveBehaviorsOperation.class);
    protected Collection<ExecutionEntity> involvedExecutions;

    public ExecuteInactiveBehaviorsOperation(CommandContext commandContext) {
        super(commandContext, null);
        this.involvedExecutions = commandContext.getInvolvedExecutions();
    }

    @Override
    public void run() {
        for (ExecutionEntity executionEntity : this.involvedExecutions) {
            Process process = ProcessDefinitionUtil.getProcess(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId());
            ArrayList<String> flowNodeIdsWithInactivatedBehavior = new ArrayList<String>();
            for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
                if (!(flowNode.getBehavior() instanceof InactiveActivityBehavior)) continue;
                flowNodeIdsWithInactivatedBehavior.add(flowNode.getId());
            }
            if (flowNodeIdsWithInactivatedBehavior.size() <= 0) continue;
            Collection<ExecutionEntity> inactiveExecutions = this.commandContext.getExecutionEntityManager().findInactiveExecutionsByProcessInstanceId(executionEntity.getProcessInstanceId());
            for (ExecutionEntity inactiveExecution : inactiveExecutions) {
                if (inactiveExecution.isActive() || !flowNodeIdsWithInactivatedBehavior.contains(inactiveExecution.getActivityId()) || inactiveExecution.isDeleted()) continue;
                FlowNode flowNode = (FlowNode)process.getFlowElement(inactiveExecution.getActivityId(), true);
                InactiveActivityBehavior inactiveActivityBehavior = (InactiveActivityBehavior)flowNode.getBehavior();
                logger.debug(String.format("Found InactiveActivityBehavior instance of class %s that can be executed on activity '%s'", inactiveActivityBehavior.getClass(), flowNode.getId()));
                inactiveActivityBehavior.executeInactive(inactiveExecution);
            }
        }
    }
}

