/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.bpm.calculator.BillCalculatorExecutor;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.BillExecutionState;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBotpCalcExecption;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.util.concurrent.ConcurrentDataUpdateUtil;

public class ExecutionConvertOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(ExecutionConvertOperation.class);
    public static final String CONVERSION_SCENE_DOWNBILLCOMING = "downBillComing";
    private Map<String, Set<String>> targetBills = new HashMap<String, Set<String>>();
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String incomingFlow;

    public ExecutionConvertOperation(CommandContext commandContext, ExecutionEntity execution, String tagentityNumber, Collection<String> businesskeys, Map<String, Object> variables) {
        super(commandContext, execution);
        this.targetBills.put(tagentityNumber, new HashSet<String>(businesskeys));
        if (variables != null) {
            this.variables = variables;
        }
    }

    public ExecutionConvertOperation(CommandContext commandContext, ExecutionEntity execution, String incomingFlow) {
        super(commandContext, execution);
        this.incomingFlow = incomingFlow;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement == null) {
            throw new WFException(WFErrorCode.engineError(), "has not current element when execute asyncExecutionConvertOperation! ");
        }
        try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("AsyncExecutionConvertOperation", currentFlowElement.getId()));){
            logger.debug(String.format("AsyncExecutionConvertOperation[%s],execution[%s]", currentFlowElement.getId(), this.execution.getId()));
            SequenceFlow inFlow = null;
            if (this.incomingFlow != null) {
                inFlow = (SequenceFlow)ProcessDefinitionUtil.getFlowElement(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId(), this.incomingFlow);
            }
            if (DynamicFlowUtil.isNextNodeTerminate(this.execution)) {
                Context.getAgenda().planContinueProcessOperation(this.execution, true);
                logger.debug(String.format("execution[%s-%s] is terminated", this.execution.getId(), this.execution.getBusinessKey()));
                return;
            }
            Collection<ExecutionEntity> originalExecutions = new ArrayList<ExecutionEntity>(1);
            originalExecutions.add(this.execution);
            BillCalculatorExecutor billConversionCalculator = this.commandContext.getBillConversionCalculator();
            BillCalculatorResult result = billConversionCalculator.execute(this.execution, inFlow, this.variables);
            logger.debug("result1 : " + result);
            if (result.getException() != null) {
                RuntimeException e = result.getException();
                if (e instanceof WFBotpCalcExecption) {
                    throw (WFBotpCalcExecption)((Object)e);
                }
                throw ExceptionUtil.createBillCalcExeption(e, this.execution, result, inFlow == null ? null : inFlow.getTargetFlowElement());
            }
            if (BillCalculatorResult.isBlocking(result)) {
                return;
            }
            if (this.execution.getTransientVariableLocal("mountBySrcExc_filteredFlag") != null) {
                logger.debug(String.format("the bill:[%s] mount bizFlow by src bill, it has already been filtered, no need to filter again.", this.targetBills.toString()));
                this.execution.removeTransientVariableLocal("mountBySrcExc_filteredFlag");
            } else if (inFlow != null && billConversionCalculator.isSupportTargetBillsFilter(this.commandContext, this.execution, inFlow)) {
                billConversionCalculator.doFilter(result, inFlow);
            }
            logger.debug("result2 : " + result);
            if (BillCalculatorResult.isNativeContinue(result)) {
                Context.getAgenda().planContinueProcessOperation(this.execution, BillCalculatorResult.isManualConversion(result));
                if (result.getTargetBills().isEmpty()) {
                    return;
                }
            }
            if (!result.getTargetBills().isEmpty()) {
                this.targetBills = result.getTargetBills();
            }
            if (result.getOriginalExecutions() != null && !result.getOriginalExecutions().isEmpty()) {
                originalExecutions = result.getOriginalExecutions();
            }
            this.convertExecutionAndContinue(inFlow, originalExecutions, result.getConversionType(), result.getTargetBillsOperation());
            if ("selfBillCalculator".equals(result.getConversionType())) {
                ConcurrentDataUpdateUtil.updateActivityName(this.execution, this.commandContext);
            }
        }
    }

    private void convertExecutionAndContinue(SequenceFlow inFlow, Collection<ExecutionEntity> originalExecutions, String convertType, Map<String, String> targetBillOperations) {
        ExecutionEntity billExecution;
        ExecutionEntity executionEntity = billExecution = this.execution.getParentId() != null ? this.execution.getParent() : this.execution;
        if (this.targetBills.isEmpty()) {
            Context.getAgenda().planContinueProcessOperation(this.execution);
        } else {
            ExecutionEntityManager executionMgr = this.commandContext.getExecutionEntityManager();
            ExecutionEntity parent = billExecution.getParentId() != null ? billExecution.getParent() : billExecution;
            Long currentActInstId = 0L;
            HistoricActivityInstanceEntity currentActInst = (HistoricActivityInstanceEntity)this.commandContext.getHistoricActivityInstanceEntityManager().findById(this.execution.getCurrentActInstId());
            if (currentActInst != null) {
                currentActInstId = currentActInst.getSourceElementId();
                if ("SequenceFlow".equals(currentActInst.getActivityType())) {
                    currentActInstId = currentActInst.getId();
                }
            }
            Map<String, BillExecutionState> execs = executionMgr.findAllBillExecution(this.execution.getProcessInstanceId());
            boolean createExecution = false;
            for (Map.Entry<String, Set<String>> entry : this.targetBills.entrySet()) {
                String tagEntityNumber = entry.getKey();
                for (String tagPk : entry.getValue()) {
                    String operation;
                    String key = String.format("%s%s%s", tagEntityNumber, tagPk, this.execution.getCurrentFlowElement().getId());
                    BillExecutionState state = execs.get(key);
                    if (state != null && state.isExistChild() && state.isNotAbort()) {
                        logger.debug(String.format("%s is exist in billexecution, no need for mount.", key));
                        continue;
                    }
                    logger.debug(String.format("%s is not exist in billexecution or child is null or is abort[%s].", key, state == null ? "null" : state.toString()));
                    if (!createExecution) {
                        createExecution = true;
                    }
                    ExecutionEntity anotherbillExecution = null;
                    if (state != null && WfUtils.isNotEmpty(state.getId())) {
                        anotherbillExecution = (ExecutionEntity)executionMgr.findById(state.getId());
                        anotherbillExecution.setAbortType(0);
                    } else {
                        anotherbillExecution = executionMgr.createChildExecution(parent);
                        anotherbillExecution.setEntityNumber(tagEntityNumber);
                        anotherbillExecution.setBusinessKey(tagPk);
                        anotherbillExecution.setBillNo(TaskBehaviorUtil.getTaskBillNo(tagEntityNumber, String.valueOf(tagPk)));
                        Map<String, Object> entityProperties = WfUtils.getEntityProperties(tagEntityNumber, String.valueOf(tagPk));
                        if (!entityProperties.isEmpty()) {
                            LocaleString entityName;
                            String billType = (String)entityProperties.get("billType");
                            if (WfUtils.isNotEmpty(billType)) {
                                anotherbillExecution.setBillType(billType);
                            }
                            if (WfUtils.isNotEmpty((ILocaleString)(entityName = (LocaleString)entityProperties.get("entityName")))) {
                                anotherbillExecution.setEntraBillName((ILocaleString)entityName);
                            }
                        }
                        anotherbillExecution.setCurrentActInstId(currentActInstId);
                        anotherbillExecution.setBillExecution(Boolean.TRUE);
                        anotherbillExecution.setActive(Boolean.FALSE);
                        anotherbillExecution.setCurrentFlowElement(this.execution.getCurrentFlowElement());
                        anotherbillExecution.setActivityId(this.execution.getCurrentFlowElement().getId());
                        this.commandContext.getExeConversionEntityManager().recordExeConversionEntity(originalExecutions, anotherbillExecution, convertType);
                    }
                    ExecutionEntity anotherExecution = executionMgr.createChildExecution(anotherbillExecution);
                    anotherExecution.setActivityName(this.execution.getActivityName());
                    String stateKey = String.format("%s.%s", "conversionTask", this.getCurrentFlowElement(this.execution).getId());
                    anotherExecution.setVariableLocal(stateKey, Boolean.TRUE);
                    String string = operation = this.variables != null && this.variables.get("_operation_") != null ? (String)this.variables.get("_operation_") : targetBillOperations.get(tagPk);
                    if (WfUtils.isNotEmpty(operation)) {
                        anotherbillExecution.setVariableLocal("_operation_", operation);
                        anotherbillExecution.setVariableLocal("convertType", convertType);
                    }
                    FlowElement currentElement = this.execution.getCurrentFlowElement();
                    anotherExecution.setCurrentFlowElement(currentElement);
                    this.commandContext.getCirculateRelationEntityManager().recordCirculateRelationShip(anotherExecution, currentElement);
                    String currentElementEntityNumber = null;
                    if (currentElement instanceof IEntitySupport) {
                        currentElementEntityNumber = ((IEntitySupport)((Object)currentElement)).getEntityNumber();
                    } else if (currentElement instanceof AutoTask) {
                        String entityId = ((AutoTask)currentElement).getEntityId();
                        currentElementEntityNumber = MetadataDao.getNumberById((String)entityId);
                    }
                    if (currentElementEntityNumber != null && !tagEntityNumber.equalsIgnoreCase(currentElementEntityNumber)) {
                        anotherExecution.setVariableLocal("bizTargetEntity", tagEntityNumber);
                    }
                    Context.getAgenda().planContinueProcessOperation(anotherExecution);
                }
            }
            if (createExecution) {
                inFlow = inFlow == null ? this.getIncomingFlow() : inFlow;
                this.completedTask(inFlow, originalExecutions);
            }
        }
    }

    private SequenceFlow getIncomingFlow() {
        String flowId;
        HistoricActivityInstanceEntityManager hiActMgr = this.commandContext.getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity currentActInst = (HistoricActivityInstanceEntity)hiActMgr.findById(this.execution.getCurrentActInstId());
        if (currentActInst == null) {
            return null;
        }
        if ("SequenceFlow".equals(currentActInst.getActivityType())) {
            flowId = currentActInst.getActivityId();
        } else {
            HistoricActivityInstanceEntity sequence = (HistoricActivityInstanceEntity)hiActMgr.findById(currentActInst.getSourceElementId());
            if (sequence == null) {
                throw new WFException(WFErrorCode.engineError(), "");
            }
            flowId = sequence.getActivityId();
        }
        SequenceFlow inFlow = (SequenceFlow)ProcessDefinitionUtil.getFlowElement(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId(), flowId);
        return inFlow;
    }

    private void completedTask(SequenceFlow flow, Collection<ExecutionEntity> originalExecutions) {
        for (ExecutionEntity e : originalExecutions) {
            TaskEntity task = e.getCurrentTask();
            if (task != null && !task.isFromHistory()) {
                if (!BizFlowUtil.canCloseTask((VariableScope)task, flow)) {
                    task.setHandleState("converting");
                    this.commandContext.getTaskEntityManager().update(task);
                    continue;
                }
                this.updateCirculateRelationState(e);
                BizFlowUtil.completeBillTaskNotContinue(this.commandContext, e, task);
                continue;
            }
            if (!BizFlowUtil.canCloseTask((VariableScope)e, flow)) continue;
            this.commandContext.getExecutionEntityManager().deleteChildrenExecutions(e.getId());
            e.setActive(false);
            this.updateCirculateRelationState(e);
        }
    }

    private void updateCirculateRelationState(ExecutionEntity e) {
        CirculateRelationEntityManager entityManager = this.commandContext.getCirculateRelationEntityManager();
        List entities = entityManager.findByQueryFilters(new QFilter[]{new QFilter("businesskey", "=", (Object)e.getBusinessKey())});
        if (entities.isEmpty()) {
            return;
        }
        for (CirculateRelationEntity entity : entities) {
            entity.setStatus("complete");
            entityManager.update(entity);
        }
    }
}

