/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.center.ForkNodeRejectListener;

public class ForkJoinUtils {
    private static final int MEETJOINMAXCIRCLE = 50;

    public static boolean meetJoinCondition(FlowNode joinNode, int noOfShouldSurvive, int noOfArrived, ExecutionEntity execution) {
        if (noOfShouldSurvive == 0) {
            int cycle;
            String joinNodeId;
            ExecutionEntity procinst = execution.getProcessInstance();
            Process process = ProcessDefinitionUtil.getProcessByProcInstId(execution.getProcessInstanceId());
            Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
            NodeForkJoinModel model = models.get(joinNodeId = joinNode.getId());
            String forkNodeId = model.getPairForkNodeId();
            String rejectNodeKey = ForkJoinUtils.getJoinNodeRejectKey(forkNodeId, cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, procinst), procinst);
            if (WfUtils.isNotEmpty(rejectNodeKey)) {
                return false;
            }
            List<ExecutionEntity> execs = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
            for (ExecutionEntity exe : execs) {
                NodeForkJoinModel cModel;
                if (exe.isScope() || !exe.isActive() || (cModel = models.get(exe.getActivityId())) == null || !joinNodeId.equals(cModel.getLatestJoinNode())) continue;
                return false;
            }
            return true;
        }
        if (noOfShouldSurvive > noOfArrived) {
            return false;
        }
        if (ModelType.AuditFlow.name().equals(execution.getProcessType()) && WfConfigurationUtil.enableForkJoinMeetingSupplementaryRules()) {
            Process process = ProcessDefinitionUtil.getProcessByProcInstId(execution.getProcessInstanceId());
            if (process == null) {
                return true;
            }
            Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
            List<ExecutionEntity> execs = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
            for (ExecutionEntity exe : execs) {
                if (exe.isScope() || !exe.isActive() || !ForkJoinUtils.checkHasNodeNotArrivedJoinNode(joinNode.getId(), exe.getActivityId(), models, 1)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkHasNodeNotArrivedJoinNode(String joinNodeId, String nodeId, Map<String, NodeForkJoinModel> models, int circle) {
        if (circle > 50) {
            return false;
        }
        NodeForkJoinModel nodeForkJoinModel = models.get(nodeId);
        if (nodeForkJoinModel == null || nodeForkJoinModel.getLatestJoinNode() == null) {
            return false;
        }
        if (joinNodeId.equals(nodeForkJoinModel.getLatestJoinNode())) {
            return true;
        }
        return ForkJoinUtils.checkHasNodeNotArrivedJoinNode(joinNodeId, nodeForkJoinModel.getLatestJoinNode(), models, circle + 1);
    }

    public static void setJoinNodeRejectKey(String forkNodeId, int cycle, ExecutionEntity proinst, String joinNodeRejectKey) {
        String key = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkRejectKey");
        proinst.setVariableLocal(key, joinNodeRejectKey);
    }

    public static String getJoinNodeRejectKey(String forkNodeId, int cycle, ExecutionEntity proinst) {
        String key = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkRejectKey");
        return (String)proinst.getVariableLocal(key);
    }

    public static void removeJoinNodeRejectKey(String forkNodeId, int cycle, ExecutionEntity proinst) {
        ForkJoinUtils.removeJoinNodeRejectKey(forkNodeId, cycle, proinst, false);
    }

    public static void removeJoinNodeRejectKey(String forkNodeId, int cycle, ExecutionEntity proinst, boolean deleteHistory) {
        String key = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkRejectKey");
        QFilter filter = new QFilter("processInstanceId", "=", (Object)proinst.getId());
        QFilter f = new QFilter("name", "=", (Object)key);
        List vs = Context.getCommandContext().getVariableInstanceEntityManager().findByQueryFilters(new QFilter[]{filter, f});
        if (!vs.isEmpty()) {
            Long id = ((VariableInstanceEntity)vs.get(0)).getId();
            Context.getCommandContext().getVariableInstanceEntityManager().delete((Entity)vs.get(0));
            if (deleteHistory) {
                Context.getCommandContext().getHistoricVariableInstanceEntityManager().delete(id);
            }
        }
    }

    public static int getEnterForkCycle(String forkNodeId, ExecutionEntity proinst) {
        if (proinst.getVariableLocal(ForkJoinUtils.getNumber(forkNodeId, proinst) + "_" + "forkNodeEnterCycle") == null) {
            return 0;
        }
        return (Integer)proinst.getVariableLocal(ForkJoinUtils.getNumber(forkNodeId, proinst) + "_" + "forkNodeEnterCycle");
    }

    public static void setEnterForkCycle(String forkNodeId, ExecutionEntity proinst, int cycle) {
        proinst.setVariableLocal(ForkJoinUtils.getNumber(forkNodeId, proinst) + "_" + "forkNodeEnterCycle", cycle);
    }

    public static void removeEnterForkCycle(String forkNodeId, ExecutionEntity proinst) {
        proinst.removeVariableLocal(ForkJoinUtils.getNumber(forkNodeId, proinst) + "_" + "forkNodeEnterCycle");
    }

    public static String getItemForkResult(String forkNodeId, String targetNodeId, int cycle, ExecutionEntity proinst) {
        String oldMapKey;
        String json;
        Map resultMap;
        String mapKey = null;
        mapKey = WfUtils.isNotEmpty(targetNodeId) ? String.format("%s_%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), ForkJoinUtils.getNumber(targetNodeId, proinst), cycle, "forkResult") : String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkResult");
        String val = (String)proinst.getVariableLocal(mapKey);
        if (WfUtils.isEmpty(val) && (resultMap = WfUtils.isEmpty(json = (String)proinst.getVariableLocal(oldMapKey = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkResult"))) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)json, Map.class)) != null && resultMap.size() > 0) {
            for (Map.Entry entry : resultMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.indexOf(targetNodeId) <= -1) continue;
                val = (String)entry.getValue();
                break;
            }
        }
        return val;
    }

    public static void setForkResult(String forkNodeId, String targetNodeId, int cycle, ExecutionEntity proinst, Object val) {
        String mapKey = null;
        mapKey = WfUtils.isNotEmpty(targetNodeId) ? String.format("%s_%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), ForkJoinUtils.getNumber(targetNodeId, proinst), cycle, "forkResult") : String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkResult");
        proinst.setVariableLocal(mapKey, val);
    }

    public static void removeForkResult(String forkNodeId, int cycle, ExecutionEntity proinst) {
        String forkResultKey = String.format("%s_%s_%s", ForkJoinUtils.getNumber(forkNodeId, proinst), cycle, "forkResult");
        proinst.removeVariableLocal(forkResultKey);
    }

    public static Object getNoOfShouldSurvive(String joinFlag, ExecutionEntity proinst) {
        return proinst.getVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "noOfShouldSurvive_forkOut");
    }

    public static void setNoOfShouldSurvive(String joinFlag, ExecutionEntity proinst, int noOfShouldSurvive) {
        proinst.setVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "noOfShouldSurvive_forkOut", noOfShouldSurvive);
    }

    public static void removeNoOfShouldSurvive(String joinFlag, ExecutionEntity proinst) {
        proinst.removeVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "noOfShouldSurvive_forkOut");
    }

    public static Object getNoOfArrived(String joinFlag, ExecutionEntity proinst) {
        return proinst.getVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "noOfArrived");
    }

    public static void setNoOfArrived(String joinFlag, ExecutionEntity proinst, int noOfArrived) {
        proinst.setVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "noOfArrived", noOfArrived);
    }

    public static void removeNoOfArrived(String joinFlag, ExecutionEntity proinst) {
        proinst.removeVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "noOfArrived");
    }

    public static Object getFirstEnterJoinExecution(String joinFlag, ExecutionEntity proinst) {
        return proinst.getVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "firstEnterJoinNodeExecution");
    }

    public static void setFirstEnterJoinExecution(String joinFlag, ExecutionEntity proinst, Long executionId) {
        proinst.setVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "firstEnterJoinNodeExecution", executionId);
    }

    public static void removeFirstEnterJoinExecution(String joinFlag, ExecutionEntity proinst) {
        proinst.removeVariableLocal(ForkJoinUtils.getJoinFlagHashCode(joinFlag, proinst) + "_" + "firstEnterJoinNodeExecution");
    }

    public static String getJoinFlag(DelegateExecution execution, String flowNodeId) {
        HistoricActivityInstanceEntity actInst = (HistoricActivityInstanceEntity)Context.getCommandContext().getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId());
        return actInst.getJoinFlag();
    }

    public static String getNumber(String nodeId, ExecutionEntity proinst) {
        if ("MAIN".equals(nodeId)) {
            return nodeId;
        }
        BpmnModel bp = ProcessDefinitionUtil.getBpmnModel(proinst.getProcessDefinitionId(), proinst.getProcessInstanceId());
        FlowElement elem = bp.getMainProcess().getFlowElement(nodeId);
        if (elem != null) {
            return elem.getNumber();
        }
        return "";
    }

    public static String getJoinFlagHashCode(String joinFlag, ExecutionEntity proinst) {
        if (WfUtils.isEmpty(joinFlag)) {
            return "";
        }
        Process process = ProcessDefinitionUtil.getBpmnModel(proinst.getProcessDefinitionId(), proinst.getProcessInstanceId()).getMainProcess();
        String[] brachers = joinFlag.split("\\$");
        StringBuilder sb = new StringBuilder();
        sb.append(process.getFlowElement(brachers[0]).getNumber()).append("$").append(brachers[1]).append("$").append(process.getFlowElement(brachers[2]).getNumber());
        return sb.toString();
    }

    public static void setJoinNodeRejectKey(Process process, FlowNode curNode, ExecutionEntity proinst) {
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel model = models.get(curNode.getId());
        String forkNodeId = model.getPairForkNodeId();
        int enterCycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, proinst);
        FlowNode forkNode = (FlowNode)process.getFlowElement(forkNodeId);
        if (forkNode == null) {
            return;
        }
        List<SequenceFlow> outFlows = forkNode.getOutgoingFlows();
        for (SequenceFlow flow : outFlows) {
            if (!"reject".equals(ForkJoinUtils.getItemForkResult(forkNodeId, flow.getTargetRef(), enterCycle, proinst))) continue;
            String joinNodeRejectKey = "JOIN_" + forkNodeId;
            ForkJoinUtils.setJoinNodeRejectKey(forkNodeId, enterCycle, proinst, joinNodeRejectKey);
            break;
        }
    }

    public static void markOtherBranchsEnd(Process process, FlowNode curNode, ExecutionEntity execution, List<SequenceFlow> outgoingSequenceFlows) {
        String forkNodeId;
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel model = models.get(curNode.getId());
        if (model != null && WfUtils.isNotEmpty(forkNodeId = model.getLatestForkNode()) && "all".equals(((FlowNode)process.getFlowElement(forkNodeId)).getPassTypeAfterInnerReject())) {
            String targetNodeId = outgoingSequenceFlows.get(0).getTargetFlowElement().getId();
            NodeForkJoinModel targetModel = models.get(targetNodeId);
            if (model.getForkStructure() != null && targetModel != null && !model.getForkStructure().equals(targetModel.getForkStructure()) && !targetNodeId.equals(model.getLatestJoinNode())) {
                ForkNodeRejectListener.markOtherBranchsEnd(Context.getCommandContext(), execution, execution.getProcessInstanceId(), curNode.getId(), targetNodeId, "", "reject");
            }
        }
    }

    public static void updateForkResultVar(FlowNode flowNode, ExecutionEntity proinst, Process process, String auditType, String nextNodeId) {
        if (WfUtils.isEmpty(auditType)) {
            return;
        }
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel model = models.get(flowNode.getId());
        if (model != null) {
            String structure = model.getForkStructure();
            String forkNodeId = model.getLatestForkNode();
            forkNodeId = WfUtils.isEmpty(forkNodeId) ? "MAIN" : forkNodeId;
            int enterCycle = "MAIN".equals(forkNodeId) ? 0 : ForkJoinUtils.getEnterForkCycle(forkNodeId, proinst);
            String forkFirstNode = "";
            int c = 36;
            if (structure.lastIndexOf(c) > -1) {
                forkFirstNode = structure.substring(structure.lastIndexOf(c) + 1);
            }
            ForkJoinUtils.setForkResult(forkNodeId, forkFirstNode, enterCycle, proinst, auditType);
            if (!"MAIN".equals(forkNodeId) && ("reject".equals(auditType) || "forceReject".equals(auditType))) {
                boolean flag = true;
                if (WfUtils.isNotEmpty(nextNodeId)) {
                    for (String nnid : nextNodeId.split("\\,")) {
                        NodeForkJoinModel nm = models.get(nnid);
                        if (nm == null || !nm.getForkStructure().contains(model.getForkStructure())) continue;
                        flag = false;
                        break;
                    }
                }
                if (flag) {
                    ForkJoinUtils.setJoinNodeRejectKey(forkNodeId, enterCycle, proinst, flowNode.getId());
                }
            }
        }
    }

    public static void setForkResult(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, ExecutionEntity proinst) {
        int enterCycle = ForkJoinUtils.getEnterForkCycle(flowNode.getId(), proinst);
        if (enterCycle > 0) {
            for (SequenceFlow s : flowNode.getOutgoingFlows()) {
                if (outgoingSequenceFlows.contains(s)) {
                    ForkJoinUtils.setForkResult(flowNode.getId(), s.getTargetFlowElement().getId(), enterCycle, proinst, "emptyVal");
                    continue;
                }
                ForkJoinUtils.setForkResult(flowNode.getId(), s.getTargetFlowElement().getId(), enterCycle, proinst, "forkResult_notIn");
            }
        }
    }

    public static boolean isForkNode(FlowNode flowNode) {
        return flowNode.getFork() != null && flowNode.getFork() != false && "leavewhenallmeet".equals(flowNode.getOutSet());
    }

    public static boolean isJoinNode(FlowNode flowNode) {
        return flowNode.getJoin() != null && flowNode.getJoin() != false && "enterwhenallarrive".equals(flowNode.getInSet());
    }
}

