/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AdhocSubProcess;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.JudgeTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.BoundaryCompensationHelper;
import kd.bos.workflow.engine.impl.bpmn.helper.SkipExpressionUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;

public class TakeOutgoingSequenceFlowsOperation
extends AbstractOperation {
    protected static Log logger = LogFactory.getLog(TakeOutgoingSequenceFlowsOperation.class);
    protected boolean evaluateConditions;

    public TakeOutgoingSequenceFlowsOperation(CommandContext commandContext, ExecutionEntity executionEntity, boolean evaluateConditions) {
        super(commandContext, executionEntity);
        this.evaluateConditions = evaluateConditions;
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("TakeOutgoingOperation", currentFlowElement.getId()));){
            if (currentFlowElement instanceof Activity && ((Activity)currentFlowElement).isForCompensation() && !DynamicFlowUtil.isNextNodeTerminateExceptAuditAbort(this.execution)) {
                this.cleanupCompensation((Long)this.execution.getVariableLocal("triggerCompensationExecuteExe"));
                BoundaryCompensationHelper.dealCompensateNodeEnd(this.execution, currentFlowElement);
                return;
            }
            if (currentFlowElement instanceof FlowNode) {
                this.handleFlowNode((FlowNode)currentFlowElement);
            } else if (currentFlowElement instanceof SequenceFlow) {
                this.cleanupExecutions(currentFlowElement);
                this.handleSequenceFlow((SequenceFlow)currentFlowElement);
            }
        }
    }

    protected void handleFlowNode(FlowNode flowNode) {
        logger.debug(String.format("takeoutgoingfromFlowNode[%s]", flowNode.getId()));
        this.handleActivityEnd(flowNode);
        if (this.enterBoundaryError) {
            logger.debug("\u8fdb\u5165\u8fb9\u754c\u5f02\u5e38\uff0c\u6b63\u5e38\u5206\u652f\u4e0d\u5728\u6d41\u8f6c\uff01");
            return;
        }
        this.cleanupExecutions(flowNode);
        if (flowNode.getParentContainer() instanceof AdhocSubProcess) {
            this.handleAdhocSubProcess(flowNode);
        } else {
            this.leaveFlowNode(flowNode);
        }
    }

    protected void handleActivityEnd(FlowNode flowNode) {
        this.commandContext.getHistoryManager().updateNodeHiUserActInst(this.execution, flowNode, WfUtils.now());
        if (!this.execution.isProcessInstanceType()) {
            this.executeExecutionListeners(flowNode, "end");
            this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
            if (!(this.execution.getCurrentFlowElement() instanceof SubProcess)) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), this.execution.getBusinessKey(), flowNode));
            }
        }
    }

    protected void leaveFlowNode(FlowNode flowNode) {
        String key;
        SequenceFlow dynSequenceFlow;
        logger.debug(String.format("Leaving flow node %s with id '%s' by following it's %d outgoing sequenceflow", flowNode.getClass().getName(), flowNode.getId(), flowNode.getOutgoingFlows().size()));
        List<SequenceFlow> outgoingSequenceFlows = new ArrayList<SequenceFlow>();
        String nextNodeId = DynamicFlowUtil.getCustomNextNodeId(this.execution);
        ExecutionEntity proinst = this.execution.getProcessInstance();
        if (DynamicFlowUtil.isNextNodeTerminate(this.execution)) {
            dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "terminateEvent", null);
            outgoingSequenceFlows.add(dynSequenceFlow);
        } else if (DynamicFlowUtil.isNextNodeDynamicJump(this.execution)) {
            dynSequenceFlow = this.findSuitableSequence(flowNode, nextNodeId);
            if (dynSequenceFlow == null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("nextnodeid", nextNodeId);
                dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "sequenceFlow", params);
            }
            outgoingSequenceFlows.add(dynSequenceFlow);
            key = String.format("%s_%s", dynSequenceFlow.getSourceRef(), "rejectToForkInnerAndSkip");
            this.execution.getProcessInstance().removeVariable(key);
        } else if (DynamicFlowUtil.isAddSignBefore(this.execution)) {
            dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "addsignbefore", null);
            outgoingSequenceFlows.add(dynSequenceFlow);
            key = String.format("%s_%s", dynSequenceFlow.getSourceRef(), "rejectToForkInnerAndSkip");
            this.execution.getProcessInstance().removeVariable(key);
        } else if (DynamicFlowUtil.isRejectToForkInner(this.execution)) {
            this.dealRejectToForkInner(flowNode, outgoingSequenceFlows, nextNodeId, proinst);
        } else if ((outgoingSequenceFlows = this.getLeaveOutgoingSequenceFlows(flowNode, outgoingSequenceFlows, nextNodeId = this.recalculateNextNodeIdIfNeed(flowNode, nextNodeId))).isEmpty()) {
            if (flowNode.getOutgoingFlows() == null || flowNode.getOutgoingFlows().isEmpty()) {
                logger.debug(String.format("No outgoing sequence flow found for flow node '%s'.", flowNode.getId()));
                Context.getAgenda().planEndExecutionOperation(this.execution);
                return;
            }
            if (nextNodeId != null) {
                dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "sequenceFlow", null);
                outgoingSequenceFlows.add(dynSequenceFlow);
            } else {
                throw new WFEngineException(WFErrorCode.noOutgoingSequenceError(), new String[]{flowNode.getName()});
            }
        }
        if (flowNode.getFork() != null && flowNode.getFork().booleanValue()) {
            String outSet = flowNode.getOutSet();
            if ("leavewhenallmeet".equals(outSet)) {
                outgoingSequenceFlows = this.dealForkNodeLeave(flowNode, outgoingSequenceFlows, proinst);
            } else if (outgoingSequenceFlows.size() > 1) {
                if ("leavewhenfristone".equals(outSet)) {
                    ArrayList<SequenceFlow> tmp = new ArrayList<SequenceFlow>();
                    tmp.add(outgoingSequenceFlows.get(0));
                    outgoingSequenceFlows = tmp;
                } else if (!"leavewithallnotjoin".equals(outSet)) {
                    throw ExceptionUtil.createWFOutSetException(flowNode, outgoingSequenceFlows, this.execution);
                }
            }
        } else if (outgoingSequenceFlows.size() > 1 && !DynamicFlowUtil.isRejectToForkInner(this.execution)) {
            throw ExceptionUtil.createWFOutSetException(flowNode, outgoingSequenceFlows, this.execution);
        }
        this.setRejectKeyForkResultAndOtherBranchsIfNeed(flowNode, outgoingSequenceFlows, nextNodeId, proinst);
        List<ExecutionEntity> outgoingExecutions = this.getOutgoingExecutions(flowNode, outgoingSequenceFlows, nextNodeId);
        List<Object> hiUserActInstEntities = new ArrayList();
        if (outgoingExecutions.size() > 1 && (ProcessType.AuditFlow.name().equals(proinst.getProcessType()) || ProcessType.NoCodeFlow.name().equals(proinst.getProcessType()))) {
            hiUserActInstEntities = this.commandContext.getHiUserActInstEntityManager().findByCurrentExecutionId(this.execution.getId());
        }
        for (ExecutionEntity outgoingExecution : outgoingExecutions) {
            if (!hiUserActInstEntities.isEmpty() && ((HiUserActInstEntity)hiUserActInstEntities.get(0)).getCurrentExecutionId().longValue() != outgoingExecution.getId().longValue()) {
                for (HiUserActInstEntity hiUserActInstEntity : hiUserActInstEntities) {
                    this.copyAndInsertHiUserInst(hiUserActInstEntity, outgoingExecution, this.commandContext);
                }
            }
            Context.getAgenda().planContinueProcessOperation(outgoingExecution);
        }
    }

    private void dealRejectToForkInner(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId, ExecutionEntity proinst) {
        Long procInstId = this.execution.getProcessInstanceId();
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId(), procInstId);
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        NodeForkJoinModel nextNodeModel = null;
        String skipToNode = DynamicFlowUtil.getDynamicVariableValue(this.execution, String.format("%s-%s", nextNodeId, "rejectToForkInnerAndSkip"));
        HistoricActivityInstanceEntityManager hiActInstManager = this.commandContext.getHistoricActivityInstanceEntityManager();
        boolean isSkip = WfUtils.isNotEmpty(skipToNode);
        ArrayList dynamicPant = new ArrayList();
        for (String nodeId : nextNodeId.split("\\,")) {
            List<HistoricActivityInstanceEntity> actInsts;
            params.put("nextnodeid", nodeId);
            SequenceFlow dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "sequenceFlow", params);
            outgoingSequenceFlows.add(dynSequenceFlow);
            nextNodeModel = models.get(nodeId);
            if (isSkip) {
                String key = String.format("%s_%s", nodeId, "rejectToForkInnerAndSkip");
                proinst.setVariable(key, String.format("%s-%s", nodeId, skipToNode));
            }
            if ((actInsts = hiActInstManager.findByActivityId(procInstId, nodeId)).isEmpty()) continue;
            Long assigneeId = null;
            for (HistoricActivityInstanceEntity actInst : actInsts) {
                String activityType = actInst.getActivityType();
                if ("YunzhijiaTask".equals(activityType) || "AuditTask".equals(activityType) && "skip".equals(actInst.getExecutionType())) continue;
                assigneeId = actInst.getAssigneeId();
            }
            if (!WfUtils.isNotEmpty(assigneeId)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nodeId", nodeId);
            map.put("userIds", String.valueOf(assigneeId));
            dynamicPant.add(map);
        }
        this.execution.getCurrentTask().setTransientVariableLocal("dynParticipant", SerializationUtils.toJsonString(dynamicPant));
        if (nextNodeModel != null) {
            String forkNodeId = nextNodeModel.getLatestForkNode();
            int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, proinst);
            ForkJoinUtils.setEnterForkCycle(forkNodeId, proinst, ++cycle);
            String joinFlag = String.format("%s$%s$%s", forkNodeId, cycle, nextNodeModel.getLatestJoinNode());
            ForkJoinUtils.setNoOfShouldSurvive(joinFlag, proinst, outgoingSequenceFlows.size());
            ForkJoinUtils.setForkResult(flowNode, outgoingSequenceFlows, proinst);
        }
    }

    private void setRejectKeyForkResultAndOtherBranchsIfNeed(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId, ExecutionEntity proinst) {
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
        String auditType = "";
        if (this.execution.getCurrentTask() != null) {
            auditType = (String)this.execution.getCurrentTask().getVariable("auditType");
            if (flowNode.getJoin() != null && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet())) {
                ForkJoinUtils.setJoinNodeRejectKey(process, flowNode, proinst);
            }
            if ("reject".equals(auditType)) {
                ForkJoinUtils.markOtherBranchsEnd(process, flowNode, this.execution, outgoingSequenceFlows);
            }
            ForkJoinUtils.updateForkResultVar(flowNode, proinst, process, auditType, nextNodeId);
        } else if (flowNode instanceof CallActivity && "dynReject".equals(DynamicFlowUtil.getDynamicType(this.execution))) {
            ForkJoinUtils.markOtherBranchsEnd(process, flowNode, this.execution, outgoingSequenceFlows);
            ForkJoinUtils.updateForkResultVar(flowNode, proinst, process, "reject", nextNodeId);
        }
    }

    private List<SequenceFlow> dealForkNodeLeave(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, ExecutionEntity proinst) {
        SequenceFlow curSequenceFlow;
        String targetNodeId;
        NodeForkJoinModel nextNodeModel;
        boolean enterForkInner;
        String joinRejectKey;
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        String flowNodeId = flowNode.getId();
        int enteredCycle = ForkJoinUtils.getEnterForkCycle(flowNodeId, proinst);
        int tmp = enteredCycle++;
        if (enteredCycle > 1 && "reject".equals(flowNode.getPassTypeAfterInnerReject()) && WfUtils.isNotEmpty(joinRejectKey = ForkJoinUtils.getJoinNodeRejectKey(flowNodeId, tmp, proinst))) {
            Iterator<SequenceFlow> iter = outgoingSequenceFlows.iterator();
            ArrayList<SequenceFlow> outgoingSequenceFlowsClone = new ArrayList<SequenceFlow>(outgoingSequenceFlows.size());
            FlowNode rejectNode = (FlowNode)process.getFlowElement(joinRejectKey);
            if (joinRejectKey.startsWith("JOIN_") || rejectNode == null) {
                while (iter.hasNext()) {
                    SequenceFlow s = iter.next();
                    outgoingSequenceFlowsClone.add(s);
                    String val = ForkJoinUtils.getItemForkResult(flowNodeId, s.getTargetFlowElement().getId(), tmp, proinst);
                    if ("reject".equals(val)) continue;
                    iter.remove();
                }
            } else {
                NodeForkJoinModel rejectNodeModel = models.get(joinRejectKey);
                String targetStructure = rejectNodeModel.getForkStructure();
                while (iter.hasNext()) {
                    SequenceFlow s = iter.next();
                    outgoingSequenceFlowsClone.add(s);
                    String tmpId = s.getTargetFlowElement().getId();
                    if (models.get(tmpId) != null && targetStructure.equals(models.get(tmpId).getForkStructure())) continue;
                    iter.remove();
                }
                --enteredCycle;
            }
            if (outgoingSequenceFlows.isEmpty()) {
                outgoingSequenceFlows = outgoingSequenceFlowsClone;
            }
        }
        boolean bl = enterForkInner = (nextNodeModel = models.get(targetNodeId = (curSequenceFlow = outgoingSequenceFlows.get(0)).getTargetFlowElement().getId())) != null && flowNodeId.equals(nextNodeModel.getLatestForkNode());
        if (tmp != enteredCycle) {
            ForkJoinUtils.setEnterForkCycle(flowNodeId, proinst, enteredCycle);
            if (enterForkInner) {
                String joinFlag = String.format("%s$%s$%s", flowNodeId, enteredCycle, nextNodeModel.getLatestJoinNode());
                ForkJoinUtils.setNoOfShouldSurvive(joinFlag, proinst, outgoingSequenceFlows.size());
                ForkJoinUtils.setForkResult(flowNode, outgoingSequenceFlows, proinst);
            }
            ForkJoinUtils.removeJoinNodeRejectKey(flowNodeId, tmp, proinst);
        } else if (enterForkInner) {
            ForkJoinUtils.removeJoinNodeRejectKey(flowNodeId, tmp, proinst);
        }
        return outgoingSequenceFlows;
    }

    private List<ExecutionEntity> getOutgoingExecutions(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId) {
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        ArrayList<ExecutionEntity> outgoingExecutions = new ArrayList<ExecutionEntity>(flowNode.getOutgoingFlows().size());
        this.execution.setCurrentFlowElement(outgoingSequenceFlows.get(0));
        this.execution.setActive(true);
        DynamicFlowUtil.transferDynInfo(this.execution, flowNode, nextNodeId);
        if (this.execution.getCurrentTask() != null) {
            this.execution.setCurrentTask(null);
            this.execution.setCurrentTaskId(null);
            this.commandContext.getExecutionEntityManager().update(this.execution);
        }
        this.transmitRejectInnerVar(outgoingSequenceFlows.get(0));
        outgoingExecutions.add(this.execution);
        if (outgoingSequenceFlows.size() > 1) {
            for (int i = 1; i < outgoingSequenceFlows.size(); ++i) {
                ExecutionEntity parent = this.execution.getParentId() != null ? this.execution.getParent() : this.execution;
                ExecutionEntity outgoingExecutionEntity = this.commandContext.getExecutionEntityManager().createChildExecution(parent);
                outgoingExecutionEntity.setCurrentActInstId(this.execution.getCurrentActInstId());
                SequenceFlow outgoingSequenceFlow = outgoingSequenceFlows.get(i);
                outgoingExecutionEntity.setCurrentFlowElement(outgoingSequenceFlow);
                executionEntityManager.update(outgoingExecutionEntity);
                outgoingExecutions.add(outgoingExecutionEntity);
                this.transmitRejectInnerVar(outgoingSequenceFlow);
            }
        }
        this.removeRejectInnerSkipVars(flowNode);
        return outgoingExecutions;
    }

    private void removeRejectInnerSkipVars(FlowNode flowNode) {
        String rejectToForkInnerAndSkipkey = String.format("%s_%s", flowNode.getId(), "rejectToForkInnerAndSkip");
        List vs = this.commandContext.getVariableInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.execution.getProcessInstanceId()), new QFilter("name", "=", (Object)rejectToForkInnerAndSkipkey)});
        for (VariableInstanceEntity v : vs) {
            this.commandContext.getVariableInstanceEntityManager().delete(v);
        }
    }

    private void transmitRejectInnerVar(SequenceFlow sequenceFlow) {
        FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
        FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
        if (sourceFlowElement != null) {
            String rejectToForkInnerAndSkipkey = String.format("%s_%s", sourceFlowElement.getId(), "rejectToForkInnerAndSkip");
            String rejectInnerInfo = (String)this.execution.getProcessInstance().getVariable(rejectToForkInnerAndSkipkey);
            if (WfUtils.isNotEmpty(rejectInnerInfo)) {
                String newKey = String.format("%s_%s", targetFlowElement.getId(), "rejectToForkInnerAndSkip");
                this.execution.getProcessInstance().setVariable(newKey, rejectInnerInfo);
            }
        }
    }

    private List<SequenceFlow> getLeaveOutgoingSequenceFlows(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId) {
        String defaultSequenceFlowId = flowNode.getDefaultFlow();
        List<SequenceFlow> outgoingFlows = this.getOutgoingFlows(flowNode);
        for (SequenceFlow sequenceFlow : outgoingFlows) {
            if (outgoingFlows.size() > 1 && !BizFlowUtil.isSequenceFlowInStartPath(this.execution, flowNode, sequenceFlow)) {
                logger.debug(String.format("SequenceFlow %s is not in the start path. FlowNode: %s ExecutionId: %s", sequenceFlow.getId(), flowNode.getId(), this.execution.getId()));
                continue;
            }
            if (sequenceFlow.getTargetFlowElement() instanceof JudgeTask) {
                JudgeTask judgeTask = (JudgeTask)sequenceFlow.getTargetFlowElement();
                if (!judgeTask.hasTrueCondition(this.execution)) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                if (!"leavewhenfristone".equals(flowNode.getOutSet())) continue;
                break;
            }
            String skipExpressionString = sequenceFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled((DelegateExecution)this.execution, skipExpressionString)) {
                boolean hasTrueCondition = false;
                hasTrueCondition = this.execution.getCurrentTask() != null ? ConditionUtil.hasTrueCondition(sequenceFlow, this.execution.getCurrentTask()) : ConditionUtil.hasTrueCondition(sequenceFlow, this.execution);
                if (!this.evaluateConditions || this.evaluateConditions && hasTrueCondition && (defaultSequenceFlowId == null || !defaultSequenceFlowId.equals(sequenceFlow.getId()))) {
                    outgoingSequenceFlows.add(sequenceFlow);
                }
                String expression = sequenceFlow.getConditionalRule() == null ? "" : sequenceFlow.getConditionalRule().getExpression();
                logger.debug(String.format("%s-%s-%s-%s", flowNode.getId(), expression, hasTrueCondition, sequenceFlow.getOrignalExpression()));
                continue;
            }
            if (flowNode.getOutgoingFlows().size() != 1 && !SkipExpressionUtil.shouldSkipFlowElement(this.commandContext, this.execution, skipExpressionString)) continue;
            outgoingSequenceFlows.add(sequenceFlow);
        }
        if (outgoingSequenceFlows.isEmpty() && this.evaluateConditions && defaultSequenceFlowId != null) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (!defaultSequenceFlowId.equals(sequenceFlow.getId())) continue;
                outgoingSequenceFlows.add(sequenceFlow);
                break;
            }
        }
        return this.filterOutgoingFlowsByNextNode(flowNode, outgoingSequenceFlows, nextNodeId);
    }

    private String recalculateNextNodeIdIfNeed(FlowNode flowNode, String nextNodeId) {
        block4: {
            block5: {
                Process process;
                UserTask userTask;
                block3: {
                    if (this.execution.getCurrentTask() == null || !WfUtils.isEmpty(nextNodeId)) break block3;
                    this.setDefaultRejectNodeAndParticipant(flowNode);
                    nextNodeId = DynamicFlowUtil.getCustomNextNodeId(this.execution);
                    if (!WfUtils.isNotEmpty(nextNodeId)) break block4;
                    this.execution.getCurrentTask().setVariableLocal("nextNodeId", nextNodeId);
                    break block4;
                }
                if (!(flowNode instanceof CallActivity) || !WfUtils.isEmpty(nextNodeId) || !"dynReject".equals(DynamicFlowUtil.getDynamicType(this.execution))) break block5;
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId());
                if (bpmnModel == null || (userTask = BpmnModelUtil.getFirstUserTask(process = bpmnModel.getMainProcess())) == null) break block4;
                nextNodeId = userTask.getId();
                this.execution.setVariableLocal("nextNodeId", nextNodeId);
                break block4;
            }
            if (WfUtils.isEmpty(DynamicFlowUtil.getDynamicType(this.execution)) && WfUtils.isNotEmpty(nextNodeId) && flowNode instanceof AuditTask) {
                AuditTask task = (AuditTask)flowNode;
                String auditNum = (String)this.execution.getCurrentTask().getVariableLocal("auditNumber");
                if (task.isDynamicReject() && auditNum != null) {
                    List<DecisionOption> options = task.getDecisionOptions();
                    for (DecisionOption option : options) {
                        if (!auditNum.equalsIgnoreCase(option.getNumber()) || !"reject".equals(option.getAuditType())) continue;
                        this.execution.getCurrentTask().setTransientVariableLocal("dynType", "dynReject");
                        break;
                    }
                }
            }
        }
        return nextNodeId;
    }

    private List<SequenceFlow> getOutgoingFlows(FlowNode flowNode) {
        List outgoingFlows = flowNode.getOutgoingFlows();
        if (DynamicFlowUtil.isFreeFlow(this.execution)) {
            String freeFlowNodeKey = DynamicFlowUtil.getFreeFlowNode(this.execution.getActivityId());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("freeflowsource", "freeflowsourceplugin");
            params.put("freeflowmodelstr", this.execution.getVariable(freeFlowNodeKey));
            DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "freeflowafternode", params);
            Object sequenceFlows = params.get("sequenceFlows");
            if (sequenceFlows instanceof List) {
                outgoingFlows = (List)sequenceFlows;
            }
            this.execution.removeVariable(freeFlowNodeKey);
        }
        if ("leavewhenfristone".equals(flowNode.getOutSet())) {
            return BpmnModelUtil.sortOutgoingFlowsByJudgeTaskSeq(outgoingFlows);
        }
        return outgoingFlows;
    }

    private List<SequenceFlow> filterOutgoingFlowsByNextNode(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId) {
        if (flowNode instanceof CallActivity) {
            return this.filterOutgoingFlowsForCallActivity((CallActivity)flowNode, outgoingSequenceFlows, nextNodeId);
        }
        if (!outgoingSequenceFlows.isEmpty() && WfUtils.isNotEmpty(nextNodeId)) {
            boolean isForcerReject;
            boolean canGoNextNode = !DynamicFlowUtil.isRejectFromCurNode(this.execution) || !(flowNode instanceof AuditTask) || ((AuditTask)flowNode).isDynamicReject();
            boolean bl = isForcerReject = flowNode instanceof YunzhijiaTask && "forceReject".equals(this.execution.getCurrentTask().getVariable("decisionscene"));
            if (canGoNextNode || isForcerReject) {
                SequenceFlow outSequenceFlow = null;
                for (SequenceFlow sequenceFlow : outgoingSequenceFlows) {
                    if (!sequenceFlow.getTargetRef().equals(nextNodeId)) continue;
                    outSequenceFlow = sequenceFlow;
                    break;
                }
                outgoingSequenceFlows = new ArrayList<SequenceFlow>();
                if (outSequenceFlow != null) {
                    outgoingSequenceFlows.add(outSequenceFlow);
                } else {
                    SequenceFlow dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, flowNode, "sequenceFlow", null);
                    outgoingSequenceFlows.add(dynSequenceFlow);
                }
            }
        }
        return outgoingSequenceFlows;
    }

    private List<SequenceFlow> filterOutgoingFlowsForCallActivity(CallActivity callActivity, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId) {
        if (WfUtils.isEmpty(nextNodeId)) {
            return outgoingSequenceFlows;
        }
        if (outgoingSequenceFlows.isEmpty() && !DynamicFlowUtil.isRejectFromCallActivity(this.execution)) {
            return outgoingSequenceFlows;
        }
        if (!outgoingSequenceFlows.isEmpty() && DynamicFlowUtil.isRejectFromCallActivity(this.execution) && !callActivity.isDynamicReject()) {
            return outgoingSequenceFlows;
        }
        SequenceFlow outSequenceFlow = null;
        for (SequenceFlow sequenceFlow : outgoingSequenceFlows) {
            if (!sequenceFlow.getTargetRef().equals(nextNodeId)) continue;
            outSequenceFlow = sequenceFlow;
            break;
        }
        outgoingSequenceFlows = new ArrayList<SequenceFlow>();
        if (outSequenceFlow != null) {
            outgoingSequenceFlows.add(outSequenceFlow);
        } else {
            HashMap<String, Object> params = null;
            if (DynamicFlowUtil.isRejectFromCallActivity(this.execution)) {
                params = new HashMap<String, Object>(1);
                params.put("nextnodeid", nextNodeId);
            }
            SequenceFlow dynSequenceFlow = DynProcessProcessorHelper.createDynProcess(this.execution, callActivity, "sequenceFlow", params);
            outgoingSequenceFlows.add(dynSequenceFlow);
        }
        return outgoingSequenceFlows;
    }

    private void copyAndInsertHiUserInst(HiUserActInstEntity i, ExecutionEntity outgoingExecution, CommandContext commandContext) {
        HiUserActInstEntity newUserInst = (HiUserActInstEntity)commandContext.getHiUserActInstEntityManager().create();
        newUserInst.setBusinesskey(i.getBusinesskey());
        newUserInst.setCurrentActId(i.getCurrentActId());
        newUserInst.setCurrentActinstId(i.getCurrentActinstId());
        newUserInst.setCurrentExecutionId(outgoingExecution.getId());
        newUserInst.setCurrentNodeName(i.getCurrentNodeName().getLocaleValue());
        newUserInst.setExecutionId(i.getExecutionId());
        newUserInst.setJoinFlag(i.getJoinFlag());
        newUserInst.setLastNodeActinstId(i.getLastNodeActinstId());
        newUserInst.setLastNodeCid(i.getLastNodeCid());
        newUserInst.setLastNodeName(i.getLastNodeName().getLocaleValue());
        newUserInst.setLastUserNodeActId(i.getLastUserNodeActId());
        newUserInst.setPathJson(i.getPathJson());
        newUserInst.setProinstId(i.getProinstId());
        newUserInst.setTaskId(i.getTaskId());
        commandContext.getHiUserActInstEntityManager().insert(newUserInst);
    }

    private SequenceFlow findSuitableSequence(FlowNode flowNode, String elemId) {
        SequenceFlow ret = null;
        VariableScope scope = this.execution;
        if (this.execution.getCurrentTask() != null) {
            scope = this.execution.getCurrentTask();
        }
        boolean isDynamicReject = flowNode instanceof AuditTask && ((AuditTask)flowNode).isDynamicReject();
        String markKey = "";
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            String condition;
            if (sequenceFlow.getTargetRef() == null || !sequenceFlow.getTargetRef().equals(elemId)) continue;
            boolean hasTrueCondition = false;
            String string = condition = isDynamicReject ? sequenceFlow.getOrignalExpression() : sequenceFlow.getConditionExpression();
            if (WfUtils.isNotEmpty(condition)) {
                markKey = ConditionUtil.getConInstKey(flowNode.getNumber(), sequenceFlow.getId());
                hasTrueCondition = ConditionUtil.hasTrueCondition(condition, scope, markKey);
            } else {
                hasTrueCondition = true;
            }
            if (!hasTrueCondition) continue;
            ret = sequenceFlow;
            break;
        }
        return ret;
    }

    private String getRejectPreNode(FlowNode flowNode) {
        List<SelectNodesModel> selectNodesModels = DynamicFlowUtil.getUpperLevel(this.execution.getCurrentTask());
        if (selectNodesModels != null && selectNodesModels.size() > 0) {
            SelectNodesModel selectNodesModel = selectNodesModels.get(0);
            return selectNodesModel.getItemId();
        }
        logger.debug("get reject previous Node is null ,please contact admin ");
        return null;
    }

    private boolean setDefaultRejectNodeAndParticipant(FlowNode flowNode) {
        boolean defRejectNode = false;
        if (flowNode instanceof AuditTask) {
            AuditTask task = (AuditTask)flowNode;
            String dynType = DynamicFlowUtil.getDynamicType(this.execution);
            if (task.isDynamicReject() || "dynBackToRejectNode".equals(dynType)) {
                TaskHelper taskHelper = this.commandContext.getProcessEngineConfiguration().getTaskHelper();
                String rejectNodeId = taskHelper.getRejectNodeId(this.execution.getProcessInstanceId(), this.execution.getCurrentActInstId());
                String auditNum = (String)this.execution.getCurrentTask().getVariableLocal("auditNumber");
                if (auditNum != null) {
                    List<DecisionOption> options = task.getDecisionOptions();
                    for (DecisionOption option : options) {
                        if (!"reject".equalsIgnoreCase(option.getAuditType())) continue;
                        if (auditNum.equalsIgnoreCase(option.getNumber()) && (option.getRejectOptions() != null && option.getRejectOptions().size() > 0 || "rejectToPreAuditNode".equals(option.getDecisionScene()))) {
                            String nextNode = null;
                            if ("rejectToPreAuditNode".equals(option.getDecisionScene())) {
                                nextNode = this.getRejectPreNode(flowNode);
                            } else if (option.getRejectOptions() != null && option.getRejectOptions().size() > 0) {
                                nextNode = option.getRejectOptions().get(0).getItemId();
                            }
                            if (nextNode == null) continue;
                            defRejectNode = true;
                            this.execution.getCurrentTask().setTransientVariableLocal("dynType", "dynReject");
                            this.execution.getCurrentTask().setTransientVariableLocal("nextNodeId", nextNode);
                            this.execution.getCurrentTask().setTransientVariableLocal("dynName", ResManager.loadKDString((String)"\u9a73\u56de", (String)"TakeOutgoingSequenceFlowsOperation_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                            String terminal = (String)this.execution.getCurrentTask().getVariable("terminal");
                            if ("api".equals(terminal)) continue;
                            List<HistoricActivityInstanceEntity> nodes = ParticipantHelper.getHisActForParticipantFromHiActivity(this.commandContext, this.execution.getProcessInstanceId(), nextNode);
                            HistoricActivityInstanceEntity hiActivity = ParticipantHelper.getUserIdsAndTaskIdsForParticipantFromHiActivity(nodes);
                            Long userId = null;
                            if (hiActivity != null) {
                                userId = hiActivity.getAssigneeId();
                            }
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("nodeId", nextNode);
                            map.put("userIds", userId == null ? "" : String.valueOf(userId));
                            ArrayList<HashMap<String, String>> ret = new ArrayList<HashMap<String, String>>();
                            ret.add(map);
                            this.execution.getCurrentTask().setTransientVariableLocal("dynParticipant", SerializationUtils.toJsonString(ret));
                            break;
                        }
                        if ("dynBackToRejectNode".equals(dynType)) {
                            defRejectNode = true;
                            this.execution.getCurrentTask().setTransientVariableLocal("nextNodeId", rejectNodeId);
                            continue;
                        }
                        if (!"dynReject".equals(dynType) || !taskHelper.isRejectBackToNode(this.commandContext, this.execution.getCurrentTask())) continue;
                        defRejectNode = true;
                        ParticipantCalculator participantCalculator = this.commandContext.getProcessEngineConfiguration().getParticipantCalculator();
                        if (!participantCalculator.isYunzhjiaTaskAgree(this.execution)) continue;
                        this.execution.getCurrentTask().setTransientVariableLocal("nextNodeId", rejectNodeId);
                    }
                }
            }
        }
        if (!defRejectNode) {
            this.execution.getCurrentTask().setTransientVariableLocal("nextNodeId", null);
        }
        return defRejectNode;
    }

    protected void handleAdhocSubProcess(FlowNode flowNode) {
        boolean completeAdhocSubProcess = false;
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)flowNode.getParentContainer();
        if (adhocSubProcess.getCompletionCondition() != null && ConditionUtil.hasTrueCondition(adhocSubProcess.getCompletionCondition(), (VariableScope)this.execution, ConditionUtil.getConInstKey(flowNode.getNumber(), "completion"))) {
            completeAdhocSubProcess = true;
        }
        if (!flowNode.getOutgoingFlows().isEmpty()) {
            this.leaveFlowNode(flowNode);
        } else {
            this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(this.execution, null, false);
        }
        if (completeAdhocSubProcess) {
            boolean endAdhocSubProcess = true;
            if (!adhocSubProcess.isCancelRemainingInstances()) {
                List<ExecutionEntity> childExecutions = this.commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.execution.getParentId());
                for (ExecutionEntity executionEntity : childExecutions) {
                    if (executionEntity.getId().equals(this.execution.getId())) continue;
                    endAdhocSubProcess = false;
                    break;
                }
            }
            if (endAdhocSubProcess) {
                Context.getAgenda().planEndExecutionOperation(this.execution.getParent());
            }
        }
    }

    protected void handleSequenceFlow(SequenceFlow sequenceFlow) {
        logger.debug(String.format("takeoutgoingfromSequenceFlow[%s]", sequenceFlow.getId()));
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
        Context.getAgenda().planContinueProcessOperation(this.execution);
    }

    protected void cleanupCompensation(Long triggerCompensationExecuteExe) {
        this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
        ExecutionEntityManager executionMgr = this.commandContext.getExecutionEntityManager();
        executionMgr.deleteExecutionAndRelatedData(this.execution, null, false);
        this.execution.getParent().setActive(false);
        executionMgr.update(this.execution.getParent());
        ExecutionEntity errorExecuteExecution = (ExecutionEntity)executionMgr.findById(triggerCompensationExecuteExe);
        if (errorExecuteExecution != null && this.execution.getParentId().equals(errorExecuteExecution.getParentId())) {
            List<ExecutionEntity> childExecutions = this.commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(errorExecuteExecution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(childExecution, null, false);
            }
            errorExecuteExecution.setActive(false);
            executionMgr.update(errorExecuteExecution);
        }
    }

    protected void cleanupExecutions(FlowElement currentFlowElement) {
        Activity activity;
        if (this.execution.getParentId() != null && this.execution.isScope()) {
            Context.getAgenda().planDestroyScopeOperation(this.execution);
        } else if (currentFlowElement instanceof Activity && CollectionUtil.isNotEmpty((activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtil.isNotEmpty(event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            List<ExecutionEntity> childExecutions = this.commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(childExecution, null, false);
            }
        }
    }

    protected ExecutionEntity findNextParentScopeExecutionWithAllEndedChildExecutions(ExecutionEntity executionEntity, ExecutionEntity executionEntityToIgnore) {
        if (executionEntity.getParentId() != null) {
            ExecutionEntity scopeExecutionEntity = executionEntity.getParent();
            while (!scopeExecutionEntity.isScope() || !scopeExecutionEntity.isProcessInstanceType()) {
                scopeExecutionEntity = scopeExecutionEntity.getParent();
            }
            if (this.allChildExecutionsEnded(scopeExecutionEntity, executionEntityToIgnore)) {
                return scopeExecutionEntity;
            }
        }
        return null;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }
}

