/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.agenda;

import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.AbstractOperation;
import kd.bos.workflow.engine.impl.delegate.ActivityBehavior;
import kd.bos.workflow.engine.impl.delegate.TriggerableActivityBehavior;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFEngineException;

public class TriggerExecutionOperation
extends AbstractOperation {
    public TriggerExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        block16: {
            FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
            try (TraceSpan tracer = Tracer.create((String)"WF_PROCESSFLOW", (String)WfTracerHelper.wrapTagValue("TriggerExecutionOperation", currentFlowElement.getId()));){
                if (currentFlowElement instanceof FlowNode) {
                    ActivityBehavior activityBehavior = (ActivityBehavior)((FlowNode)currentFlowElement).getBehavior();
                    if (activityBehavior instanceof TriggerableActivityBehavior) {
                        if (currentFlowElement instanceof BoundaryEvent) {
                            this.commandContext.getHistoryManager().recordActivityStart(this.execution);
                        }
                        ((TriggerableActivityBehavior)activityBehavior).trigger(this.execution, null, null);
                        if (currentFlowElement instanceof BoundaryEvent) {
                            this.commandContext.getHistoryManager().recordActivityEnd(this.execution, null);
                        }
                        break block16;
                    }
                    throw new WFEngineException("Invalid behavior: " + activityBehavior + " should implement " + TriggerableActivityBehavior.class.getName());
                }
                throw new WFEngineException("Programmatic error: no current flow element found or invalid type: " + currentFlowElement + ". Halting.");
            }
        }
    }
}

