/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor;

import java.util.LinkedList;
import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class DefaultAsyncJobExecutor
implements AsyncExecutor {
    protected static Log log = LogFactory.getLog(DefaultAsyncJobExecutor.class);
    protected int corePoolSize = 3;
    protected int maxPoolSize = 10;
    protected long keepAliveTime = 5000L;
    protected int queueSize = 100;
    protected ThreadPool executorService;
    protected long secondsToWaitOnShutdown = 60L;
    protected boolean autoActivate;
    protected boolean active;
    protected boolean messageQueueMode;
    protected int maxTimerJobsPerAcquisition = 1;
    protected int maxAsyncJobsDuePerAcquisition = 1;
    protected int defaultTimerJobAcquireWaitTimeInMinutes = 3;
    protected int defaultAsyncJobAcquireWaitTimeInMinutes = 8;
    protected int defaultQueueSizeFullWaitTime = 0;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int timerLockTimeInMinutes = 5;
    protected int asyncJobLockTimeInMinutes = 2;
    protected int retryWaitTimeInMillis = 500;
    protected int resetExpiredJobsInterval = 300000;
    protected int resetExpiredJobsPageSize = 3;
    protected LinkedList<JobEntity> temporaryJobQueue = new LinkedList();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Override
    public boolean executeAsyncJob(JobEntity job) {
        if (this.messageQueueMode) {
            return true;
        }
        return true;
    }

    @Override
    public void start() {
        if (this.active) {
            return;
        }
        if (!this.messageQueueMode) {
            this.initAsyncJobExecutionThreadPool();
        }
        this.active = true;
        this.executeTemporaryJobs();
    }

    protected void executeTemporaryJobs() {
        while (!this.temporaryJobQueue.isEmpty()) {
            JobEntity job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.active) {
            return;
        }
        log.debug("Shutting down the default async job executor [{" + this.getClass().getName() + "}].");
        this.stopExecutingAsyncJobs();
        this.active = false;
    }

    protected void initAsyncJobExecutionThreadPool() {
        if (!this.messageQueueMode && this.executorService == null) {
            log.debug("Creating executor service with corePoolSize {" + this.corePoolSize + "}, maxPoolSize {" + this.maxPoolSize + "} and keepAliveTime {" + this.keepAliveTime + "}");
            this.executorService = ThreadPools.newCachedThreadPool((String)"wf-async-job-executor-thread-pools", (int)this.corePoolSize, (int)this.maxPoolSize);
        }
    }

    protected void stopExecutingAsyncJobs() {
        if (this.executorService != null) {
            this.executorService = null;
        }
    }

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public boolean isAutoActivate() {
        return this.autoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.autoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean isActive) {
        this.active = isActive;
    }

    public boolean isMessageQueueMode() {
        return this.messageQueueMode;
    }

    public void setMessageQueueMode(boolean isMessageQueueMode) {
        this.messageQueueMode = isMessageQueueMode;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public ThreadPool getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ThreadPool executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public int getTimerLockTimeInMinutes() {
        return this.timerLockTimeInMinutes;
    }

    @Override
    public void setTimerLockTimeInMinutes(int timerLockTimeInMinutes) {
        this.timerLockTimeInMinutes = timerLockTimeInMinutes;
    }

    @Override
    public int getAsyncJobLockTimeInMinutes() {
        return this.asyncJobLockTimeInMinutes;
    }

    @Override
    public void setAsyncJobLockTimeInMinutes(int asyncJobLockTimeInMillis) {
        this.asyncJobLockTimeInMinutes = asyncJobLockTimeInMillis;
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.maxTimerJobsPerAcquisition;
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.maxTimerJobsPerAcquisition = maxTimerJobsPerAcquisition;
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.maxAsyncJobsDuePerAcquisition = maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMinutes() {
        return this.defaultTimerJobAcquireWaitTimeInMinutes;
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMinutes(int defaultTimerJobAcquireWaitTimeInMinutes) {
        this.defaultTimerJobAcquireWaitTimeInMinutes = defaultTimerJobAcquireWaitTimeInMinutes;
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.defaultAsyncJobAcquireWaitTimeInMinutes;
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMinutes(int defaultAsyncJobAcquireWaitTimeInMinutes) {
        this.defaultAsyncJobAcquireWaitTimeInMinutes = defaultAsyncJobAcquireWaitTimeInMinutes;
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.defaultQueueSizeFullWaitTime;
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        this.defaultQueueSizeFullWaitTime = defaultQueueSizeFullWaitTime;
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.retryWaitTimeInMillis;
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        this.retryWaitTimeInMillis = retryWaitTimeInMillis;
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return this.resetExpiredJobsInterval;
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        this.resetExpiredJobsInterval = resetExpiredJobsInterval;
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.resetExpiredJobsPageSize;
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        this.resetExpiredJobsPageSize = resetExpiredJobsPageSize;
    }
}

