/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.servicehanler.EvtJobHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillSubjectModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.BroadcastTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.ExpireOperation;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.bpmn.model.TimingModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.delegate.event.ActivitiEventDispatcher;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.asyncexecutor.RepeatJobModel;
import kd.bos.workflow.engine.impl.bpmn.behavior.CallActivityUtil;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculator;
import kd.bos.workflow.engine.impl.calendar.BusinessCalendar;
import kd.bos.workflow.engine.impl.calendar.CycleBusinessCalendar;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.NoExecutionVariableScope;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.IJobScheduleCallback;
import kd.bos.workflow.engine.impl.jobexecutor.JobHandler;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.jobexecutor.ScheduleJobAddedNotification;
import kd.bos.workflow.engine.impl.jobexecutor.TimerEventHandler;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractWfJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.job.SuspendedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TimerUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.exception.BizErrorInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.WfTraceType;
import org.apache.commons.lang.StringUtils;

public class DefaultJobManager
implements JobManager {
    private static final String TASKID = "taskId";
    public static final String BUSINESSKEY = "businessKey";
    public static final String BILLNO = "billNo";
    public static final String OPERATION = "operation";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String VARIABLES = "variables";
    public static final String CIRCULATIONMSG = "circulationMsg";
    public static final String USERIDS = "userIds";
    public static final String SUPEREXECUTIONID = "superExecutionId";
    protected static Log logger = LogFactory.getLog(DefaultJobManager.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultJobManager() {
    }

    public DefaultJobManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public JobEntity createAsyncContinuationJob(ExecutionEntity execution, boolean exclusive) {
        boolean isJoin;
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, exclusive, "async-continuation");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.fillPayload(jobEntity, payload);
        RepeatJobModel rjModel = null;
        String actId = execution.getCurrentActivityId();
        Process process = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId()).getMainProcess();
        FlowNode flowNode = (FlowNode)process.getFlowElement(actId);
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel model = models.get(actId);
        boolean bl = isJoin = flowNode != null && flowNode.getJoin() != null && model != null;
        if (isJoin && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet())) {
            String forkNodeId = model.getPairForkNodeId();
            int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, execution.getProcessInstance());
            String joinFlag = forkNodeId + "$" + cycle + "$" + flowNode.getId();
            payload.put("joinFlag", joinFlag);
            rjModel = new RepeatJobModel(joinFlag.hashCode() + "_" + jobEntity.getProcessInstanceId(), RepeatJobModel.JobLockedStrategy.NOTHING, "Continuation_JOIN");
        }
        if (ModelType.BizFlow.name().equalsIgnoreCase(process.getProcessType())) {
            RepeatJobModel t;
            String lockKey;
            if (flowNode instanceof EndEvent) {
                lockKey = String.format("EndBizProcess-%s-%s", execution.getProcessInstanceId(), flowNode.getId());
                rjModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.SERIAL, "EndBizProcess");
            } else {
                lockKey = String.format("Parallel-%s-%s", execution.getProcessInstanceId(), execution.getBusinessKey());
                rjModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "ParallelFlow");
            }
            if (flowNode instanceof EventSupportTask && (t = this.addJobEventLock(flowNode, execution, jobEntity, payload)) != null) {
                rjModel = t;
            }
        } else if (ModelType.AuditFlow.name().equalsIgnoreCase(process.getProcessType()) || ModelType.NoCodeFlow.name().equalsIgnoreCase(process.getProcessType())) {
            String nodes;
            RepeatJobModel rfModel = this.lockFork(jobEntity, actId, process, model, payload);
            if (rfModel == null && CallActivityUtil.isSerialExecuteEndEventWhenAbortByParentProcess(flowNode, execution)) {
                Long superProcessInstanceId = 0L;
                if (execution.getVariable("superProcInstId") instanceof Long) {
                    superProcessInstanceId = (Long)execution.getVariable("superProcInstId");
                } else if (execution.getSuperExecution() != null) {
                    superProcessInstanceId = execution.getSuperExecution().getProcessInstanceId();
                }
                if (WfUtils.isNotEmpty(superProcessInstanceId)) {
                    String lockKey = String.format("AbortByParentProcessAbort-%s", superProcessInstanceId);
                    rfModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "AbortByParentProcessAbort");
                }
            }
            if (rfModel == null && flowNode instanceof EndEvent) {
                String lockKey = String.format("EndAuditFlowProcess-%s-%s", execution.getProcessInstanceId(), actId);
                rfModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.DISCARD, "ParallelFlow");
            }
            if (rfModel != null) {
                rjModel = rfModel;
            }
            if (ModelType.AuditFlow.name().equalsIgnoreCase(process.getProcessType()) && flowNode instanceof AutoTask && WfConfigurationUtil.getConfigCenterVal("wf.engine.enableSerialExecute") != null && WfUtils.isNotEmpty(nodes = (String)execution.getVariable("serialExecuteNode")) && Arrays.asList(nodes.split(",")).contains(flowNode.getNumber())) {
                String serialExecuteCount;
                String serialExecuteKey = (String)execution.getVariable("serialexecutekey");
                String string = serialExecuteCount = execution.getVariable("serialexecutecount") == null ? "0" : String.valueOf(execution.getVariable("serialexecutecount"));
                if (WfUtils.isNotEmpty(serialExecuteKey) && WfUtils.isNotEmpty(serialExecuteCount)) {
                    int count = 0;
                    int target = 0;
                    try {
                        count = Integer.parseInt(serialExecuteCount);
                        target = Integer.parseInt((String)WfConfigurationUtil.getConfigCenterVal("wf.engine.serialExecuteThreshold"));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    if (target > 0 && count > target) {
                        String lockKey = String.format("AutoTask-%s", serialExecuteKey);
                        rjModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.SERIAL, "AutoTaskSerialExecute");
                    }
                }
            }
        }
        if (rjModel != null) {
            payload.put("_lockKey_", rjModel);
            jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        }
        return jobEntity;
    }

    private RepeatJobModel addJobEventLock(FlowNode flowNode, ExecutionEntity execution, JobEntity jobEntity, Map<String, Object> payload) {
        WaitTask waitTask;
        TimingModel timingModel;
        String event = "";
        RepeatJobModel t = null;
        if (flowNode instanceof BroadcastTask) {
            BroadcastTask broadcast = (BroadcastTask)flowNode;
            event = broadcast.getEvent();
        } else if (flowNode instanceof WaitTask && (timingModel = (waitTask = (WaitTask)flowNode).getTimingModel()) != null && "event".equals(timingModel.getType())) {
            event = timingModel.getEvent();
        }
        if (WfUtils.isNotEmpty(event)) {
            String lockKey = String.format("BroadcastWaitEvent-%s-%s", execution.getBizTraceNo(), event);
            t = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "BroadcastWaitEvent");
        }
        return t;
    }

    private RepeatJobModel lockFork(JobEntity jobEntity, String actId, Process process, NodeForkJoinModel model, Map<String, Object> payload) {
        FlowNode forkNode;
        RepeatJobModel rjModel = null;
        if (model != null && model.getLatestForkNode() != null && (forkNode = (FlowNode)process.getFlowElement(model.getLatestForkNode())) != null) {
            List<SequenceFlow> fs = forkNode.getOutgoingFlows();
            for (SequenceFlow s : fs) {
                if (s.isDynamic() || s.getTargetFlowElement() == null || !actId.equals(s.getTargetFlowElement().getId())) continue;
                if (payload == null) {
                    payload = new HashMap<String, Object>();
                }
                rjModel = new RepeatJobModel(forkNode.getId() + "_" + jobEntity.getProcessInstanceId(), RepeatJobModel.JobLockedStrategy.NOTHING, "Continuation_ForkNextNode");
                payload.put("_lockKey_", rjModel);
                jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
                break;
            }
        }
        return rjModel;
    }

    @Override
    public JobEntity createAsyncExecuteBehaviorJob(ExecutionEntity execution, boolean exclusive) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, exclusive, "execute-behavior");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createAsyncTerminateProcessJob(JobEntity job, String exceptionMessage) {
        return this.createAsyncTerminateProcessJob(job, null, exceptionMessage);
    }

    @Override
    public JobEntity createAsyncTerminateProcessJob(JobEntity job, String errorCode, String exceptionMessage) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "async-terminateProcess");
        jobEntity.setProcessDefinitionId(job.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(job.getProcessInstanceId());
        jobEntity.setExecutionId(job.getExecutionId());
        jobEntity.setElementId(job.getElementId());
        jobEntity.setBusinessKey(job.getBusinessKey());
        jobEntity.setEntityNumber(job.getEntityNumber());
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("elementId", job.getElementId());
        payload.put("exceptionMessage", exceptionMessage);
        payload.put("errorCode", errorCode);
        payload.put("_lockKey_", new RepeatJobModel(String.format("terminate-procInst-%s", jobEntity.getProcessInstanceId()), RepeatJobModel.JobLockedStrategy.DISCARD, "AsyncTerminateProcess"));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createAsyncExecutionConversionJob(ExecutionEntity execution, SequenceFlow incomingFlow) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, false, "async-executionConversion");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (incomingFlow.isEnableAggregation()) {
            String lockKey = String.format("DataConvergence-%s-%s", execution.getProcessInstanceId(), incomingFlow.getId());
            RepeatJobModel rjModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "DataConvergence");
            payload.put("_lockKey_", rjModel);
        } else {
            String lockKey = String.format("Parallel-%s-%s", execution.getProcessInstanceId(), execution.getBusinessKey());
            RepeatJobModel rjModel = new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "ParallelFlow");
            payload.put("_lockKey_", rjModel);
        }
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries() * 2);
        payload.put("incomingflow", incomingFlow.getId());
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createMultiInstanceAsyncContinuationJob(ExecutionEntity execution, boolean exclusive) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, exclusive, "multi-async-continuation");
        String actId = execution.getCurrentActivityId();
        Process process = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId()).getMainProcess();
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        NodeForkJoinModel model = models.get(actId);
        HashMap<String, Object> payload = new HashMap<String, Object>(8);
        if (model != null && model.getLatestForkNode() != null) {
            this.fillPayload(jobEntity, payload);
            RepeatJobModel rpModel = this.lockFork(jobEntity, actId, process, model, payload);
            if (rpModel == null && WfUtils.isNotEmpty(execution.getParentId())) {
                RepeatJobModel rjModel = new RepeatJobModel(String.valueOf(execution.getParentId()), RepeatJobModel.JobLockedStrategy.NOTHING, "MultiInstanceAsyncContinuation");
                payload.put("_lockKey_", rjModel);
                jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
            }
        } else {
            if (WfUtils.isNotEmpty(execution.getParentId())) {
                RepeatJobModel rjModel = null;
                Object nrOfInstances = execution.getParent().getVariable("nrOfInstances");
                int maxSize = WfConfigurationUtil.getMaxSizeOfMultiInstances();
                rjModel = null != nrOfInstances && Integer.parseInt(nrOfInstances.toString()) > maxSize ? new RepeatJobModel(String.valueOf(execution.getParentId()), RepeatJobModel.JobLockedStrategy.SERIAL, "MultiInstanceAsyncContinuation") : new RepeatJobModel(String.valueOf(execution.getParentId()), RepeatJobModel.JobLockedStrategy.NOTHING, "MultiInstanceAsyncContinuation");
                payload.put("_lockKey_", rjModel);
            }
            this.fillPayload(jobEntity, payload);
        }
        return jobEntity;
    }

    @Override
    public JobEntity createAsyncTriggerJob(ExecutionEntity execution, boolean exclusive) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, exclusive, "async-trigger");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (execution.getCurrentTask() != null) {
            TaskEntity task = execution.getCurrentTask();
            if (BpmnModelUtil.instanceofYunzhijiaTask(task.getCategory())) {
                RepeatJobModel rjModel = null;
                WfTraceType.WfTraceJobInfo traceJobInfo = WfTraceType.getOrCreate().getJobInfo();
                if (traceJobInfo != null && WfUtils.isNotEmpty(traceJobInfo.getLockKey()) && "multi-async-continuation".equalsIgnoreCase(traceJobInfo.getJobType())) {
                    rjModel = new RepeatJobModel(traceJobInfo.getLockKey(), RepeatJobModel.JobLockedStrategy.NOTHING, "Yunzhijia_AsyncTrigger");
                }
                if (rjModel == null && WfUtils.isNotEmpty(execution.getParentId())) {
                    rjModel = new RepeatJobModel(String.valueOf(execution.getParentId()), RepeatJobModel.JobLockedStrategy.NOTHING, "Yunzhijia_AsyncTrigger");
                }
                if (rjModel != null) {
                    payload.put("_lockKey_", rjModel);
                }
            } else {
                String actId = task.getTaskDefinitionKey();
                Process process = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId()).getMainProcess();
                FlowElement currentFlowNode = process.getFlowElement(actId);
                Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
                NodeForkJoinModel model = models.get(actId);
                if (model != null && WfUtils.isNotEmpty(model.getLatestJoinNode())) {
                    RepeatJobModel rjModel = new RepeatJobModel(model.getLatestJoinNode() + "_" + jobEntity.getProcessInstanceId(), RepeatJobModel.JobLockedStrategy.NOTHING, "Concurrent_AsyncTrigger");
                    payload.put("_lockKey_", rjModel);
                } else if (currentFlowNode instanceof Activity && ((Activity)currentFlowNode).isForCompensation()) {
                    RepeatJobModel rjModel = new RepeatJobModel(String.format("%s-%s", execution.getProcessInstanceId(), actId), RepeatJobModel.JobLockedStrategy.NOTHING, "Concurrent_AsyncTrigger");
                    payload.put("_lockKey_", rjModel);
                } else {
                    RepeatJobModel rjModel = new RepeatJobModel(String.valueOf(execution.getCurrentActInstId()), RepeatJobModel.JobLockedStrategy.DISCARD, "AsyncTrigger");
                    payload.put("_lockKey_", rjModel);
                }
            }
        } else if (WfUtils.isNotEmpty(execution.getCurrentActInstId())) {
            RepeatJobModel rjModel = new RepeatJobModel(String.valueOf(execution.getCurrentActInstId()), RepeatJobModel.JobLockedStrategy.DISCARD, "AsyncTrigger");
            payload.put("_lockKey_", rjModel);
        }
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public void scheduleAsyncJob(JobEntity jobEntity) {
        this.getJobEntityManager().insert(jobEntity);
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue("saveToLocalJob", String.valueOf(jobEntity.getId())));){
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_CREATE, jobEntity.getJobHandlerType(), jobEntity.getJobHandlerConfiguration(), jobEntity));
            }
            if (WfTraceType.get() != null) {
                WfTraceType.get().setChildJob(jobEntity.getId());
            }
            this.triggerExecutorIfNeeded(jobEntity);
        }
    }

    @Override
    public void scheduleAsyncJob(JobEntity jobEntity, IJobScheduleCallback callBack) {
        this.getJobEntityManager().insert(jobEntity);
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue("saveToLocalJob", String.valueOf(jobEntity.getId())));){
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_CREATE, jobEntity.getJobHandlerType(), jobEntity.getJobHandlerConfiguration(), jobEntity));
            }
            ScheduleJobAddedNotification jobAddedNotification = new ScheduleJobAddedNotification(jobEntity, callBack);
            this.getCommandContext().addCloseListener(jobAddedNotification);
        }
    }

    @Override
    public void batchScheduleAsyncJob(List<JobEntity> jobs) {
        this.hintAsyncExecutor(jobs);
    }

    protected void triggerExecutorIfNeeded(JobEntity jobEntity) {
        this.hintAsyncExecutor(jobEntity);
    }

    @Override
    public TimerJobEntity createTimerJob(TimerEventDefinition timerEventDefinition, boolean interrupting, ExecutionEntity execution, String timerEventType, String jobHandlerConfiguration) {
        TimerJobEntity timerJobEntity = this.internalCreateAsyncTimerJob(execution, true, timerEventType);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (jobHandlerConfiguration != null) {
            JSONObject config = JSON.parseObject((String)jobHandlerConfiguration);
            payload.putAll((Map<String, Object>)config);
        }
        this.addExtraVariable(payload);
        payload.put("_requestContext_", WfUtils.dumpRequestContext(RequestContext.get()));
        timerJobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        TimerUtil.initTimerEntityForTimerEventDefinition(timerJobEntity, timerEventDefinition, interrupting, execution);
        return timerJobEntity;
    }

    @Override
    public void scheduleTimerJob(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new WFEngineException("Empty timer job can not be scheduled");
        }
        this.getTimerJobEntityManager().insert(timerJob);
        CommandContext commandContext = Context.getCommandContext();
        ActivitiEventDispatcher eventDispatcher = commandContext.getEventDispatcher();
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_SCHEDULED, timerJob));
        }
    }

    @Override
    public JobEntity moveTimerJobToExecutableJob(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new WFEngineException("Empty timer job can not be scheduled");
        }
        boolean exist = this.getTimerJobEntityManager().exist(timerJob.getId());
        if (!exist) {
            return null;
        }
        DLockInfo info = DLock.getLockInfo((String)String.format(this.getLockKey(), timerJob.getId()));
        if (info != null) {
            logger.debug(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88abtimer\u626b\u63cf\u5230\u4e86\uff0c\u8d70\u5230\u8fd9\u91cc\u5f88\u5947\u602a\uff01", timerJob.getId()));
            return null;
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(timerJob);
        boolean insertSuccesful = this.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccesful) {
            this.getTimerJobEntityManager().delete(timerJob);
            logger.debug(String.format("new executable job[%s],original timerjob[%s]", executableJob.getId(), timerJob.getId()));
            return executableJob;
        }
        return null;
    }

    protected JobEntityManager getJobEntityManager() {
        if (this.processEngineConfiguration == null) {
            return Context.getProcessEngineConfiguration().getJobEntityManager();
        }
        return this.processEngineConfiguration.getJobEntityManager();
    }

    protected TimerJobEntityManager getTimerJobEntityManager() {
        if (this.processEngineConfiguration == null) {
            return Context.getProcessEngineConfiguration().getTimerJobEntityManager();
        }
        return this.processEngineConfiguration.getTimerJobEntityManager();
    }

    protected String getLockKey() {
        return "wf/jobexecute/%s";
    }

    protected DeadLetterJobEntityManager getDeadLetterJobEntityManager() {
        if (this.processEngineConfiguration == null) {
            return Context.getProcessEngineConfiguration().getDeadLetterJobEntityManager();
        }
        return this.processEngineConfiguration.getDeadLetterJobEntityManager();
    }

    @Override
    public TimerJobEntity moveJobToTimerJob(AbstractJobEntity job) {
        TimerJobEntity timerJob = this.createTimerJobFromOtherJob(job);
        Long id = job instanceof JobEntity ? ((JobEntity)job).getRootJobId() : job.getId();
        boolean exist = this.getTimerJobEntityManager().exist(id);
        if (exist) {
            return null;
        }
        timerJob.setRootTraceNo(job.getRootTraceNo());
        boolean insertSuccesful = this.getTimerJobEntityManager().insertTimerJobEntity(timerJob);
        if (insertSuccesful) {
            if (job instanceof SuspendedJobEntity) {
                this.processEngineConfiguration.getSuspendedJobEntityManager().delete((SuspendedJobEntity)job);
            }
            return timerJob;
        }
        return null;
    }

    @Override
    public SuspendedJobEntity moveJobToSuspendedJob(AbstractJobEntity job) {
        Long id = job instanceof JobEntity ? ((JobEntity)job).getRootJobId() : job.getId();
        boolean exist = this.processEngineConfiguration.getSuspendedJobEntityManager().exist(id);
        if (exist) {
            return null;
        }
        SuspendedJobEntity suspendedJob = this.createSuspendedJobFromOtherJob(job);
        this.processEngineConfiguration.getSuspendedJobEntityManager().insert(suspendedJob);
        if (job instanceof TimerJobEntity) {
            this.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.getJobEntityManager().delete((JobEntity)job);
        }
        return suspendedJob;
    }

    @Override
    public AbstractJobEntity activateSuspendedJob(SuspendedJobEntity job) {
        boolean isAbandon;
        AbstractWfJobEntity activatedJob = null;
        ExecutionEntity procinst = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(job.getProcessInstanceId());
        boolean bl = isAbandon = procinst.getVariable("processAbandon") != null;
        if (isAbandon) {
            if (!"timer".equals(job.getJobType())) {
                AbstractWfJobEntity jobEntity = activatedJob = this.createExecutableJobFromOtherJob(job);
                jobEntity.setState(JobStateEnum.COMPLETED.getNumber());
                this.getJobEntityManager().insert(jobEntity);
            }
        } else if ("timer".equals(job.getJobType())) {
            activatedJob = this.createTimerJobFromOtherJob(job);
            this.getTimerJobEntityManager().insert((TimerJobEntity)activatedJob);
        } else {
            AbstractWfJobEntity jobEntity = activatedJob = this.createExecutableJobFromOtherJob(job);
            this.getJobEntityManager().insert(jobEntity);
            this.triggerExecutorIfNeeded((JobEntity)jobEntity);
        }
        this.processEngineConfiguration.getSuspendedJobEntityManager().delete(job);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_MOVESUSPENDJOBTOJOB, job.getJobHandlerType(), job.getJobHandlerConfiguration(), job));
        }
        return activatedJob;
    }

    @Override
    public DeadLetterJobEntity moveJobToDeadLetterJob(AbstractJobEntity job, Throwable exception) {
        DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(job, exception);
        Long id = job instanceof JobEntity ? ((JobEntity)job).getRootJobId() : job.getId();
        ILocalJobHandleStrategy strategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(job.getJobType());
        strategy.setProcessEngineConfiguration(this.processEngineConfiguration);
        boolean exist = strategy.exsitDeadLetterJob(id);
        if (exist) {
            return null;
        }
        deadLetterJob.setRootTraceNo(job.getRootTraceNo());
        this.setDeadLetterJobProcessType(deadLetterJob);
        this.getDeadLetterJobEntityManager().insert(deadLetterJob);
        if (job instanceof TimerJobEntity) {
            this.getTimerJobEntityManager().delete((TimerJobEntity)job);
        }
        return deadLetterJob;
    }

    private void setDeadLetterJobProcessType(DeadLetterJobEntity deadLetterJob) {
        Map payload;
        HistoricProcessInstanceEntity hiProcInstEntity;
        ProcessDefinitionEntity procDefEntity;
        Long procDefId = deadLetterJob.getProcessDefinitionId();
        if (WfUtils.isNotEmpty(procDefId) && (procDefEntity = (ProcessDefinitionEntity)this.processEngineConfiguration.getRepositoryService().findEntityById(procDefId, "wf_processdefinition", "type")) != null) {
            deadLetterJob.setProcessType(procDefEntity.getType());
        }
        Long procInstId = deadLetterJob.getProcessInstanceId();
        if (WfUtils.isEmpty(deadLetterJob.getProcessType()) && WfUtils.isNotEmpty(procInstId) && (hiProcInstEntity = (HistoricProcessInstanceEntity)this.processEngineConfiguration.getRepositoryService().findEntityById(procInstId, EntityNumberConstant.getHiProcInstEntityNumber(), "processtype")) != null) {
            deadLetterJob.setProcessType(hiProcInstEntity.getProcessType());
        }
        String configuration = deadLetterJob.getJobHandlerConfiguration();
        if (WfUtils.isEmpty(deadLetterJob.getProcessType()) && WfUtils.isNotEmpty(configuration) && WfUtils.isNotEmptyForMap(payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class)) && "nocode".equals(payload.get("separateStorageKey"))) {
            deadLetterJob.setProcessType(ProcessType.NoCodeFlow.name());
        }
        if (WfUtils.isEmpty(deadLetterJob.getProcessType())) {
            deadLetterJob.setProcessType(ProcessType.AuditFlow.name());
        }
    }

    protected String getExecuteJobLockKey() {
        return "wf/movtojob/%s";
    }

    @Override
    public JobEntity moveDeadLetterJobToExecutableJob(DeadLetterJobEntity deadLetterJobEntity, int retries) {
        if (deadLetterJobEntity == null) {
            throw new WFIllegalArgumentException("Null job provided");
        }
        try (DLock lock = DLock.create((String)String.format(this.getExecuteJobLockKey(), deadLetterJobEntity.getId()), (String)("moveDeadLetterJobToExecutableJob[" + deadLetterJobEntity.getId() + "]")).fastMode();){
            boolean canLock = lock.tryLock(60000L);
            if (canLock) {
                DeadLetterJobEntity tmp = (DeadLetterJobEntity)this.getDeadLetterJobEntityManager().findById(deadLetterJobEntity.getId());
                if (tmp == null) {
                    JobEntity jobEntity = null;
                    return jobEntity;
                }
                DLockInfo info = DLock.getLockInfo((String)String.format(this.getLockKey(), deadLetterJobEntity.getId()));
                if (info != null) {
                    logger.debug(String.format("job[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u4f46\u88ab\u91cd\u65b0\u6fc0\u6d3b\u5230\u4e86\uff0c\u8d70\u5230\u8fd9\u91cc\u5f88\u5947\u602a\uff01", deadLetterJobEntity.getId()));
                    JobEntity jobEntity = null;
                    return jobEntity;
                }
                JobEntity executableJob = this.createExecutableJobFromOtherJob(deadLetterJobEntity);
                executableJob.setRetries(retries);
                boolean insertSuccesful = this.getJobEntityManager().insertJobEntity(executableJob);
                if (insertSuccesful) {
                    this.getDeadLetterJobEntityManager().delete(deadLetterJobEntity);
                    this.triggerExecutorIfNeeded(executableJob);
                    JobEntity jobEntity = executableJob;
                    return jobEntity;
                }
            }
        }
        return null;
    }

    @Override
    public void execute(Job job) {
        if (job instanceof JobEntity) {
            if ("message".equals(job.getJobType())) {
                this.executeMessageJob((JobEntity)job);
            } else if ("timer".equals(job.getJobType())) {
                this.executeTimerJob((JobEntity)job);
            }
        } else if (job instanceof EvtJobEntity) {
            this.executeEvtJob((EvtJobEntity)job);
        } else {
            throw new WFEngineException("Only jobs with type JobEntity are supported to be executed");
        }
    }

    @Override
    public void unacquire(Job job) {
        if (job instanceof JobEntity) {
            JobEntity jobEntity = (JobEntity)job;
            this.getJobEntityManager().delete(jobEntity.getId());
            JobEntity newJobEntity = (JobEntity)this.getJobEntityManager().create();
            this.copyJobInfo(newJobEntity, jobEntity);
            newJobEntity.setId(null);
            newJobEntity.setLockExpirationTime(null);
            newJobEntity.setLockOwnerId(Integer.toString(0));
            this.getJobEntityManager().insert(newJobEntity);
        }
    }

    protected void executeMessageJob(JobEntity jobEntity) {
        this.executeJobHandler(jobEntity);
    }

    protected void executeTimerJob(JobEntity timerEntity) {
        TimerJobEntity newTimerJobEntity;
        TimerJobEntityManager timerJobEntityManager = this.getTimerJobEntityManager();
        VariableScope variableScope = null;
        if (WfUtils.isNotEmpty(timerEntity.getExecutionId())) {
            variableScope = (VariableScope)this.getExecutionEntityManager().findById(timerEntity.getExecutionId());
        }
        if (variableScope == null) {
            variableScope = NoExecutionVariableScope.getSharedInstance();
        }
        this.restoreExtraData(timerEntity, variableScope);
        boolean isTimerStartEventJob = "timer-start-event".equals(timerEntity.getJobHandlerType());
        if (isTimerStartEventJob && timerEntity.getDuedate() != null && !this.isValidTime(timerEntity, timerEntity.getDuedate(), variableScope)) {
            logger.debug("Timer {" + timerEntity.getId() + "} fired. but the dueDate is after the endDate.  Deleting timer.");
            this.getJobEntityManager().delete(timerEntity);
            return;
        }
        this.executeJobHandler(timerEntity);
        this.getJobEntityManager().delete(timerEntity);
        if (WfConfigurationUtil.removeTimingLogImmediately()) {
            this.processEngineConfiguration.getEventLogEntryEntityManager().deleteLogsByJob(timerEntity);
            this.processEngineConfiguration.getHistoricConditionRuleInstanceEntityManager().deleteHistoricConditionRuleInstanceByJob(timerEntity);
            this.processEngineConfiguration.getConditionParseLogManager().delete(timerEntity);
        }
        logger.debug("Timer {" + timerEntity.getId() + "} fired. Deleting timer.");
        if (isTimerStartEventJob && WfUtils.isNotEmpty(timerEntity.getRepeat()) && (newTimerJobEntity = timerJobEntityManager.createAndCalculateNextTimer(timerEntity, variableScope)) != null) {
            this.scheduleTimerJob(newTimerJobEntity);
        }
    }

    protected void executeJobHandler(JobEntity jobEntity) {
        ExecutionEntity execution = null;
        if (WfUtils.isNotEmpty(jobEntity.getExecutionId())) {
            execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
        }
        if (execution == null) {
            logger.debug(String.format("execution is null when execute job handler.executionId:[%s]", jobEntity.getExecutionId()));
        }
        Map<String, JobHandler> jobHandlers = this.processEngineConfiguration.getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        logger.debug("executeJobHandler in " + jobHandler.getClass().getName() + ",with configuration[" + jobEntity.getJobHandlerConfiguration() + "]");
        jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), execution, this.getCommandContext());
    }

    protected void executeEvtJob(EvtJobEntity jobEntity) {
        Map<String, EvtJobHandler> jobHandlers = this.processEngineConfiguration.getEvtJobHandlers();
        EvtJobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        logger.debug("executeJobHandler in " + jobHandler.getClass().getName() + ",with configuration[" + jobEntity.getJobHandlerConfiguration() + "]");
        jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), null, this.getCommandContext());
    }

    protected void restoreExtraData(JobEntity timerEntity, VariableScope variableScope) {
        Process process;
        String activityId = timerEntity.getElementId();
        if ("timer-start-event".equalsIgnoreCase(timerEntity.getJobHandlerType())) {
            activityId = TimerEventHandler.getActivityIdFromConfiguration(timerEntity.getJobHandlerConfiguration());
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(timerEntity.getJobHandlerConfiguration());
            if (endDateExpressionString != null) {
                Expression endDateExpression = this.processEngineConfiguration.getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                String calendarName = TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration());
                BusinessCalendar businessCalendar = this.processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(calendarName, variableScope));
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue(variableScope);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        timerEntity.setEndDate((Date)endDateValue);
                    } else {
                        throw new WFEngineException("Timer '" + ((ExecutionEntity)variableScope).getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (timerEntity.getEndDate() == null) {
                        timerEntity.setEndDate(businessCalendar.resolveEndDate(endDateString));
                    }
                }
            }
        }
        int maxIterations = 1;
        if (timerEntity.getProcessDefinitionId() != null && (process = ProcessDefinitionUtil.getProcess(timerEntity.getProcessDefinitionId(), timerEntity.getProcessInstanceId())) != null) {
            maxIterations = this.getMaxIterations(process, activityId);
        }
        timerEntity.setMaxIterations(maxIterations);
    }

    protected int getMaxIterations(Process process, String activityId) {
        String t;
        FlowElement flowElement = process.getFlowElement(activityId, true);
        if (flowElement instanceof WaitTask && (t = ((WaitTask)flowElement).getTimingModel().getAttributeValue("maxIterations")) != null) {
            try {
                return Integer.parseInt(t);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return -1;
    }

    protected boolean isValidTime(JobEntity timerEntity, Date newTimerDate, VariableScope variableScope) {
        BusinessCalendar businessCalendar = this.processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope));
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CycleBusinessCalendar.NAME;
        if (StringUtils.isNotEmpty((String)calendarName)) {
            businessCalendarName = (String)Context.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue(variableScope);
        }
        return businessCalendarName;
    }

    protected void hintAsyncExecutor(JobEntity job) {
    }

    protected void hintAsyncExecutor(List<JobEntity> jobs) {
    }

    protected TimerJobEntity internalCreateAsyncTimerJob(ExecutionEntity execution, boolean exclusive, String jobType) {
        TimerJobEntity asyncJob = (TimerJobEntity)this.getTimerJobEntityManager().create();
        this.fillDefaultAsyncTimerJobInfo(asyncJob, execution, exclusive, jobType);
        return asyncJob;
    }

    protected TimerJobEntity internalCreateAsyncTimerJob(MessageContext ctx, boolean exclusive, String jobType) {
        TimerJobEntity asyncJob = (TimerJobEntity)this.getTimerJobEntityManager().create();
        this.fillDefaultAsyncTimerJobInfo(asyncJob, ctx, exclusive, jobType);
        return asyncJob;
    }

    protected JobEntity internalCreateLockedAsyncJob(boolean exclusive, String jobType) {
        JobEntity asyncJob = (JobEntity)this.getJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, exclusive, jobType);
        JobUtil.setJobLockProperty(asyncJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return asyncJob;
    }

    protected JobEntity internalCreateLockedAsyncJob(ExecutionEntity execution, boolean exclusive, String jobType) {
        JobEntity asyncJob = (JobEntity)this.getJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, execution, exclusive, jobType);
        JobUtil.setJobLockProperty(asyncJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return asyncJob;
    }

    protected JobEntity internalCreateLockedAsyncJob(TaskEntity task, boolean exclusive, String jobType) {
        JobEntity asyncJob = (JobEntity)this.getJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, task, exclusive, jobType);
        JobUtil.setJobLockProperty(asyncJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return asyncJob;
    }

    protected JobEntity internalCreateLockedAsyncJob(MessageContext ctx, boolean exclusive, String jobType) {
        JobEntity asyncJob = (JobEntity)this.getJobEntityManager().create();
        this.fillDefaultAsyncJobInfo(asyncJob, ctx, exclusive, jobType);
        JobUtil.setJobLockProperty(asyncJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return asyncJob;
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, boolean exclusive, String jobType) {
        Long currentJobId;
        jobEntity.setJobType("message");
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExclusive(exclusive);
        jobEntity.setJobHandlerType(jobType);
        WfTraceType.WfTraceJobInfo jobInfo = WfTraceType.getOrCreate().getJobInfo();
        if (jobInfo != null && (currentJobId = jobInfo.getCurrentJobId()) != null) {
            jobEntity.setSrcJobId(currentJobId);
        }
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, TaskEntity task, boolean exclusive, String jobType) {
        jobEntity.setJobType("message");
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExecutionId(task == null ? null : task.getExecutionId());
        jobEntity.setProcessInstanceId(task == null ? null : task.getProcessInstanceId());
        jobEntity.setProcessDefinitionId(task == null ? null : task.getProcessDefinitionId());
        jobEntity.setExclusive(exclusive);
        jobEntity.setBusinessKey(task == null ? null : task.getBusinessKey());
        jobEntity.setEntityNumber(task == null ? null : task.getEntityNumber());
        jobEntity.setJobHandlerType(jobType);
        jobEntity.setElementId(task == null ? null : task.getTaskDefinitionKey());
        jobEntity.setOrgUnitId(task == null ? null : task.getOrgUnitId());
        this.setJobEntityBizTraceNo(jobEntity, task == null ? null : task.getExecution());
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            jobEntity.setSrcJobId(WfTraceType.getOrCreate().getJobInfo().getCurrentJobId());
        }
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, ExecutionEntity execution, boolean exclusive, String jobType) {
        jobEntity.setJobType("message");
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExecutionId(execution == null ? null : execution.getId());
        jobEntity.setProcessInstanceId(execution == null ? null : execution.getProcessInstanceId());
        jobEntity.setProcessDefinitionId(execution == null ? null : execution.getProcessDefinitionId());
        jobEntity.setExclusive(exclusive);
        jobEntity.setBusinessKey(execution == null ? null : execution.getBusinessKey());
        jobEntity.setEntityNumber(execution == null ? null : execution.getEntityNumber());
        jobEntity.setJobHandlerType(jobType);
        jobEntity.setElementId(execution == null ? null : execution.getCurrentActivityId());
        jobEntity.setOrgUnitId(execution == null ? null : execution.getMainOrgId());
        this.setJobEntityBizTraceNo(jobEntity, execution);
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            jobEntity.setSrcJobId(WfTraceType.getOrCreate().getJobInfo().getCurrentJobId());
        }
    }

    private void setJobEntityBizTraceNo(AbstractJobEntity jobEntity, ExecutionEntity execution) {
        Object bizTraceNo = null;
        if (execution != null && (bizTraceNo = execution.getVariable("biztraceno")) != null) {
            jobEntity.setBizTraceNo(String.valueOf(bizTraceNo));
        }
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, MessageContext ctx, boolean exclusive, String jobType) {
        jobEntity.setJobType("message");
        jobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExecutionId(ctx.getExecutionId());
        jobEntity.setProcessInstanceId(ctx.getProcessInstanceId());
        jobEntity.setProcessDefinitionId(ctx.getProcessDefinitionId());
        jobEntity.setExclusive(exclusive);
        jobEntity.setBusinessKey(ctx.getBusinessKey());
        jobEntity.setEntityNumber(ctx.getEntityNumber());
        jobEntity.setJobHandlerType(jobType);
        jobEntity.setElementId(ctx.getElementId());
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            jobEntity.setSrcJobId(WfTraceType.getOrCreate().getJobInfo().getCurrentJobId());
        }
    }

    protected void fillDefaultAsyncTimerJobInfo(TimerJobEntity timerJobEntity, MessageContext ctx, boolean exclusive, String jobType) {
        timerJobEntity.setJobType("timer");
        timerJobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        timerJobEntity.setExecutionId(ctx.getExecutionId());
        timerJobEntity.setProcessInstanceId(ctx.getProcessInstanceId());
        timerJobEntity.setProcessDefinitionId(ctx.getProcessDefinitionId());
        timerJobEntity.setExclusive(exclusive);
        timerJobEntity.setBusinessKey(ctx.getBusinessKey());
        timerJobEntity.setEntityNumber(ctx.getEntityNumber());
        timerJobEntity.setJobHandlerType(jobType);
        timerJobEntity.setElementId(ctx.getElementId());
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            timerJobEntity.setLockOwnerId(lockTag);
        }
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            timerJobEntity.setSrcJobId(WfTraceType.getOrCreate().getJobInfo().getCurrentJobId());
        }
    }

    protected void fillDefaultAsyncTimerJobInfo(TimerJobEntity timerJobEntity, ExecutionEntity execution, boolean exclusive, String jobType) {
        timerJobEntity.setJobType("timer");
        timerJobEntity.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        timerJobEntity.setExecutionId(execution == null ? null : execution.getId());
        timerJobEntity.setProcessInstanceId(execution == null ? null : execution.getProcessInstanceId());
        timerJobEntity.setProcessDefinitionId(execution == null ? null : execution.getProcessDefinitionId());
        timerJobEntity.setExclusive(exclusive);
        timerJobEntity.setBusinessKey(execution == null ? null : execution.getBusinessKey());
        timerJobEntity.setEntityNumber(execution == null ? null : execution.getEntityNumber());
        timerJobEntity.setJobHandlerType(jobType);
        timerJobEntity.setElementId(execution == null ? null : execution.getCurrentActivityId());
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            timerJobEntity.setLockOwnerId(lockTag);
        }
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            timerJobEntity.setSrcJobId(WfTraceType.getOrCreate().getJobInfo().getCurrentJobId());
        }
    }

    protected JobEntity createExecutableJobFromOtherJob(AbstractJobEntity job) {
        String source = JobHandleStrategyFactory.getWFSource();
        JobEntity executableJob = (JobEntity)this.getJobEntityManager().create();
        this.copyJobInfo(executableJob, job);
        executableJob.setSource(source);
        JobUtil.setJobLockProperty(executableJob, this.processEngineConfiguration, this.getAsyncExecutor());
        return executableJob;
    }

    protected TimerJobEntity createTimerJobFromOtherJob(AbstractJobEntity otherJob) {
        TimerJobEntity timerJob = (TimerJobEntity)this.getTimerJobEntityManager().create();
        this.copyJobInfo(timerJob, otherJob);
        String lockTag = WfConfigurationUtil.getLockTag();
        if (WfUtils.isNotEmpty(lockTag)) {
            timerJob.setLockOwnerId(lockTag);
        }
        return timerJob;
    }

    protected SuspendedJobEntity createSuspendedJobFromOtherJob(AbstractJobEntity otherJob) {
        SuspendedJobEntity suspendedJob = (SuspendedJobEntity)this.processEngineConfiguration.getSuspendedJobEntityManager().create();
        this.copyJobInfo(suspendedJob, otherJob);
        return suspendedJob;
    }

    protected DeadLetterJobEntity createDeadLetterJobFromOtherJob(AbstractJobEntity otherJob, Throwable exception) {
        FlowElement elem;
        DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)this.getDeadLetterJobEntityManager().create();
        this.copyJobInfo(deadLetterJob, otherJob);
        if (!("event".equals(otherJob.getJobType()) || "taskMessage".equals(otherJob.getJobType()) || "taskTimer".equals(otherJob.getJobType()))) {
            this.copyExecutionInfo(deadLetterJob, otherJob.getProcessInstanceId());
        }
        WFEngineException wfException = null;
        wfException = exception != null ? (!(exception instanceof WFEngineException) ? new WFEngineException(exception.getMessage(), exception) : (WFEngineException)((Object)exception)) : new WFEngineException(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38", (String)"DefaultJobManager_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        if (wfException.getErrorCode() != null) {
            BizErrorInfo errorInfo = ExceptionUtil.getBizErrorCodeAndMsg(exception);
            String bizErrorCode = errorInfo.getErrCode();
            String errorCode = wfException.getErrorCode().getCode();
            if (WfUtils.isNotEmpty(bizErrorCode) && !bizErrorCode.equalsIgnoreCase(errorCode)) {
                errorCode = String.format("%s.%s", errorCode, bizErrorCode);
            }
            deadLetterJob.setErrorCode(errorCode);
            deadLetterJob.setExceptionMessage(wfException.getMessage());
        }
        if (WfUtils.isEmpty(deadLetterJob.getElementId()) && WfUtils.isNotEmpty(wfException.getElementId())) {
            deadLetterJob.setElementId(wfException.getElementId());
        }
        if (!("event".equals(otherJob.getJobType()) || "taskMessage".equals(otherJob.getJobType()) || "taskTimer".equals(otherJob.getJobType()) || otherJob.getProcessInstanceId() == null && otherJob.getProcessDefinitionId() == null || (elem = ProcessDefinitionUtil.getFlowElement(otherJob.getProcessDefinitionId(), otherJob.getProcessInstanceId(), deadLetterJob.getElementId())) == null)) {
            String multiKey = BpmnModelUtil.getActivityNameMultiKey(elem.getId());
            ILocaleString localeName = BpmnModelUtil.getMultiLangFieldValue(otherJob.getProcessInstanceId(), multiKey, elem.getName());
            if (WfUtils.isEmpty(localeName)) {
                localeName = new LocaleString(elem.getName());
            }
            deadLetterJob.setElementName(localeName);
        }
        deadLetterJob.setErrorType(wfException.getType());
        deadLetterJob.setSolution(wfException.getSolution());
        deadLetterJob.setExceptionStackMessage(WfUtils.getExceptionStacktrace(wfException.getCause()));
        return deadLetterJob;
    }

    private String getBizErrorCode(Throwable exception) {
        ErrorCode errorCode;
        if (exception != null && exception.getCause() != null && exception.getCause() instanceof KDBizException && (errorCode = ((KDBizException)exception.getCause()).getErrorCode()) != null && !"bizOperationUnKnowError".equalsIgnoreCase(errorCode.getCode())) {
            return errorCode.getCode();
        }
        return null;
    }

    private void copyExecutionInfo(DeadLetterJobEntity deadLetterJobEntity, Long processInstanceId) {
        if (WfUtils.isNullObject(processInstanceId) || Long.valueOf(0L).equals(processInstanceId)) {
            String pInstanceId = this.processEngineConfiguration.getExecutionEntityManager().inProcess(deadLetterJobEntity.getBusinessKey());
            if (WfUtils.isNotEmpty(pInstanceId)) {
                TaskEntityManager taskMgr;
                List<TaskEntity> tasks;
                processInstanceId = Long.valueOf(pInstanceId);
                processInstanceId = ((ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(processInstanceId)).getProcessInstanceId();
                deadLetterJobEntity.setProcessInstanceId(processInstanceId);
                if (WfUtils.isNotEmpty(deadLetterJobEntity.getOperation()) && WfUtils.isNotEmpty(deadLetterJobEntity.getEntityNumber()) && (tasks = (taskMgr = this.processEngineConfiguration.getTaskEntityManager()).findTasksByBusinessKey(deadLetterJobEntity.getBusinessKey())) != null && tasks.size() > 0) {
                    for (TaskEntity task : tasks) {
                        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId());
                        UserTask userTask = (UserTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
                        boolean continueFlow = userTask != null && deadLetterJobEntity.getEntityNumber().equalsIgnoreCase(userTask.getEntityNumber()) && userTask.getOperationStr() != null && Arrays.asList(userTask.getOperationStr().split(",")).contains(deadLetterJobEntity.getOperation());
                        if (!continueFlow) continue;
                        deadLetterJobEntity.setElementId(task.getTaskDefinitionKey());
                    }
                }
            }
            if (WfUtils.isNullObject(processInstanceId) || Long.valueOf(0L).equals(processInstanceId)) {
                this.copySubjectAndEntityName(deadLetterJobEntity, null);
                return;
            }
        }
        Long exId = WfUtils.isEmpty(deadLetterJobEntity.getExecutionId()) ? processInstanceId : deadLetterJobEntity.getExecutionId();
        ExecutionEntity executionEntity = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(exId);
        if (executionEntity == null) {
            HistoricProcessInstanceEntity hisProcInstEntity = (HistoricProcessInstanceEntity)this.processEngineConfiguration.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
            if (hisProcInstEntity != null) {
                deadLetterJobEntity.setKeyversion(hisProcInstEntity.getName());
                deadLetterJobEntity.setSubject(hisProcInstEntity.getSubject());
                deadLetterJobEntity.setEntrabillname(hisProcInstEntity.getEntraBillName());
            }
            return;
        }
        if (WfUtils.isEmpty(deadLetterJobEntity.getElementId()) && WfUtils.isNotEmpty(deadLetterJobEntity.getExecutionId())) {
            String activityIds = executionEntity.getActivityId();
            deadLetterJobEntity.setElementId(activityIds.split(",")[0]);
        }
        deadLetterJobEntity.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
        deadLetterJobEntity.setKeyversion(executionEntity.getName());
        deadLetterJobEntity.setSubject(executionEntity.getSubject());
        deadLetterJobEntity.setEntrabillname(executionEntity.getEntraBillName());
        deadLetterJobEntity.setOrgUnitId(executionEntity.getMainOrgId());
        deadLetterJobEntity.setOrgViewId(executionEntity.getOrgViewId());
        this.copySubjectAndEntityName(deadLetterJobEntity, executionEntity);
    }

    protected void copySubjectAndEntityName(DeadLetterJobEntity deadLetterJobEntity, ExecutionEntity executionEntity) {
        if (deadLetterJobEntity.getSubject() == null || WfUtils.isEmpty(deadLetterJobEntity.getSubject().getLocaleValue())) {
            FlowElement f;
            BillSubjectCalculator calculator = this.processEngineConfiguration.getBillSubjectCalculator();
            List<BillSubjectModel> subjectModels = new ArrayList<BillSubjectModel>();
            if (executionEntity != null && (f = ProcessDefinitionUtil.getFlowElement(executionEntity.getProcessDefinitionId(), executionEntity.getProcessInstanceId(), executionEntity.getActivityId())) instanceof UserTask) {
                subjectModels = ((UserTask)f).getSubject();
            }
            VariableScope scope = null;
            scope = executionEntity != null ? (executionEntity.getCurrentTask() != null ? executionEntity.getCurrentTask() : executionEntity) : new BusinessModelVariableScope(deadLetterJobEntity.getBusinessKey(), deadLetterJobEntity.getEntityNumber());
            ILocaleString subject = calculator.getSubjectByBillSubjectModel(subjectModels, deadLetterJobEntity.getBusinessKey(), deadLetterJobEntity.getEntityNumber(), scope);
            deadLetterJobEntity.setSubject(subject);
        }
        if ((deadLetterJobEntity.getEntrabillname() == null || WfUtils.isEmpty(deadLetterJobEntity.getEntrabillname().getLocaleValue())) && executionEntity != null && WfUtils.isNotEmpty(executionEntity.getEntraBillName())) {
            deadLetterJobEntity.setEntrabillname(executionEntity.getEntraBillName());
        }
    }

    protected void copyJobInfo(AbstractJobEntity copyToJob, AbstractJobEntity copyFromJob) {
        copyToJob.setDuedate(copyFromJob.getDuedate());
        copyToJob.setExclusive(copyFromJob.isExclusive());
        copyToJob.setExecutionId(copyFromJob.getExecutionId());
        if (copyFromJob instanceof JobEntity) {
            copyToJob.setId(((JobEntity)copyFromJob).getRootJobId());
        } else if (copyToJob instanceof JobEntity) {
            ((JobEntity)copyToJob).setRootJobId(copyFromJob.getId());
            ((JobEntity)copyToJob).setState(JobStateEnum.CREATED.getNumber());
        } else {
            copyToJob.setId(copyFromJob.getId());
        }
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setJobType(copyFromJob.getJobType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setProcessDefinitionId(copyFromJob.getProcessDefinitionId());
        copyToJob.setProcessInstanceId(copyFromJob.getProcessInstanceId());
        copyToJob.setRepeat(copyFromJob.getRepeat());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setBusinessKey(copyFromJob.getBusinessKey());
        copyToJob.setEntityNumber(copyFromJob.getEntityNumber());
        copyToJob.setOperation(copyFromJob.getOperation());
        copyToJob.setElementId(copyFromJob.getElementId());
        copyToJob.setSrcJobId(copyFromJob.getSrcJobId());
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected AsyncExecutor getAsyncExecutor() {
        return this.processEngineConfiguration.getAsyncExecutor();
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return this.processEngineConfiguration.getExecutionEntityManager();
    }

    @Override
    public JobEntity createEventAddressMessageJob(String entityNumber, String businessKey, String eventNumber, Map<String, Object> variables) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "event-address-process");
        jobEntity.setBusinessKey(businessKey);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(BUSINESSKEY, businessKey);
        payload.put(ENTITYNUMBER, entityNumber);
        payload.put("eventNumber", eventNumber);
        payload.put(VARIABLES, variables);
        String lockKey = String.format("%s-%s-%s", eventNumber, entityNumber, jobEntity.getBizTraceNo());
        payload.put("_lockKey_", new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "EventAddressMessage"));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createAddressMessageJob(String billId, String operation, String entityNumber, Map<String, Object> variables) {
        Object jobId;
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "address-process-event");
        jobEntity.setBusinessKey(billId);
        jobEntity.setOperation(operation);
        jobEntity.setEntityNumber(entityNumber);
        String procDefId = null;
        if (variables != null) {
            procDefId = (String)variables.get("procdefid");
            if (WfUtils.isNotEmpty(procDefId)) {
                Long processDefinitionId = Long.parseLong(procDefId);
                jobEntity.setProcessDefinitionId(processDefinitionId);
            }
            if (variables.get(SUPEREXECUTIONID) instanceof Long) {
                Long superExecutionId = (Long)variables.get(SUPEREXECUTIONID);
                jobEntity.setExecutionId(superExecutionId);
            }
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        String bizTraceNo = null;
        if (variables != null) {
            bizTraceNo = (String)variables.get("biztraceno");
        }
        payload.put("biztraceno", WfUtils.isNotEmpty(bizTraceNo) ? bizTraceNo : jobEntity.getBizTraceNo());
        payload.put(BUSINESSKEY, billId);
        payload.put(OPERATION, operation);
        payload.put(ENTITYNUMBER, entityNumber);
        payload.put(VARIABLES, variables);
        payload.put("_billno_", WfUtils.pop(variables, "_billno_"));
        StringBuilder lockKey = new StringBuilder().append(billId).append(operation);
        if (variables != null && ModelType.NoCodeFlow.name().equals(variables.get("processType")) && WfUtils.isNotEmpty(procDefId) && (jobId = WfUtils.pop(variables, "jobId")) != null) {
            lockKey.append(".").append(jobId);
        }
        payload.put("_lockKey_", new RepeatJobModel(lockKey.toString(), RepeatJobModel.JobLockedStrategy.DISCARD, "AddressMessage"));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    protected void fillPayload(JobEntity jobEntity, Map<String, Object> payload) {
        if (payload == null) {
            payload = new HashMap<String, Object>();
        }
        RequestContext requestContext = RequestContext.get();
        Map<String, Object> context = WfUtils.dumpRequestContext(requestContext);
        if ("async-compensationTaskJob".equals(jobEntity.getJobHandlerType()) || "address-process-event".equals(jobEntity.getJobHandlerType())) {
            context.put("lang", requestContext.getLang().toString());
        }
        payload.put("_requestContext_", context);
        this.fillBillNo(payload);
        this.addExtraVariable(payload);
        jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        jobEntity.setSource(JobHandleStrategyFactory.getWFSource());
        jobEntity.setState(JobStateEnum.CREATED.getNumber());
        jobEntity.setRootTraceNo(RequestContext.get().getTraceId());
    }

    @Override
    public JobEntity createStartProcessMessageJobByEventScription(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        JobEntity message = this.internalCreateLockedAsyncJob(false, "start-process-event");
        if (WfUtils.isEmpty(message.getId())) {
            message.setId(ORM.create().genLongId("wf_job"));
        }
        message.setProcessDefinitionId(eventSubscriptionEntity.getProcessDefinitionId());
        message.setProcessInstanceId(eventSubscriptionEntity.getProcessInstanceId());
        message.setExecutionId(eventSubscriptionEntity.getExecutionId());
        if (payload instanceof Map) {
            ProcessDefinitionEntityImpl def;
            Map data = (Map)payload;
            data.put("_CONFIGURATIONID_", eventSubscriptionEntity.getId());
            if (data.get("_businessKey_") != null) {
                message.setBusinessKey((String)data.get("_businessKey_"));
            }
            if (data.get(SUPEREXECUTIONID) instanceof Long) {
                message.setExecutionId((Long)data.get(SUPEREXECUTIONID));
            }
            if (data.get("currentActInstId") != null) {
                message.setElementId((String)data.get("currentActInstId"));
            }
            if (eventSubscriptionEntity.getProcessDefinitionId() != null && (def = (ProcessDefinitionEntityImpl)ProcessDefinitionUtil.getProcessDefinition(eventSubscriptionEntity.getProcessDefinitionId())) != null) {
                message.setEntityNumber(def.getEntraBill());
                message.setOperation(def.getOperation());
            }
            Object entityNumber = data.get("_entityNumber_");
            Object businessKey = data.get("_businessKey_");
            StringBuilder lockKey = new StringBuilder().append(entityNumber).append(".").append(businessKey);
            if (ModelType.NoCodeFlow.name().equals(data.get("processType")) && WfUtils.isNotEmpty(message.getId())) {
                lockKey.append(".").append(message.getId());
            }
            data.put("_lockKey_", new RepeatJobModel(lockKey.toString(), RepeatJobModel.JobLockedStrategy.DISCARD, "StartProcessMessage"));
            this.fillPayload(message, data);
        }
        return message;
    }

    @Override
    public JobEntity createWaitEventJobByEventScription(EventSubscriptionEntity eventSubscriptionEntity, Map<String, Object> payload) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "wait-event");
        jobEntity.setProcessDefinitionId(eventSubscriptionEntity.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(eventSubscriptionEntity.getProcessInstanceId());
        jobEntity.setExecutionId(eventSubscriptionEntity.getExecutionId());
        jobEntity.setElementId(eventSubscriptionEntity.getActivityId());
        jobEntity.setBusinessKey((String)payload.get(BUSINESSKEY));
        jobEntity.setEntityNumber((String)payload.get(ENTITYNUMBER));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createDelayBroadcastJob(ExecutionEntity execution, Map<String, Object> payload) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "delay-broadcast");
        this.fillPayload(jobEntity, payload);
        jobEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(execution.getProcessInstanceId());
        jobEntity.setExecutionId(execution.getId());
        jobEntity.setElementId(execution.getActivityId());
        jobEntity.setBusinessKey(execution.getBusinessKey());
        jobEntity.setEntityNumber(execution.getEntityNumber());
        jobEntity.setState(JobStateEnum.COMPLETED.getNumber());
        return jobEntity;
    }

    @Override
    public JobEntity createStartCallActivityMessageJob(DelegateExecution execution, CallActivity callActivity) {
        ExecutionEntity entity = null;
        if (execution instanceof ExecutionEntity) {
            entity = (ExecutionEntity)execution;
        }
        JobEntity message = this.internalCreateLockedAsyncJob(entity, false, "start-callactivity-event");
        message.setProcessDefinitionId(execution.getProcessDefinitionId());
        message.setProcessInstanceId(execution.getProcessInstanceId());
        message.setExecutionId(execution.getId());
        message.setBusinessKey(execution.getBusinessKey());
        message.setEntityNumber(execution.getEntityNumber());
        if ("processAddress".equalsIgnoreCase(callActivity.getCalledWay())) {
            message.setOperation(callActivity.getCallProcessName());
        } else {
            message.setProcessDefinitionId(callActivity.getCallProcessId());
        }
        this.fillPayload(message, null);
        return message;
    }

    @Override
    public JobEntity createTaskRuleAnalysisJobHandler(TaskEntity entity) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "async-taskRuleAnalysis");
        jobEntity.setProcessDefinitionId(entity.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(entity.getProcessInstanceId());
        jobEntity.setElementId(entity.getTaskDefinitionKey());
        jobEntity.setEntityNumber(entity.getEntityNumber());
        jobEntity.setExecutionId(entity.getExecutionId());
        jobEntity.setBusinessKey(entity.getBusinessKey());
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, entity.getId());
        RepeatJobModel rjModel = new RepeatJobModel(String.format("taskRule-%s", entity.getId()), RepeatJobModel.JobLockedStrategy.NOTHING, "TaskHandle");
        payload.put("_lockKey_", rjModel);
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public TimerJobEntity createExpireModelTimerJob(TaskEntity context, ExpireOperation operation, Date dueDate) {
        TimerJobEntity timerJobEntity = this.internalCreateAsyncTimerJob(context.getExecution(), false, "expireModelJobHandler");
        timerJobEntity.setDuedate(dueDate);
        timerJobEntity.setProcessDefinitionId(context.getProcessDefinitionId());
        timerJobEntity.setProcessInstanceId(context.getProcessInstanceId());
        timerJobEntity.setElementId(context.getTaskDefinitionKey());
        timerJobEntity.setEntityNumber(context.getEntityNumber());
        timerJobEntity.setBusinessKey(context.getBusinessKey());
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, context.getId());
        payload.put("operationNumber", operation.getOperationNumber());
        payload.put("operationConfig", operation.getConfig());
        if (WfUtils.isNotEmpty(context.getParentTaskId())) {
            RepeatJobModel rjModel = new RepeatJobModel(String.format("Expire-%s", context.getParentTaskId()), RepeatJobModel.JobLockedStrategy.NOTHING, "ExpireTask");
            payload.put("_lockKey_", rjModel);
        } else {
            RepeatJobModel rjModel = new RepeatJobModel(String.format("Expire-%s", context.getId()), RepeatJobModel.JobLockedStrategy.NOTHING, "ExpireTask");
            payload.put("_lockKey_", rjModel);
        }
        this.fillBillNo(payload);
        payload.put("_requestContext_", WfUtils.dumpRequestContext(RequestContext.get()));
        this.addExtraVariable(payload);
        timerJobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        return timerJobEntity;
    }

    @Override
    public TimerJobEntity createTimingModelTimerJob(String type, ExecutionEntity execution, Date dueDate) {
        TimerJobEntity timerJobEntity = this.internalCreateAsyncTimerJob(execution, false, "async-timing");
        timerJobEntity.setDuedate(dueDate);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        this.addExtraVariable(payload);
        payload.put("timingType", type);
        this.fillBillNo(payload);
        payload.put("_requestContext_", WfUtils.dumpRequestContext(RequestContext.get()));
        timerJobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        return timerJobEntity;
    }

    private void fillBillNo(Map<String, Object> payload) {
        String billNo;
        String string = billNo = WfTraceType.get().getJobInfo() == null ? null : WfTraceType.get().getJobInfo().getBillNo();
        if (WfUtils.isNotEmpty(billNo) && payload.get("_billno_") == null) {
            payload.put("_billno_", billNo);
        }
    }

    @Override
    public JobEntity createStartRPAProcessJob(ExecutionEntity execution) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, false, "start-rpa-process");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("actInstId", execution.getCurrentActInstId());
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createCirculateJob(ExecutionEntity execution, Long taskId) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, false, "async-circulate");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, taskId);
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createCirculateJob(ExecutionEntity execution, Long taskId, List<Long> userIds, ILocaleString circulationMsg) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, false, "async-circulate");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, taskId);
        payload.put(USERIDS, userIds);
        payload.put(CIRCULATIONMSG, circulationMsg);
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createAutoCoordinateJob(ExecutionEntity execution, Long taskId, List<Long> autoCoordinatorIds) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(execution, false, "async-autoCoordinate");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, taskId);
        payload.put("autoCoordinatorIds", autoCoordinatorIds);
        RepeatJobModel rjModel = new RepeatJobModel(String.format("autoCo-%s", taskId), RepeatJobModel.JobLockedStrategy.NOTHING, "TaskHandle");
        payload.put("_lockKey_", rjModel);
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createToDoJob(MessageContext ctx, ToDoInfo todo, String serviceKey) {
        String billNo;
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(ctx, false, "async-todo");
        jobEntity.setRetries(MessageServiceUtil.getJobEntityRestries(jobEntity, serviceKey, jobEntity.getRetries()));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("context", SerializationUtils.toJsonString((Object)ctx));
        payload.put("model", SerializationUtils.toJsonString((Object)todo));
        payload.put("service", serviceKey);
        String string = billNo = WfUtils.isNotEmpty(todo.getBillNo()) ? todo.getBillNo() : ctx.getBillNo();
        if (WfUtils.isEmpty((String)payload.get("_billno_")) && WfUtils.isNotEmpty(billNo)) {
            payload.put("_billno_", billNo);
        }
        String state = todo.getState().name();
        String lockKey = todo.getTaskId() + todo.getState().name() + serviceKey;
        if (ToDoInfo.State.NEW.name().equals(state) || ToDoInfo.State.DEAL.name().equals(state) || ToDoInfo.State.DELETEANDCREATE.name().equals(state)) {
            payload.put("_lockKey_", new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.DISCARD, "createToDoJobTask"));
        } else if (ToDoInfo.State.DELETE.name().equals(state)) {
            payload.put("_lockKey_", new RepeatJobModel(lockKey, RepeatJobModel.JobLockedStrategy.NOTHING, "createToDoJobTask"));
        }
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createMessageJob(MessageContext ctx, MessageInfo msg, String serviceKey) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "async-msg");
        jobEntity.setProcessDefinitionId(ctx.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(ctx.getProcessInstanceId());
        jobEntity.setElementId(ctx.getElementId());
        jobEntity.setEntityNumber(ctx.getEntityNumber());
        jobEntity.setBusinessKey(ctx.getBusinessKey());
        if (WfUtils.isEmpty(msg.getId())) {
            msg.setId(Long.valueOf(ORM.create().genLongId("wf_msg_message")));
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("context", SerializationUtils.toJsonString((Object)ctx));
        payload.put("model", SerializationUtils.toJsonString((Object)msg));
        payload.put("service", serviceKey);
        if (WfUtils.isNotEmpty(ctx.getBillNo())) {
            payload.put("_billno_", ctx.getBillNo());
        }
        payload.put("_lockKey_", new RepeatJobModel(String.format("messagejob-%s", msg.getId()), RepeatJobModel.JobLockedStrategy.DISCARD, "createMessageJob"));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createMessageJob(MessageContext ctx, MessageInfo msg) {
        return this.createMessageJob(ctx, msg, "");
    }

    @Override
    public JobEntity createTaskTransferHandler(TaskHandleLogEntity entity) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "async-taskTransfer");
        TaskEntity task = (TaskEntity)this.getCommandContext().getTaskEntityManager().findById(entity.getTaskId());
        jobEntity.setProcessDefinitionId(task.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(task.getProcessInstanceId());
        jobEntity.setElementId(task.getTaskDefinitionKey());
        jobEntity.setEntityNumber(task.getEntityNumber());
        jobEntity.setBusinessKey(task.getBusinessKey());
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, entity.getTaskId());
        payload.put("assigneeid", entity.getAssigneeid());
        payload.put("ownerId", entity.getOwnerId());
        payload.put("status", entity.isStatus());
        payload.put("subscribe", entity.isSubscribe());
        payload.put("type", entity.getType());
        payload.put("assignee", entity.getAssignee());
        payload.put("processDefinitionId", entity.getProcessDefinitionId());
        payload.put("processInstanceId", entity.getProcessInstanceId());
        payload.put(BUSINESSKEY, entity.getBusinessKey());
        payload.put(BILLNO, entity.getBillNo());
        payload.put("taskHandleLogEntityId", entity.getId());
        payload.put("_lockKey_", new RepeatJobModel(String.format("transferJob-%s", entity.getTaskId()), RepeatJobModel.JobLockedStrategy.DISCARD, "createTaskTransferHandler"));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createWithdrawTaskTransferHandler(Map<String, Long> taskIdAndOwnerId) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(false, "async-taskTransfer");
        TaskEntity task = (TaskEntity)this.getCommandContext().getTaskEntityManager().findById(taskIdAndOwnerId.get(TASKID));
        jobEntity.setProcessDefinitionId(task.getProcessDefinitionId());
        jobEntity.setProcessInstanceId(task.getProcessInstanceId());
        jobEntity.setElementId(task.getTaskDefinitionKey());
        jobEntity.setEntityNumber(task.getEntityNumber());
        jobEntity.setBusinessKey(task.getBusinessKey());
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(TASKID, taskIdAndOwnerId.get(TASKID));
        payload.put("assigneeid", taskIdAndOwnerId.get("withdrawerId"));
        this.fillPayload(jobEntity, payload);
        return jobEntity;
    }

    @Override
    public JobEntity createCompensationTaskJob(TaskEntity task, Map<String, Object> variables) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(task, true, "async-compensationTaskJob");
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        if (variables != null) {
            tmp.put("varaibles", variables);
        }
        RepeatJobModel rjModel = new RepeatJobModel(String.valueOf(task.getId()), RepeatJobModel.JobLockedStrategy.DISCARD, "CompensationTask");
        tmp.put("_lockKey_", rjModel);
        tmp.put(TASKID, task.getId());
        tmp.put("_billno_", task.getBillNo());
        this.fillPayload(jobEntity, tmp);
        return jobEntity;
    }

    @Override
    public JobEntity createCompensationConvertTaskJob(TaskEntity task, Map<String, Object> variables) {
        JobEntity jobEntity = this.internalCreateLockedAsyncJob(task, true, "async-compensationTaskJob");
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        if (variables != null) {
            tmp.put("varaibles", variables);
        }
        tmp.put("convertTask", Boolean.TRUE);
        RepeatJobModel rjModel = new RepeatJobModel(String.valueOf(task.getId()), RepeatJobModel.JobLockedStrategy.DISCARD, "CompensationConvertTask");
        tmp.put("_lockKey_", rjModel);
        tmp.put(TASKID, task.getId());
        this.fillPayload(jobEntity, tmp);
        return jobEntity;
    }

    @Override
    public TimerJobEntity createTimeJobForCheckToDoJob(MessageContext ctx, ToDoInfo model, String serviceKey) {
        TimerJobEntity timerJobEntity = this.internalCreateAsyncTimerJob(ctx, true, "async-todo");
        timerJobEntity.setRetries(MessageServiceUtil.getJobEntityRestries(timerJobEntity, serviceKey, timerJobEntity.getRetries()));
        timerJobEntity.setJobType("message");
        GregorianCalendar newDateCal = new GregorianCalendar();
        Date now = WfUtils.now();
        newDateCal.setTime(now);
        ((Calendar)newDateCal).add(12, 2);
        timerJobEntity.setDuedate(newDateCal.getTime());
        model.setState(ToDoInfo.State.ONLYCHECK);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("context", SerializationUtils.toJsonString((Object)ctx));
        payload.put("model", SerializationUtils.toJsonString((Object)model));
        if (model.getNotifyType().contains("yunzhijiaeco")) {
            payload.put("service", "yunzhijiaeco");
        } else {
            payload.put("service", "yunzhijia");
        }
        this.fillBillNo(payload);
        payload.put("_requestContext_", WfUtils.dumpRequestContext(RequestContext.get()));
        this.addExtraVariable(payload);
        timerJobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        this.getTimerJobEntityManager().insert(timerJobEntity);
        return timerJobEntity;
    }

    @Override
    public JobEntity reSendExecutableJobByJob(JobEntity job) {
        if (job == null) {
            throw new WFEngineException("Empty async job can not be scheduled");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(job);
        executableJob.setRootJobId(job.getId());
        executableJob.setState(JobStateEnum.CREATED.getNumber());
        executableJob.setId(null);
        boolean insertSuccesful = this.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccesful) {
            logger.debug(String.format("job[%s] is reSendExecutableJobByJob,reties[%s]", executableJob.getId(), executableJob.getRetries()));
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public void reSendExecutableJob(JobEntity job) {
        if (job != null) {
            job.setState(JobStateEnum.CREATED.getNumber());
            JobUtil.setJobLockProperty(job, this.processEngineConfiguration, this.getAsyncExecutor());
            this.getJobEntityManager().update(job);
            logger.debug(String.format("job[%s] is resend, retires[%s]", job.getId(), job.getRetries()));
            if (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
                WfTraceType.get().getJobInfo().addJobsAfterJobExecute(job);
            }
        }
    }

    @Override
    public DeadLetterJobEntity createParentBizFlowDonothingDeadLetterJob(ExecutionEntity execution, ILocaleString suspendReason) {
        DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)this.getDeadLetterJobEntityManager().create();
        deadLetterJob.setJobType("message");
        deadLetterJob.setRetries(this.processEngineConfiguration.getAsyncExecutorNumberOfRetries());
        deadLetterJob.setExecutionId(execution == null ? null : execution.getId());
        deadLetterJob.setProcessInstanceId(execution == null ? null : execution.getProcessInstanceId());
        deadLetterJob.setProcessDefinitionId(execution == null ? null : execution.getProcessDefinitionId());
        deadLetterJob.setExclusive(false);
        deadLetterJob.setBusinessKey(execution == null ? null : execution.getBusinessKey());
        deadLetterJob.setEntityNumber(execution == null ? null : execution.getEntityNumber());
        deadLetterJob.setJobHandlerType("donothing-event");
        deadLetterJob.setElementId(execution == null ? null : execution.getCurrentActivityId());
        deadLetterJob.setOrgUnitId(execution == null ? null : execution.getMainOrgId());
        deadLetterJob.setBizTraceNo(execution == null ? null : execution.getBizTraceNo());
        deadLetterJob.setExceptionMessage(suspendReason == null ? " " : suspendReason.getLocaleValue());
        if (WfTraceType.getOrCreate().getJobInfo() != null) {
            deadLetterJob.setSrcJobId(WfTraceType.getOrCreate().getJobInfo().getCurrentJobId());
        }
        deadLetterJob.setElementName(execution == null ? null : execution.getActivityName());
        deadLetterJob.setEntrabillname(execution == null ? null : execution.getEntraBillName());
        deadLetterJob.setSubject(execution == null ? null : execution.getSubject());
        deadLetterJob.setErrorCode("bos.wf.bizflowDonothing");
        deadLetterJob.setErrorType("engine");
        RequestContext requestContext = RequestContext.get();
        HashMap<String, Object> payload = new HashMap<String, Object>(8);
        Map<String, Object> context = WfUtils.dumpRequestContext(requestContext);
        payload.put("_requestContext_", context);
        this.addExtraVariable(payload);
        deadLetterJob.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        deadLetterJob.setRootTraceNo(RequestContext.get().getTraceId());
        return deadLetterJob;
    }

    @Override
    public JobEntity createTestMQJob() {
        JobEntity jobEntity = (JobEntity)this.getJobEntityManager().create();
        jobEntity.setJobType("message");
        jobEntity.setRetries(0);
        jobEntity.setJobHandlerType("donothing-event");
        RequestContext requestContext = RequestContext.get();
        HashMap<String, Object> payload = new HashMap<String, Object>(8);
        Map<String, Object> context = WfUtils.dumpRequestContext(requestContext);
        payload.put("_requestContext_", context);
        payload.put("mq_support_tool", "mq_support_tool");
        this.addExtraVariable(payload);
        jobEntity.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        jobEntity.setRootTraceNo(RequestContext.get().getTraceId());
        jobEntity.setSource(JobHandleStrategyFactory.getWFSource());
        jobEntity.setState(JobStateEnum.CREATED.getNumber());
        return jobEntity;
    }

    private void addExtraVariable(Map<String, Object> payload) {
        this.addSeparateStorageKey(payload);
        this.addBusinessObjectDataSource(payload);
    }

    private void addSeparateStorageKey(Map<String, Object> payload) {
        String separateStorageKey;
        if (payload != null && WfUtils.isNotEmpty(separateStorageKey = (String)ThreadTruck.get((Object)"separateStorageKey"))) {
            payload.put("separateStorageKey", separateStorageKey);
        }
    }

    private void addBusinessObjectDataSource(Map<String, Object> payload) {
        Object businessObjectDataSource;
        if (payload != null && (businessObjectDataSource = ThreadTruck.get((Object)"businessObjectDataSource")) != null) {
            payload.put("businessObjectDataSource", businessObjectDataSource);
        }
    }
}

