/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.ExecuteAsyncJobCmd;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.BizErrorInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFRequestTimeoutException;
import kd.bos.workflow.exception.WFVerifySqlSaveException;

public class ExecuteAsyncRunnable
implements Runnable {
    private static Log log = LogFactory.getLog(ExecuteAsyncRunnable.class);
    protected ExecuteJob job;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ExecuteAsyncRunnable(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public ExecuteAsyncRunnable(ExecuteJob job, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.job = job;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public void run() {
        if (this.job != null) {
            try {
                this.processEngineConfiguration.getCommandExecutor().execute(new ExecuteAsyncJobCmd(this.job));
            }
            catch (WFVerifySqlSaveException exception) {
                log.error(String.format("Wf VerifySqlError jobId[%s] on finished: %s", this.job.getId(), exception.getMessage()));
            }
            catch (Throwable exception2) {
                try {
                    WFRequestTimeoutException exception2;
                    BizErrorInfo bizErrorInfo = ExceptionUtil.getErrorCodeAndMsg(exception2);
                    if (BosErrorCode.govRequestTimeout.getCode().equals(bizErrorInfo.getErrCode())) {
                        exception2 = new WFRequestTimeoutException(new Object[0]);
                    }
                    String message = "Job " + this.job.getId() + " failed to execute, error msg is [" + WfUtils.getExceptionStacktrace((Throwable)((Object)exception2)) + "],try to handle failed job.";
                    log.error(message);
                    this.handleFailedJob((Throwable)((Object)exception2));
                }
                catch (WFVerifySqlSaveException WFVerifySqlSaveException2) {
                    log.error(String.format("Wf handleFailedJob VerifySqlError jobId[%s] on errored: %s", this.job.getId(), WFVerifySqlSaveException2.getMessage()));
                }
                catch (Exception e) {
                    String message = "Job " + this.job.getId() + " failed to retry, error msg is [" + WfUtils.getExceptionStacktrace(exception2) + "], will throw exceptions to jobprocess.";
                    log.info(message);
                    throw new KDException((Throwable)e, WFErrorCode.jobExecutingError(), new Object[]{this.job.getId(), WfUtils.getExceptionStacktrace(e)});
                }
            }
        } else {
            log.warn("ExecuteAsyncRunnable Job is null!");
        }
    }

    protected void handleFailedJob(Throwable exception) {
        JobUtil.handleFailedJob(this.processEngineConfiguration, this.job, exception);
    }
}

