/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor.schedule;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.ProcessEngineConfiguration;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cmd.job.AcquireJobsCmd;
import kd.bos.workflow.engine.impl.cmd.job.TaskJobHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class AcquireAsyncJobsDueTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(AcquireAsyncJobsDueTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        log.debug("{} starting to acquire async jobs due");
        if (!ProcessEngines.isInitialized()) {
            return;
        }
        try {
            AsyncExecutor asyncExecutor = this.getAsyncExecutor();
            CommandExecutor commandExecutor = asyncExecutor.getProcessEngineConfiguration().getCommandExecutor();
            final List<JobEntity> acquiredJobs = commandExecutor.execute(new AcquireJobsCmd(asyncExecutor));
            if (acquiredJobs != null && acquiredJobs.size() > 0) {
                asyncExecutor.getProcessEngineConfiguration().getCommandExecutor().execute(new Command<Void>(){

                    @Override
                    public Void execute(CommandContext commandContext) {
                        JobUtil.sendJobToMQ(acquiredJobs);
                        return null;
                    }
                });
            }
        }
        finally {
            log.debug("{} stopped async job due acquisition");
        }
        try {
            if (param == null || param.get("executeNewTaskJobSchedule") == null || WfUtils.isEmpty((String)param.get("executeNewTaskJobSchedule"))) {
                TaskJobHelper.getTaskJobManagerProvider().executeDueTaskSchedule(context, param);
            }
        }
        finally {
            log.debug("{} stopped async Taskjob due acquisition");
        }
    }

    public AsyncExecutor getAsyncExecutor() {
        ProcessEngineConfiguration configuration = ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        AsyncExecutor asyncExecutor = configuration.getAsyncExecutor();
        return asyncExecutor;
    }
}

