/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.devopos.WFDevopsUtils;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.ProcessEngineConfiguration;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.AcquireTimerJobsCmd;
import kd.bos.workflow.engine.impl.cmd.job.TaskJobHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;

public class AcquireTimerJobsTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(AcquireTimerJobsTask.class);

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        long start;
        block23: {
            start = System.currentTimeMillis();
            log.debug("{} starting to acquire async jobs due");
            if (!ProcessEngines.isInitialized()) {
                return;
            }
            try {
                CommandExecutor commandExecutor;
                List<TimerJobEntity> acquiredJobs;
                AsyncExecutor asyncExecutor = this.getAsyncExecutor();
                char[] supports = new char[]{};
                String index = "";
                if (param != null) {
                    String val = (String)param.get("mods");
                    if (null != val) {
                        supports = val.toCharArray();
                    }
                    index = (String)param.get("index");
                }
                if ((acquiredJobs = (commandExecutor = asyncExecutor.getProcessEngineConfiguration().getCommandExecutor()).execute(new AcquireTimerJobsCmd(asyncExecutor))) == null || acquiredJobs.isEmpty()) break block23;
                Object threeTimerTasks = WfConfigurationUtil.getConfigCenterVal("workflow.jobs.splitMultiTimerTasks");
                if ("true".equals(threeTimerTasks) && supports.length > 0) {
                    Arrays.sort(supports);
                    ArrayList<TimerJobEntity> filteredJobs = new ArrayList<TimerJobEntity>();
                    for (TimerJobEntity tjob : acquiredJobs) {
                        String id = String.valueOf(tjob.getId());
                        char end = id.charAt(id.length() - 1);
                        if (Arrays.binarySearch(supports, end) <= -1) continue;
                        filteredJobs.add(tjob);
                    }
                    acquiredJobs.clear();
                    acquiredJobs.addAll(filteredJobs);
                }
                log.debug(String.format("AcquireTimerJobsTask acquiredJobs size is %s,%s,%s", acquiredJobs.size(), String.valueOf(supports), index));
                DLock lock = DLock.create((String)("wf/movetimerJobsToExecute" + index), (String)"move timerJobs to executableJob").fastMode();
                Object object = null;
                try {
                    boolean canLock = lock.tryLock(60000L);
                    if (canLock) {
                        commandExecutor.execute(new Command<Void>(){

                            @Override
                            public Void execute(CommandContext commandContext) {
                                ArrayList<JobEntity> executeJobs = new ArrayList<JobEntity>(acquiredJobs.size());
                                JobManager jobManager = AcquireTimerJobsTask.this.getJobManager();
                                for (TimerJobEntity job : acquiredJobs) {
                                    executeJobs.add(jobManager.moveTimerJobToExecutableJob(job));
                                }
                                jobManager.batchScheduleAsyncJob(executeJobs);
                                AcquireTimerJobsTask.this.collectMessageData(acquiredJobs);
                                return null;
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (lock != null) {
                        if (object != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            lock.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.info(WfUtils.getExceptionStacktrace(e));
            }
        }
        try {
            if (param == null || param.get("executeNewTaskJobSchedule") == null || WfUtils.isEmpty((String)param.get("executeNewTaskJobSchedule"))) {
                TaskJobHelper.getTaskJobManagerProvider().executeTimerTaskSchedule(context, param);
            }
        }
        catch (Exception e) {
            log.info("TaskJobe xecute Filed :" + WfUtils.getExceptionStacktrace(e));
        }
        long end = System.currentTimeMillis();
        log.debug(String.format("AcquireTimerJobsTask end%s - start%s = %s", end, start, end - start));
    }

    public AsyncExecutor getAsyncExecutor() {
        ProcessEngineConfiguration configuration = ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        AsyncExecutor asyncExecutor = configuration.getAsyncExecutor();
        return asyncExecutor;
    }

    public JobManager getJobManager() {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        JobManager dataManager = configuration.getJobManager();
        return dataManager;
    }

    private void collectMessageData(List<TimerJobEntity> jobs) {
        Date asyncMessageStartTime = WFDevopsUtils.getAsyncMessageStartTime();
        int addressAddCount = 0;
        HashMap<String, Map<Long, Integer>> map = new HashMap<String, Map<Long, Integer>>(2);
        map.put("timer", new HashMap(500));
        map.put("message", new HashMap(500));
        for (TimerJobEntity job : jobs) {
            boolean isOld = job.getCreateDate().before(asyncMessageStartTime);
            if ("address-process-event".equalsIgnoreCase(job.getJobHandlerType()) && !isOld) {
                ++addressAddCount;
                continue;
            }
            if (WfUtils.isEmpty(job.getProcessDefinitionId())) continue;
            Map joinJobsMap = "timer".equals(job.getJobType()) ? (Map)map.get("timer") : (Map)map.get("message");
            if (StringUtils.isNotBlank(joinJobsMap.get(job.getProcessDefinitionId()))) {
                joinJobsMap.put(job.getProcessDefinitionId(), (Integer)joinJobsMap.get(job.getProcessDefinitionId()) + 1);
                continue;
            }
            joinJobsMap.put(job.getProcessDefinitionId(), 1);
        }
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(jobs.size());
        infos.addAll(this.batchBuildIndicatorInfo(map, addressAddCount));
        WorkflowDevopsService.create().batchExceutionDataCollection(infos);
    }

    private List<IndicatorInfo> batchBuildIndicatorInfo(Map<String, Map<Long, Integer>> versionJobsMap, int addressCount) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(versionJobsMap.size());
        for (Map.Entry<String, Map<Long, Integer>> entry : versionJobsMap.entrySet()) {
            if ("timer".equals(entry.getKey())) {
                entry.getValue().forEach((key, value) -> {
                    IndicatorInfo indicatorInfo = new IndicatorInfo("asyncMessage", (Object)"product", -value.intValue());
                    indicatorInfo.addToSpecialProperty("procDefId", key);
                    infos.add(indicatorInfo);
                });
                continue;
            }
            entry.getValue().forEach((key, value) -> {
                IndicatorInfo indicatorInfo = new IndicatorInfo("asyncMessage", (Object)"timing", -value.intValue());
                indicatorInfo.addToSpecialProperty("procDefId", key);
                infos.add(indicatorInfo);
            });
        }
        if (addressCount > 0) {
            IndicatorInfo indicatorInfo = new IndicatorInfo("addressMessage", (Object)"timing", -addressCount);
            infos.add(indicatorInfo);
        }
        return infos;
    }
}

