/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class ClearHistoryDataTask
extends AbstractTask {
    protected Log logger = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final Object MTABLES_STR = "mTables";
    private static final String HIVARIABLEDATE = "hiVariableDate";

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        if (param != null && !param.isEmpty()) {
            String mTables = (String)param.get(MTABLES_STR);
            this.removeMultiLangTables(mTables);
        }
        this.removeParticipantTable();
        this.removeHiVariableTables();
    }

    /*
     * Unable to fully structure code
     */
    private void removeHiVariableTables() {
        obj = (String)WfConfigurationUtil.getConfigCenterVal("hiVariableDate");
        lastDate = null;
        if (obj == null) {
            ds = DB.queryDataSet((String)"removeHiVariableTables", (DBRoute)DBRoute.workflow, (String)"SELECT MIN(FENDTIME) AS minDate FROM T_WF_HIPROCINST WHERE FENDTIME IS NOT NULL");
            var4_5 = null;
            try {
                if (ds == null || !ds.hasNext()) ** GOTO lbl30
                row = ds.next();
                lastDate = row.getDate("minDate");
            }
            catch (Throwable row) {
                var4_5 = row;
                throw row;
            }
            finally {
                if (ds != null) {
                    if (var4_5 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row) {
                            var4_5.addSuppressed(row);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        } else {
            try {
                lastDate = DateFormat.getInstance().parse(obj);
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
lbl30:
        // 4 sources

        if (lastDate == null) {
            return;
        }
        endTime = new Date(lastDate.getTime() + 2592000000L);
        querySql = "SELECT TOP 5000 FID,FENDTIME FROM t_wf_hiprocinst where FENDTIME is not null and FENDTIME >= ? and FENDTIME < ?";
        tmp = lastDate;
        ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql, (Object[])new Object[]{lastDate, endTime}, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                Date m = tmp;
                ArrayList<Object[]> ret = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] t = new Object[]{rs.getLong("FID")};
                    ret.add(t);
                    m = rs.getDate("FENDTIME");
                }
                DynamicObject value = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"id,key,value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)ClearHistoryDataTask.HIVARIABLEDATE)});
                if (value == null) {
                    value = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_confcenter"));
                    value.set("key", (Object)ClearHistoryDataTask.HIVARIABLEDATE);
                }
                value.set("value", (Object)DateFormat.getInstance().format(m));
                DynamicObject[] dynObjs = new DynamicObject[]{value};
                SaveServiceHelper.save((DynamicObject[])dynObjs);
                return ret;
            }
        });
        batchSql = "DELETE FROM t_wf_hivarinst WHERE FPROCINSTID = ? and fname not in ('appnumber','pageParameter')";
        WfUtils.executeBatch(batchSql, ids, 2000);
    }

    private void removeParticipantTable() {
        this.removeParticipant();
    }

    private void removeParticipant() {
        String querySql = "SELECT TOP 10000 FID FROM t_wf_hiparticipant where FPROCINSTID>0 and FTASKID=0 ";
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                ArrayList<Object[]> ret = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] t = new Object[]{rs.getLong("FID")};
                    ret.add(t);
                }
                return ret;
            }
        });
        String deleteSQL = "Delete from t_wf_participant where FID=? ";
        WfUtils.executeBatch(deleteSQL, ids, 2000);
        deleteSQL = "Delete from t_wf_participant_l where FID=? ";
        WfUtils.executeBatch(deleteSQL, ids, 2000);
        deleteSQL = "Delete from t_wf_hiparticipant where FID=? ";
        WfUtils.executeBatch(deleteSQL, ids, 2000);
        deleteSQL = "Delete from t_wf_hiparticipant_l where FID=? ";
        WfUtils.executeBatch(deleteSQL, ids, 2000);
    }

    private void removeMultiLangTables(String mTables) {
        Object obj = JSON.parse((String)mTables);
        JSONObject jsonObject = (JSONObject)obj;
        if (jsonObject != null) {
            for (String key : jsonObject.keySet()) {
                String removeLang = (String)jsonObject.get((Object)key);
                this.removeTableData(key, removeLang);
            }
        }
    }

    private void removeTableData(String key, String removeLang) {
        StringBuilder sb = new StringBuilder();
        if (removeLang != null) {
            String[] arr;
            sb.append("(");
            for (String t : arr = StringUtils.split((String)removeLang, (String)",")) {
                if (!WfUtils.isNotEmpty(t) || "zh_CN".equalsIgnoreCase(t) || "zh-CN".equalsIgnoreCase(t) || "CN".equalsIgnoreCase(t)) continue;
                sb.append("'").append(t).append("'").append(",");
            }
            if (sb.length() == 1) {
                return;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        String querySql = String.format("SELECT top 10000 FPKID FROM %s where FLOCALEID in %s ", key, sb.toString());
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql, (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                ArrayList<Object[]> ret = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] t = new Object[]{rs.getString("FPKID")};
                    ret.add(t);
                }
                return ret;
            }
        });
        String deleteSQL = String.format("Delete from %s where FPKID=? ", key);
        WfUtils.executeBatch(deleteSQL, ids, 2000);
    }
}

