/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.asyncexecutor.schedule;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.MessageCommonService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class HandleFailedJobsTask
extends AbstractTask {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        this.handleFailJobs();
        this.resendFailMessages();
    }

    private void handleFailJobs() {
        if (!ProcessEngines.isInitialized()) {
            this.log.debug("HandleFailedJobsTask_init success");
            return;
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        try {
            String entityNumbers = WfConfigurationUtil.getNeedUpdateExtFieldEntitynumbers();
            this.log.debug("HandleFailedJobsTask_entityNumbers:" + entityNumbers);
            if (StringUtils.isNotBlank((CharSequence)entityNumbers)) {
                service.getTaskService().repairTaskBusinessField(entityNumbers);
            }
        }
        catch (Exception e) {
            this.log.error("\u66f4\u65b0\u5f85\u529e\u4efb\u52a1\u8868\u7684\u4e1a\u52a1\u5b57\u6bb5\u5386\u53f2\u6570\u636e\u5931\u8d25,\u5931\u8d25\u539f\u56e0:" + e.getMessage());
            return;
        }
        try {
            if (!WfConfigurationUtil.isEnableAnyMessageChannel()) {
                this.log.info("HandleFailedJobsTask#handleFailJobs#allChannelDisable");
                return;
            }
            service.getRuntimeService().scheduleHandleFailedJobs();
        }
        catch (Exception e) {
            this.log.error("\u5904\u7406\u5931\u8d25\u5f85\u529etodo, \u5931\u8d25\u539f\u56e0:" + e.getMessage());
        }
    }

    private void resendFailMessages() {
        MessageCommonService messageCommonService = (MessageCommonService)ServiceFactory.getService(MessageCommonService.class);
        messageCommonService.handleFailMessages();
    }
}

