/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.AggregateInfo;
import kd.bos.workflow.engine.extitf.AggregateResult;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.BillCalculatorFactory;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.TargetBillsFilterCondition;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFTargetBillFilterException;

public class BillCalculatorExecutor {
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private BillCalculatorFactory bcFactory;
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());

    public BillCalculatorExecutor(ProcessEngineConfigurationImpl p) {
        this.processEngineConfiguration = p;
        this.bcFactory = BillCalculatorFactory.get();
    }

    public BillCalculatorResult execute(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        BillCalculatorCtx ctx = this.bcFactory.buildContext(execution, incomgingFlow, extraVars);
        BillCalculatorResult result = this.aggregationBills(execution, incomgingFlow, ctx);
        if (result == null) {
            result = this.bcFactory.execute(execution, ctx);
            this.collectOriginalExecutions(execution, ctx, result);
        }
        return result;
    }

    private BillCalculatorResult aggregationBills(ExecutionEntity execution, SequenceFlow incomgingFlow, BillCalculatorCtx ctx) {
        if (incomgingFlow != null && this.isAggregationCalculator(ctx) && incomgingFlow.isEnableAggregation()) {
            String vname = String.format("%s.%s", "aggregationPks", incomgingFlow.getId());
            HashSet<String> aggregationColls = new HashSet<String>(4);
            String aggregationGroup = (String)execution.getProcessInstance().getVariable(vname);
            if (WfUtils.isNotEmpty(aggregationGroup)) {
                aggregationColls = (Set)SerializationUtils.fromJsonString((String)aggregationGroup, Set.class);
            }
            aggregationColls.add(execution.getBusinessKey());
            String aggregationType = incomgingFlow.getAggregationType();
            if ("pluginAggregate".equals(aggregationType)) {
                if (WfUtils.isEmpty(incomgingFlow.getAggregationPlugin())) {
                    throw new WFException(WFErrorCode.aggregationError(), ResManager.loadKDString((String)"\u63d2\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u805a\u5408\u63d2\u4ef6\u3002", (String)"BillCalculatorExecutor_0", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                JSONObject json = (JSONObject)JSONObject.parse((String)incomgingFlow.getAggregationPlugin());
                String plugin = json.getString("value");
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)execution.getEntityNumber());
                String appId = dt.getAppId();
                AggregateInfo info = new AggregateInfo();
                info.putBills(execution.getEntityNumber(), aggregationColls);
                this.logger.debug(String.format("AggregateInfo[%s],execution[%s],aggregationColls[%s]", info, execution, WfUtils.listToString(aggregationColls, ",")));
                AggregateResult ret = (AggregateResult)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBizPlugin", (Object[])new Object[]{plugin, "aggregateBills", new Object[]{execution, info}});
                this.logger.debug(String.format("AggregateResult[%s]", ret));
                if (!ret.isOver()) {
                    BillCalculatorResult result = new BillCalculatorResult();
                    result.setConversionType(ctx.getType());
                    result.setState("blocking");
                    execution.getProcessInstance().setVariable(vname, SerializationUtils.toJsonString(aggregationColls));
                    return result;
                }
                ctx.setSrcPkIds(ret.getBillPks());
                aggregationColls.removeAll(ret.getBillPks());
                if (aggregationColls.isEmpty()) {
                    execution.getProcessInstance().removeVariable(vname);
                } else {
                    execution.getProcessInstance().setVariable(vname, SerializationUtils.toJsonString(aggregationColls));
                }
            } else if ("executionAggregate".equals(aggregationType)) {
                String aggregationActivityId = incomgingFlow.getTargetRef();
                BpmnModel model = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
                List<FlowElement> preNodes = BpmnModelUtil.getPreviousNodes(model, aggregationActivityId);
                HashSet<String> preNodeIds = new HashSet<String>(preNodes.size());
                for (FlowElement ele : preNodes) {
                    preNodeIds.add(ele.getId());
                }
                preNodeIds.remove(aggregationActivityId);
                this.logger.debug(WfUtils.listToString(preNodeIds, ","));
                List<ExecutionEntity> activeExecutions = this.processEngineConfiguration.getExecutionEntityManager().findBizActivitySubExecutions(execution.getProcessInstanceId());
                boolean flag = true;
                for (ExecutionEntity e : activeExecutions) {
                    String activityId = e.getActivityId();
                    this.logger.debug(String.format("AggregateInfo[%s-%s]", activityId, e.getBusinessKey()));
                    if (e.isBillExecution() || !preNodeIds.contains(activityId) && !aggregationActivityId.equals(activityId)) continue;
                    flag = aggregationActivityId.equals(activityId);
                    if (!flag || !(flag = aggregationColls.contains(e.getBusinessKey()))) break;
                    if (!e.getParent().isBillExecution() || !aggregationActivityId.equals(activityId)) continue;
                    aggregationColls.add(e.getBusinessKey());
                }
                if (flag) {
                    ctx.setSrcPkIds(aggregationColls);
                    execution.getProcessInstance().removeVariable(vname);
                } else {
                    execution.getProcessInstance().setVariable(vname, SerializationUtils.toJsonString(aggregationColls));
                    BillCalculatorResult result = new BillCalculatorResult();
                    result.setConversionType(ctx.getType());
                    result.setState("blocking");
                    return result;
                }
            }
        }
        return null;
    }

    private void collectOriginalExecutions(ExecutionEntity execution, BillCalculatorCtx ctx, BillCalculatorResult result) {
        HashSet<Long> originalIds = new HashSet<Long>();
        String currentActivityId = execution.getActivityId();
        List<ExecutionEntity> activeExecutions = this.processEngineConfiguration.getExecutionEntityManager().findBizActivitySubExecutions(execution.getProcessInstanceId());
        if (result.getOriginalExecutions() != null) {
            for (ExecutionEntity e : result.getOriginalExecutions()) {
                originalIds.add(e.getId());
            }
        } else {
            result.setOriginalExecutions(new ArrayList<ExecutionEntity>());
        }
        for (ExecutionEntity e : activeExecutions) {
            if (e.isBillExecution() || originalIds.contains(e.getId()) || e.getParent() == null || !e.getParent().isBillExecution() || ctx.getSrcPkIds() == null || !ctx.getSrcPkIds().contains(e.getBusinessKey()) || !WfUtils.isNotEmpty(currentActivityId) || !currentActivityId.equals(e.getCurrentActivityId())) continue;
            result.getOriginalExecutions().add(e);
        }
    }

    protected boolean isAggregationCalculator(BillCalculatorCtx ctx) {
        String converType = ctx.getType();
        if (converType.equals("manualMountMultiSrcsBillCalculate") || converType.equals("originalBillCalculate")) {
            return false;
        }
        if ("botpBillCalculate".equals(converType)) {
            BillRelationshipModel convInfo = (BillRelationshipModel)ctx.getExtraVariable().get("conversionInfo");
            return convInfo != null && "auto".equals(convInfo.getConversionMode());
        }
        return true;
    }

    public boolean isSupportTargetBillsFilter(CommandContext commandContext, ExecutionEntity execution, SequenceFlow incomingFlow) {
        SequenceFlow sequenceFlow;
        BillRelationshipModel relationshipModel = null;
        String sequenceFlowId = "";
        if (incomingFlow != null) {
            relationshipModel = incomingFlow.getBillRelationshipModel();
            sequenceFlowId = incomingFlow.getId();
        } else if (execution != null && (sequenceFlow = this.tryGetIncomingFlowByExec(commandContext, execution)) != null) {
            relationshipModel = sequenceFlow.getBillRelationshipModel();
            sequenceFlowId = sequenceFlow.getId();
        }
        if (relationshipModel != null) {
            if ("botpTargetBills".equals(relationshipModel.getRelationType()) && !"auto".equals(relationshipModel.getConversionMode())) {
                this.logger.debug(String.format("current incomingFlowId: [%s], relationType: [%s], conversionMode: [%s]. Not currently supported target bills filter.", sequenceFlowId, "botpTargetBills", relationshipModel.getConversionMode()));
                return false;
            }
            this.logger.debug(String.format("current incomingFlowId: [%s], relationType: [%s], conversionMode: [%s]. Support target bills filter.", sequenceFlowId, relationshipModel.getRelationType(), relationshipModel.getConversionMode()));
            return true;
        }
        return false;
    }

    public SequenceFlow tryGetIncomingFlowByExec(CommandContext commandContext, ExecutionEntity execution) {
        if (execution != null) {
            HistoricActivityInstanceEntityManager hiActInstanceEntityManager = commandContext.getHistoricActivityInstanceEntityManager();
            HistoricActivityInstanceEntity incomingFlowActInst = (HistoricActivityInstanceEntity)hiActInstanceEntityManager.findById(execution.getCurrentActInstId());
            if (incomingFlowActInst != null && !"SequenceFlow".equals(incomingFlowActInst.getActivityType())) {
                incomingFlowActInst = (HistoricActivityInstanceEntity)hiActInstanceEntityManager.findById(incomingFlowActInst.getSourceElementId());
            }
            String incomingFlowActId = incomingFlowActInst != null ? incomingFlowActInst.getActivityId() : "";
            SequenceFlow incomingFlow = (SequenceFlow)ProcessDefinitionUtil.getFlowElement(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), incomingFlowActId);
            return incomingFlow;
        }
        return null;
    }

    public void doFilter(BillCalculatorResult result, SequenceFlow inFlow) {
        List<Object> filterResult = this.getFilterResult(result, result.getTargetBills(), inFlow);
        if (WfUtils.isNotEmptyForCollection(filterResult)) {
            String targetEntityNumber = inFlow.getTargetBillsFilterCondition().getTargetEntityNumber();
            this.updateBillCalculatorResult(result, targetEntityNumber, filterResult);
        }
    }

    public void doFilter(BillCalculatorResult result, Map<String, Set<String>> targetBills, SequenceFlow incomingFlow) {
        List<Object> filterResult = this.getFilterResult(result, targetBills, incomingFlow);
        if (WfUtils.isNotEmptyForCollection(filterResult)) {
            Set filterResultSet = filterResult.stream().map(String::valueOf).collect(Collectors.toSet());
            String targetEntityNumber = incomingFlow.getTargetBillsFilterCondition().getTargetEntityNumber();
            targetBills.put(targetEntityNumber, filterResultSet);
        }
    }

    public boolean doFilter(SequenceFlow incomingFlow, String entityNumber, String businessKey) {
        String targetEntityNumber;
        FilterCondition filterCondition = this.getFilterCondition(incomingFlow);
        if (filterCondition != null && StringUtils.equals((CharSequence)(targetEntityNumber = incomingFlow.getTargetBillsFilterCondition().getTargetEntityNumber()), (CharSequence)entityNumber)) {
            this.logger.debug(String.format("start filter target bills. incomingFlowId:[%s], entityNumber:[%s], businessKey:[%s]", incomingFlow.getId(), entityNumber, businessKey));
            ISimpleProperty prop = EntityMetadataCache.getDataEntityType((String)entityNumber).getPrimaryKey();
            QFilter filter = null;
            filter = prop instanceof LongProp ? new QFilter("id", "=", (Object)Long.parseLong(businessKey)) : new QFilter("id", "=", (Object)businessKey);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition);
            filterBuilder.buildFilter(false);
            filter.and(filterBuilder.getQFilter());
            List pks = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])new QFilter[]{filter}, null, (int)1);
            this.logger.debug(String.format("filter result: \u8fc7\u6ee4\u6761\u4ef6\u5b9e\u4f53\u7f16\u7801[%s]\uff0c\u8fc7\u6ee4\u6761\u4ef6[%s]\uff0c\u8fc7\u6ee4\u4e4b\u524d\u7684\u6570\u91cf[%s]\uff0c\u8fc7\u6ee4\u540e\u7684\u6570\u91cf[%s]", targetEntityNumber, filterBuilder.getFilterString().replaceAll("\\s+", " ").trim(), 1, pks.size()));
            if (WfUtils.isEmptyForCollection(pks)) {
                return false;
            }
        }
        return true;
    }

    private List<Object> getFilterResult(BillCalculatorResult result, Map<String, Set<String>> targetBills, SequenceFlow incomingFlow) {
        List<Object> filterResult = new ArrayList<Object>(8);
        if (WfUtils.isEmptyForMap(targetBills)) {
            this.logger.debug(String.format("target bills is empty. incomingFlowId:[%s], conversionType:[%s]", incomingFlow.getId(), result.getConversionType()));
        } else {
            this.logger.debug(String.format("start filter target bills. incomingFlowId:[%s], conversionType:[%s]", incomingFlow.getId(), result.getConversionType()));
            FilterCondition filterCondition = this.getFilterCondition(incomingFlow);
            if (filterCondition != null) {
                String targetEntityNumber = incomingFlow.getTargetBillsFilterCondition().getTargetEntityNumber();
                Set<String> targetBillPks = targetBills.get(targetEntityNumber);
                this.logger.debug(String.format("targetEntityNumber[%s], targetBillsQuantity[%s]", targetEntityNumber, targetBillPks.size()));
                if (WfUtils.isNotEmptyForCollection(targetBillPks)) {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
                    ISimpleProperty prop = mainEntityType.getPrimaryKey();
                    QFilter filter = null;
                    if (prop instanceof LongProp) {
                        List pks = targetBillPks.stream().map(Long::parseLong).collect(Collectors.toList());
                        filter = new QFilter("id", "in", pks);
                    } else {
                        filter = new QFilter("id", "in", targetBillPks);
                    }
                    FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
                    filterBuilder.buildFilter(false);
                    filter.and(filterBuilder.getQFilter());
                    filterResult = QueryServiceHelper.queryPrimaryKeys((String)targetEntityNumber, (QFilter[])new QFilter[]{filter}, null, (int)Integer.MAX_VALUE);
                    this.logger.debug(String.format("filter result: \u5355\u636e\u8ba1\u7b97\u7c7b\u578b[%s]\uff0c\u8fc7\u6ee4\u6761\u4ef6\u5b9e\u4f53\u7f16\u7801[%s]\uff0c\u8fc7\u6ee4\u6761\u4ef6[%s]\uff0c\u8fc7\u6ee4\u4e4b\u524d\u7684\u6570\u91cf[%s]\uff0c\u8fc7\u6ee4\u540e\u7684\u6570\u91cf[%s]", result.getConversionType(), targetEntityNumber, filterBuilder.getFilterString().replaceAll("\\s+", " ").trim(), targetBillPks.size(), filterResult.size()));
                    if (WfUtils.isEmptyForCollection(filterResult) && BillCalculatorResult.isStopContinueNoTargetBills(result)) {
                        throw new WFTargetBillFilterException(WFErrorCode.targetBillFilterException(), new Object[]{result.getConversionType(), targetEntityNumber, filterBuilder.getFilterString().replaceAll("\\s+", " ").trim(), targetBillPks.size(), filterResult.size()});
                    }
                }
            }
        }
        return filterResult;
    }

    private FilterCondition getFilterCondition(SequenceFlow sequenceFlow) {
        if (sequenceFlow != null && sequenceFlow.isEnableTargetBillsFilter() && sequenceFlow.getTargetBillsFilterCondition() != null) {
            TargetBillsFilterCondition targetBillsFilterCondition = sequenceFlow.getTargetBillsFilterCondition();
            String targetEntityNumber = targetBillsFilterCondition.getTargetEntityNumber();
            String filterConditionJson = targetBillsFilterCondition.getFilterConditionJson();
            if (WfUtils.isNotEmpty(targetEntityNumber) && WfUtils.isNotEmpty(filterConditionJson)) {
                FilterCondition filterCondition = null;
                try {
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionJson, FilterCondition.class);
                }
                catch (Exception e) {
                    this.logger.error(String.format("\u76ee\u6807\u5355\u8fc7\u6ee4\u6761\u4ef6\u5e8f\u5217\u5316\u9519\u8bef\uff1a%s", WfUtils.getExceptionStacktrace(e)));
                    return null;
                }
                if (filterCondition != null && WfUtils.isNotEmptyForCollection(filterCondition.getFilterRow())) {
                    return filterCondition;
                }
            }
        }
        return null;
    }

    private void updateBillCalculatorResult(BillCalculatorResult result, String targetEntityNumber, List<Object> pks) {
        HashSet<String> filterResult = new HashSet<String>(pks.size());
        Set<String> targetBillPks = result.getTargetBills().get(targetEntityNumber);
        Map<String, String> billsOperation = result.getTargetBillsOperation();
        List pkStr = pks.stream().map(String::valueOf).collect(Collectors.toList());
        for (String billPk : targetBillPks) {
            if (pkStr.contains(billPk)) {
                filterResult.add(billPk);
                continue;
            }
            billsOperation.remove(billPk);
        }
        result.getTargetBills().put(targetEntityNumber, filterResult);
    }
}

