/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.BotpBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.ExpressionBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.IBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.ManualMountMultiSrcsBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.OriginalBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.PluginBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.QueryBotpResultBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.SelfBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class BillCalculatorFactory {
    private Log logger = LogFactory.getLog(this.getClass());
    private static BillCalculatorFactory instance;
    private Map<String, IBillCalculator> billCalculators = new LinkedHashMap<String, IBillCalculator>(16);

    private BillCalculatorFactory() {
        this.billCalculators.put("pluginBillCalculate", new PluginBillCalculator());
        this.billCalculators.put("expressionBillCalculate", new ExpressionBillCalculator());
        this.billCalculators.put("queryBotpResultBillCalculate", new QueryBotpResultBillCalculator());
        this.billCalculators.put("manualMountMultiSrcsBillCalculate", new ManualMountMultiSrcsBillCalculator());
        this.billCalculators.put("selfBillCalculator", new SelfBillCalculator());
        this.billCalculators.put("botpBillCalculate", new BotpBillCalculator());
        this.billCalculators.put("originalBillCalculate", new OriginalBillCalculator());
    }

    public static BillCalculatorFactory get() {
        if (instance == null) {
            instance = new BillCalculatorFactory();
        }
        return instance;
    }

    public BillCalculatorCtx buildContext(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        String argsDesc = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u5355\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u8d85\u51fa\u5355\u636e\u8ba1\u7b97\u8303\u56f4-\u65e0\u6cd5\u521b\u5efa\u5355\u636e\u8ba1\u7b97\u4e0a\u4e0b\u6587\uff1b\u53c2\u6570execution[%1$s],\u5165\u53e3\u7ebf[%2$s],\u5176\u4ed6\u53c2\u6570[%3$s]", (String)"BillCalculatorFactory_1", (String)"bos-wf-engine", (Object[])new Object[0]), execution, incomgingFlow == null ? "null" : incomgingFlow.getId(), extraVars == null ? "null" : SerializationUtils.toJsonString(extraVars));
        this.logger.debug(String.format("\u4e1a\u52a1\u6d41\u5355\u636e\u8ba1\u7b97\u5f02\u5e38\uff0c\u8d85\u51fa\u5355\u636e\u8ba1\u7b97\u8303\u56f4-\u65e0\u6cd5\u521b\u5efa\u5355\u636e\u8ba1\u7b97\u4e0a\u4e0b\u6587\uff1b\u53c2\u6570execution[%1$s],\u5165\u53e3\u7ebf[%2$s],\u5176\u4ed6\u53c2\u6570[%3$s]", execution, incomgingFlow == null ? "null" : incomgingFlow.getId(), extraVars == null ? "null" : SerializationUtils.toJsonString(extraVars)));
        BillCalculatorCtx ctx = null;
        for (IBillCalculator ibc : this.billCalculators.values()) {
            ctx = ibc.createBillContext(execution, incomgingFlow, extraVars);
            if (!WfUtils.isNotEmpty(ctx.getType())) continue;
            return ctx;
        }
        throw new WFException(WFErrorCode.engineError(), argsDesc);
    }

    public BillCalculatorResult execute(ExecutionEntity execution, BillCalculatorCtx context) {
        this.logger.debug(String.format("\u6267\u884c\u5355\u636e\u8ba1\u7b97\uff0c\u53c2\u6570[%s][%s]", execution, context));
        return this.billCalculators.get(context.getType()).convert(execution, context);
    }
}

