/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.ExplicitBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBillCalcException;

public class BotpBillCalculator
extends ExplicitBillCalculator {
    public static final String TYPE = "botpBillCalculate";

    @Override
    public BillCalculatorCtx createBillContext(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        extraVars = extraVars == null ? Collections.emptyMap() : extraVars;
        BillCalculatorCtx ctx = new BillCalculatorCtx();
        String entityNumber = execution.getEntityNumber();
        ArrayList<String> srcPks = (ArrayList<String>)extraVars.get("targetBusinesskeys");
        if (srcPks == null) {
            srcPks = new ArrayList<String>(1);
            srcPks.add(execution.getBusinessKey());
        }
        ctx.setSrcPkIds((Collection<String>)srcPks);
        if (incomgingFlow != null) {
            BillRelationshipModel billReationInfo = incomgingFlow.getBillRelationshipModel();
            if (billReationInfo != null && "botpTargetBills".equals(billReationInfo.getRelationType()) && incomgingFlow.getTargetFlowElement() != null) {
                FlowElement targetFlowElement = incomgingFlow.getTargetFlowElement();
                if (targetFlowElement instanceof IEntitySupport) {
                    ctx.setTagEntityNumber(((IEntitySupport)((Object)targetFlowElement)).getEntityNumber());
                    ctx.setType(TYPE);
                    HashMap<String, Object> extraVariable = new HashMap<String, Object>(2);
                    extraVariable.put("conversionInfo", billReationInfo);
                    extraVariable.put("enableGenerateTarget", incomgingFlow.isEnableGenerateTarget());
                    ctx.setExtraVariable(extraVariable);
                    ctx.setAfterOperation(billReationInfo.getAfteroperation());
                } else if (targetFlowElement instanceof AutoTask) {
                    String entityId = ((AutoTask)targetFlowElement).getEntityId();
                    ctx.setTagEntityNumber(MetadataDao.getNumberById((String)entityId));
                    ctx.setType(TYPE);
                    HashMap<String, Object> extraVariable = new HashMap<String, Object>(2);
                    extraVariable.put("conversionInfo", billReationInfo);
                    extraVariable.put("enableGenerateTarget", incomgingFlow.isEnableGenerateTarget());
                    ctx.setExtraVariable(extraVariable);
                    ctx.setAfterOperation(billReationInfo.getAfteroperation());
                }
            }
            ctx.setTargetFlowElement(incomgingFlow.getTargetFlowElement());
            ctx.setSrcFlowElement(incomgingFlow.getSourceFlowElement());
            FlowElement element = null;
            String billTaskId = BizFlowUtil.findClosestBillTaskId(execution.getId(), incomgingFlow);
            if (WfUtils.isNotEmpty(billTaskId)) {
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getSchemeId(), execution.getProcessInstanceId());
                element = bpmnModel.getFlowElement(billTaskId);
            }
            if (element instanceof BillTask) {
                BillTask billTask = (BillTask)element;
                Map<String, Object> variable = ctx.getExtraVariable();
                if (variable == null) {
                    variable = new HashMap<String, Object>();
                    ctx.setExtraVariable(variable);
                }
                variable.put("billCloseConfig", billTask.getBillCloseConfig());
            }
        }
        ctx.setSrcEntityNumber(entityNumber);
        return ctx;
    }

    @Override
    public void convertRestBills(BillCalculatorResult result, ExecutionEntity execution, BillCalculatorCtx context) {
        try {
            BillRelationshipModel convInfo = (BillRelationshipModel)context.getExtraVariable().get("conversionInfo");
            if ("auto".equals(convInfo.getConversionMode())) {
                this.doBotpConversion(context, result, context.getSrcPkIds(), execution);
            } else {
                result.setConversionType("manualConversion");
            }
        }
        catch (RuntimeException e) {
            if (e instanceof WFBillCalcException) {
                result.setException(e);
            } else {
                result.setException((RuntimeException)((Object)ExceptionUtil.createBotpCalcExeption(e, execution, context)));
            }
            result.logInfo(WfUtils.getExceptionStacktrace(e));
        }
    }
}

