/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.IBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public abstract class ExplicitBillCalculator
implements IBillCalculator {
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());

    protected void tryFindTargetBillBySource(Long[] sourceBills, ExecutionEntity execution, BillCalculatorCtx context, BillCalculatorResult result) {
        Map tgtBillMap = BFTrackerServiceHelper.findTargetBills((String)execution.getEntityNumber(), (Long[])sourceBills);
        if (!tgtBillMap.isEmpty()) {
            String targetEntityNumber = context.getTagEntityNumber();
            for (Map.Entry entry : tgtBillMap.entrySet()) {
                String tenFromRet = (String)entry.getKey();
                for (Long pk : (HashSet)entry.getValue()) {
                    if (!tenFromRet.equals(targetEntityNumber)) continue;
                    result.addTargetBill(tenFromRet, pk);
                }
            }
        }
    }

    @Override
    public BillCalculatorResult convert(ExecutionEntity execution, BillCalculatorCtx context) {
        boolean enableGenerateTarget;
        BillCalculatorResult result = BillCalculatorResult.createInstance(context, execution);
        Object generageTarget = context.getExtraVariable().get("enableGenerateTarget");
        boolean bl = enableGenerateTarget = generageTarget == null ? false : (Boolean)generageTarget;
        if (enableGenerateTarget) {
            this.convertRestBills(result, execution, context);
            return result;
        }
        Long[] billIds = new Long[context.getSrcPkIds().size()];
        int i = 0;
        for (String sp : context.getSrcPkIds()) {
            billIds[i++] = Long.valueOf(sp);
        }
        this.tryFindTargetBillBySource(billIds, execution, context, result);
        BillRelationshipModel convInfo = (BillRelationshipModel)context.getExtraVariable().get("conversionInfo");
        BillCloseConfig billCloseConfig = (BillCloseConfig)context.getExtraVariable().get("billCloseConfig");
        if (result.getTargetBills() != null && !result.getTargetBills().isEmpty()) {
            List<ExecutionEntity> children;
            boolean flag = this.canCloseTask(execution, convInfo, billCloseConfig);
            if (flag && context.getSrcPkIds().size() > 1 && (children = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId())) != null) {
                for (ExecutionEntity e : children) {
                    if (!context.getSrcPkIds().contains(e.getBusinessKey()) || e.getParent() == null || !e.getParent().isBillExecution() || (flag = this.canCloseTask(execution, convInfo, billCloseConfig))) continue;
                    break;
                }
            }
            if (flag) {
                this.logger.debug("\u9690\u5f0f\u8f6c\u6362\u80fd\u591f\u76f4\u63a5\u79bb\u5f00");
                return result;
            }
        }
        this.convertRestBills(result, execution, context);
        return result;
    }

    private boolean canCloseTask(ExecutionEntity execution, BillRelationshipModel convInfo, BillCloseConfig billCloseConfig) {
        ConditionalRuleEntity closeCondition;
        if (billCloseConfig != null && (closeCondition = billCloseConfig.getBillCloseCondition()) != null) {
            return ConditionUtil.hasTrueCondition(closeCondition, (VariableScope)execution, String.format("bizFlow-billCloseCondition-%s", execution.getActivityId()));
        }
        return BizFlowUtil.canCloseTask((VariableScope)execution, convInfo);
    }

    public void convertRestBills(BillCalculatorResult result, ExecutionEntity execution, BillCalculatorCtx context) {
    }

    protected void doBotpConversion(BillCalculatorCtx context, BillCalculatorResult result, Collection<String> aggregationPkCols, ExecutionEntity execution) {
        String srcEntityNumber = context.getSrcEntityNumber();
        String targetEntityNumber = context.getTagEntityNumber();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setHasRight(true);
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(aggregationPkCols.size());
        boolean isLongPk = EntityMetadataCache.getDataEntityType((String)srcEntityNumber).getPrimaryKey() instanceof LongProp;
        for (String obj : aggregationPkCols) {
            ListSelectedRow row = isLongPk ? new ListSelectedRow((Object)Long.valueOf(obj), Boolean.valueOf(true)) : new ListSelectedRow((Object)obj, Boolean.valueOf(true));
            rows.add(row);
            String cacheKey = String.format("findbizobj_%s.%s", srcEntityNumber, row);
            Context.getCommandContext().getCachedDynamicObj().remove(cacheKey);
        }
        pushArgs.setSelectedRows(rows);
        BillRelationshipModel convInfo = (BillRelationshipModel)context.getExtraVariable().get("conversionInfo");
        if (!"automatch".equals(convInfo.getConversionMethod())) {
            pushArgs.setRuleId(convInfo.getConversionMethod());
        }
        String startMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884cbotp\u5355\u636e\u8f6c\u5316\uff0c\u539f\u5355[{0}]Pks[{1}]\uff0c\u76ee\u6807\u5355[{2}]", (String)"BotpBillCalculator_7", (String)"bos-wf-engine", (Object[])new Object[]{srcEntityNumber, WfUtils.listToString(aggregationPkCols, ","), targetEntityNumber});
        result.logInfo(startMsg);
        ConvertOperationResult convResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)convResult.getTargetEntityNumber());
        List targetBillObjList = convResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType, true);
        String commitMsg = ResManager.loadKDString((String)"botp\u5355\u636e\u8f6c\u5316\u5b8c\u6210\uff0c\u751f\u6210\u76ee\u6807\u5355[{0}]\u4e2a\uff0c\u51c6\u5907\u6267\u884c\u63d0\u4ea4\u3002", (String)"BotpBillCalculator_8", (String)"bos-wf-engine", (Object[])new Object[]{targetBillObjList.size()});
        result.logInfo(commitMsg);
        if (!targetBillObjList.isEmpty()) {
            boolean isSubmit;
            DynamicObject[] targetBillObjs = targetBillObjList.toArray(new DynamicObject[targetBillObjList.size()]);
            String entityNumber = targetBillObjs[0].getDataEntityType().getName();
            Operations targetOperations = EntityMetadataCache.getDataEntityOperations((String)convResult.getTargetEntityNumber());
            String opKey = context.getAfterOperation();
            OperationResult opRet = this.doOperation(entityNumber, targetBillObjs, targetOperations.getSave(), null);
            boolean bl = isSubmit = "submit".equalsIgnoreCase(opKey) || "audit".equalsIgnoreCase(opKey);
            if (isSubmit && opRet != null && WfUtils.isNotEmptyForCollection(opRet.getSuccessPkIds())) {
                opRet = this.doOperation(entityNumber, null, targetOperations.getSubmit(), opRet.getSuccessPkIds().toArray());
                boolean isAudit = "audit".equalsIgnoreCase(opKey);
                if (isAudit && opRet != null && WfUtils.isNotEmptyForCollection(opRet.getSuccessPkIds())) {
                    this.doOperation(entityNumber, null, targetOperations.getAudit(), opRet.getSuccessPkIds().toArray());
                }
            }
            String endMsg = ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c[{0}]\u5b8c\u6bd5\u3002", (String)"BotpBillCalculator_9", (String)"bos-wf-engine", (Object[])new Object[]{opKey});
            result.logInfo(endMsg);
            for (DynamicObject d : targetBillObjList) {
                result.addTargetBill(entityNumber, d.getPkValue());
                result.addTargetBillOperation(d.getPkValue(), opKey);
            }
        } else {
            KDBizException e = new KDBizException(WFErrorCode.billCalculateError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5355\u636eBOTP\u8f6c\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"BotpBillCalculator_4", (String)"bos-wf-engine", (Object[])new Object[0]), convResult.getMessage())});
            this.logger.warn(result.getLogInfo());
            throw ExceptionUtil.createBotpCalcExeption((Exception)((Object)e), execution, context);
        }
        result.setScuess(true);
        result.setConversionType("autoBotpConversion");
    }

    private OperationResult doOperation(String entityNumber, DynamicObject[] targetBillObjs, String opKey, Object[] ids) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("WF", "TRUE");
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("mutex_ignoremodify", "true");
        options.setVariableValue("ignoreinteraction", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationResult ret = null;
        int length = 0;
        if (targetBillObjs != null) {
            ret = WfCommonUtil.executeOperate((String)opKey, (String)entityNumber, (DynamicObject[])targetBillObjs, (OperateOption)options);
            length = targetBillObjs.length;
        } else {
            ret = WfCommonUtil.executeOperate((String)opKey, (String)entityNumber, (Object[])ids, (OperateOption)options);
            length = ids.length;
        }
        if (!(ret == null || ret.isSuccess() && length == ret.getSuccessPkIds().size())) {
            StringBuilder ssb = new StringBuilder();
            List errs = ret.getAllErrorOrValidateInfo();
            if (errs != null && !errs.isEmpty()) {
                for (IOperateInfo info : errs) {
                    ssb.append("\n").append(info.getTitle()).append(":").append(info.getMessage());
                }
            }
            WFBizOperationException bizErr = new WFBizOperationException(null, WFErrorCode.businessBizOperationError(), new Object[]{ssb.toString()});
            bizErr.setOperationResult(ret);
            throw bizErr;
        }
        return ret;
    }
}

