/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.IBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFBillCalcException;
import kd.bos.workflow.exception.WFErrorCode;

public class ExpressionBillCalculator
implements IBillCalculator {
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());
    public static final String TYPE = "expressionBillCalculate";

    @Override
    public BillCalculatorCtx createBillContext(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        BillCalculatorCtx ctx = new BillCalculatorCtx();
        if (incomgingFlow == null || incomgingFlow.getBillRelationshipModel() == null) {
            return ctx;
        }
        BillRelationshipModel relationModel = incomgingFlow.getBillRelationshipModel();
        if (relationModel != null && "findByExpression".equals(relationModel.getRelationType())) {
            ctx.setType(TYPE);
            HashMap<String, Object> extVars = new HashMap<String, Object>();
            extVars.put("conversionInfo", relationModel);
            ctx.setExtraVariable(extVars);
        }
        ctx.setTargetFlowElement(incomgingFlow.getTargetFlowElement());
        ctx.setSrcFlowElement(incomgingFlow.getSourceFlowElement());
        return ctx;
    }

    @Override
    public BillCalculatorResult convert(ExecutionEntity execution, BillCalculatorCtx context) {
        BillCalculatorResult result = BillCalculatorResult.createInstance(context, execution);
        result.setConversionType("ExpressConversion");
        BillRelationshipModel convInfo = (BillRelationshipModel)context.getExtraVariable().get("conversionInfo");
        String expression = convInfo.getExpression();
        String targetEntityNumber = null;
        FlowElement targetele = context.getTargetFlowElement();
        if (targetele instanceof UserTask) {
            targetEntityNumber = ((UserTask)targetele).getEntityNumber();
        } else if (targetele instanceof AutoTask) {
            targetEntityNumber = MetadataDao.getNumberById((String)((AutoTask)targetele).getEntityId());
        } else if (targetele instanceof CallActivity) {
            targetEntityNumber = ((CallActivity)targetele).getEntityNumber();
        } else if (targetele instanceof WaitTask) {
            targetEntityNumber = ((WaitTask)targetele).getEntityNumber();
        } else if (targetele instanceof IEntitySupport) {
            targetEntityNumber = ((IEntitySupport)((Object)targetele)).getEntityNumber();
        } else {
            this.logger.debug(String.format("target node is %s", targetele.getId()));
        }
        if (WfUtils.isEmpty(expression) || WfUtils.isEmpty(targetEntityNumber)) {
            throw new WFBillCalcException(WFErrorCode.billCalcExcpetion(), new Object[]{"ExpressConversion", execution.getEntityNumber(), execution.getBusinessKey(), targetEntityNumber, context.getSrcFlowElement() == null ? "" : context.getSrcFlowElement().getId(), context.getTargetFlowElement() == null ? "" : context.getTargetFlowElement().getId(), String.format("expression[%s] or targetEntityNumber[%s] is null", expression, targetEntityNumber)});
        }
        Collection<String> srcPks = context.getSrcPkIds();
        String vname = String.format("%s.%s", execution.getActivityId(), "srcPks");
        String vEntityNumberName = String.format("%s.%s", execution.getActivityId(), "expectEntityNumber");
        if (srcPks != null && !srcPks.isEmpty()) {
            execution.setTransientVariable(vname, SerializationUtils.toJsonString(srcPks));
        }
        execution.setTransientVariable(vEntityNumberName, targetEntityNumber);
        execution.setTransientVariable("targetNode", targetele.getId());
        String targetPks = (String)ExpressionCalculatorUtil.parseValue(null, execution, "${" + expression + "}", null);
        execution.removeTransientVariable(vname);
        execution.removeTransientVariable(vEntityNumberName);
        execution.removeTransientVariable("targetNode");
        if (WfUtils.isNotEmpty(targetPks)) {
            for (String tpk : targetPks.split("\\,")) {
                result.addTargetBill(targetEntityNumber, tpk);
            }
        } else {
            throw new WFBillCalcException(WFErrorCode.billCalcEmptyExcpetion(), new Object[]{"ExpressConversion", execution.getEntityNumber(), execution.getBusinessKey(), targetEntityNumber, context.getTargetFlowElement() == null ? "" : context.getTargetFlowElement().getId(), context.getSrcFlowElement() == null ? "" : context.getSrcFlowElement().getId(), String.format("bill result is empty, expression[%s] or targetEntityNumber[%s] ", expression, targetEntityNumber)});
        }
        result.setScuess(true);
        return result;
    }
}

