/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.IBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;

public class OriginalBillCalculator
implements IBillCalculator {
    public static final String TYPE = "originalBillCalculate";

    @Override
    public BillCalculatorCtx createBillContext(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        BillCalculatorCtx ctx = new BillCalculatorCtx();
        ctx.setType(TYPE);
        ctx.setTagEntityNumber(ctx.getSrcEntityNumber());
        if (incomgingFlow != null) {
            ctx.setTargetFlowElement(incomgingFlow.getTargetFlowElement());
            ctx.setSrcFlowElement(incomgingFlow.getSourceFlowElement());
        }
        return ctx;
    }

    @Override
    public BillCalculatorResult convert(ExecutionEntity execution, BillCalculatorCtx context) {
        BillCalculatorResult result = BillCalculatorResult.createInstance(context, execution);
        result.setScuess(true);
        result.setConversionType("noConversion");
        boolean nodeBillAndFlowBillConsistent = this.nodeBillAndFlowBillConsistent(context, execution);
        if (!nodeBillAndFlowBillConsistent) {
            String entityNumber = null;
            if (context.getTargetFlowElement() instanceof IEntitySupport) {
                entityNumber = ((IEntitySupport)((Object)context.getTargetFlowElement())).getEntityNumber();
            } else if (context.getTargetFlowElement() instanceof AutoTask) {
                entityNumber = MetadataDao.getNumberById((String)((AutoTask)context.getTargetFlowElement()).getEntityId());
            } else if (context.getTargetFlowElement() instanceof EventSupportTask) {
                entityNumber = MetadataDao.getNumberById((String)((EventSupportTask)context.getTargetFlowElement()).getEntityId());
            }
            WFEngineException e = new WFEngineException(WFErrorCode.entityNotMatchError(), new Object[]{execution.getEntityNumber(), execution.getActivityId(), entityNumber});
            throw ExceptionUtil.createBillCalcExeption((Exception)((Object)e), execution, result, context.getTargetFlowElement());
        }
        result.logInfo(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49\u5355\u636e\u8f6c\u6362\uff0c\u53ef\u4ee5\u76f4\u63a5\u79bb\u5f00\u3002", (String)"OriginalBillCalculator_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        return result;
    }

    private Boolean nodeBillAndFlowBillConsistent(BillCalculatorCtx context, ExecutionEntity execution) {
        boolean isConsistent = true;
        if (context.getTargetFlowElement() instanceof Gateway) {
            ArrayList<String> entityNumbers = new ArrayList<String>();
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
            FlowNode flowElements = (FlowNode)context.getTargetFlowElement();
            List<SequenceFlow> sequenceFlows = flowElements.getIncomingFlows();
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                String entityNum;
                String flowNode = sequenceFlow.getSourceRef();
                FlowElement flowElement = bpmnModel.getFlowElement(flowNode);
                if (flowElement instanceof IEntitySupport) {
                    IEntitySupport iEntitySupport = (IEntitySupport)((Object)flowElement);
                    entityNumbers.add(iEntitySupport.getEntityNumber());
                    continue;
                }
                if (flowElement instanceof AutoTask) {
                    entityNum = MetadataDao.getNumberById((String)((AutoTask)flowElement).getEntityId());
                    entityNumbers.add(entityNum);
                    continue;
                }
                if (!(flowElement instanceof EventSupportTask)) continue;
                entityNum = MetadataDao.getNumberById((String)((EventSupportTask)flowElement).getEntityId());
                entityNumbers.add(entityNum);
            }
            if (entityNumbers.size() <= 0 || !entityNumbers.contains(execution.getEntityNumber())) {
                isConsistent = false;
            }
        } else if (context.getTargetFlowElement() instanceof IEntitySupport && !((IEntitySupport)((Object)context.getTargetFlowElement())).getEntityNumber().equalsIgnoreCase(execution.getEntityNumber())) {
            isConsistent = false;
        } else if (context.getTargetFlowElement() instanceof EventSupportTask) {
            String entityNum = MetadataDao.getNumberById((String)((EventSupportTask)context.getTargetFlowElement()).getEntityId());
            if (!execution.getEntityNumber().equalsIgnoreCase(entityNum)) {
                isConsistent = false;
            }
        }
        return isConsistent;
    }
}

