/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.IBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;

public class PluginBillCalculator
implements IBillCalculator {
    public static final String TYPE = "pluginBillCalculate";

    @Override
    public BillCalculatorCtx createBillContext(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        BillCalculatorCtx ctx = new BillCalculatorCtx();
        if (incomgingFlow == null || incomgingFlow.getBillRelationshipModel() == null) {
            return ctx;
        }
        BillRelationshipModel relationModel = incomgingFlow.getBillRelationshipModel();
        if (relationModel != null && "findByPlugin".equals(relationModel.getRelationType())) {
            ctx.setType(TYPE);
            HashMap<String, Object> extVars = new HashMap<String, Object>();
            extVars.put("relation", relationModel);
            ctx.setExtraVariable(extVars);
        }
        ctx.setTargetFlowElement(incomgingFlow.getTargetFlowElement());
        ctx.setSrcFlowElement(incomgingFlow.getSourceFlowElement());
        return ctx;
    }

    @Override
    public BillCalculatorResult convert(ExecutionEntity execution, BillCalculatorCtx context) {
        MainEntityType dt;
        String appId;
        Object targetBills;
        String plugin;
        BillCalculatorResult result = BillCalculatorResult.createInstance(context, execution);
        BillRelationshipModel relation = (BillRelationshipModel)context.getExtraVariable().get("relation");
        String srcEntityNumber = execution.getEntityNumber();
        ArrayList<String> srcPks = new ArrayList<String>();
        if (context.getSrcPkIds() == null || context.getSrcPkIds().isEmpty()) {
            srcPks.add(execution.getBusinessKey());
        } else {
            srcPks.addAll(context.getSrcPkIds());
        }
        String targetBillRageStr = relation.getTargetBillRage();
        if (WfUtils.isEmpty(targetBillRageStr) && context.getTargetFlowElement() != null) {
            FlowElement targetFlowElement = context.getTargetFlowElement();
            if (targetFlowElement instanceof IEntitySupport) {
                targetBillRageStr = ((IEntitySupport)((Object)targetFlowElement)).getEntityNumber();
            } else if (targetFlowElement instanceof AutoTask) {
                targetBillRageStr = MetadataDao.getNumberById((String)((AutoTask)targetFlowElement).getEntityId());
            }
        }
        if (WfUtils.isNotEmpty(plugin = relation.getPlugin())) {
            JSONObject data = (JSONObject)JSONObject.parse((String)plugin);
            plugin = data.getString("value");
        }
        if ((targetBills = DispatchServiceHelper.invokeBOSServiceByAppId((String)(appId = (dt = EntityMetadataCache.getDataEntityType((String)srcEntityNumber)).getAppId()), (String)IWorkflowService.class.getSimpleName(), (String)"invokeBizPlugin", (Object[])new Object[]{plugin, "getTargetBills", new Object[]{srcEntityNumber, srcPks, targetBillRageStr}})) instanceof Set && !((Set)targetBills).isEmpty()) {
            for (Long pk : (Set)targetBills) {
                result.addTargetBill(targetBillRageStr, pk);
            }
        }
        if (result.getTargetBills().isEmpty()) {
            throw new KDException(WFErrorCode.engineError(), new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u8ba1\u7b97\u5931\u8d25\uff0c\u7adf\u7136\u6ca1\u6709\u76ee\u6807\u5355\u3002\u539f\u56e0%s", (String)"BotpBillCalculator_6", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return result;
    }
}

