/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.IBillCalculator;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.bpm.calculator.billrelation.BillRelationHelper;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFBillCalcException;
import kd.bos.workflow.exception.WFErrorCode;

public class QueryBotpResultBillCalculator
implements IBillCalculator {
    public static final String TYPE = "queryBotpResultBillCalculate";
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());

    @Override
    public BillCalculatorCtx createBillContext(ExecutionEntity execution, SequenceFlow incomgingFlow, Map<String, Object> extraVars) {
        BillCalculatorCtx ctx = new BillCalculatorCtx();
        if (incomgingFlow == null || incomgingFlow.getBillRelationshipModel() == null) {
            return ctx;
        }
        BillRelationshipModel relation = incomgingFlow.getBillRelationshipModel();
        if (relation != null && "queryBotpTargetBills".equals(relation.getRelationType())) {
            ctx.setType(TYPE);
            HashMap<String, Object> extVars = new HashMap<String, Object>();
            extVars.put("relation", relation);
            ctx.setExtraVariable(extVars);
        }
        ctx.setTargetFlowElement(incomgingFlow.getTargetFlowElement());
        ctx.setSrcFlowElement(incomgingFlow.getSourceFlowElement());
        return ctx;
    }

    @Override
    public BillCalculatorResult convert(ExecutionEntity execution, BillCalculatorCtx context) {
        BillCalculatorResult result = BillCalculatorResult.createInstance(context, execution);
        BillRelationshipModel relation = (BillRelationshipModel)context.getExtraVariable().get("relation");
        String targetBillRageStr = relation.getTargetBillRage();
        if (WfUtils.isEmpty(targetBillRageStr) && context.getTargetFlowElement() != null && context.getTargetFlowElement() instanceof IEntitySupport) {
            targetBillRageStr = ((IEntitySupport)((Object)context.getTargetFlowElement())).getEntityNumber();
        } else if (context != null && context.getTargetFlowElement() instanceof AutoTask) {
            String entityId = ((AutoTask)context.getTargetFlowElement()).getEntityId();
            targetBillRageStr = MetadataDao.getNumberById((String)entityId);
        }
        if (targetBillRageStr != null) {
            ArrayList<String> srcPks = new ArrayList<String>();
            if (context.getSrcPkIds() != null && !context.getSrcPkIds().isEmpty()) {
                srcPks.addAll(context.getSrcPkIds());
            } else {
                srcPks.add(execution.getBusinessKey());
            }
            Map<String, Set<String>> targetBillMaps = BillRelationHelper.get().getDirectTargetBill(srcPks, execution.getEntityNumber(), targetBillRageStr);
            List<String> targetBillRage = Arrays.asList(targetBillRageStr.split("\\,"));
            for (Map.Entry<String, Set<String>> entry : targetBillMaps.entrySet()) {
                String tenFromRet = entry.getKey();
                for (String pk : entry.getValue()) {
                    if (srcPks.contains(pk) || !targetBillRage.contains(tenFromRet)) continue;
                    result.addTargetBill(tenFromRet, pk);
                    this.logger.debug(String.format("targetBill[%s],targetEntityNumber[%s]", pk, tenFromRet));
                }
            }
        }
        if (result.getTargetBills().isEmpty()) {
            throw new WFBillCalcException(WFErrorCode.billCalcExcpetion(), new Object[]{"queryBotpConversion", execution.getEntityNumber(), execution.getBusinessKey(), targetBillRageStr, context.getSrcFlowElement().getId(), context.getTargetFlowElement().getId(), ResManager.loadKDString((String)"\u5355\u636e\u8ba1\u7b97\u5931\u8d25\uff0c\u7adf\u7136\u6ca1\u6709\u76ee\u6807\u5355\u3002", (String)"BotpBillCalculator_5", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return result;
    }
}

