/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class BillCalculatorResult {
    public static final String CONVERSIONTYPE_NOCONVERSION = "noConversion";
    public static final String CONVERSIONTYPE_AUTOBOTPCONVERSION = "autoBotpConversion";
    public static final String CONVERSIONTYPE_MANUALCONVERSION = "manualConversion";
    public static final String CONVERSIONTYPE_MULTIAGGREGATION = "multiAggregation";
    public static final String CONVERSIONTYPE_QUERYBOTPCONVERSION = "queryBotpConversion";
    public static final String CONVERSIONTYPE_EXPRESSCONVERSION = "ExpressConversion";
    public static final String CONVERSIONSTATE_BLOCKING = "blocking";
    private boolean scuess;
    private RuntimeException e;
    private String conversionType;
    private StringBuilder logInfo = new StringBuilder();
    private Map<String, Set<String>> targetBills = new HashMap<String, Set<String>>();
    private Map<String, String> targetBillsOperation = new HashMap<String, String>();
    private Collection<ExecutionEntity> originalExecutions;
    private String state;

    public boolean isScuess() {
        return this.scuess;
    }

    public void setScuess(boolean scuess) {
        this.scuess = scuess;
    }

    public RuntimeException getException() {
        return this.e;
    }

    public void setException(RuntimeException e) {
        this.setScuess(false);
        this.e = e;
    }

    public String getConversionType() {
        return this.conversionType;
    }

    public void setConversionType(String conversionType) {
        this.conversionType = conversionType;
    }

    public void logInfo(String log) {
        this.logInfo.append(log).append("\r\n");
    }

    public String getLogInfo() {
        return this.logInfo.toString();
    }

    public Collection<ExecutionEntity> getOriginalExecutions() {
        return this.originalExecutions;
    }

    public void setOriginalExecutions(Collection<ExecutionEntity> originalExecutions) {
        this.originalExecutions = originalExecutions;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Map<String, Set<String>> getTargetBills() {
        return this.targetBills;
    }

    public void setTargetBills(Map<String, Set<String>> targetBills) {
        this.targetBills = targetBills;
    }

    public void addTargetBill(String entityNumber, Object pk) {
        HashSet tmp = new HashSet();
        HashSet<String> pks = this.targetBills.putIfAbsent(entityNumber, tmp);
        if (pks == null) {
            pks = new HashSet<String>();
        }
        pks.add(String.valueOf(pk));
        this.targetBills.put(entityNumber, pks);
    }

    public static BillCalculatorResult createInstance(BillCalculatorCtx ctx, ExecutionEntity execution) {
        BillCalculatorResult result = new BillCalculatorResult();
        result.setConversionType(ctx.getType());
        result.logInfo(String.format("activity node [%s] execute bill convert, type is [%s], execution is [%s].", execution.getActivityId(), ctx.getType(), execution.getId()));
        return result;
    }

    public static boolean isNativeContinue(BillCalculatorResult result) {
        return CONVERSIONTYPE_NOCONVERSION.equals(result.getConversionType()) || CONVERSIONTYPE_MANUALCONVERSION.equals(result.getConversionType());
    }

    public static boolean isManualConversion(BillCalculatorResult result) {
        return CONVERSIONTYPE_MANUALCONVERSION.equals(result.getConversionType());
    }

    public static boolean isNoConversionType(BillCalculatorResult result) {
        return CONVERSIONTYPE_NOCONVERSION.equals(result.getConversionType());
    }

    public static boolean isStopContinueNoTargetBills(BillCalculatorResult result) {
        String conversionType = result.getConversionType();
        return CONVERSIONTYPE_AUTOBOTPCONVERSION.equals(conversionType) || "queryBotpResultBillCalculate".equals(conversionType) || CONVERSIONTYPE_EXPRESSCONVERSION.equals(conversionType) || "pluginBillCalculate".equals(conversionType) || "botpBillCalculate".equals(conversionType);
    }

    public static boolean isBlocking(BillCalculatorResult result) {
        return CONVERSIONSTATE_BLOCKING.equals(result.getState());
    }

    public void addTargetBillOperation(Object pk, String opKey) {
        this.targetBillsOperation.put(String.valueOf(pk), opKey);
    }

    public Map<String, String> getTargetBillsOperation() {
        return this.targetBillsOperation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.originalExecutions != null) {
            for (ExecutionEntity exe : this.originalExecutions) {
                sb.append('[').append(exe.getId()).append(',').append(exe.getActivityId()).append("],");
            }
        }
        return "BillCalculatorResult [scuess=" + this.scuess + ", conversionType=" + this.conversionType + ", logInfo=" + this.logInfo + ", targetBills=" + WfUtils.mapToString(this.targetBills) + ", targetBillsOperation=" + WfUtils.mapToString(this.targetBillsOperation) + ", originalExecutions=" + sb + ", state=" + this.state + "]";
    }
}

