/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billrelation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billrelation.BotpRelationServiceImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillRelationModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillRelationTypeEntity;

public class BillRelationHelper {
    private static BillRelationHelper instance;
    private static BotpRelationServiceImpl botpRelationService;
    private static Log logger;

    private BillRelationHelper() {
    }

    public static BillRelationHelper get() {
        if (instance == null) {
            instance = new BillRelationHelper();
        }
        return instance;
    }

    public Map<String, Set<String>> getDirectSourceBill(String targetEntity, List<String> targetPks) {
        logger.debug(String.format("getDirectSourceBill params %s - %s ", targetEntity, targetPks == null ? "null" : WfUtils.listToString(targetPks, ",")));
        Map<Object, Object> directSourceBill = new HashMap();
        CommandContext commandContext = Context.getCommandContext();
        List<BillRelationModelEntity> brme = commandContext.getBillRelationModelManager().getRelationModelByTargetBill(targetEntity);
        if (brme == null || brme.isEmpty()) {
            directSourceBill = this.getBillsByBotp("getDirectSrcBillByTargetBill", targetEntity, targetPks, new HashMap<String, Object>());
            return directSourceBill;
        }
        for (BillRelationModelEntity model : brme) {
            String relationType = model.getRelationtype();
            BillRelationTypeEntity billRt = commandContext.getBillRelationTypeManager().getRelationTypeByNumber(relationType);
            if (billRt == null) continue;
            String parseClass = billRt.getParseClass();
            if (WfUtils.isNotEmpty(parseClass)) {
                Map pluginConfig = (Map)SerializationUtils.fromJsonString((String)parseClass, Map.class);
                String clazz = (String)pluginConfig.get("class");
                String appId = (String)pluginConfig.get("appid");
                String paramStr = model.getParamJson();
                Map extraParam = WfUtils.isNotEmpty(paramStr) ? (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class) : new HashMap();
                logger.debug(String.format("invokeBOSServiceByAppId params %s, %s, %s", appId, clazz, paramStr));
                Map ret = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBillRelationMethod", (Object[])new Object[]{clazz, "getDirectSrcBillByTargetBill", new Object[]{targetEntity, targetPks, extraParam}});
                logger.debug(String.format("result %s", WfUtils.mapToString(ret)));
                if (ret == null) continue;
                for (Map.Entry entry : ret.entrySet()) {
                    String entityNumber = (String)entry.getKey();
                    Set pks = (Set)directSourceBill.get(entityNumber);
                    if (pks != null) {
                        pks.addAll((Collection)entry.getValue());
                        continue;
                    }
                    if (!WfUtils.isNotEmptyForCollection((Collection)entry.getValue())) continue;
                    directSourceBill.put(entityNumber, entry.getValue());
                }
                continue;
            }
            logger.debug("no find billRelationTpye number is " + relationType);
        }
        if (directSourceBill.isEmpty()) {
            directSourceBill = this.getBillsByBotp("getDirectSrcBillByTargetBill", targetEntity, targetPks, new HashMap<String, Object>());
            logger.debug(String.format("botpRelationService get %s", WfUtils.mapToString(directSourceBill)));
        }
        return directSourceBill;
    }

    private Map<String, Set<String>> getBillsByBotp(String methodName, String entityNumber, List<String> pks, Map<String, Object> extraParams) {
        if ("getDirectSrcBillByTargetBill".equals(methodName)) {
            return botpRelationService.getDirectSrcBillByTargetBill(entityNumber, pks, extraParams);
        }
        return botpRelationService.getDirectTargetBillBySrcBill(entityNumber, pks, extraParams);
    }

    public Map<String, Set<String>> getDirectTargetBill(List<String> srcPks, String srcEntity, String targetEntity) {
        logger.debug(String.format("getDirectSourceBill params %s - %s ", srcEntity, targetEntity, srcPks == null ? "null" : WfUtils.listToString(srcPks, ",")));
        Map<String, Set<String>> directTargetBill = new HashMap<String, Set<String>>();
        CommandContext commandContext = Context.getCommandContext();
        List<BillRelationModelEntity> brme = commandContext.getBillRelationModelManager().getRelationModelBySrcAndTargetBill(srcEntity, targetEntity);
        if (brme == null || brme.isEmpty()) {
            logger.debug("no find billRelationModel targetEntity is " + targetEntity);
            directTargetBill = this.getBillsByBotp("getDirectTargetBillBySrcBill", srcEntity, srcPks, new HashMap<String, Object>());
            return directTargetBill;
        }
        for (BillRelationModelEntity model : brme) {
            String relationType = model.getRelationtype();
            BillRelationTypeEntity billRt = commandContext.getBillRelationTypeManager().getRelationTypeByNumber(relationType);
            if (billRt == null) continue;
            String parseClass = billRt.getParseClass();
            if (WfUtils.isNotEmpty(parseClass)) {
                Map pluginConfig = (Map)SerializationUtils.fromJsonString((String)parseClass, Map.class);
                String clazz = (String)pluginConfig.get("class");
                String appId = (String)pluginConfig.get("appid");
                String paramStr = model.getParamJson();
                Map extraParam = WfUtils.isNotEmpty(paramStr) ? (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class) : new HashMap();
                logger.debug(String.format("invokeBOSServiceByAppId params %s, %s, %s", appId, clazz, paramStr));
                Map ret = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBillRelationMethod", (Object[])new Object[]{clazz, "getDirectTargetBillBySrcBill", new Object[]{srcEntity, srcPks, extraParam}});
                logger.debug(String.format("result %s", WfUtils.mapToStr(ret)));
                if (ret == null) continue;
                for (Map.Entry entry : ret.entrySet()) {
                    String entityNumber = (String)entry.getKey();
                    Set<String> pks = directTargetBill.get(entityNumber);
                    if (pks != null) {
                        pks.addAll((Collection)entry.getValue());
                        continue;
                    }
                    if (!WfUtils.isNotEmptyForCollection((Collection)entry.getValue())) continue;
                    directTargetBill.put(entityNumber, (Set<String>)entry.getValue());
                }
                continue;
            }
            logger.debug("no find billRelationTpye number is " + relationType);
        }
        return directTargetBill;
    }

    static {
        botpRelationService = new BotpRelationServiceImpl();
        logger = LogFactory.getLog(BillRelationHelper.class);
    }
}

