/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billrelation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.workflow.api.IRelationService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.util.WfCommonUtil;

public class BotpRelationServiceImpl
implements IRelationService {
    protected static Log logger = LogFactory.getLog(BotpRelationServiceImpl.class);

    public Map<String, Set<String>> getDirectSrcBillByTargetBill(String targetEntityNumber, List<String> tPks, Map<String, Object> extraParams) {
        if (tPks == null || tPks.isEmpty()) {
            logger.debug(String.format("targetEntity[%s] do not have pks.", targetEntityNumber));
            return new HashMap<String, Set<String>>();
        }
        Long[] targetPks = new Long[tPks.size()];
        for (int i = 0; i < tPks.size(); ++i) {
            targetPks[i] = Long.valueOf(tPks.get(i));
        }
        HashMap<String, Set<String>> directSrcBills = new HashMap<String, Set<String>>();
        String way = (String)WfConfigurationUtil.getConfigCenterVal("workflow.engine.GetBotpSrcType");
        if (way == null || "new".equalsIgnoreCase(way)) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("botp_track_only_dirt_link", "true");
            List bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)targetEntityNumber, (Long[])targetPks, (OperateOption)op);
            if (bfRows == null || bfRows.isEmpty()) {
                logger.debug(String.format("targetEntity[%s] do not have sourcebill bfRows.", targetEntityNumber));
                return directSrcBills;
            }
            HashMap<Long, String> entityNums = new HashMap<Long, String>();
            for (BFRow row : bfRows) {
                String entityNum;
                TableDefine def;
                Long mTblId;
                if (row.getSId() == null || row.getSId().getMainTableId() == null || WfUtils.isEmpty(mTblId = row.getSId().getMainTableId())) continue;
                if (entityNums.get(mTblId) == null && (def = ConvertMetaServiceHelper.loadTableDefine((Long)mTblId)) != null && WfUtils.isNotEmpty(def.getEntityNumber())) {
                    entityNums.put(mTblId, def.getEntityNumber());
                }
                if (WfUtils.isEmpty(entityNum = (String)entityNums.get(mTblId))) continue;
                HashSet<String> set = (HashSet<String>)directSrcBills.get(entityNum);
                if (set == null) {
                    set = new HashSet<String>();
                }
                if (WfUtils.isNotEmpty(row.getSId().getBillId())) {
                    set.add(String.valueOf(row.getSId().getBillId()));
                }
                directSrcBills.put(entityNum, set);
            }
            logger.debug(String.format("targetEntity[%s] sourcebill [%s].", targetEntityNumber, WfUtils.mapToString(directSrcBills)));
        } else {
            Set<String> srcIds = this.getDirectSourceBillIds(targetEntityNumber, tPks);
            if (srcIds.isEmpty()) {
                return new HashMap<String, Set<String>>();
            }
            Map allSources = BFTrackerServiceHelper.findSourceBills((String)targetEntityNumber, (Long[])targetPks);
            for (Map.Entry entry : allSources.entrySet()) {
                HashSet sourcePks = (HashSet)entry.getValue();
                String sourceEntityNumber = (String)entry.getKey();
                for (Long pk : sourcePks) {
                    String spk = String.valueOf(pk);
                    if (!srcIds.contains(spk)) continue;
                    HashSet<String> spkSet = (HashSet<String>)directSrcBills.get(sourceEntityNumber);
                    if (spkSet == null) {
                        spkSet = new HashSet<String>(16);
                        directSrcBills.put(sourceEntityNumber, spkSet);
                    }
                    spkSet.add(spk);
                }
            }
        }
        return directSrcBills;
    }

    private Set<String> getDirectSourceBillIds(String entityNumber, List<String> billIds) {
        HashSet<String> srcIds = new HashSet<String>(1);
        DynamicObject entity = WfUtils.findBusinessObject(billIds.get(0), entityNumber);
        if (entity == null) {
            return srcIds;
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
        MainEntityType entityType = null;
        IDataEntityType dataEntityType = entity.getDataEntityType();
        entityType = dataEntityType instanceof MainEntityType ? (MainEntityType)dataEntityType : EntityMetadataCache.getDataEntityType((String)entityNumber);
        dataEntitySet.Parse(new DynamicObject[]{entity}, entityType);
        for (LinkSetItemElement itemElement : linkSet.getItems()) {
            ExtendedDataEntity[] linkRows = dataEntitySet.FindByEntityKey(itemElement.getLinkEntityKey());
            if (linkRows == null) continue;
            for (ExtendedDataEntity linkRow : linkRows) {
                Object srcId = linkRow.getValue(itemElement.getLinkEntityKey() + "_sbillid");
                srcIds.add(String.valueOf(srcId));
            }
        }
        return srcIds;
    }

    public Map<String, Set<String>> getDirectTargetBillBySrcBill(String srcEntityNunber, List<String> spks, Map<String, Object> extraParams) {
        HashMap<String, Set<String>> targetBills = new HashMap<String, Set<String>>(16);
        Long[] sourcePks = new Long[spks.size()];
        for (int i = 0; i < spks.size(); ++i) {
            sourcePks[i] = Long.valueOf(spks.get(0));
        }
        Map queryTargetBills = BFTrackerServiceHelper.findTargetBills((String)srcEntityNunber, (Long[])sourcePks);
        if (queryTargetBills != null && !queryTargetBills.isEmpty()) {
            for (Map.Entry entry : queryTargetBills.entrySet()) {
                String entityNumber = (String)entry.getKey();
                HashSet<String> tbills = (HashSet<String>)targetBills.get(entityNumber);
                if (tbills == null) {
                    tbills = new HashSet<String>();
                    targetBills.put(entityNumber, tbills);
                }
                for (Long pk : (HashSet)entry.getValue()) {
                    tbills.add(String.valueOf(pk));
                }
            }
        }
        return targetBills;
    }

    public List<String> convert(String srcEntity, String targetEntity, List<String> srcPks, String afterOperation, Map<String, Object> extraParams) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setAutoSave(true);
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(srcPks.size());
        boolean isLongPk = EntityMetadataCache.getDataEntityType((String)srcEntity).getPrimaryKey() instanceof LongProp;
        for (String obj : srcPks) {
            ListSelectedRow row = isLongPk ? new ListSelectedRow((Object)Long.valueOf(obj), Boolean.valueOf(true)) : new ListSelectedRow((Object)obj, Boolean.valueOf(true));
            rows.add(row);
        }
        pushArgs.setSelectedRows(rows);
        ConvertOperationResult convResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)convResult.getTargetEntityNumber());
        List targetBillObjList = convResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType, true);
        if (!targetBillObjList.isEmpty()) {
            boolean isSubmit;
            Object[] targetBillObjs = targetBillObjList.toArray(new DynamicObject[targetBillObjList.size()]);
            String entityNumber = targetBillObjs[0].getDataEntityType().getName();
            Operations targetOperations = EntityMetadataCache.getDataEntityOperations((String)convResult.getTargetEntityNumber());
            String opKey = afterOperation;
            OperationResult opRet = this.doOperation(entityNumber, targetBillObjs, targetOperations.getSave());
            boolean bl = isSubmit = "submit".equalsIgnoreCase(opKey) || "audit".equalsIgnoreCase(opKey);
            if (isSubmit && opRet != null && WfUtils.isNotEmptyForCollection(opRet.getSuccessPkIds())) {
                opRet = this.doOperation(entityNumber, opRet.getSuccessPkIds().toArray(), targetOperations.getSubmit());
                boolean isAudit = "audit".equalsIgnoreCase(opKey);
                if (isAudit && opRet != null && WfUtils.isNotEmptyForCollection(opRet.getSuccessPkIds())) {
                    this.doOperation(entityNumber, opRet.getSuccessPkIds().toArray(), targetOperations.getAudit());
                }
            }
            ArrayList<String> ret = new ArrayList<String>(targetBillObjList.size());
            for (DynamicObject obj : targetBillObjList) {
                ret.add(String.valueOf(obj.getPkValue()));
            }
            return ret;
        }
        throw new KDBizException(WFErrorCode.billCalculateError(), new Object[]{String.format(ResManager.loadKDString((String)"\u5355\u636eBOTP\u8f6c\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"BotpBillCalculator_4", (String)"bos-wf-engine", (Object[])new Object[0]), convResult.getMessage())});
    }

    private OperationResult doOperation(String entityNumber, Object[] ids, String opKey) {
        OperateOption options = OperateOption.create();
        options.setVariableValue("WF", "TRUE");
        options.setVariableValue("ishasright", String.valueOf(true));
        options.setVariableValue("mutex_ignoremodify", "true");
        options.setVariableValue("ignoreinteraction", String.valueOf(true));
        options.setVariableValue("ignorewarn", String.valueOf(true));
        OperationResult ret = WfCommonUtil.executeOperate((String)opKey, (String)entityNumber, (Object[])ids, (OperateOption)options);
        if (ret != null && ids.length != ret.getSuccessPkIds().size()) {
            StringBuilder ssb = new StringBuilder();
            List errs = ret.getAllErrorOrValidateInfo();
            if (errs != null && !errs.isEmpty()) {
                for (IOperateInfo info : errs) {
                    ssb.append("\n").append(info.getTitle()).append(":").append(info.getMessage());
                }
            }
            WFBizOperationException bizErr = new WFBizOperationException(null, WFErrorCode.businessBizOperationError(), new Object[]{ssb.toString()});
            bizErr.setOperationResult(ret);
            throw bizErr;
        }
        return ret;
    }
}

