/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billrelation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.IRelationService;
import kd.bos.workflow.engine.WfUtils;

public class CorrelationServiceImpl
implements IRelationService {
    protected static Log logger = LogFactory.getLog(CorrelationServiceImpl.class);
    public static final String PARAM_SRCENTITY = "srcentity";
    public static final String PARAM_TARGETENTITY = "targetentity";
    public static final String PARAM_SRCFIELD = "srcfield";
    public static final String PARAM_TARGETFIELD = "targetfield";
    public static final String PARAM_FILTERGRIDAP = "filtergridap";

    public Map<String, Set<String>> getDirectSrcBillByTargetBill(String targetEntityNumber, List<String> tpks, Map<String, Object> extraParams) {
        DynamicObject[] targetObjs;
        if (tpks.isEmpty()) {
            return new HashMap<String, Set<String>>();
        }
        ISimpleProperty prop = EntityMetadataCache.getDataEntityType((String)targetEntityNumber).getPrimaryKey();
        Object[] pks = tpks.toArray();
        if (prop instanceof LongProp) {
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = Long.valueOf(tpks.get(i));
            }
        }
        if ((targetObjs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)targetEntityNumber))) == null || targetObjs.length < 1) {
            logger.debug(String.format("\u5173\u8054\u7c7b\u578b\u8ba1\u7b97\u5931\u8d25\uff0c\u627e\u4e0d\u5230number\u4e3a[%s]PK\u4e3a[%s]\u7684\u5b9e\u4f53", targetEntityNumber, WfUtils.listToString(tpks, ",")));
            return new HashMap<String, Set<String>>();
        }
        String targetField = (String)extraParams.get(PARAM_TARGETFIELD);
        String srcEntityNumber = (String)extraParams.get(PARAM_SRCENTITY);
        String srcField = (String)extraParams.get(PARAM_SRCFIELD);
        boolean isLongProp = false;
        if (srcField.equals("id")) {
            ISimpleProperty srcPkProp = EntityMetadataCache.getDataEntityType((String)srcEntityNumber).getPrimaryKey();
            isLongProp = srcPkProp instanceof LongProp || srcPkProp instanceof BigIntProp;
        }
        String[] structure = null;
        if (targetField.contains(".")) {
            structure = targetField.split("\\.");
        }
        ArrayList<Object> values = new ArrayList<Object>(16);
        for (DynamicObject targetObj : targetObjs) {
            if (structure != null) {
                DynamicObjectCollection entry = targetObj.getDynamicObjectCollection(structure[0]);
                if (entry == null || entry.isEmpty()) continue;
                for (DynamicObject obj : entry) {
                    this.getRealFieldValue(isLongProp, values, obj.get(structure[1]));
                }
                continue;
            }
            Object targetFieldVal = targetObj.get(targetField);
            this.getRealFieldValue(isLongProp, values, targetFieldVal);
        }
        logger.debug(String.format("values[%s],srcfield[%s],srcet[%s]", WfUtils.listToString(values, ","), srcField, srcEntityNumber));
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>(1);
        if (!values.isEmpty()) {
            QFilter filter = new QFilter(srcField, "in", (Object)values.toArray());
            List rpks = QueryServiceHelper.queryPrimaryKeys((String)srcEntityNumber, (QFilter[])new QFilter[]{filter}, null, (int)Integer.MAX_VALUE);
            HashSet<String> retSet = new HashSet<String>(rpks.size());
            for (Object p : rpks) {
                retSet.add(String.valueOf(p));
            }
            ret.put(srcEntityNumber, retSet);
        } else {
            logger.debug("\u4ece\u76ee\u6807\u5355\u4e2d\u83b7\u53d6value\u4e3a\u7a7a\u3002");
        }
        return ret;
    }

    private void getRealFieldValue(boolean isLongProp, List<Object> values, Object targetFieldVal) {
        if (targetFieldVal == null) {
            return;
        }
        Object value = targetFieldVal;
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).getPkValue();
        }
        logger.debug(String.format("PkValue: %s", value));
        if (isLongProp) {
            if (value instanceof Long) {
                values.add(value);
            } else {
                try {
                    value = Long.valueOf(String.valueOf(value));
                    values.add(value);
                }
                catch (Exception e) {
                    logger.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        } else {
            value = String.valueOf(value);
            values.add(value);
        }
    }

    public Map<String, Set<String>> getDirectTargetBillBySrcBill(String srcEntityNumber, List<String> spks, Map<String, Object> extraParams) {
        IDataEntityProperty tProp;
        DynamicObject[] srcObjs;
        if (spks.isEmpty()) {
            return new HashMap<String, Set<String>>();
        }
        ISimpleProperty prop = EntityMetadataCache.getDataEntityType((String)srcEntityNumber).getPrimaryKey();
        Object[] pks = spks.toArray();
        if (prop instanceof LongProp) {
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = Long.valueOf(spks.get(i));
            }
        }
        if ((srcObjs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)srcEntityNumber))) == null || srcObjs.length < 1) {
            logger.warn(String.format("\u5173\u8054\u7c7b\u578b\u8ba1\u7b97\u5931\u8d25\uff0c\u627e\u4e0d\u5230number\u4e3a[%s]PK\u4e3a[%s]\u7684\u5b9e\u4f53", srcEntityNumber, WfUtils.listToString(spks, ",")));
            return new HashMap<String, Set<String>>();
        }
        String targetField = (String)extraParams.get(PARAM_TARGETFIELD);
        String targetEntityNumber = (String)extraParams.get(PARAM_TARGETENTITY);
        String srcField = (String)extraParams.get(PARAM_SRCFIELD);
        Map allFields = EntityMetadataCache.getDataEntityType((String)targetEntityNumber).getAllFields();
        String fieldForProp = targetField;
        if (fieldForProp.contains(".")) {
            String[] longFields = fieldForProp.split("\\.");
            fieldForProp = longFields[longFields.length - 1];
        }
        boolean isLongProp = (tProp = (IDataEntityProperty)allFields.get(fieldForProp)) instanceof LongProp || tProp instanceof BigIntProp || tProp instanceof BasedataProp && ((BasedataProp)tProp).getRefIdProp() instanceof LongProp;
        ArrayList<Object> srcFieldVals = new ArrayList<Object>(srcObjs.length);
        for (DynamicObject srcObj : srcObjs) {
            Object srcFieldVal = srcObj.get(srcField);
            if (isLongProp) {
                if (srcFieldVal instanceof Long) {
                    srcFieldVals.add(srcFieldVal);
                } else {
                    try {
                        srcFieldVal = Long.valueOf(String.valueOf(srcFieldVal));
                        srcFieldVals.add(srcFieldVal);
                    }
                    catch (Exception e) {
                        logger.error(WfUtils.getExceptionStacktrace(e));
                    }
                }
            } else {
                srcFieldVal = String.valueOf(srcFieldVal);
                srcFieldVals.add(srcFieldVal);
            }
            logger.debug("" + srcFieldVal);
        }
        logger.debug(String.format("srcfv:%s", WfUtils.listToString(srcFieldVals, ",")));
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>(1);
        if (!srcFieldVals.isEmpty()) {
            QFilter filter = new QFilter(targetField, "in", srcFieldVals);
            String filterJson = (String)extraParams.get(PARAM_FILTERGRIDAP);
            if (WfUtils.isNotEmpty(filterJson)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)targetEntityNumber), filterCondition);
                filterBuilder.buildFilter(false);
                filter.and(filterBuilder.getQFilter());
            }
            List rpks = QueryServiceHelper.queryPrimaryKeys((String)targetEntityNumber, (QFilter[])new QFilter[]{filter}, null, (int)Integer.MAX_VALUE);
            HashSet<String> retSet = new HashSet<String>(rpks.size());
            for (Object p : rpks) {
                retSet.add(String.valueOf(p));
            }
            ret.put(targetEntityNumber, retSet);
        } else {
            logger.debug("\u4ece\u6e90\u5355\u4e2d\u83b7\u53d6value\u4e3a\u7a7a\u3002");
        }
        return ret;
    }
}

