/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billrelation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.IRelationService;
import kd.bos.workflow.engine.WfUtils;

public class CostRecordRelationServiceImpl
implements IRelationService {
    protected static Log logger = LogFactory.getLog(CostRecordRelationServiceImpl.class);
    public static final String FORM_COSTRECORD = "cal_costrecord_subentity";
    public static final String FIELD_BIZBILLID = "bizbillid";
    public static final String FIELD_BIZENTITYOBJECT = "bizentityobject";
    public static final String FIELD_ID = "id";

    public Map<String, Set<String>> getDirectSrcBillByTargetBill(String targetEntiyNumber, List<String> tpk, Map<String, Object> extraParams) {
        Long[] targetPks = new Long[tpk.size()];
        for (int i = 0; i < tpk.size(); ++i) {
            targetPks[i] = Long.valueOf(tpk.get(i));
        }
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        DynamicObject[] ps = BusinessDataServiceHelper.load((String)FORM_COSTRECORD, (String)String.format("%s,%s", FIELD_BIZBILLID, FIELD_BIZENTITYOBJECT), (QFilter[])new QFilter[]{new QFilter(FIELD_ID, "in", (Object)targetPks)});
        if (ps != null && ps.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dyn : ps) {
                DynamicObject eo = dyn.getDynamicObject(FIELD_BIZENTITYOBJECT);
                String number = eo.getString("number");
                sb.append(String.format("2 number[%s],targetBillId[%s]", number, dyn.getPkValue()));
                if (WfUtils.isEmpty(number)) continue;
                HashSet<String> ids = (HashSet<String>)ret.get(number);
                if (ids == null) {
                    ids = new HashSet<String>();
                }
                ids.add(dyn.getString(FIELD_BIZBILLID));
                ret.put(number, ids);
            }
            logger.debug(sb.toString());
        }
        return ret;
    }

    public Map<String, Set<String>> getDirectTargetBillBySrcBill(String srcEntityNunber, List<String> spk, Map<String, Object> extraParams) {
        Long[] sourcePks = new Long[spk.size()];
        for (int i = 0; i < spk.size(); ++i) {
            sourcePks[i] = Long.valueOf(spk.get(i));
        }
        DynamicObjectCollection ds = QueryServiceHelper.query((String)FORM_COSTRECORD, (String)FIELD_ID, (QFilter[])new QFilter[]{new QFilter(FIELD_BIZBILLID, "in", (Object)sourcePks)});
        HashSet<String> ids = new HashSet<String>(16);
        if (ds != null && !ds.isEmpty()) {
            for (DynamicObject obj : ds) {
                Long voucherId = obj.getLong(FIELD_ID);
                if (!WfUtils.isNotEmpty(voucherId)) continue;
                ids.add(String.valueOf(voucherId));
            }
        }
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        ret.put(FORM_COSTRECORD, ids);
        return ret;
    }
}

