/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.calculator.billrelation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.IRelationService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.calculator.billrelation.CorrelationServiceImpl;

public class DAPRelationServiceImpl
implements IRelationService {
    protected static Log logger = LogFactory.getLog(CorrelationServiceImpl.class);
    public static final String FORM_AI_DAPTRACKER = "ai_daptracker";
    public static final String FORM_GL_VOUCHER = "gl_voucher";
    public static final String FIELD_VOUCHERID = "voucherid";
    public static final String FIELD_SOURCEBILLID = "sourcebillid";
    public static final String FIELD_BILLTYPE = "billtype";

    public Map<String, Set<String>> getDirectSrcBillByTargetBill(String targetEntityNumber, List<String> tpks, Map<String, Object> extraParams) {
        if (!tpks.isEmpty()) {
            HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
            Long[] targetPks = new Long[tpks.size()];
            for (int i = 0; i < tpks.size(); ++i) {
                targetPks[i] = Long.valueOf(tpks.get(i));
            }
            QFilter[] filter = new QFilter[]{new QFilter(FIELD_VOUCHERID, "in", (Object)targetPks)};
            DynamicObjectCollection ds = QueryServiceHelper.query((String)FORM_AI_DAPTRACKER, (String)String.format("%s,%s,%s", FIELD_SOURCEBILLID, FIELD_BILLTYPE, FIELD_VOUCHERID), (QFilter[])filter);
            if (ds != null && !ds.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dyn : ds) {
                    String number = dyn.getString(FIELD_BILLTYPE);
                    sb.append(String.format("1 number[%s],targetBillId[%s]", number, dyn.get(FIELD_VOUCHERID)));
                    if (WfUtils.isEmpty(number)) continue;
                    HashSet<String> t = (HashSet<String>)ret.get(number);
                    if (t == null) {
                        t = new HashSet<String>();
                    }
                    t.add(dyn.getString(FIELD_SOURCEBILLID));
                    ret.put(number, t);
                }
                logger.debug(sb.toString());
            }
            return ret;
        }
        return Collections.emptyMap();
    }

    public Map<String, Set<String>> getDirectTargetBillBySrcBill(String srcEntityNunber, List<String> spks, Map<String, Object> extraParams) {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>(1);
        if (WfUtils.isNotEmpty(srcEntityNunber) && !spks.isEmpty()) {
            Long[] sourcePks = new Long[spks.size()];
            for (int i = 0; i < spks.size(); ++i) {
                sourcePks[i] = Long.valueOf(spks.get(i));
            }
            QFilter[] filter = new QFilter[]{new QFilter(FIELD_SOURCEBILLID, "in", (Object)sourcePks).and(new QFilter(FIELD_BILLTYPE, "=", (Object)srcEntityNunber))};
            DynamicObjectCollection ds = QueryServiceHelper.query((String)FORM_AI_DAPTRACKER, (String)String.format("%s,%s,%s", FIELD_SOURCEBILLID, FIELD_BILLTYPE, FIELD_VOUCHERID), (QFilter[])filter);
            if (ds != null && !ds.isEmpty()) {
                HashSet<String> t = new HashSet<String>();
                for (DynamicObject dyn : ds) {
                    String voucherid = dyn.getString(FIELD_VOUCHERID);
                    logger.debug(String.format("2 srcentity[%s],srcPk[%s],voucherid[%s]", srcEntityNunber, dyn.get(FIELD_SOURCEBILLID), voucherid));
                    if (WfUtils.isEmpty(voucherid)) continue;
                    t.add(voucherid);
                }
                if (!t.isEmpty()) {
                    ret.put(FORM_GL_VOUCHER, t);
                }
            }
        } else {
            logger.debug("args is null");
        }
        return ret;
    }
}

