/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.model.BpmStartupItem;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;

public class GetBpmStartupItemsCmd
implements Command<List<BpmStartupItem>> {
    private Long procDefId;

    public GetBpmStartupItemsCmd(Long procDefId) {
        this.procDefId = procDefId;
    }

    @Override
    public List<BpmStartupItem> execute(CommandContext commandContext) {
        ArrayList<BpmStartupItem> items = new ArrayList<BpmStartupItem>();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FID, FCONDRULEID, FENTITYNUMBER, FOPERATION, FALLOWSTART, FBATCHNUMBER, FBATCHNUMNAME, FEVENTNUMBER, FSTARTTYPE");
        sb.append(" FROM T_WF_PROCESSCONFIG ");
        sb.append("WHERE FPROCDEFID = ? ORDER BY FID ASC;");
        String lang = RequestContext.get().getLang().toString();
        Object[] params = new Object[]{this.procDefId};
        ArrayList<String> eventNumbers = new ArrayList<String>();
        ArrayList<BpmStartupItem> eventItems = new ArrayList<BpmStartupItem>();
        ArrayList<Long> conditionRuleIds = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.findBpmStartupItemsByProcDefId", (DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])params);){
            for (Row row : ds) {
                Long processConfigId = row.getLong("FID");
                Long conditionId = row.getLong("FCONDRULEID");
                conditionRuleIds.add(conditionId);
                String entityNumber = row.getString("FENTITYNUMBER");
                LocaleString name = WfUtils.getEntityNameProperty(entityNumber, null);
                String entityName = name != null ? (String)name.get((Object)lang) : "";
                boolean allowStart = row.getBoolean("FALLOWSTART");
                BpmStartupItem item = new BpmStartupItem(processConfigId, conditionId, entityName, entityNumber, "", allowStart);
                item.setOperation(row.getString("FOPERATION"));
                item.setBatchNumber(row.getString("FBATCHNUMBER"));
                item.setBatchNumName(row.getString("FBATCHNUMNAME"));
                String eventNumber = row.getString("FEVENTNUMBER");
                if (WfUtils.isNotEmpty(eventNumber)) {
                    eventNumbers.add(eventNumber);
                    item.setEventNumber(eventNumber);
                    eventItems.add(item);
                }
                item.setStartType(row.getString("FSTARTTYPE"));
                items.add(item);
            }
        }
        if (WfUtils.isNotEmptyForCollection(items) && WfUtils.isNotEmptyForCollection(conditionRuleIds)) {
            HashMap<Long, ILocaleString> localeValueMap = new HashMap<Long, ILocaleString>(conditionRuleIds.size());
            QFilter[] showTextFilters = new QFilter[]{new QFilter("ID", "in", conditionRuleIds)};
            List ruleEntities = commandContext.getConditionRuleEntityManager().findByQueryFilters(showTextFilters, "id, showtext", null);
            for (ConditionalRuleEntity entity : ruleEntities) {
                localeValueMap.put(entity.getId(), entity.getShowtext());
            }
            for (BpmStartupItem item : items) {
                ILocaleString localeString = (ILocaleString)localeValueMap.get(item.getConditionId());
                String showTextValue = localeString != null ? localeString.toString() : "";
                item.setCondShowText(showTextValue);
            }
        }
        if (!eventItems.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("number", "in", eventNumbers)};
            DynamicObjectCollection events = QueryServiceHelper.query((String)"evt_event", (String)"name,number", (QFilter[])filters);
            HashMap<String, String> eventMap = new HashMap<String, String>(events.size());
            for (DynamicObject event : events) {
                eventMap.put(event.getString("number"), event.getString("name"));
            }
            for (BpmStartupItem item : eventItems) {
                item.setEventName((String)eventMap.get(item.getEventNumber()));
            }
        }
        return items;
    }
}

