/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.bizflow.graph.model.CustomRelationCardData;
import kd.bos.workflow.bizflow.graph.model.CustomRelationDatas;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillRelationModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillRelationTypeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillRelationTypeManager;

public class GetCustomRelationDatasCmd
implements Command<CustomRelationDatas> {
    private String entityNumber;
    private String businessKey;
    private Log log = LogFactory.getLog(this.getClass());

    public GetCustomRelationDatasCmd(String entityNumber, String businessKey) {
        this.entityNumber = entityNumber;
        this.businessKey = businessKey;
    }

    @Override
    public CustomRelationDatas execute(CommandContext commandContext) {
        CustomRelationDatas datas = new CustomRelationDatas();
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("relationtype", "not in", (Object)new String[]{"botp", "dap"}), new QFilter("srcbill", "=", (Object)this.entityNumber).or(new QFilter("targetbill", "=", (Object)this.entityNumber))};
        String fields = String.format("%s,%s,%s,%s", "srcbill", "targetbill", "relationtypeid", "paramjson");
        List relationModelEntities = commandContext.getBillRelationModelManager().findByQueryFilters(filters, fields, null);
        if (relationModelEntities.isEmpty()) {
            this.log.debug(String.format("no relationmodel. EntityNumber: %s", this.entityNumber));
            return datas;
        }
        HashMap<Long, ArrayList<BillRelationModelEntity>> relationModelMap = new HashMap<Long, ArrayList<BillRelationModelEntity>>(relationModelEntities.size());
        for (BillRelationModelEntity relationModel : relationModelEntities) {
            Long relationTypeId = relationModel.getRelationTypeId();
            ArrayList<BillRelationModelEntity> relationModels = (ArrayList<BillRelationModelEntity>)relationModelMap.get(relationTypeId);
            if (relationModels == null) {
                relationModels = new ArrayList<BillRelationModelEntity>();
                relationModelMap.put(relationTypeId, relationModels);
            }
            relationModels.add(relationModel);
        }
        BillRelationTypeManager relationTypeManager = commandContext.getBillRelationTypeManager();
        EntityQueryBuilder relationTypeQuery = relationTypeManager.createQueryBuilder();
        relationTypeQuery.addFilter("id", "in", relationModelMap.keySet());
        relationTypeQuery.setSelectFields(String.format("%s,%s,%s", "id", "name", "parseclass"));
        List relationTypes = relationTypeManager.findByQueryBuilder(relationTypeQuery);
        int size = relationTypes.size();
        HashMap<Long, BillRelationTypeEntity> relationTypeMap = new HashMap<Long, BillRelationTypeEntity>(size);
        HashMap<Long, String> relationTypeNameMap = new HashMap<Long, String>(size);
        for (BillRelationTypeEntity relationType : relationTypes) {
            relationTypeMap.put(relationType.getId(), relationType);
            relationTypeNameMap.put(relationType.getId(), String.valueOf(relationType.getName()));
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(this.businessKey);
        HashSet<String> entities = new HashSet<String>(16);
        LinkedHashMap<Long, CustomRelationCardData> datasMap = new LinkedHashMap<Long, CustomRelationCardData>(relationModelMap.size());
        for (Map.Entry entry : relationModelMap.entrySet()) {
            Long relationTypeId = (Long)entry.getKey();
            List relationModels = (List)entry.getValue();
            BillRelationTypeEntity relationType = (BillRelationTypeEntity)relationTypeMap.get(relationTypeId);
            String parseClass = relationType.getParseClass();
            if (WfUtils.isEmpty(parseClass)) {
                this.log.debug(String.format("BillRelationType %s parseClass is null.", relationTypeId));
                continue;
            }
            Map config = (Map)SerializationUtils.fromJsonString((String)parseClass, Map.class);
            String clazz = (String)config.get("class");
            String appId = (String)config.get("appid");
            Map ret = null;
            CustomRelationCardData data = new CustomRelationCardData();
            data.setRelationTypeId(relationTypeId);
            datasMap.put(relationType.getId(), data);
            for (BillRelationModelEntity relationModel : relationModels) {
                HashMap<String, String> params;
                String expectantEntity = null;
                Map<String, String> map = params = WfUtils.isNotEmpty(relationModel.getParamJson()) ? (Map)SerializationUtils.fromJsonString((String)relationModel.getParamJson(), Map.class) : new HashMap<String, String>();
                if (this.entityNumber.equals(relationModel.getSrcbill())) {
                    expectantEntity = relationModel.getTargetbill();
                    params.put("targetEntityNumber", expectantEntity);
                    ret = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBillRelationMethod", (Object[])new Object[]{clazz, "getDirectTargetBillBySrcBill", new Object[]{this.entityNumber, billIds, params}});
                } else {
                    expectantEntity = relationModel.getSrcbill();
                    params.put("sourceEntityNumber", expectantEntity);
                    ret = (Map)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)IWorkflowService.class.getSimpleName(), (String)"invokeBillRelationMethod", (Object[])new Object[]{clazz, "getDirectSrcBillByTargetBill", new Object[]{this.entityNumber, billIds, params}});
                }
                if (ret == null || ret.isEmpty()) {
                    this.log.debug(String.format("result is null. invoke plugin: %s, entityNumber: %s, businessKey: %s", clazz, this.entityNumber, this.businessKey));
                    continue;
                }
                for (Map.Entry e : ret.entrySet()) {
                    String entity = (String)e.getKey();
                    if (!expectantEntity.equals(entity)) continue;
                    Set ids = (Set)e.getValue();
                    for (String id : ids) {
                        entities.add(entity);
                        data.addBillInfo(entity, id);
                    }
                }
            }
        }
        datas.setDatasMap(datasMap);
        datas.setTypeMap(relationTypeNameMap);
        datas.setCustomRelationEntities(this.getCustomRelationEntityNumbers(commandContext, entities));
        return datas;
    }

    private Set<String> getCustomRelationEntityNumbers(CommandContext commandContext, Set<String> entityNumbers) {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("relationtype", "not in", (Object)new String[]{"botp", "dap"}), new QFilter("srcbill", "in", entityNumbers).or(new QFilter("targetbill", "in", entityNumbers))};
        String fields = String.format("%s,%s", "srcbill", "targetbill");
        List relationModels = commandContext.getBillRelationModelManager().findByQueryFilters(filters, fields, null);
        HashSet<String> ret = new HashSet<String>(relationModels.size());
        for (BillRelationModelEntity relationModel : relationModels) {
            ret.add(relationModel.getSrcbill());
            ret.add(relationModel.getTargetbill());
        }
        return ret;
    }
}

