/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.bpm.cmd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpm.model.BpmStartupItem;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;

public class UpdateBpmStartupConditionCmd
implements Command<Void> {
    private Long procDefId;
    private List<BpmStartupItem> items;
    private Log log = LogFactory.getLog(this.getClass());

    public UpdateBpmStartupConditionCmd(Long procDefId, List<BpmStartupItem> items) {
        this.items = items;
        this.procDefId = procDefId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.items == null || this.items.isEmpty()) {
            this.log.debug("The bpmStartupItems is null!");
            return null;
        }
        ProcessConfigEntityManager configManager = commandContext.getProcessConfigEntityManager();
        ConditionalRuleEntityManager conditionManager = commandContext.getConditionRuleEntityManager();
        ResourceEntityManager resourceEntityManager = commandContext.getResourceEntityManager();
        ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(this.procDefId);
        ResourceEntity resourceEntity = (ResourceEntity)resourceEntityManager.findById(procDefEntity.getResourceId());
        JSONObject modelJSON = JSON.parseObject((String)resourceEntity.getData());
        String startItemProp = "properties.startItems";
        String evtStartItemProp = "properties.evtStartItems";
        JSONArray startItemsModel = (JSONArray)BpmnModelUtil.getProperty((Map<String, Object>)modelJSON, startItemProp);
        JSONArray evtStartItemsModel = (JSONArray)BpmnModelUtil.getProperty((Map<String, Object>)modelJSON, evtStartItemProp);
        if (evtStartItemsModel == null) {
            evtStartItemsModel = new JSONArray();
        }
        for (BpmStartupItem item : this.items) {
            if ("event".equals(item.getStartType())) {
                this.insertOrUpdateEventStartItem(item, commandContext);
                this.insertOrUpdateModelEventStartItem(item, evtStartItemsModel);
                continue;
            }
            ProcessConfigEntity processConfig = this.updateProcessConfigCondition(item, configManager, conditionManager);
            processConfig.setOperation(item.getOperation());
            processConfig.setAllowStart(item.isAllowStart());
            processConfig.setBatchNumber(item.getBatchNumber());
            processConfig.setBatchNumName(item.getBatchNumName());
            configManager.update(processConfig);
            this.updateModelStartItem(item, startItemsModel);
        }
        BpmnModelUtil.setProperty((Map<String, Object>)modelJSON, startItemProp, startItemsModel);
        BpmnModelUtil.setProperty((Map<String, Object>)modelJSON, evtStartItemProp, evtStartItemsModel);
        resourceEntity.setData(modelJSON.toJSONString());
        resourceEntityManager.update(resourceEntity);
        ProcessDefinitionEntityManager entityManager = commandContext.getProcessDefinitionEntityManager();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)entityManager.findById(this.procDefId, String.format("%s,%s", "id", "modifyDate"));
        entityManager.update(processDefinition);
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = commandContext.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache();
        processDefinitionCache.remove(this.procDefId);
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(resourceEntity.getData());
        DynamicSchemeUtil.disposeOperationCache(commandContext, this.procDefId, model, true);
        return null;
    }

    private void updateModelStartItem(BpmStartupItem item, JSONArray modelItems) {
        if (modelItems == null || modelItems.isEmpty()) {
            return;
        }
        String entityNumber = item.getEntityNumber();
        if (WfUtils.isEmpty(entityNumber)) {
            return;
        }
        for (int i = 0; i < modelItems.size(); ++i) {
            JSONObject modelItem = modelItems.getJSONObject(i);
            if (!entityNumber.equals(modelItem.getString("entitynumber"))) continue;
            if (WfUtils.isNotEmpty(item.getCondition())) {
                modelItem.put("condition", this.getConditionJSON(item));
            } else if (item.isCondRuleDeleted()) {
                modelItem.put("condition", null);
            }
            modelItem.put("operation", (Object)item.getOperationValue());
            modelItem.put("allowstart", (Object)item.isAllowStart());
            modelItem.put("batchnumber", (Object)item.getBatchNumber());
            modelItem.put("batchnumname", (Object)item.getBatchNumName());
            break;
        }
    }

    private void insertOrUpdateModelEventStartItem(BpmStartupItem item, JSONArray modelItems) {
        JSONObject modelItem = null;
        if (modelItems.isEmpty()) {
            modelItem = new JSONObject();
            modelItems.add((Object)modelItem);
        } else {
            modelItem = modelItems.getJSONObject(0);
        }
        if (WfUtils.isEmpty(item.getCondition()) && WfUtils.isEmpty(item.getEventNumber())) {
            modelItems.clear();
            return;
        }
        if (WfUtils.isNotEmpty(item.getCondition())) {
            modelItem.put("condition", this.getConditionJSON(item));
        } else if (item.isCondRuleDeleted()) {
            modelItem.put("condition", null);
        }
        if (WfUtils.isNotEmpty(item.getEventNumber())) {
            modelItem.put("eventName", (Object)item.getEventName());
            modelItem.put("eventNumber", (Object)item.getEventNumber());
        }
    }

    private Object getConditionJSON(BpmStartupItem item) {
        ConditionalRuleEntity condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel(item.getCondition());
        return JSON.toJSON((Object)condRule);
    }

    private ProcessConfigEntity updateProcessConfigCondition(BpmStartupItem item, ProcessConfigEntityManager configManager, ConditionalRuleEntityManager conditionManager) {
        ProcessConfigEntity processConfig = (ProcessConfigEntity)configManager.findById(item.getProcessConfigId());
        if (item.isCondRuleDeleted()) {
            conditionManager.delete(item.getConditionId());
            processConfig.setStartCondition(null);
            processConfig.setCondRuleId(null);
        } else if (WfUtils.isNotEmpty(item.getCondition())) {
            ConditionalRuleEntity condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel(item.getCondition());
            conditionManager.saveOrUpdateConditionRule(condRule);
            processConfig.setStartCondition(condRule.getConditionRule());
            processConfig.setCondRuleId(condRule.getId());
        } else {
            this.log.debug(String.format("%s not modified!", item));
        }
        return processConfig;
    }

    private void insertOrUpdateEventStartItem(BpmStartupItem item, CommandContext commandContext) {
        ProcessConfigEntityManager configManager = commandContext.getProcessConfigEntityManager();
        ConditionalRuleEntityManager conditionManager = commandContext.getConditionRuleEntityManager();
        ProcessDefinitionEntityManager procdefManager = commandContext.getProcessDefinitionEntityManager();
        if (WfUtils.isNotEmpty(item.getProcessConfigId())) {
            if (WfUtils.isEmpty(item.getEventNumber()) && item.isCondRuleDeleted()) {
                configManager.delete(item.getProcessConfigId());
                conditionManager.delete(item.getConditionId());
                return;
            }
            ProcessConfigEntity processConfig = this.updateProcessConfigCondition(item, configManager, conditionManager);
            processConfig.setStartType(item.getStartType());
            processConfig.setEventNumber(item.getEventNumber());
            configManager.update(processConfig);
        } else {
            Process process;
            AllowNextPersonSettingModel allowNextPerson;
            if (WfUtils.isEmpty(item.getCondition()) && WfUtils.isEmpty(item.getEventNumber())) {
                this.log.debug("event start: condition and batchNumber is null! Do not add!");
                return;
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)procdefManager.findById(item.getProcDefId());
            Long processDefinitionId = processDefinition.getId();
            ProcessConfigEntity processConfig = (ProcessConfigEntity)configManager.create();
            processConfig.setProcDefId(processDefinitionId);
            processConfig.setEnable("enable".equalsIgnoreCase(processDefinition.getEnable()));
            if (WfUtils.isNotEmpty(item.getCondition())) {
                ConditionalRuleEntity condRule = ConditionalRuleConvertUtil.jsonToConditionalRuleModel(item.getCondition());
                condRule.setProcdefid(processDefinitionId);
                commandContext.getConditionRuleEntityManager().saveOrUpdateConditionRule(condRule);
                processConfig.setStartCondition(condRule.getConditionRule());
                processConfig.setCondRuleId(condRule.getId());
            }
            if ((allowNextPerson = (process = ProcessDefinitionUtil.getBpmnModelByProcDefId(processDefinitionId).getMainProcess()).getAllowNextPersonSettingModel()) != null) {
                processConfig.setAllowNextPerson(allowNextPerson.isAllowNextPersonWhenMatch());
            }
            processConfig.setStartType(item.getStartType());
            processConfig.setEventNumber(item.getEventNumber());
            processConfig.setProcessType(ModelType.BizFlow.name());
            configManager.insert(processConfig);
        }
    }
}

